/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcFile;
import com.insightful.miner.BDLManager;
import com.insightful.miner.EngineNetworkManager;
import com.insightful.miner.MinerApp;
import com.insightful.miner.ReadOtherFileEngineNode;
import com.insightful.miner.XTProps;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class ReadTextFileEngineNode
extends ReadOtherFileEngineNode {
    private boolean runningInBDLManager() {
        EngineNetworkManager mgr = this.getNetworkManager();
        return mgr != null && mgr instanceof BDLManager;
    }

    private String getDelimiterString(XTProps props) {
        String delim = props.getValue("delimiter", "");
        if (!this.runningInBDLManager() && delim.length() == 0) {
            delim = props.getValue("userDelimiter", ",");
        }
        return delim;
    }

    public void procSetProperties(CNKProc proc, XTProps props) throws Exception {
        CNKProcFile fProc = (CNKProcFile)proc;
        fProc.setFileName(this.getNetworkManager().getAbsolutePath(props.getValue("filePath", "")));
        fProc.setFileType("ASCII");
        String delim = this.getDelimiterString(props);
        fProc.setDelimiter(delim);
        this.setFileProcColumns(fProc, props);
        this.setFileRange(fProc, props);
        fProc.setExternalEncoding(props.getValue("textEncoding", "ASCII"));
        int maxLineWidth = props.getInt("maxLineWidth", 0);
        if (maxLineWidth < 32768) {
            maxLineWidth = 32768;
        }
        fProc.setTxtMaxLineWidth(maxLineWidth);
        fProc.setSeparateDelimiters(props.getBoolean("separateDelimiters", true));
        long asciiStartRow = props.getLong("asciiStartRow", -1L);
        long asciiEndRow = props.getLong("asciiEndRow", -1L);
        if (asciiStartRow >= 0L) {
            --asciiStartRow;
        }
        if (asciiEndRow >= 0L) {
            --asciiEndRow;
        }
        if (props.getValue("asciiStartRow", null) == null) {
            asciiStartRow = props.getLong("startRow", -1L);
        }
        if (props.getValue("asciiEndRow", null) == null) {
            asciiEndRow = props.getLong("endRow", -1L);
        }
        if (asciiEndRow < asciiStartRow) {
            asciiEndRow = -1L;
        }
        if (!this.hasBDLProps(props) && props.getValue("useColumnNames", null) != null && !props.getBoolean("useColumnNames", true)) {
            if (asciiStartRow > 0L) {
                --asciiStartRow;
            }
            if (asciiEndRow > 0L) {
                --asciiEndRow;
            }
        }
        fProc.setAsciiStartRow(asciiStartRow);
        fProc.setAsciiEndRow(asciiEndRow);
        fProc.setStartRow(0L);
        fProc.setEndRow(-1L);
        int lookLines = props.getInt("lookMaxLines", 32);
        if (lookLines < 1) {
            lookLines = 0;
        }
        if (lookLines > 0 && asciiStartRow >= 0L) {
            lookLines = (int)((long)lookLines + asciiStartRow);
        }
        fProc.setTxtLookMaxLines(lookLines);
        this.setTextFormats(fProc, props, true);
    }

    public long procGetEstimatedNumRows(CNKProc proc) {
        long estimatedLines = -1L;
        try {
            XTProps info = this.getDataSourceInfo();
            estimatedLines = (long)info.getDouble("estimatedRows", -1.0);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return estimatedLines;
    }

    public void updateDataSourceInfoWarnings(XTProps currentProps, XTProps info) {
        try {
            int lookLines;
            String filename = currentProps.getValue("filePath", "");
            if (filename == null || filename.equals("")) {
                return;
            }
            filename = this.getNetworkManager().getAbsolutePath(filename);
            File fl = new File(filename);
            if (!fl.isFile()) {
                return;
            }
            long totalBytes = fl.length();
            if (totalBytes == 0L) {
                return;
            }
            String delim = this.getDelimiterString(currentProps);
            char delimChar = delim.length() == 0 ? (char)',' : (char)delim.charAt(0);
            boolean isUTF8 = !currentProps.getValue("textEncoding", "ASCII").equals("ASCII");
            int maxLineWidth = currentProps.getInt("maxLineWidth", 0);
            if (maxLineWidth < 32768) {
                maxLineWidth = 32768;
            }
            if ((lookLines = currentProps.getInt("lookMaxLines", 32)) < 1) {
                lookLines = 0;
            }
            if (this.runningInBDLManager()) {
                lookLines = 32;
            }
            long maxBytes = (long)lookLines * (long)maxLineWidth;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(filename));
            Scanner scan = new Scanner();
            scan.scanFile(in, lookLines, maxBytes, delimChar, isUTF8, maxLineWidth);
            ((InputStream)in).close();
            double avgLineWidth = scan.getAvgLineWidth();
            long estimatedRows = avgLineWidth > 0.0 ? (long)((double)totalBytes / avgLineWidth) : -1L;
            info.set("warning", scan.getWarnings(this.runningInBDLManager()));
            info.set("estimatedRows", estimatedRows);
            this.printlnDebug("text file scan of " + filename + ":" + " read " + scan.m_totalLines + " lines, " + scan.m_totalBytes + " bytes" + ", file len=" + totalBytes + ", avg line width=" + (int)avgLineWidth + ", est rows=" + estimatedRows + ", good:bad utf8 bytes=" + scan.m_utf8GoodBytes + ":" + scan.m_utf8BadBytes);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class Range {
        int m_min;
        int m_max;
        long m_total = 0L;
        int m_num = 0;

        Range() {
        }

        void add(int val) {
            if (this.m_num > 0) {
                if (val < this.m_min) {
                    this.m_min = val;
                } else if (val > this.m_max) {
                    this.m_max = val;
                }
            } else {
                this.m_min = val;
                this.m_max = val;
            }
            this.m_total += (long)val;
            ++this.m_num;
        }

        boolean gotAny() {
            return this.m_num > 0;
        }

        int getMin() {
            return this.m_min;
        }

        int getMax() {
            return this.m_max;
        }

        double getMean() {
            if (this.m_num > 0) {
                return (double)this.m_total / (double)this.m_num;
            }
            return 0.0;
        }

        int getNum() {
            return this.m_num;
        }
    }

    public static class Scanner {
        int[] m_delimiterChars = new int[]{44, 9, 32, 39, 0};
        String[] m_delimiterDescriptions = new String[]{"comma delimited", "tab delimited", "single space delimited", "single quote delimited", ""};
        DelimProc[] m_delimiterProcessors;
        int m_numDelimeters;
        int m_bytesOnLine = 0;
        int m_selectedDelim;
        int m_totalLines = 0;
        long m_totalBytes = 0L;
        Range m_lineSizeRange = new Range();
        Range m_allButFirstLineSizeRange = new Range();
        boolean m_processingQuote = false;
        int m_unterminatedQuotes = 0;
        int m_utf8GoodBytes = 0;
        int m_utf8BadBytes = 0;
        int m_maxLineWidth = 0;
        final int UTF8_INIT = 0;
        final int UTF8_TWO_BYTE_HEADER = 1;
        final int UTF8_THREE_BYTE_HEADER = 2;
        final int UTF8_THREE_BYTE_SECOND = 3;
        int m_utf8State = 0;
        boolean m_inUTF8 = false;

        public void scanFile(InputStream in, int maxLines, long maxBytes, char delimChar, boolean inUTF8, int maxLineWidth) {
            this.m_maxLineWidth = maxLineWidth;
            this.m_inUTF8 = inUTF8;
            this.m_numDelimeters = this.m_delimiterChars.length;
            this.m_selectedDelim = this.m_delimiterChars.length - 1;
            this.m_delimiterChars[this.m_selectedDelim] = delimChar;
            this.m_delimiterProcessors = new DelimProc[this.m_numDelimeters];
            for (int i = 0; i < this.m_numDelimeters; ++i) {
                if (this.m_delimiterChars[i] == delimChar && i < this.m_selectedDelim) {
                    this.m_selectedDelim = i;
                    --this.m_numDelimeters;
                }
                this.m_delimiterProcessors[i] = new DelimProc(this.m_delimiterChars[i] == 32);
            }
            byte[] inByteArray = new byte[64000];
            this.m_totalLines = 0;
            this.m_totalBytes = 0L;
            block3: while (maxLines < 1 || this.m_totalLines < maxLines && this.m_totalBytes < maxBytes) {
                int readBytes = 0;
                try {
                    readBytes = in.read(inByteArray);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (readBytes <= 0) break;
                if (maxLines > 0 && this.m_totalBytes + (long)readBytes > maxBytes) {
                    readBytes = (int)(maxBytes - this.m_totalBytes);
                }
                this.m_totalBytes += (long)readBytes;
                for (int readByteIndex = 0; readByteIndex < readBytes; ++readByteIndex) {
                    int i;
                    int c = inByteArray[readByteIndex];
                    if (c < 0) {
                        c += 256;
                    }
                    if (this.m_utf8State != 0 || c > 127) {
                        this.utf8Interpret(c);
                    }
                    if (c == 13) continue;
                    if (c == 10) {
                        if (this.m_bytesOnLine < 1) continue;
                        if (this.m_processingQuote) {
                            this.m_processingQuote = false;
                            ++this.m_unterminatedQuotes;
                        }
                        for (i = 0; i < this.m_numDelimeters; ++i) {
                            this.m_delimiterProcessors[i].endOfLineProcessing();
                        }
                        if (this.m_totalLines > 0) {
                            this.m_allButFirstLineSizeRange.add(this.m_bytesOnLine);
                        }
                        this.m_lineSizeRange.add(this.m_bytesOnLine);
                        ++this.m_totalLines;
                        if (maxLines > 0 && this.m_totalLines >= maxLines) continue block3;
                        this.m_bytesOnLine = 0;
                        continue;
                    }
                    ++this.m_bytesOnLine;
                    if (c == 34) {
                        boolean bl = this.m_processingQuote = !this.m_processingQuote;
                    }
                    if (this.m_processingQuote) continue;
                    for (i = 0; i < this.m_numDelimeters; ++i) {
                        if (c != this.m_delimiterChars[i]) continue;
                        this.m_delimiterProcessors[i].gotDelimiter();
                    }
                }
            }
        }

        public String getWarnings(boolean bdlWarningsOnly) {
            boolean looksLikeUTF8;
            StringBuffer buf = new StringBuffer();
            if (this.m_lineSizeRange.getNum() > 0 && this.m_maxLineWidth < this.m_lineSizeRange.getMax()) {
                int maxThousands = 1000 * (1 + (int)((double)this.m_lineSizeRange.getMax() / 1000.0));
                this.addCRWarning(buf, MinerApp.getText("ReadTextFileEngineNode_msg_maxLineWidthNote") + " " + maxThousands);
            }
            if (bdlWarningsOnly) {
                return buf.toString();
            }
            boolean anyGoodDelim = false;
            if (this.m_delimiterProcessors[this.m_selectedDelim].good()) {
                anyGoodDelim = true;
            } else {
                for (int i = 0; i < this.m_numDelimeters; ++i) {
                    if (i == this.m_selectedDelim || !this.m_delimiterProcessors[i].good()) continue;
                    anyGoodDelim = true;
                    this.addCRWarning(buf, MinerApp.getText("ReadTextFileEngineNode_msg_betterDelimiterNote") + " " + this.m_delimiterDescriptions[i]);
                }
            }
            boolean bl = looksLikeUTF8 = this.m_utf8GoodBytes > 0 && this.m_utf8BadBytes < 50 && (double)this.m_utf8BadBytes < (double)this.m_utf8GoodBytes * 0.1;
            if (this.m_inUTF8 && !looksLikeUTF8) {
                this.addCRWarning(buf, MinerApp.getText("ReadTextFileEngineNode_msg_asciiEncodingBetterNote"));
            } else if (!this.m_inUTF8 && looksLikeUTF8) {
                this.addCRWarning(buf, MinerApp.getText("ReadTextFileEngineNode_msg_utf8EncodingBetterNote"));
            }
            if (!anyGoodDelim && this.m_utf8BadBytes > 150) {
                this.addCRWarning(buf, MinerApp.getText("ReadTextFileEngineNode_msg_notATextFileNote"));
            }
            return buf.toString();
        }

        private void addCRWarning(StringBuffer buf, String str) {
            if (buf.length() > 0) {
                buf.append("\n");
            }
            buf.append(str);
        }

        public double getAvgLineWidth() {
            return this.m_allButFirstLineSizeRange.getMean();
        }

        public boolean isLegalUTF8TwoByteHeader(int c) {
            return (c & 0xE0) == 192;
        }

        public boolean isLegalUTF8ThreeByteHeader(int c) {
            return (c & 0xF0) == 224;
        }

        public boolean isLegalUTF8FollowByte(int c) {
            return (c & 0xC0) == 128;
        }

        public void utf8InterpretHeader(int c) {
            if (c < 128) {
                this.m_utf8State = 0;
            } else if (this.isLegalUTF8TwoByteHeader(c)) {
                this.m_utf8State = 1;
            } else if (this.isLegalUTF8ThreeByteHeader(c)) {
                this.m_utf8State = 2;
            } else {
                ++this.m_utf8BadBytes;
                this.m_utf8State = 0;
            }
        }

        public void utf8Interpret(int c) {
            switch (this.m_utf8State) {
                case 0: {
                    if (c < 128) break;
                    this.utf8InterpretHeader(c);
                    break;
                }
                case 1: {
                    if (this.isLegalUTF8FollowByte(c)) {
                        this.m_utf8GoodBytes += 2;
                        this.m_utf8State = 0;
                        break;
                    }
                    ++this.m_utf8BadBytes;
                    this.utf8InterpretHeader(c);
                    break;
                }
                case 2: {
                    if (this.isLegalUTF8FollowByte(c)) {
                        this.m_utf8State = 3;
                        break;
                    }
                    ++this.m_utf8BadBytes;
                    this.utf8InterpretHeader(c);
                    break;
                }
                case 3: {
                    if (this.isLegalUTF8FollowByte(c)) {
                        this.m_utf8GoodBytes += 3;
                        this.m_utf8State = 0;
                        break;
                    }
                    this.m_utf8BadBytes += 2;
                    this.utf8InterpretHeader(c);
                }
            }
        }

        class DelimProc {
            Range m_numColumnsRange = new Range();
            int m_lastDelimIndex = -1;
            int m_numColumns = 0;
            boolean m_spaceDelim = false;

            DelimProc(boolean spaceDelim) {
                this.m_spaceDelim = spaceDelim;
            }

            void endOfLineProcessing() {
                ++this.m_numColumns;
                this.m_numColumnsRange.add(this.m_numColumns);
                this.m_numColumns = 0;
                this.m_lastDelimIndex = -1;
            }

            void gotDelimiter() {
                if (this.m_spaceDelim) {
                    boolean repeatDelim = this.m_lastDelimIndex >= 0 && this.m_lastDelimIndex == Scanner.this.m_bytesOnLine - 1;
                    this.m_lastDelimIndex = Scanner.this.m_bytesOnLine;
                    if (repeatDelim || Scanner.this.m_bytesOnLine < 2) {
                        return;
                    }
                }
                ++this.m_numColumns;
            }

            boolean good() {
                return this.m_numColumnsRange.gotAny() && this.m_numColumnsRange.getMin() > 1 && this.m_numColumnsRange.getMin() == this.m_numColumnsRange.getMax();
            }
        }
    }
}

