/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineMessageHandler;
import com.insightful.miner.EngineNode;
import com.insightful.miner.SortAndShuffle;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Vector;

public class UnstackEngineNode
extends EngineNode {
    public static String GROUP_COLUMNS_ATTRIBUTE_TAG = "groupCols";
    public static String KEY_COLUMNS_ATTRIBUTE_TAG = "keyCols";
    public static String VALUE_COLUMN_ATTRIBUTE_TAG = "valueCol";
    public static String SORT_ATTRIBUTE_TAG = "sortRequired";
    public static String PRUNE_EMPTY_COLUMNS_ATTRIBUTE_TAG = "pruneEmpbyColumns";

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return true;
    }

    public boolean hasDynamicOutputs() {
        return true;
    }

    public boolean executeDataCacheProc() throws Exception {
        XTMetaData inputMD = this.getInputMetaData(0);
        XTProps props = this.getNodeProperties();
        UnstackColumnInfo info = new UnstackColumnInfo(props, inputMD);
        XTMetaData outputMD = this.calculateOutputMetaData(info);
        StringBuffer keyWarn = null;
        for (int i = 0; i < info.m_numKeyColumns; ++i) {
            if (!info.m_keyOutputColumnsChanged[i]) continue;
            if (keyWarn == null) {
                keyWarn = new StringBuffer("Unstack renamed key columns to resolve name conflicts: ");
            } else {
                keyWarn.append(", ");
            }
            keyWarn.append((String)info.m_keyColumnNames.get(i));
            keyWarn.append(" -> ");
            keyWarn.append(info.m_keyOutputColumnNames[i]);
        }
        if (keyWarn != null) {
            this.printlnWarning(keyWarn.toString());
        }
        int outputColumnCount = info.m_numKeyColumns + info.m_totalGroupOutputColumns;
        File unsortedFile = new File(this.getInputDataCacheFileName(0));
        File sortedFile = this.createWorkspaceTempFile("unstack", "tmp");
        sortedFile.deleteOnExit();
        boolean doPrune = props.getBoolean(PRUNE_EMPTY_COLUMNS_ATTRIBUTE_TAG, true);
        boolean[] outputColumnValid = new boolean[outputColumnCount];
        for (int i = 0; i < info.m_numKeyColumns; ++i) {
            outputColumnValid[i] = true;
        }
        int rowChunkSize = this.getMaxRowsPerBlock();
        boolean sortRequired = props.getBoolean(SORT_ATTRIBUTE_TAG, true);
        if (sortRequired) {
            int i;
            int numSortColumns = info.m_numKeyColumns + info.m_numGroupColumns;
            String[] sortColumnOrder = new String[numSortColumns];
            boolean[] sortAscending = new boolean[numSortColumns];
            boolean[] sortNAatTop = new boolean[numSortColumns];
            boolean alphabetical = false;
            int sortColumnNumber = 0;
            for (i = 0; i < info.m_numKeyColumns; ++i) {
                sortColumnOrder[sortColumnNumber] = (String)info.m_keyColumnNames.get(i);
                sortAscending[sortColumnNumber] = true;
                sortNAatTop[sortColumnNumber] = false;
                ++sortColumnNumber;
            }
            for (i = 0; i < info.m_numGroupColumns; ++i) {
                sortColumnOrder[sortColumnNumber] = (String)info.m_groupColumnNames.get(i);
                sortAscending[sortColumnNumber] = true;
                sortNAatTop[sortColumnNumber] = false;
                ++sortColumnNumber;
            }
            boolean success = SortAndShuffle.sort(unsortedFile, sortedFile, inputMD, (EngineNode)this, rowChunkSize, sortColumnOrder, sortAscending, sortNAatTop, alphabetical, true);
            this.resetProgressIndicator();
            if (!success) {
                return false;
            }
        } else {
            sortedFile = unsortedFile;
        }
        DataCacheRowBuf oRowBuf = null;
        DataCacheRowBuf newRowBuf = null;
        DataCacheRowBuf lastRowBuf = null;
        String nonPrunedFilename = doPrune ? this.createWorkspaceTempFile("unstack", "tmp").getAbsolutePath() : this.getOutputDataCacheFileName(0);
        File nonPrunedFile = new File(nonPrunedFilename);
        FileOutputStream oDataStream = new FileOutputStream(nonPrunedFile);
        BufferedOutputStream oDataBuffer = new BufferedOutputStream(oDataStream);
        DataOutputStream oDataOutputStream = new DataOutputStream(oDataBuffer);
        FileInputStream iDataStream = new FileInputStream(sortedFile);
        BufferedInputStream iDataBuffer = new BufferedInputStream(iDataStream);
        DataInputStream iDataInputStream = new DataInputStream(iDataBuffer);
        newRowBuf = new DataCacheRowBuf(inputMD);
        lastRowBuf = new DataCacheRowBuf(inputMD);
        try {
            oRowBuf = new DataCacheRowBuf(outputMD);
        }
        catch (OutOfMemoryError oom) {
            if (!sortRequired) {
                throw new Exception("data has been sorted incorrectly.");
            }
            throw oom;
        }
        for (int i = 0; i < outputColumnCount; ++i) {
            oRowBuf.setNA(i);
        }
        newRowBuf.readRow(iDataInputStream);
        lastRowBuf.copyAllColumns(newRowBuf);
        long outputRowCount = 0L;
        long curRow = 0L;
        long rowCount = inputMD.getNumRows();
        String origText = (String)EngineMessageHandler.sendMessageToApp("getStatusText", new Object[0]);
        String str = origText + ": Unstacking rows...";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        while (true) {
            if (!newRowBuf.isSame(lastRowBuf, info.m_keyColumnNumbers)) {
                this.fillInRowBuf(oRowBuf, lastRowBuf, info.m_keyColumnNumbers, info.m_keyOutputColumnNums);
                oRowBuf.writeRow(oDataOutputStream);
                for (int i = 0; i < outputColumnCount; ++i) {
                    oRowBuf.setNA(i);
                }
                lastRowBuf.copyAllColumns(newRowBuf);
                ++outputRowCount;
            }
            int outputGroupColumn = 0;
            for (int groupVar = 0; groupVar < info.m_numGroupColumns; ++groupVar) {
                int numGroupLevels = info.m_numGroupColumnLevels[groupVar];
                int groupColumnNumber = info.m_groupColumnNumbers[groupVar];
                int groupLevel = 0;
                groupLevel = newRowBuf.isNA(groupColumnNumber) ? numGroupLevels - 1 : newRowBuf.getLevelNum(groupColumnNumber);
                if (groupLevel < 0) {
                    groupLevel = 0;
                } else if (groupLevel >= numGroupLevels) {
                    groupLevel = numGroupLevels - 1;
                }
                outputGroupColumn = outputGroupColumn * numGroupLevels + groupLevel;
            }
            oRowBuf.copyColumn(outputGroupColumn += info.m_numKeyColumns, info.m_valueColumnNumber, newRowBuf);
            if (doPrune && !outputColumnValid[outputGroupColumn] && !newRowBuf.isNA(info.m_valueColumnNumber)) {
                outputColumnValid[outputGroupColumn] = true;
            }
            if (curRow >= rowCount - 1L) break;
            newRowBuf.readRow(iDataInputStream);
            int tempPercentDone = (int)(99.0 * ((double)curRow / (double)rowCount));
            if (!this.updateProgressIndicator(tempPercentDone)) {
                return false;
            }
            ++curRow;
        }
        this.fillInRowBuf(oRowBuf, lastRowBuf, info.m_keyColumnNumbers, info.m_keyOutputColumnNums);
        oRowBuf.writeRow(oDataOutputStream);
        outputMD.setNumRows(++outputRowCount);
        this.setOutputMetaData(0, outputMD);
        oDataOutputStream.close();
        iDataInputStream.close();
        if (sortRequired) {
            sortedFile.delete();
        }
        if (!this.updateProgressIndicator(100)) {
            return false;
        }
        if (doPrune) {
            XTMetaData prunedMD = null;
            Vector<String> nonEmptyColumns = new Vector<String>();
            for (int i = 0; i < outputColumnValid.length; ++i) {
                if (!outputColumnValid[i]) continue;
                nonEmptyColumns.add(outputMD.ordinalToName(i));
            }
            prunedMD = outputMD.selectiveClone(nonEmptyColumns);
            int[] convertPrunedToNonPruned = new int[nonEmptyColumns.size()];
            for (int i = 0; i < convertPrunedToNonPruned.length; ++i) {
                String colName = prunedMD.ordinalToName(i);
                convertPrunedToNonPruned[i] = outputMD.nameToOrdinal(colName);
            }
            String prunedFilename = this.getOutputDataCacheFileName(0);
            oDataStream = new FileOutputStream(prunedFilename);
            oDataBuffer = new BufferedOutputStream(oDataStream);
            oDataOutputStream = new DataOutputStream(oDataBuffer);
            oRowBuf = new DataCacheRowBuf(prunedMD);
            iDataStream = new FileInputStream(nonPrunedFile);
            iDataBuffer = new BufferedInputStream(iDataStream);
            iDataInputStream = new DataInputStream(iDataBuffer);
            newRowBuf = new DataCacheRowBuf(outputMD);
            newRowBuf.readRow(iDataInputStream);
            curRow = 0L;
            this.resetProgressIndicator();
            EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{origText + ": Pruning empty columns..."});
            while (curRow < outputRowCount) {
                int tempPercentDone;
                for (int i = 0; i < convertPrunedToNonPruned.length; ++i) {
                    oRowBuf.copyColumn(i, convertPrunedToNonPruned[i], newRowBuf);
                }
                oRowBuf.writeRow(oDataOutputStream);
                newRowBuf.readRow(iDataInputStream);
                if (this.updateProgressIndicator(tempPercentDone = (int)(99.0 * ((double)(++curRow) / (double)rowCount)))) continue;
                return false;
            }
            prunedMD.setNumRows(outputRowCount);
            this.setOutputMetaData(0, prunedMD);
            oDataOutputStream.close();
            iDataInputStream.close();
            nonPrunedFile.delete();
        }
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{origText});
        return true;
    }

    private void fillInRowBuf(DataCacheRowBuf oRowBuf, DataCacheRowBuf lastRowBuf, int[] inputKeys, int[] outputKeys) {
        for (int i = 0; i < inputKeys.length; ++i) {
            int iColNum = inputKeys[i];
            int oColNum = outputKeys[i];
            oRowBuf.copyColumn(oColNum, iColNum, lastRowBuf);
        }
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        try {
            XTMetaData inputMD = this.getInputMetaData(0);
            XTProps props = this.getNodeProperties();
            UnstackColumnInfo info = new UnstackColumnInfo(props, inputMD);
            return this.calculateOutputMetaData(info);
        }
        catch (Exception e) {
        }
        catch (OutOfMemoryError oome) {
            oome.printStackTrace();
        }
        return super.calculateOutputMetaData(outputNum);
    }

    private XTMetaData calculateOutputMetaData(UnstackColumnInfo info) throws Exception {
        int i;
        XTMetaData outputMD = new XTMetaData();
        for (i = 0; i < info.m_numKeyColumns; ++i) {
            outputMD.appendCopyDataField(info.m_inputMD, info.m_keyColumnNumbers[i], info.m_keyOutputColumnNames[i]);
            if (!info.m_inputMD.isCategoricalColumn(info.m_keyColumnNumbers[i])) continue;
            String columnName = (String)info.m_keyColumnNames.get(i);
            outputMD.setCategoricalLevels(columnName, info.m_inputMD.getCategoricalDataFieldLevels(columnName));
        }
        for (i = 0; i < info.m_totalGroupOutputColumns; ++i) {
            outputMD.appendCopyDataField(info.m_inputMD, info.m_valueColumnNumber, info.m_groupOutputColumnNames[i]);
        }
        return outputMD;
    }

    private static class UnstackColumnInfo {
        XTMetaData m_inputMD;
        String m_valueColumnName;
        int m_valueColumnNumber;
        Vector m_groupColumnNames;
        int m_numGroupColumns;
        int[] m_groupColumnNumbers;
        Vector m_keyColumnNames;
        int m_numKeyColumns;
        int[] m_keyColumnNumbers;
        int[] m_numGroupColumnLevels;
        int m_totalGroupOutputColumns;
        String[] m_groupOutputColumnNames;
        String[] m_keyOutputColumnNames;
        boolean[] m_keyOutputColumnsChanged;
        int[] m_keyOutputColumnNums;

        UnstackColumnInfo(XTProps props, XTMetaData inputMD) throws Exception {
            int keyCol;
            String colName;
            int i;
            this.m_inputMD = inputMD;
            this.m_valueColumnName = props.getValue(VALUE_COLUMN_ATTRIBUTE_TAG);
            this.m_valueColumnNumber = this.m_inputMD.nameToOrdinal(this.m_valueColumnName);
            if (this.m_valueColumnNumber < 0) {
                throw new Exception("no such value column: " + this.m_valueColumnName);
            }
            this.m_groupColumnNames = props.getSubProperties(GROUP_COLUMNS_ATTRIBUTE_TAG);
            this.m_numGroupColumns = this.m_groupColumnNames.size();
            this.m_groupColumnNumbers = new int[this.m_numGroupColumns];
            for (i = 0; i < this.m_numGroupColumns; ++i) {
                colName = (String)this.m_groupColumnNames.get(i);
                this.m_groupColumnNumbers[i] = this.m_inputMD.nameToOrdinal(colName);
                if (this.m_groupColumnNumbers[i] < 0) {
                    throw new Exception("no such group column: " + colName);
                }
                if (inputMD.isCategoricalColumn(this.m_groupColumnNumbers[i])) continue;
                throw new Exception("non-categorical group column: " + colName);
            }
            this.m_keyColumnNames = props.getSubProperties(KEY_COLUMNS_ATTRIBUTE_TAG);
            this.m_numKeyColumns = this.m_keyColumnNames.size();
            this.m_keyColumnNumbers = new int[this.m_numKeyColumns];
            for (i = 0; i < this.m_numKeyColumns; ++i) {
                colName = (String)this.m_keyColumnNames.get(i);
                this.m_keyColumnNumbers[i] = this.m_inputMD.nameToOrdinal(colName);
                if (this.m_keyColumnNumbers[i] >= 0) continue;
                throw new Exception("no such key column: " + colName);
            }
            this.m_numGroupColumnLevels = new int[this.m_numGroupColumns];
            this.m_totalGroupOutputColumns = 1;
            Vector[] groupLevels = new Vector[this.m_numGroupColumns];
            for (int groupCol = 0; groupCol < this.m_numGroupColumns; ++groupCol) {
                String colName2 = (String)this.m_groupColumnNames.get(groupCol);
                groupLevels[groupCol] = inputMD.getCategoricalDataFieldLevels(colName2);
                if (inputMD.getColumnMissingCount(colName2) > 0.0) {
                    groupLevels[groupCol].add("NaN");
                }
                this.m_numGroupColumnLevels[groupCol] = groupLevels[groupCol].size();
                this.m_totalGroupOutputColumns *= this.m_numGroupColumnLevels[groupCol];
            }
            int[] indices = new int[this.m_numGroupColumns];
            this.m_groupOutputColumnNames = new String[this.m_totalGroupOutputColumns];
            block3: for (int newCol = 0; newCol < this.m_totalGroupOutputColumns; ++newCol) {
                int col;
                String newColumnName = "";
                for (col = 0; col < this.m_numGroupColumns; ++col) {
                    if (col != 0) {
                        newColumnName = newColumnName + "_";
                    }
                    newColumnName = newColumnName + (String)groupLevels[col].get(indices[col]);
                }
                this.m_groupOutputColumnNames[newCol] = newColumnName;
                for (col = this.m_numGroupColumns - 1; col >= 0; --col) {
                    int n = col;
                    indices[n] = indices[n] + 1;
                    if (indices[col] < this.m_numGroupColumnLevels[col]) continue block3;
                    indices[col] = 0;
                }
            }
            if (this.m_totalGroupOutputColumns == 1 && this.m_numGroupColumns < 1) {
                this.m_groupOutputColumnNames[0] = "df.2";
            }
            this.m_keyOutputColumnNames = new String[this.m_numKeyColumns];
            this.m_keyOutputColumnsChanged = new boolean[this.m_numKeyColumns];
            int suffixInt = 1;
            for (keyCol = 0; keyCol < this.m_numKeyColumns; ++keyCol) {
                String keyColName;
                String testName = keyColName = (String)this.m_keyColumnNames.get(keyCol);
                while (true) {
                    int newCol;
                    boolean dup = false;
                    for (newCol = 0; newCol < this.m_totalGroupOutputColumns; ++newCol) {
                        if (!testName.equals(this.m_groupOutputColumnNames[newCol])) continue;
                        dup = true;
                        break;
                    }
                    for (newCol = 0; newCol < keyCol; ++newCol) {
                        if (!testName.equals(this.m_keyOutputColumnNames[newCol])) continue;
                        dup = true;
                        break;
                    }
                    if (!dup) break;
                    this.m_keyOutputColumnsChanged[keyCol] = true;
                    testName = keyColName + suffixInt++;
                }
                this.m_keyOutputColumnNames[keyCol] = testName;
            }
            this.m_keyOutputColumnNums = new int[this.m_numKeyColumns];
            for (keyCol = 0; keyCol < this.m_numKeyColumns; ++keyCol) {
                this.m_keyOutputColumnNums[keyCol] = keyCol;
            }
        }
    }
}

