/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.HelpManager;
import com.insightful.miner.MinerApp;
import com.insightful.miner.Win32Tools;
import java.awt.Frame;
import java.io.File;

public class WinHelpManagerImpl
implements HelpManager {
    private String m_chmFile;
    private int m_hwnd;
    private static final String TOPIC_SEPARATOR = "::/";
    private static final String DEFAULT_TOPIC = "Welcome.htm";
    private static final int HH_DISPLAY_TOPIC = 0;
    private static final int HH_DISPLAY_TOC = 1;
    private static final int HH_DISPLAY_INDEX = 2;
    private static final int HH_DISPLAY_SEARCH = 3;
    private static final int HH_CLOSE_ALL = 18;

    public WinHelpManagerImpl(String chmFile) {
        this(null, chmFile);
    }

    public WinHelpManagerImpl(Frame frame, String chmFile) {
        if (chmFile == null) {
            throw new IllegalArgumentException("Compile help file path is null.");
        }
        this.m_chmFile = chmFile.replace('/', '\\');
        if (frame == null) {
            this.m_hwnd = 0;
        } else {
            this.m_hwnd = Win32Tools.getHwnd(frame);
            if (this.m_hwnd < 0) {
                this.m_hwnd = 0;
            }
        }
    }

    public void showViewer() {
        this.showContents();
    }

    public void showContents() {
        WinHelpManagerImpl.nativeHtmlHelp(this.m_hwnd, this.m_chmFile, 1, 0);
    }

    public void showIndex() {
        WinHelpManagerImpl.nativeHtmlHelp(this.m_hwnd, this.m_chmFile, 2, 0);
    }

    public void showSearch() {
        WinHelpManagerImpl.nativeHtmlHelp(this.m_hwnd, this.m_chmFile, 3, 0);
    }

    public void showTopic(String topic) {
        this.showHtmlHelpTopic(this.m_chmFile, topic);
    }

    public void showHtmlHelpTopic(String fileName, String topic) {
        topic = topic.replace(' ', '_');
        if (!(topic = topic.replace(':', '_')).endsWith(".htm")) {
            topic = topic + ".htm";
        }
        WinHelpManagerImpl.nativeHtmlHelp(this.m_hwnd, fileName + TOPIC_SEPARATOR + topic, 0, 0);
    }

    public void showPDF(String filePath) {
        if (filePath == null || !new File(filePath).exists()) {
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), MinerApp.getText("WinHelpManagerImpl_msg_PDFFileNotFound"), MinerApp.getText("WinHelpManagerImpl_msg_fileNotFound"), 0);
            return;
        }
        if (!WinHelpManagerImpl.nativeShowPDF(new File(filePath).getAbsolutePath())) {
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), MinerApp.getText("WinHelpManagerImpl_msg_cannotLaunchPDFViewer"), MinerApp.getText("WinHelpManagerImpl_msg_viewFailed"), 0);
        }
    }

    public void exit() {
        WinHelpManagerImpl.nativeHtmlHelp(this.m_hwnd, this.m_chmFile, 18, 0);
    }

    private static native int nativeHtmlHelp(int var0, String var1, int var2, int var3);

    private static native boolean nativeShowPDF(String var0);
}

