/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerLicenseInfo;
import com.insightful.miner.Win32Tools;

public class WinLicenseManager {
    private static final int LMAPI_CONNECTERROR_NOCONNECT_CACHEBAD = 0;
    private static final int LMAPI_CONNECTERROR_SERVERDOWN = 1;
    private static final int LMAPI_CONNECTERROR_CANTRECONNECT = 2;
    private static final int LMAPI_CONNECTERROR_NOLICENSE = 3;
    private static final int LMAPI_CONNECTERROR_LICENSEINVALIDATED = 4;
    private static final int LMAPI_CONNECTERROR_NOCONNECT_CACHEGOOD = 5;
    private static final int LMAPI_CONNECTERROR_OUTOFCPUS = 6;
    private static final int LMAPI_CONNECTERROR_INVALIDLMVERSION = 7;
    private static final int LMAPI_CONNECTERROR_DIFFDISPLAYNAME = 100;
    private static final String TITLE_LMERROR = "License Manager Error";
    private static final String MESSAGE_NOCONNECT_CACHEBAD = "Cannot contact the license manager.  This may be caused by\nnetwork problems or server problems.  It may also be caused\nby a missing or invalid configuration file called 'lmaccess.ini'\nlocated in the program install directory.\n\nThis client has not previously been granted a license, or\nhas run the maximum number of allowable time since the\nlicense server was last contacted.\n\nThe license manager problems must be resolved before this\napplication may be used.";
    private static final String TITLE_NOCONNECT_CACHEBAD = "Cannot Contact License Manager:  No License";
    private static final String MESSAGE_NOCONNECT_CACHEGOOD = "Cannot contact the license manager.  This may be caused by\nnetwork problems or server problems.  It may also be caused\nby a missing or invalid configuration file called 'lmaccess.ini'\nlocated in the program install directory.\n\nThis client has previously been granted a license.  The\napplication may be run a limited number of times under\na temporary license.\n\nThe license manager problems must be resolved to assure future\naccess to the application.";
    private static final String TITLE_NOCONNECT_CACHEGOOD = "Cannot Contact License Manager:  Temporary License";
    private static final String TITLE_CONNECT_NOLICENSE = "No license available";
    private static final String MESSAGE_CONNECT_NOLICENSE = "No valid license can be found for this copy of the program.\nPlease contact your system adminstrator for more information.\n";
    private static final String TITLE_CONNECT_LICENSEINVALID = "License is invalid or not available";
    private static final String MESSAGE_CONNECT_LICENSEINVALID = "The license for this copy of the program has been invalidated\nor is not available.\n\nPlease contact your system adminstrator for more information.\n";
    private static final String TITLE_CONNECT_INVALIDLMVERSION = "Invalid version of the License Manager";
    private static final String MESSAGE_CONNECT_INVALIDLMVERSION = "The version of the license manager is significantly lower than the version\nof this program which uses it.  A newer version of the license manager must\nbe installed to use this program.\n\nPlease contact your system adminstrator to update the license manager to the lastest version.\n\n";
    private static final String TITLE_CONNECT_OUTOFCPUS = "Exceeded licensed CPUs";
    private static final String MESSAGE_CONNECT_OUTOFCPUS = "You have exceeded the number of CPUs licensed on this server.\nPlease contact Insightful for additional CPU licenses.";
    private static final String TITLE_CONNECT_DIFFDISPLAYNAME = "Remote access not supported";
    private static final String MESSAGE_CONNECT_DIFFDISPLAYNAME = "This edition of the program does not support remote access through terminals.\nPlease contact Insightful for a license which allows remote access.";
    private static MinerLicenseInfo g_licenseInfo = new MinerLicenseInfo();

    private WinLicenseManager() {
    }

    public static boolean hasValidLicense() {
        boolean validFlag = false;
        Win32Tools.loadLibraries();
        validFlag = WinLicenseManager.nativeIsLicenseValid(MinerApp.isInteractive(), g_licenseInfo);
        if (!validFlag && !MinerApp.isInteractive()) {
            System.out.println(MESSAGE_CONNECT_NOLICENSE);
        }
        return validFlag;
    }

    public static MinerLicenseInfo getLicenseInfo() {
        return g_licenseInfo;
    }

    public static int shutdownLicenseManager() {
        return WinLicenseManager.nativeShutdownLicenseManager();
    }

    public static boolean handleLicenseManagerErrorMessage(int errorCode, String sErrorInfoFromLM) {
        boolean result = false;
        MinerApp.outputText("License manager error condition", 0, true);
        MinerApp.outputText("  Error code:  " + errorCode + ", Error message: " + sErrorInfoFromLM, 0, true);
        AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), "Error code:  " + errorCode + "\n\nError message: " + sErrorInfoFromLM, TITLE_LMERROR, 0);
        return result;
    }

    private static native boolean nativeIsLicenseValid(boolean var0, MinerLicenseInfo var1);

    private static native int nativeShutdownLicenseManager();
}

