/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.ReadDatabaseDialog;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class WriteDatabaseDialog
extends NodeDialog {
    protected JTextField m_dbUserTextField;
    protected JPasswordField m_dbPasswordTextField;
    protected JTextField m_dbDatabaseTextField;
    protected JTextField m_dbTableTextField;
    protected JTextField m_dbServerTextField;
    protected JRadioButton m_createTableRadioButton;
    protected JRadioButton m_overwriteTableRadioButton;
    protected JRadioButton m_appendTableRadioButton;
    private static WriteDatabaseDialog instance = null;

    public static WriteDatabaseDialog getInstance() {
        if (instance == null) {
            instance = new WriteDatabaseDialog();
        }
        return instance;
    }

    protected WriteDatabaseDialog() {
        this.setMinimumSize(new Dimension(400, 400));
    }

    public void restoreProperties() {
        String writeOptionDefault;
        String writeOption;
        super.restoreProperties();
        XTProps props = this.getNodeModel().getXTProps();
        if (this.m_dbUserTextField != null) {
            this.m_dbUserTextField.setText(props.getValue("dbUser", ""));
        }
        if (this.m_dbPasswordTextField != null) {
            this.m_dbPasswordTextField.setText(props.getValue("dbPassword", ""));
        }
        if (this.m_dbDatabaseTextField != null) {
            this.m_dbDatabaseTextField.setText(props.getValue("dbDatabase", ""));
        }
        if (this.m_dbTableTextField != null) {
            this.m_dbTableTextField.setText(props.getValue("dbTable", ""));
        }
        if (this.m_dbServerTextField != null) {
            this.m_dbServerTextField.setText(props.getValue("dbServer", ""));
        }
        if ((writeOption = props.getValue("dbWriteOption", writeOptionDefault = props.getBoolean("dbAppend", false) ? "append" : "overwrite")).equals("overwrite")) {
            this.m_overwriteTableRadioButton.setSelected(true);
        } else if (writeOption.equals("append")) {
            this.m_appendTableRadioButton.setSelected(true);
        } else {
            this.m_createTableRadioButton.setSelected(true);
        }
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        this.saveFileProperties(props);
    }

    public void saveFileProperties(XTProps props) {
        if (this.m_dbUserTextField != null) {
            props.set("dbUser", this.m_dbUserTextField.getText());
        }
        if (this.m_dbPasswordTextField != null) {
            props.set("dbPassword", String.valueOf(this.m_dbPasswordTextField.getPassword()));
        }
        if (this.m_dbDatabaseTextField != null) {
            props.set("dbDatabase", this.m_dbDatabaseTextField.getText());
        }
        if (this.m_dbTableTextField != null) {
            props.set("dbTable", this.m_dbTableTextField.getText());
        }
        if (this.m_dbServerTextField != null) {
            props.set("dbServer", this.m_dbServerTextField.getText());
        }
        String writeOption = "create";
        if (this.m_overwriteTableRadioButton.isSelected()) {
            writeOption = "overwrite";
        } else if (this.m_appendTableRadioButton.isSelected()) {
            writeOption = "append";
        }
        props.set("dbWriteOption", writeOption);
    }

    public XTProps getCurrentFileProperties() {
        try {
            XTProps props = new XTProps();
            this.saveFileProperties(props);
            return props;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected JTextField addDBField(GridBagConstraints gc, JPanel panel, int gridy, boolean isPasswordTextField, String textTag, String hotKeyTag) {
        String hotKeyString;
        JTextField textField = isPasswordTextField ? new JPasswordField() : new JTextField();
        JLabel label = new JLabel(MinerApp.getText(textTag));
        if (hotKeyTag != null && (hotKeyString = MinerApp.getText(hotKeyTag)) != null && hotKeyString.length() > 0) {
            label.setDisplayedMnemonic(hotKeyString.charAt(0));
        }
        label.setLabelFor(textField);
        gc.fill = 0;
        gc.anchor = 18;
        gc.insets = new Insets(5, 5, 5, 5);
        gc.gridx = 0;
        gc.gridy = gridy;
        gc.gridheight = 1;
        gc.gridwidth = 2;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        panel.add((Component)label, gc);
        gc.fill = 2;
        gc.gridx = -1;
        gc.gridy = gridy;
        gc.gridheight = 1;
        gc.gridwidth = 6;
        gc.weightx = 1.0;
        panel.add((Component)textField, gc);
        return textField;
    }

    protected JTextField addDBTableNameField(GridBagConstraints gc, JPanel panel, int gridy, boolean last, String textTag, String hotKeyTag) {
        String hotKeyString;
        JTextField textField = new JTextField();
        JLabel label = new JLabel(MinerApp.getText(textTag));
        label.setLabelFor(textField);
        if (hotKeyTag != null && (hotKeyString = MinerApp.getText(hotKeyTag)) != null && hotKeyString.length() > 0) {
            label.setDisplayedMnemonic(hotKeyString.charAt(0));
        }
        String buttonLabel = MinerApp.getText("ReadDatabaseDialog_browseTablesButtonLabel");
        AbstractAction buttonAction = new AbstractAction(buttonLabel){

            public void actionPerformed(ActionEvent e) {
                if (WriteDatabaseDialog.this.m_dbTableTextField == null) {
                    return;
                }
                String oldTable = WriteDatabaseDialog.this.m_dbTableTextField.getText();
                String newTable = ReadDatabaseDialog.browseTableNames(WriteDatabaseDialog.this, WriteDatabaseDialog.this.getCurrentFileProperties(), oldTable);
                if (newTable != null) {
                    WriteDatabaseDialog.this.m_dbTableTextField.setText(newTable);
                }
            }
        };
        JButton browseButton = new JButton(buttonAction);
        String buttonHotkey = MinerApp.getText("ReadDatabaseDialog_browseTablesButtonHotkey");
        if (buttonHotkey != null && buttonHotkey.length() > 0) {
            browseButton.setMnemonic(buttonHotkey.charAt(0));
        }
        gc.fill = 0;
        gc.anchor = 18;
        gc.insets = new Insets(5, 5, 5, 5);
        gc.gridx = 0;
        gc.gridy = gridy;
        gc.gridheight = 1;
        gc.gridwidth = 2;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        if (last) {
            gc.weighty = 1.0;
        }
        panel.add((Component)label, gc);
        gc.fill = 2;
        gc.anchor = 18;
        gc.insets = new Insets(5, 5, 5, 5);
        gc.gridx = 2;
        gc.gridy = gridy;
        gc.gridheight = 1;
        gc.gridwidth = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        if (last) {
            gc.weighty = 1.0;
        }
        panel.add((Component)textField, gc);
        gc.fill = 2;
        gc.anchor = 18;
        gc.insets = new Insets(5, 5, 5, 5);
        gc.gridx = 4;
        gc.gridy = gridy;
        gc.gridheight = 1;
        gc.gridwidth = 2;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        if (last) {
            gc.weighty = 1.0;
        }
        panel.add((Component)browseButton, gc);
        return textField;
    }

    protected JRadioButton addDBRadioButton(GridBagConstraints gc, JPanel panel, int gridy, boolean last, String textTag, String hotKeyTag) {
        String hotKeyString;
        JRadioButton rb = new JRadioButton(MinerApp.getText(textTag));
        if (hotKeyTag != null && (hotKeyString = MinerApp.getText(hotKeyTag)) != null && hotKeyString.length() > 0) {
            rb.setMnemonic(hotKeyString.charAt(0));
        }
        gc.fill = 2;
        gc.anchor = 18;
        gc.insets = new Insets(0, 5, 0, 5);
        gc.gridx = -1;
        gc.gridy = gridy;
        gc.gridheight = 1;
        gc.gridwidth = 1;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        if (last) {
            gc.weighty = 1.0;
        }
        panel.add((Component)rb, gc);
        return rb;
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        optionsPanel.add((Component)this.createDBFieldsPanel(), "North");
        optionsPanel.add((Component)this.createWriteOptionPanel(), "Center");
        return optionsPanel;
    }

    protected JPanel createDBFieldsPanel() {
        JPanel dbFieldsPanel = new JPanel();
        dbFieldsPanel.setLayout(new GridBagLayout());
        dbFieldsPanel.setBorder(new TitledBorder(new EtchedBorder(), MinerApp.getText("WriteDatabaseDialog_odbcBorder")));
        GridBagConstraints gc = new GridBagConstraints();
        int gridy = 0;
        this.m_dbUserTextField = this.addDBField(gc, dbFieldsPanel, gridy++, false, "WriteDatabaseDialog_dbUserLabel", "WriteDatabaseDialog_dbUserHotkey");
        this.m_dbPasswordTextField = (JPasswordField)this.addDBField(gc, dbFieldsPanel, gridy++, true, "WriteDatabaseDialog_dbPasswordLabel", "WriteDatabaseDialog_dbPasswordHotkey");
        this.m_dbDatabaseTextField = this.addDBField(gc, dbFieldsPanel, gridy++, false, "WriteDatabaseDialog_dbDataSourceNameLabel", "WriteDatabaseDialog_dbDataSourceNameHotkey");
        this.m_dbTableTextField = this.addDBTableNameField(gc, dbFieldsPanel, gridy++, true, "WriteDatabaseDialog_dbTableLabel", "WriteDatabaseDialog_dbTableHotkey");
        dbFieldsPanel.setSize(dbFieldsPanel.getPreferredSize());
        return dbFieldsPanel;
    }

    protected JPanel createWriteOptionPanel() {
        JPanel writeOptionPanel = new JPanel();
        writeOptionPanel.setLayout(new GridBagLayout());
        writeOptionPanel.setBorder(new TitledBorder(new EtchedBorder(), MinerApp.getText("WriteDatabaseDialog_writeOptionsBorder")));
        GridBagConstraints gc = new GridBagConstraints();
        int gridy = 0;
        this.m_createTableRadioButton = this.addDBRadioButton(gc, writeOptionPanel, gridy++, false, "WriteDatabaseDialog_createTableLabel", "WriteDatabaseDialog_createTableHotkey");
        this.m_overwriteTableRadioButton = this.addDBRadioButton(gc, writeOptionPanel, gridy++, false, "WriteDatabaseDialog_overwriteTableLabel", "WriteDatabaseDialog_overwriteTableHotkey");
        this.m_appendTableRadioButton = this.addDBRadioButton(gc, writeOptionPanel, gridy++, true, "WriteDatabaseDialog_appendTableLabel", "WriteDatabaseDialog_appendTableHotkey");
        ButtonGroup writeOptionButtonGroup = new ButtonGroup();
        writeOptionButtonGroup.add(this.m_createTableRadioButton);
        writeOptionButtonGroup.add(this.m_overwriteTableRadioButton);
        writeOptionButtonGroup.add(this.m_appendTableRadioButton);
        writeOptionPanel.setSize(writeOptionPanel.getPreferredSize());
        return writeOptionPanel;
    }
}

