/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.CreateDictionaryDialog;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.ReadOtherFileDialog;
import com.insightful.miner.ReadTextFileDialog;
import com.insightful.miner.WriteOtherFileDialog;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class WriteFixedFormatFileDialog
extends NodeDialog {
    private JTextField fileNameTextField;
    private JTextField dictionaryTextField;
    private JTextField m_NAStringTextField;
    private NodeDialog.DateOutputFormatComboBox m_timeDateFormatComboBox;
    private static String[] m_typeDescriptionList = new String[]{"Text File (*.txt)", "Data File (*.dat)", "ASCII File (*.asc)", "Print Format File (*.prn)"};
    private static String[][] m_extensionList = new String[][]{{".txt"}, {".dat"}, {".asc"}, {".prn"}};
    private AbstractAction fileNameTextFieldAction;
    private AbstractAction typeComboBoxAction;
    private AbstractAction saveAsAction;
    private static WriteFixedFormatFileDialog instance = null;

    public static WriteFixedFormatFileDialog getInstance() {
        if (instance == null) {
            instance = new WriteFixedFormatFileDialog();
        }
        return instance;
    }

    private WriteFixedFormatFileDialog() {
        this.setResizable(true);
        Dimension min = new Dimension(610, 400);
        this.setMinimumSize(min);
        this.setSize(min);
    }

    public void onOk() {
        if (WriteOtherFileDialog.hasFilenameChanged(this.fileNameTextField, this.getNodeModel().getXTProps()) && !ReadOtherFileDialog.checkOverWriteFile(this, this.fileNameTextField.getText())) {
            return;
        }
        super.onOk();
    }

    public void restoreProperties() {
        super.restoreProperties();
        XTProps props = this.getNodeModel().getXTProps();
        this.fileNameTextField.setText(props.getValue("filePath", ""));
        this.dictionaryTextField.setText(props.getValue("dictionaryFile", ""));
        this.m_NAStringTextField.setText(props.getValue("NAString", ""));
        this.m_timeDateFormatComboBox.setText(props.getValue("timeDateFormat", MinerApp.getWorksheetPropertiesManager().getDateFormatString()));
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        String path = this.fileNameTextField.getText();
        WriteOtherFileDialog.directoryCreationCheck(this.tabbedPane, path);
        props.set("filePath", path);
        props.set("dictionaryFile", this.dictionaryTextField.getText());
        props.set("NAString", this.m_NAStringTextField.getText());
        props.set("timeDateFormat", this.m_timeDateFormatComboBox.getText());
    }

    public void createActions() {
        super.createActions();
        this.saveAsAction = new AbstractAction(MinerApp.getText("WriteTextFileDialog_browse")){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.browseWriteFileName(instance, WriteFixedFormatFileDialog.this.fileNameTextField, m_extensionList, m_typeDescriptionList, null);
            }
        };
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel saveFilePanel = new JPanel(new GridBagLayout());
        this.fileNameTextField = new JTextField(25);
        this.fileNameTextField.setAction(this.fileNameTextFieldAction);
        JLabel fileNameLabel = new JLabel(MinerApp.getText("WriteTextFileDialog_filename"));
        fileNameLabel.setDisplayedMnemonic(70);
        JButton browseButton = new JButton(this.saveAsAction);
        browseButton.setMnemonic('b');
        fileNameLabel.setLabelFor(browseButton);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridwidth = 2;
        constraints.weightx = 0.0;
        saveFilePanel.add((Component)fileNameLabel, constraints);
        constraints.gridwidth = 6;
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        saveFilePanel.add((Component)this.fileNameTextField, constraints);
        constraints.gridx = 8;
        constraints.weightx = 0.0;
        constraints.gridwidth = 2;
        constraints.fill = 0;
        saveFilePanel.add((Component)browseButton, constraints);
        constraints.gridy = 2;
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.gridwidth = 10;
        constraints.insets = new Insets(15, 0, 15, 0);
        saveFilePanel.add((Component)new JSeparator(0), constraints);
        JPanel moreOptionsPanel = new JPanel(new GridBagLayout());
        moreOptionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ReadTextFileDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel dictionaryLabel = new JLabel(MinerApp.getText("ReadOtherFileDialog_dataDictionary"));
        dictionaryLabel.setDisplayedMnemonic('d');
        this.dictionaryTextField = new JTextField(25);
        JButton dictionaryBrowseButton = new JButton(new AbstractAction(MinerApp.getText("ReadTextFileDialog_browse")){

            public void actionPerformed(ActionEvent e) {
                ReadTextFileDialog.browseDictionaryFileName(instance, WriteFixedFormatFileDialog.this.dictionaryTextField);
            }
        });
        dictionaryBrowseButton.setMnemonic(82);
        dictionaryLabel.setLabelFor(dictionaryBrowseButton);
        JButton createdictionaryBrowseButton = new JButton(new AbstractAction(MinerApp.getText("ReadFixedFormatFileDialog_createEdit")){

            public void actionPerformed(ActionEvent e) {
                CreateDictionaryDialog dlg = new CreateDictionaryDialog(WriteFixedFormatFileDialog.this, WriteFixedFormatFileDialog.this.dictionaryTextField.getText());
                dlg.show();
                if (dlg.success) {
                    WriteFixedFormatFileDialog.this.dictionaryTextField.setText(dlg.filename);
                }
            }
        });
        createdictionaryBrowseButton.setMnemonic(67);
        dictionaryLabel.setLabelFor(createdictionaryBrowseButton);
        JLabel naLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_missingValString"));
        this.m_NAStringTextField = new JTextField(15);
        naLabel.setDisplayedMnemonic('v');
        naLabel.setLabelFor(this.m_NAStringTextField);
        JLabel timeDateFormatLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_dateTimeFormat"));
        this.m_timeDateFormatComboBox = new NodeDialog.DateOutputFormatComboBox();
        timeDateFormatLabel.setDisplayedMnemonic('f');
        timeDateFormatLabel.setLabelFor(this.m_timeDateFormatComboBox);
        int gridy = 0;
        GridBagConstraints optionsConstraints = new GridBagConstraints();
        optionsConstraints.anchor = 18;
        optionsConstraints.gridy = gridy++;
        optionsConstraints.gridx = 0;
        optionsConstraints.weightx = 0.0;
        moreOptionsPanel.add((Component)dictionaryLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 1.0;
        optionsConstraints.insets = new Insets(0, 25, 0, 0);
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.dictionaryTextField, optionsConstraints);
        optionsConstraints.weightx = 0.0;
        optionsConstraints.gridx = 2;
        optionsConstraints.insets = new Insets(0, 10, 0, 10);
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)dictionaryBrowseButton, optionsConstraints);
        optionsConstraints.weightx = 0.0;
        optionsConstraints.gridx = 3;
        optionsConstraints.insets = new Insets(0, 10, 0, 10);
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)createdictionaryBrowseButton, optionsConstraints);
        optionsConstraints.gridx = 0;
        optionsConstraints.gridy = gridy++;
        optionsConstraints.gridwidth = 1;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.insets = new Insets(10, 0, 0, 0);
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)timeDateFormatLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.gridwidth = 3;
        optionsConstraints.weighty = 1.0;
        optionsConstraints.insets = new Insets(10, 25, 0, 10);
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.m_timeDateFormatComboBox, optionsConstraints);
        optionsPanel.add((Component)saveFilePanel, "North");
        optionsPanel.add((Component)moreOptionsPanel, "Center");
        return optionsPanel;
    }
}

