/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.XMLTree;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLTreeProps
extends XMLTree {
    protected Element propertyRootNode = null;
    public static String XT_PROPERTY_NODE_TAG = "XTProps";
    public static String PROPERTY_NODE_TAG = "Property";
    public static String NAME_ATTRIBUTE_TAG = "name";
    public static String VALUE_ATTRIBUTE_TAG = "value";
    public static String COMPLEX_NODE_TAG = "Complex";
    public static String COMPLEX_ATTRIBUTE_TAG = "complex";

    public XMLTreeProps() throws Exception {
        this.propertyRootNode = this.m_document.createElement(XT_PROPERTY_NODE_TAG);
        this.m_xml.appendChild(this.propertyRootNode);
    }

    public XMLTreeProps(Element elt) throws Exception {
        super(elt);
        this.propertyRootNode = this.m_xml.getNodeName().equals(XMLTree.IMML_NODE_TAG) ? (Element)this.m_xml.getFirstChild() : this.m_xml;
        if (this.propertyRootNode == null) {
            throw new Exception("Root node was not found.");
        }
        if (!this.propertyRootNode.getNodeName().equals(XT_PROPERTY_NODE_TAG)) {
            throw new Exception("Malformed XML: no " + XT_PROPERTY_NODE_TAG + " tag was found.");
        }
    }

    public XMLTreeProps(XMLTree md) throws Exception {
        super(md);
        this.propertyRootNode = this.m_xml.getNodeName().equals(XT_PROPERTY_NODE_TAG) ? this.m_xml : (Element)this.m_xml.getFirstChild();
        if (this.propertyRootNode == null) {
            throw new Exception("Root node was not found.");
        }
        if (!this.propertyRootNode.getNodeName().equals(XT_PROPERTY_NODE_TAG)) {
            throw new Exception("Malformed XML: no " + XT_PROPERTY_NODE_TAG + " tag was found.");
        }
    }

    public int getInt(String prop, int defaultValue) {
        try {
            Element element = this.findProperty(prop);
            return Integer.parseInt(element.getAttribute(VALUE_ATTRIBUTE_TAG));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int getInt(String[] path, int defaultValue) {
        try {
            Element element = this.findProperty(path);
            return Integer.parseInt(element.getAttribute(VALUE_ATTRIBUTE_TAG));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double getDouble(String prop, double defaultValue) {
        try {
            Element element = this.findProperty(prop);
            return Double.parseDouble(element.getAttribute(VALUE_ATTRIBUTE_TAG));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double getDouble(String[] path, double defaultValue) {
        try {
            Element element = this.findProperty(path);
            return Double.parseDouble(element.getAttribute(VALUE_ATTRIBUTE_TAG));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String prop) {
        return this.getBoolean(prop, false);
    }

    public boolean getBoolean(String prop, boolean defaultValue) {
        try {
            Element element = this.findProperty(prop);
            return Boolean.valueOf(element.getAttribute(VALUE_ATTRIBUTE_TAG));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String[] path, boolean defaultValue) {
        try {
            Element element = this.findProperty(path);
            return Boolean.valueOf(element.getAttribute(VALUE_ATTRIBUTE_TAG));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String getValue(String prop) {
        return this.getValue(prop, "");
    }

    public String getValue(String prop, String defaultValue) {
        try {
            Element element = this.findProperty(prop);
            return this.getValue(element);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String getValue(String[] path) {
        return this.getValue(path, "");
    }

    public String getValue(String[] path, String defaultValue) {
        try {
            Element element = this.findProperty(path);
            return this.getValue(element);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Vector getSubProperties(String prop) {
        try {
            Element element = this.findProperty(prop);
            NodeList list = element.getChildNodes();
            Vector<String> ret = new Vector<String>();
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                ret.addElement(((Element)list.item(i)).getAttribute(NAME_ATTRIBUTE_TAG));
            }
            return ret;
        }
        catch (Exception e) {
            return new Vector();
        }
    }

    public Vector getSubPropertyValues(String prop) {
        try {
            Element element = this.findProperty(prop);
            NodeList list = element.getChildNodes();
            Vector<String> ret = new Vector<String>();
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                ret.addElement(((Element)list.item(i)).getAttribute(VALUE_ATTRIBUTE_TAG));
            }
            return ret;
        }
        catch (Exception e) {
            return new Vector();
        }
    }

    public Vector getSubPropertyValues(String[] path) {
        try {
            Element element = this.findProperty(path);
            NodeList list = element.getChildNodes();
            Vector<String> ret = new Vector<String>();
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                ret.addElement(((Element)list.item(i)).getAttribute(VALUE_ATTRIBUTE_TAG));
            }
            return ret;
        }
        catch (Exception e) {
            return new Vector();
        }
    }

    public Vector getSubProperties(String[] path) {
        try {
            Element element = this.findProperty(path);
            NodeList list = element.getChildNodes();
            Vector<String> ret = new Vector<String>();
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                ret.addElement(((Element)list.item(i)).getAttribute(NAME_ATTRIBUTE_TAG));
            }
            return ret;
        }
        catch (Exception e) {
            return new Vector();
        }
    }

    public Vector getFirstLevelProperties() {
        try {
            String[] path = new String[]{};
            return this.getSubProperties(path);
        }
        catch (Exception e) {
            return new Vector();
        }
    }

    public boolean isPathValid(String[] path) {
        return this.findProperty(path) != null;
    }

    public void set(String prop, String value) {
        Element property = this.findProperty(prop);
        if (property == null) {
            property = this.m_document.createElement(PROPERTY_NODE_TAG);
            property.setAttribute(NAME_ATTRIBUTE_TAG, prop);
            this.propertyRootNode.appendChild(property);
        }
        this.setValue(property, value);
    }

    public void set(String prop, boolean value) {
        this.set(prop, String.valueOf(value));
    }

    public void set(String prop, int value) {
        this.set(prop, String.valueOf(value));
    }

    public void set(String prop1, String prop2, boolean value) {
        this.set(prop1, prop2, String.valueOf(value));
    }

    public void set(String prop1, String prop2, String value) {
        Element property1 = this.findProperty(prop1);
        if (property1 != null) {
            Element property2 = this.findPropertyFrom(prop2, property1);
            if (property2 == null) {
                property2 = this.m_document.createElement(PROPERTY_NODE_TAG);
            }
            property2.setAttribute(NAME_ATTRIBUTE_TAG, prop2);
            this.setValue(property2, value);
            property1.appendChild(property2);
            return;
        }
        property1 = this.m_document.createElement(PROPERTY_NODE_TAG);
        property1.setAttribute(NAME_ATTRIBUTE_TAG, prop1);
        this.setValue(property1, "");
        Element property2 = this.m_document.createElement(PROPERTY_NODE_TAG);
        property2.setAttribute(NAME_ATTRIBUTE_TAG, prop2);
        this.setValue(property2, value);
        property1.appendChild(property2);
        this.propertyRootNode.appendChild(property1);
    }

    public void set(String[] path, boolean value) {
        this.set(path, String.valueOf(value));
    }

    public void set(String[] path, String value) {
        Element attachTo = this.propertyRootNode;
        Element toBeAttached = null;
        for (int i = 0; i < path.length; ++i) {
            toBeAttached = this.findPropertyFrom(path[i], attachTo);
            if (toBeAttached == null) {
                toBeAttached = this.m_document.createElement(PROPERTY_NODE_TAG);
                toBeAttached.setAttribute(NAME_ATTRIBUTE_TAG, path[i]);
                attachTo.appendChild(toBeAttached);
            }
            attachTo = toBeAttached;
            if (i != path.length - 1) continue;
            this.setValue(toBeAttached, value);
        }
    }

    public void setSubProperties(String prop1, String prop2, Vector properties) {
        for (int i = 0; i < properties.size(); ++i) {
            this.set(prop1, prop2, (String)properties.get(i));
        }
    }

    public boolean removeProperty(String[] path) {
        try {
            Element removal = this.findProperty(path);
            Element parent = (Element)removal.getParentNode();
            parent.removeChild(removal);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public XMLTree copy() {
        try {
            XMLTreeProps p = (XMLTreeProps)this.clone();
            return p;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object clone() {
        try {
            return new XMLTreeProps(this);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Element findProperty(String prop) {
        for (Element child = (Element)this.propertyRootNode.getFirstChild(); child != null; child = (Element)child.getNextSibling()) {
            if (!child.getAttribute(NAME_ATTRIBUTE_TAG).equals(prop)) continue;
            return child;
        }
        return null;
    }

    protected Element findPropertyFrom(String find, Element from) {
        for (Element child = (Element)from.getFirstChild(); child != null; child = (Element)child.getNextSibling()) {
            if (!child.getAttribute(NAME_ATTRIBUTE_TAG).equals(find)) continue;
            return child;
        }
        return null;
    }

    protected Element findProperty(String[] path) {
        Element node = this.propertyRootNode;
        for (int i = 0; i < path.length; ++i) {
            if ((node = this.findPropertyFrom(path[i], node)) != null) continue;
            return null;
        }
        return node;
    }

    protected void setValue(Element property, String value) {
        int newLineIndex = value.indexOf("\n");
        int tabIndex = value.indexOf("\t");
        if (newLineIndex == -1 && tabIndex == -1) {
            if (property.getAttribute(COMPLEX_ATTRIBUTE_TAG).equals("true")) {
                Node node = property.getFirstChild();
                property.removeAttribute(COMPLEX_ATTRIBUTE_TAG);
                property.removeChild(node);
            }
            property.setAttribute(VALUE_ATTRIBUTE_TAG, value);
        } else {
            if (!property.getAttribute(COMPLEX_ATTRIBUTE_TAG).equals("true")) {
                property.setAttribute(COMPLEX_ATTRIBUTE_TAG, "true");
                Element complex = this.m_document.createElement(COMPLEX_NODE_TAG);
                Text text = this.m_document.createTextNode(value);
                complex.appendChild(text);
                if (property.hasChildNodes()) {
                    property.insertBefore(complex, property.getFirstChild());
                } else {
                    property.appendChild(complex);
                }
            } else {
                Element complex = (Element)property.getFirstChild();
                Text text = (Text)complex.getFirstChild();
                text.setNodeValue(value);
            }
            if (property.hasAttribute(VALUE_ATTRIBUTE_TAG)) {
                property.removeAttribute(VALUE_ATTRIBUTE_TAG);
            }
        }
    }

    protected String getValue(Element element) {
        if (element.getAttribute(COMPLEX_ATTRIBUTE_TAG).equals("true")) {
            Element complex = (Element)element.getFirstChild();
            Text text = (Text)complex.getFirstChild();
            return text.getNodeValue();
        }
        return element.getAttribute(VALUE_ATTRIBUTE_TAG);
    }

    public static void test() {
    }
}

