/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.graphdlg.controls;

import com.insightful.miner.graphdlg.controls.MinerControlMethods;
import com.insightful.miner.graphdlg.controls.MinerLabelBox;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class MinerRadioButtonGroup
extends MinerLabelBox
implements MinerControlMethods {
    int listSize;
    JRadioButton[] buttonList;
    ButtonGroup buttonGroup;
    JPanel buttonPanel;

    public MinerRadioButtonGroup(String text, char mnemonic, String[] listData) {
        this(text, listData);
        this.setMnemonic(mnemonic);
    }

    public MinerRadioButtonGroup(String text, int mnemonic, String[] listData) {
        this(text, listData);
        this.setMnemonic(mnemonic);
    }

    public MinerRadioButtonGroup(String text, String[] listData) {
        super(text);
        this.listSize = listData.length;
        this.buttonList = new JRadioButton[this.listSize];
        this.buttonGroup = new ButtonGroup();
        for (int i = 0; i < this.listSize; ++i) {
            this.buttonList[i] = new JRadioButton(listData[i], i == 0);
            this.buttonList[i].setPreferredSize(labelDimension);
            this.buttonGroup.add(this.buttonList[i]);
        }
        int totalHeight = MinerRadioButtonGroup.labelDimension.height * this.listSize;
        if (!text.endsWith(":")) {
            text = text + ":";
        }
        this.buttonPanel = new JPanel();
        for (int i = 0; i < this.listSize; ++i) {
            this.buttonPanel.add(this.buttonList[i]);
        }
        this.buttonPanel.setLayout(new GridLayout(this.listSize, 1));
        this.buttonPanel.setPreferredSize(new Dimension(MinerRadioButtonGroup.labelDimension.width, totalHeight));
        this.setActionControl(this.buttonPanel);
        this.setLabelFor(this.buttonList[0]);
    }

    public String getValue() {
        for (int i = 0; i < this.listSize; ++i) {
            if (!this.buttonList[i].isSelected()) continue;
            return this.buttonList[i].getText();
        }
        return "";
    }

    public void setValue(String value) {
        for (int i = 0; i < this.listSize; ++i) {
            if (!this.buttonList[i].getText().equals(value)) continue;
            this.buttonList[i].setSelected(true);
        }
    }

    public String[] getOptionList() {
        return null;
    }

    public void setOptionList(String[] listData) {
        if (listData.length == this.listSize) {
            for (int i = 0; i < this.listSize; ++i) {
                this.buttonList[i].setText(listData[i]);
            }
        }
    }

    public boolean isEnabled() {
        return this.buttonList[0].isEnabled();
    }

    public void setEnabled(boolean b) {
        this.setLabelEnabled(b);
        for (int i = 0; i < this.listSize; ++i) {
            this.buttonList[i].setEnabled(b);
        }
    }

    public void addActionListener(ActionListener listener) {
        for (int i = 0; i < this.listSize; ++i) {
            this.buttonList[i].addActionListener(listener);
        }
    }

    public String getActionCommand() {
        return this.buttonList[0].getActionCommand();
    }

    public void setActionCommand(String aCommand) {
        for (int i = 0; i < this.listSize; ++i) {
            this.buttonList[i].setActionCommand(aCommand);
        }
    }
}

