/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql;

import com.insightful.miner.sql.Expression;
import com.insightful.miner.sql.HsqlException;
import com.insightful.miner.sql.Result;
import com.insightful.miner.sql.Select;
import com.insightful.miner.sql.SubQuery;
import com.insightful.miner.sql.Trace;

final class CompiledStatement {
    static final int UNKNOWN = 0;
    static final int INSERT_VALUES = 1;
    static final int INSERT_SELECT = 2;
    static final int UPDATE = 3;
    static final int DELETE = 4;
    static final int SELECT = 5;
    static final int CALL = 6;
    static final int DML = 7;
    static final int DQL = 8;
    static final int DDL = 9;
    Expression condition;
    int[] columnMap;
    Expression[] columnValues;
    boolean[] checkColumns;
    Expression expression;
    Select select;
    Expression[] parameters;
    int[] paramTypes;
    SubQuery[] subqueries;
    int type;
    String tableName;
    String sql;
    private static final Result updateCount = new Result(1);

    CompiledStatement() {
        this.parameters = new Expression[0];
        this.paramTypes = new int[0];
        this.subqueries = new SubQuery[0];
        this.type = 9;
    }

    void bind(Object[] values) throws HsqlException {
        Trace.check(this.parameters != null, 5);
        int len = this.parameters.length;
        Trace.check(values.length >= len, 5);
        for (int i = 0; i < len; ++i) {
            this.parameters[i].bind(values[i]);
        }
    }

    CompiledStatement(String tableName, boolean delete, Expression deleteCondition, Expression[] parameters) throws HsqlException {
        this.tableName = tableName;
        if (deleteCondition != null) {
            this.condition = new Expression(deleteCondition);
            this.condition.resolveTypes();
        }
        this.setParameters(parameters);
        this.type = 4;
    }

    CompiledStatement(String tableName, int[] columnMap, Expression[] columnValues, Expression updateCondition, Expression[] parameters) throws HsqlException {
        this.tableName = tableName;
        this.columnMap = columnMap;
        this.columnValues = columnValues;
        for (int i = 0; i < columnValues.length; ++i) {
            Expression cve = columnValues[i];
            if (cve.isParam()) continue;
            cve.resolveTypes();
        }
        if (updateCondition != null) {
            this.condition = new Expression(updateCondition);
            this.condition.resolveTypes();
        }
        this.setParameters(parameters);
        this.type = 3;
    }

    CompiledStatement(int[] columnMap, Expression[] columnValues, boolean[] checkColumns, Expression[] parameters) throws HsqlException {
        this.columnMap = columnMap;
        this.checkColumns = checkColumns;
        this.columnValues = columnValues;
        for (int i = 0; i < columnValues.length; ++i) {
            Expression cve = columnValues[i];
            if (!cve.isParam()) continue;
        }
        this.setParameters(parameters);
        this.type = 1;
    }

    CompiledStatement(int[] columnMap, boolean[] checkColumns, Select select, Expression[] parameters) throws HsqlException {
        this.columnMap = columnMap;
        this.checkColumns = checkColumns;
        this.select = select;
        this.resolveInsertParameterTypes();
        select.prepareResult();
        this.setParameters(parameters);
        this.type = 2;
    }

    CompiledStatement(Select select, Expression[] parameters) throws HsqlException {
        this.select = select;
        for (int i = 0; i < select.iResultLen; ++i) {
            Expression colexpr = select.exprColumns[i];
            if (colexpr.getDataType() != 0) continue;
            colexpr.setDataType(12);
        }
        select.prepareResult();
        this.setParameters(parameters);
        this.type = 5;
    }

    CompiledStatement(Expression expression, Expression[] parameters) throws HsqlException {
        this.expression = expression;
        expression.resolveTypes();
        expression.paramMode = 4;
        this.setParameters(parameters);
        this.type = 6;
    }

    private void resolveInsertParameterTypes() {
        for (int i = 0; i < this.select.iResultLen; ++i) {
            Expression colexpr = this.select.exprColumns[i];
            if (colexpr.getDataType() != 0) continue;
        }
    }

    private void setParameters(Expression[] parameters) {
        this.parameters = parameters;
        int[] types = new int[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            types[i] = parameters[i].getDataType();
        }
        this.paramTypes = types;
    }

    void dematerializeSubQueries() {
        for (int i = 0; i < this.subqueries.length; ++i) {
            this.subqueries[i].isMaterialised = false;
        }
    }

    Result describeResult() {
        switch (this.type) {
            case 6: {
                Expression e = this.expression;
                Result r = Result.newSingleColumnResult("@p0", e.getDataType());
                r.metaData.sClassName[0] = e.getValueClassName();
                return r;
            }
            case 5: {
                return this.select.sIntoTable == null ? this.select.describeResult() : updateCount;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                return updateCount;
            }
        }
        return Trace.toResult(Trace.error(201));
    }

    Result describeParameters() {
        int outlen = this.parameters.length;
        int offset = 0;
        Result out = Result.newParameterDescriptionResult(outlen);
        for (int i = 0; i < this.parameters.length; ++i) {
            Expression e = this.parameters[i];
            int idx = i + offset;
            out.metaData.sName[idx] = "@p" + (i + 1);
            out.metaData.sClassName[idx] = e.getValueClassName();
            out.metaData.colType[idx] = e.getDataType();
            out.metaData.colSize[idx] = e.getColumnSize();
            out.metaData.colScale[idx] = e.getColumnScale();
            out.metaData.nullability[idx] = e.nullability;
            out.metaData.isIdentity[idx] = e.isIdentity;
            out.metaData.paramMode[idx] = e.paramMode;
        }
        return out;
    }

    public String toString() {
        try {
            return this.toStringImpl();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    private String toStringImpl() throws Exception {
        StringBuffer sb = new StringBuffer();
        switch (this.type) {
            case 5: {
                sb.append(this.select.toString());
                this.appendParms(sb).append('\n');
                this.appendSubqueries(sb);
                return sb.toString();
            }
            case 1: {
                sb.append("INSERT VALUES");
                sb.append('[').append('\n');
                this.appendColumns(sb).append('\n');
                this.appendTable(sb).append('\n');
                this.appendParms(sb).append('\n');
                this.appendSubqueries(sb).append(']');
                return sb.toString();
            }
            case 2: {
                sb.append("INSERT SELECT");
                sb.append('[').append('\n');
                this.appendColumns(sb).append('\n');
                this.appendTable(sb).append('\n');
                sb.append(this.select).append('\n');
                this.appendParms(sb).append('\n');
                this.appendSubqueries(sb).append(']');
                return sb.toString();
            }
            case 3: {
                sb.append("UPDATE");
                sb.append('[').append('\n');
                this.appendColumns(sb).append('\n');
                this.appendTable(sb).append('\n');
                this.appendCondition(sb);
                this.appendParms(sb).append('\n');
                this.appendSubqueries(sb).append(']');
                return sb.toString();
            }
            case 4: {
                sb.append("DELETE");
                sb.append('[').append('\n');
                this.appendTable(sb).append('\n');
                this.appendCondition(sb);
                this.appendParms(sb).append('\n');
                this.appendSubqueries(sb).append(']');
                return sb.toString();
            }
            case 6: {
                sb.append("CALL");
                sb.append('[');
                sb.append(this.expression).append('\n');
                this.appendParms(sb).append('\n');
                this.appendSubqueries(sb).append(']');
                return sb.toString();
            }
        }
        return "UNKNOWN";
    }

    private StringBuffer appendSubqueries(StringBuffer sb) {
        sb.append("SUBQUERIES[");
        for (int i = 0; i < this.subqueries.length; ++i) {
            sb.append("\n[level=").append(this.subqueries[i].level).append('\n').append("hasParams=").append(this.subqueries[i].hasParams).append('\n').append("org.hsqldb.Select@").append(Integer.toHexString(this.subqueries[i].select.hashCode())).append("]");
        }
        sb.append(']');
        return sb;
    }

    private StringBuffer appendTable(StringBuffer sb) {
        return sb;
    }

    private StringBuffer appendColumns(StringBuffer sb) {
        sb.append("COLUMNS=[");
        for (int i = 0; i < this.columnMap.length; ++i) {
        }
        sb.append(']');
        return sb;
    }

    private StringBuffer appendParms(StringBuffer sb) {
        sb.append("PARAMETERS=[");
        for (int i = 0; i < this.parameters.length; ++i) {
            sb.append('\n').append('@').append(i).append('[').append(this.parameters[i]).append(']');
        }
        sb.append(']');
        return sb;
    }

    private StringBuffer appendCondition(StringBuffer sb) {
        return this.condition == null ? sb.append("CONDITION[]\n") : sb.append("CONDITION[").append(this.condition).append("]\n");
    }
}

