/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql;

import com.insightful.miner.XTMetaData;
import com.insightful.miner.sql.CompiledStatement;
import com.insightful.miner.sql.Expression;
import com.insightful.miner.sql.Function;
import com.insightful.miner.sql.HsqlException;
import com.insightful.miner.sql.HsqlNameManager;
import com.insightful.miner.sql.Select;
import com.insightful.miner.sql.SubQuery;
import com.insightful.miner.sql.TableFilter;
import com.insightful.miner.sql.Token;
import com.insightful.miner.sql.Tokenizer;
import com.insightful.miner.sql.Trace;
import com.insightful.miner.sql.Types;
import com.insightful.miner.sql.lib.ArrayUtil;
import com.insightful.miner.sql.lib.HashMap;
import com.insightful.miner.sql.lib.HsqlArrayList;
import com.insightful.miner.sql.lib.IntValueHashMap;
import com.insightful.miner.sql.lib.ValuePool;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Parser {
    private Hashtable metaDataMap;
    private HsqlNameManager nameManager;
    private Tokenizer tokenizer;
    private String sTable;
    private String sToken;
    private String sName;
    private Object oData;
    private int iType;
    private int iToken;
    private int subQueryLevel;
    private HsqlArrayList subQueryList = new HsqlArrayList();
    static HashMap simpleFunctions = new HashMap();
    private static IntValueHashMap tokenSet;
    HsqlArrayList parameters = new HsqlArrayList();
    private static final Expression[] noParameters;
    private static final SubQuery[] noSubqueries;

    public Parser(Hashtable mdMap, Tokenizer t) {
        this.metaDataMap = mdMap;
        this.tokenizer = t;
    }

    void reset(String sql) {
        this.sTable = null;
        this.sToken = null;
        this.oData = null;
        this.tokenizer.reset(sql);
        this.subQueryList.clear();
        this.subQueryLevel = 0;
        this.parameters.clear();
    }

    void checkTableWriteAccess() throws HsqlException {
    }

    HsqlArrayList getColumnNames(XTMetaData md, Tokenizer t, boolean full) throws HsqlException {
        String token;
        HsqlArrayList columns = new HsqlArrayList();
        do {
            if (full) {
                token = t.getIdentifier();
                boolean quoted = t.wasQuotedIdentifier();
                HsqlNameManager.HsqlName name = this.nameManager.newHsqlName(token, quoted);
                columns.add(name);
                continue;
            }
            columns.add(t.getName());
        } while ((token = t.getString()).equals(","));
        if (!token.equals(")")) {
            throw Trace.error(11, token);
        }
        return columns;
    }

    SubQuery parseSubquery(XTMetaData[] md, HsqlNameManager.HsqlName[] colNames, boolean resolveAll, int predicateType) throws HsqlException {
        int[] nArray;
        SubQuery sq = new SubQuery();
        ++this.subQueryLevel;
        Select s = this.parseSelect(false);
        sq.level = this.subQueryLevel--;
        boolean isResolved = s.resolveAll(resolveAll);
        sq.select = s;
        sq.isResolved = isResolved;
        if (!isResolved) {
            return sq;
        }
        Vector<String> newColNames = new Vector<String>();
        Vector<Integer> newColTypes = new Vector<Integer>();
        if (colNames != null) {
            if (colNames.length != s.iResultLen) {
                throw Trace.error(5);
            }
            for (int i = 0; i < s.iResultLen; ++i) {
                HsqlNameManager.HsqlName name = colNames[i];
                s.exprColumns[i].setAlias(name.name, name.isNameQuoted);
                newColNames.add(s.exprColumns[i].getAlias());
                newColTypes.add(new Integer(s.exprColumns[i].getDataType()));
            }
        } else {
            for (int i = 0; i < s.iResultLen; ++i) {
                String colname = s.exprColumns[i].getAlias();
                if (colname != null && colname.length() != 0) continue;
                colname = "COL_" + String.valueOf(i + 1);
                s.exprColumns[i].setAlias(colname, false);
                newColNames.add(s.exprColumns[i].getAlias());
                newColTypes.add(new Integer(s.exprColumns[i].getDataType()));
            }
        }
        if (predicateType == 30) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = null;
        }
        int[] pcol = nArray;
        sq.isInPredicate = predicateType == 30;
        this.subQueryList.add(sq);
        return sq;
    }

    Select parseSelect(boolean isUnion) throws HsqlException {
        String token;
        Select select = new Select();
        if (!isUnion) {
            this.parseLimit(select);
        }
        if ((token = this.tokenizer.getString()).equals("DISTINCT")) {
            select.isDistinctSelect = true;
        } else {
            this.tokenizer.back();
        }
        HsqlArrayList vcolumn = new HsqlArrayList();
        do {
            Expression e = this.parseExpression();
            token = this.tokenizer.getString();
            if (token.equals("AS")) {
                e.setAlias(this.tokenizer.getName(), this.tokenizer.wasQuotedIdentifier());
                token = this.tokenizer.getString();
            } else if (this.tokenizer.wasName()) {
                e.setAlias(token, this.tokenizer.wasQuotedIdentifier());
                token = this.tokenizer.getString();
            }
            vcolumn.add(e);
        } while (token.equals(","));
        if (token.equals("INTO")) {
            boolean getname = true;
            token = this.tokenizer.getString();
            getname = false;
            if (getname) {
                token = this.tokenizer.getString();
            }
            select.sIntoTable = this.nameManager.newHsqlName(token, this.tokenizer.wasQuotedIdentifier());
            token = this.tokenizer.getString();
            if ("?".equals(this.sToken)) {
                throw Trace.error(11, 195);
            }
        }
        if (!token.equals("FROM")) {
            throw Trace.error(11, token);
        }
        Expression condition = null;
        HsqlArrayList vfilter = new HsqlArrayList();
        vfilter.add(this.parseTableFilter(false));
        while (true) {
            token = this.tokenizer.getString();
            boolean isInner = false;
            if (token.equals("INNER")) {
                token = this.tokenizer.getThis("JOIN").toUpperCase();
                isInner = true;
            } else if (token.equals("JOIN")) {
                isInner = true;
            }
            if (token.equals("LEFT") || token.equals("RIGHT") || token.equals("FULL") || token.equals("JOIN")) {
                boolean isleft = token.equals("LEFT");
                boolean isfull = token.equals("FULL");
                if (!token.equals("JOIN")) {
                    token = this.tokenizer.getString();
                }
                if (token.equals("OUTER")) {
                    token = this.tokenizer.getString();
                }
                Trace.check(token.equals("JOIN"), 11, token);
                TableFilter tf = this.parseTableFilter(!isInner);
                tf.setLeftFull(isleft, isfull);
                vfilter.add(tf);
                token = this.tokenizer.getString();
                if (!token.equals("ON")) continue;
                Expression newcondition = this.parseExpression();
                newcondition.checkTables(vfilter);
                condition = Parser.addJoinCondition(condition, newcondition, tf, true);
                continue;
            }
            if (token.equals("CROSS")) {
                this.tokenizer.getThis("JOIN");
                TableFilter tf = this.parseTableFilter(false);
                tf.isCrossJoin = true;
                vfilter.add(tf);
                continue;
            }
            if (!token.equals(",")) break;
            TableFilter tf = this.parseTableFilter(true);
            tf.setLeftFull(false, true);
            vfilter.add(tf);
        }
        this.tokenizer.back();
        Parser.resolveSelectTableFilter(select, vcolumn, vfilter);
        token = this.tokenizer.getString();
        if (token.equals("WHERE")) {
            Expression newcondition = this.parseExpression();
            newcondition = Parser.resolveWhereColumnAliases(newcondition, vcolumn);
            condition = Parser.addCondition(condition, newcondition);
            token = this.tokenizer.getString();
        }
        select.queryCondition = condition;
        if (token.equals("GROUP")) {
            this.tokenizer.getThis("BY");
            int len = 0;
            do {
                Expression e = this.parseExpression();
                vcolumn.add(e);
                token = this.tokenizer.getString();
                ++len;
            } while (token.equals(","));
            select.iGroupLen = len;
        }
        if (token.equals("HAVING")) {
            select.iHavingIndex = vcolumn.size();
            select.havingCondition = this.parseExpression();
            token = this.tokenizer.getString();
            vcolumn.add(select.havingCondition);
        }
        switch (Token.get(token)) {
            case 227: {
                token = this.tokenizer.getString();
                if (token.equals("ALL")) {
                    select.iUnionType = 2;
                } else if (token.equals("DISTINCT")) {
                    select.iUnionType = 1;
                } else {
                    select.iUnionType = 1;
                    this.tokenizer.back();
                }
                this.tokenizer.getThis("SELECT");
                select.sUnion = this.parseSelect(true);
                break;
            }
            case 115: {
                token = this.tokenizer.getString();
                if (!token.equals("DISTINCT")) {
                    this.tokenizer.back();
                }
                this.tokenizer.getThis("SELECT");
                select.iUnionType = 3;
                select.sUnion = this.parseSelect(true);
                break;
            }
            case 78: 
            case 310: {
                token = this.tokenizer.getString();
                if (!token.equals("DISTINCT")) {
                    this.tokenizer.back();
                }
                this.tokenizer.getThis("SELECT");
                select.iUnionType = 4;
                select.sUnion = this.parseSelect(true);
                break;
            }
            default: {
                this.tokenizer.back();
            }
        }
        if (!isUnion) {
            token = this.tokenizer.getString();
            if (token.equals("ORDER")) {
                this.tokenizer.getThis("BY");
                this.parseOrderBy(select, vcolumn);
            } else {
                this.tokenizer.back();
            }
        }
        int len = vcolumn.size();
        select.exprColumns = new Expression[len];
        vcolumn.toArray(select.exprColumns);
        return select;
    }

    private void parseLimit(Select select) throws HsqlException {
        Expression e2;
        Expression e1;
        String token = this.tokenizer.getString();
        boolean islimit = false;
        if (token.equals("LIMIT")) {
            this.read();
            e1 = this.readTerm();
            e2 = this.readTerm();
            islimit = true;
            this.tokenizer.back();
        } else if (token.equals("TOP")) {
            this.read();
            e1 = new Expression(4, ValuePool.getInt(0));
            e2 = this.readTerm();
            this.tokenizer.back();
        } else {
            this.tokenizer.back();
            return;
        }
        if ((e1.getType() == 1 && e1.getDataType() == 4 && (Integer)e1.getValue() >= 0 || e1.isParam()) && (e2.getType() == 1 && e2.getDataType() == 4 && (Integer)e1.getValue() >= 0 || e2.isParam())) {
            e1.setDataType(4);
            e2.setDataType(4);
            select.limitCondition = new Expression(8, e1, e2);
            return;
        }
        int messageid = islimit ? 168 : 169;
        throw Trace.error(16, messageid);
    }

    private void parseOrderBy(Select select, HsqlArrayList vcolumn) throws HsqlException {
        String token;
        int len = 0;
        do {
            Expression e = this.parseExpression();
            e = Parser.resolveOrderByColumnAlias(e, vcolumn, select.iResultLen, select.sUnion != null);
            token = this.tokenizer.getString();
            if (token.equals("DESC")) {
                e.setDescending();
                token = this.tokenizer.getString();
            } else if (token.equals("ASC")) {
                token = this.tokenizer.getString();
            }
            vcolumn.add(e);
            ++len;
        } while (token.equals(","));
        this.tokenizer.back();
        select.iOrderLen = len;
    }

    private static void resolveSelectTableFilter(Select select, HsqlArrayList vcolumn, HsqlArrayList vfilter) throws HsqlException {
        Expression e;
        int i;
        int len = vfilter.size();
        TableFilter[] filters = new TableFilter[len];
        vfilter.toArray(filters);
        select.tFilter = filters;
        len = vcolumn.size();
        for (i = 0; i < len; ++i) {
            e = (Expression)vcolumn.get(i);
            if (e.getType() == 6) {
                int current = i;
                --len;
                vcolumn.remove(current);
                continue;
            }
            if (e.getType() != 2 || e.getFilter() != null) continue;
            for (int f = 0; f < filters.length; ++f) {
                e.resolveTables(filters[f]);
            }
        }
        for (i = 0; i < len; ++i) {
            e = (Expression)vcolumn.get(i);
            e.resolveTypes();
        }
        select.iResultLen = len;
    }

    private static Expression resolveWhereColumnAliases(Expression e, HsqlArrayList vcolumn) throws HsqlException {
        return e;
    }

    private static Expression resolveOrderByColumnAlias(Expression e, HsqlArrayList vcolumn, int visiblecols, boolean union) throws HsqlException {
        if (e.getType() == 1) {
            return Parser.resolveOrderByColumnIndex(e, vcolumn, visiblecols);
        }
        if (e.getType() != 2) {
            if (union) {
                throw Trace.error(70);
            }
            return e;
        }
        String ordercolname = e.getColumnName();
        String ordertablename = e.getTableName();
        if (ordertablename != null) {
            int size = visiblecols;
            for (int i = 0; i < size; ++i) {
                Expression colexpr = (Expression)vcolumn.get(i);
                if (!ordercolname.equals(colexpr.getColumnName()) || !ordertablename.endsWith(colexpr.getTableName())) continue;
                colexpr.orderColumnIndex = i;
                return colexpr;
            }
            if (union) {
                throw Trace.error(70, ordercolname);
            }
            return e;
        }
        Expression found = e;
        int size = vcolumn.size();
        for (int i = 0; i < size; ++i) {
            Expression colexpr = (Expression)vcolumn.get(i);
            String colalias = colexpr.getDefinedAlias();
            String colname = colexpr.getColumnName();
            if (!ordercolname.equals(colalias) && !ordercolname.equals(colname)) continue;
            if (found != e && i < visiblecols) {
                throw Trace.error(156, ordercolname);
            }
            if (found != e) continue;
            found = colexpr;
            found.orderColumnIndex = i;
        }
        if (union && (found == e || found.orderColumnIndex >= visiblecols)) {
            throw Trace.error(70, ordercolname);
        }
        return found;
    }

    private static Expression resolveOrderByColumnIndex(Expression e, HsqlArrayList vcolumn, int visiblecols) throws HsqlException {
        int i;
        if (e.getDataType() == 4 && 0 < (i = ((Integer)e.getValue()).intValue()) && i <= visiblecols) {
            Expression colexpr = (Expression)vcolumn.get(i - 1);
            colexpr.orderColumnIndex = i - 1;
            return colexpr;
        }
        throw Trace.error(70);
    }

    private TableFilter parseTableFilter(boolean outerjoin) throws HsqlException {
        String token = this.tokenizer.getString();
        XTMetaData md = null;
        String sAlias = null;
        if (token.equals("(")) {
            this.tokenizer.getThis("SELECT");
            SubQuery sq = this.parseSubquery(null, null, true, 3);
            this.tokenizer.getThis(")");
            md = sq.md;
        } else {
            this.tokenizer.back();
            sAlias = this.tokenizer.getName();
        }
        token = this.tokenizer.getString();
        if (token.equals("LEFT") || token.equals("RIGHT") || token.equals("FULL") || token.equals("INNER") || token.equals("JOIN") || token.equals("CROSS")) {
            this.tokenizer.back();
        } else if (token.equals("AS")) {
            sAlias = this.tokenizer.getName();
        } else if (this.tokenizer.wasName()) {
            sAlias = token;
        } else {
            this.tokenizer.back();
        }
        TableFilter tf = new TableFilter(sAlias, outerjoin);
        return tf;
    }

    private static Expression addCondition(Expression e1, Expression e2) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null) {
            return e1;
        }
        return new Expression(28, e1, e2);
    }

    private static Expression addJoinCondition(Expression e1, Expression e2, TableFilter tf, boolean outer) throws HsqlException {
        if (!e2.setForJoin(tf, outer)) {
            throw Trace.error(64);
        }
        return Parser.addCondition(e1, e2);
    }

    Expression parseExpression() throws HsqlException {
        this.read();
        Expression r = this.readOr();
        this.tokenizer.back();
        return r;
    }

    private Expression readAggregate() throws HsqlException {
        boolean distinct = false;
        int type = this.iToken;
        this.read();
        if (this.tokenizer.getString().equals("DISTINCT")) {
            distinct = true;
        } else {
            this.tokenizer.back();
        }
        this.readThis(101);
        Expression s = this.readOr();
        this.readThis(102);
        Expression aggregateExp = new Expression(type, s, null);
        aggregateExp.setDistinctAggregate(distinct);
        return aggregateExp;
    }

    private Expression readOr() throws HsqlException {
        Expression r = this.readAnd();
        while (this.iToken == 29) {
            int type = this.iToken;
            Expression a = r;
            this.read();
            r = new Expression(type, a, this.readAnd());
        }
        return r;
    }

    private Expression readAnd() throws HsqlException {
        Expression r = this.readCondition();
        while (this.iToken == 28) {
            int type = this.iToken;
            Expression a = r;
            this.read();
            r = new Expression(type, a, this.readCondition());
        }
        return r;
    }

    private Expression readCondition() throws HsqlException {
        switch (this.iToken) {
            case 20: {
                int type = this.iToken;
                this.read();
                return new Expression(type, this.readCondition(), null);
            }
            case 31: {
                int type = this.iToken;
                this.read();
                this.readThis(101);
                Trace.check(this.iToken == 103, 11);
                SubQuery sq = this.parseSubquery(null, null, false, 31);
                Select select = sq.select;
                Expression s = new Expression(select, !sq.isResolved);
                this.read();
                this.readThis(102);
                return new Expression(type, s, null);
            }
        }
        Expression a = this.readConcat();
        boolean not = false;
        if (this.iToken == 20) {
            not = true;
            this.read();
        }
        switch (this.iToken) {
            case 27: {
                a = this.parseLikePredicate(a);
                break;
            }
            case 106: {
                a = this.parseBetweenPredicate(a);
                break;
            }
            case 30: {
                a = this.parseInPredicate(a);
                break;
            }
            default: {
                Trace.check(!not, 11);
                if (Expression.isCompare(this.iToken)) {
                    int type = this.iToken;
                    this.read();
                    return new Expression(type, a, this.readConcat());
                }
                return a;
            }
        }
        if (not) {
            a = new Expression(20, a, null);
        }
        return a;
    }

    private Expression parseLikePredicate(Expression a) throws HsqlException {
        this.read();
        Expression b = this.readTerm();
        Character escape = null;
        if (this.sToken.equals("ESCAPE")) {
            this.read();
            Expression c = this.readTerm();
            Trace.check(c.getType() == 1, 7);
            String s = (String)c.getValue(12);
            if (s == null || s.length() < 1) {
                throw Trace.error(7, s);
            }
            escape = new Character(s.charAt(0));
        }
        a = new Expression(a, b, escape);
        return a;
    }

    private Expression parseBetweenPredicate(Expression a) throws HsqlException {
        this.read();
        Expression l = new Expression(22, a, this.readConcat());
        this.readThis(28);
        Expression h = new Expression(25, a, this.readConcat());
        if (l.getArg().isParam() && l.getArg2().isParam()) {
            throw Trace.error(216, 185);
        }
        if (h.getArg().isParam() && h.getArg2().isParam()) {
            throw Trace.error(216, 185);
        }
        return new Expression(28, l, h);
    }

    private Expression parseInPredicate(Expression a) throws HsqlException {
        int type = this.iToken;
        this.read();
        this.readThis(101);
        Expression b = null;
        if (this.iToken == 103) {
            SubQuery sq = this.parseSubquery(null, null, false, 30);
            Select select = sq.select;
            Trace.check(select.iResultLen == 1, 159);
            b = new Expression(select, !sq.isResolved);
            this.read();
        } else {
            this.tokenizer.back();
            HsqlArrayList v = new HsqlArrayList();
            do {
                Expression value = this.parseExpression();
                if (value.exprType == 1 && value.valueData == null && !value.isParam()) {
                    throw Trace.error(79);
                }
                v.add(value);
                this.read();
            } while (this.iToken == 104);
            Expression[] valueList = (Expression[])v.toArray(new Expression[v.size()]);
            b = new Expression(valueList);
        }
        this.readThis(102);
        return new Expression(type, a, b);
    }

    private void readThis(int type) throws HsqlException {
        Trace.check(this.iToken == type, 11);
        this.read();
    }

    private Expression readConcat() throws HsqlException {
        Expression r = this.readSum();
        while (this.iToken == 105) {
            int type = 15;
            Expression a = r;
            this.read();
            r = new Expression(type, a, this.readSum());
        }
        return r;
    }

    private Expression readSum() throws HsqlException {
        Expression r = this.readFactor();
        while (true) {
            int type;
            if (this.iToken == 100) {
                type = 11;
            } else {
                if (this.iToken != 10) break;
                type = 12;
            }
            Expression a = r;
            this.read();
            r = new Expression(type, a, this.readFactor());
        }
        return r;
    }

    private Expression readFactor() throws HsqlException {
        Expression r = this.readTerm();
        while (this.iToken == 13 || this.iToken == 14) {
            int type = this.iToken;
            Expression a = r;
            this.read();
            r = new Expression(type, a, this.readTerm());
        }
        return r;
    }

    private Expression readTerm() throws HsqlException {
        Expression r = null;
        block0 : switch (this.iToken) {
            case 2: {
                String name = this.sName;
                r = new Expression(this.sTable, name);
                this.read();
                if (this.iToken == 101) {
                    String javaName = name;
                    Function f = new Function(name, javaName, false);
                    int len = f.getArgCount();
                    int i = 0;
                    this.read();
                    if (this.iToken != 102) {
                        while (true) {
                            f.setArgument(i++, this.readOr());
                            if (this.iToken != 104) break;
                            this.read();
                        }
                    }
                    this.readThis(102);
                    r = new Expression(f);
                    break;
                }
                String javaName = (String)simpleFunctions.get(name);
                if (javaName == null) break;
                Function f = new Function(name, javaName, true);
                r = new Expression(f);
                break;
            }
            case 10: {
                int type = this.iToken;
                this.read();
                r = new Expression(type, this.readTerm(), null);
                Trace.check(!r.getArg().isParam(), 212);
                break;
            }
            case 100: {
                this.read();
                r = this.readTerm();
                Trace.check(!r.isParam(), 216, Trace.getMessage(212));
                break;
            }
            case 101: {
                this.read();
                r = this.readOr();
                if (this.iToken != 102) {
                    throw Trace.error(11, this.sToken);
                }
                this.read();
                break;
            }
            case 1: {
                r = new Expression(this.iType, this.oData);
                this.read();
                break;
            }
            case 9: {
                r = new Expression(0, null, true);
                this.parameters.add(r);
                this.read();
                break;
            }
            case 103: {
                Select select = this.parseSelect(false);
                select.resolve();
                r = new Expression(select, true);
                this.read();
                break;
            }
            case 13: {
                r = new Expression(this.sTable, (String)null);
                this.read();
                break;
            }
            case 15: {
                int type = this.iToken;
                this.read();
                this.readThis(101);
                r = this.readOr();
                this.readThis(104);
                r = new Expression(type, r, this.readOr());
                this.readThis(102);
                break;
            }
            case 62: {
                int type = this.iToken;
                this.read();
                this.readThis(101);
                r = this.readOr();
                this.readThis(104);
                Expression thenelse = this.readOr();
                this.readThis(104);
                thenelse = new Expression(70, thenelse, this.readOr());
                r = new Expression(type, r, thenelse);
                this.readThis(102);
                break;
            }
            case 68: {
                int type = 62;
                Expression predicand = null;
                this.read();
                if (this.iToken != 110) {
                    predicand = this.readOr();
                }
                Expression leaf = null;
                do {
                    Expression casewhen = this.parseCaseWhen(predicand);
                    if (r == null) {
                        r = casewhen;
                    } else {
                        leaf.setRightExpression(casewhen);
                    }
                    leaf = casewhen.getRightExpression();
                } while (this.iToken == 110);
                if (this.iToken == 112) {
                    this.readThis(112);
                    Expression elsexpr = this.readOr();
                    leaf.setRightExpression(elsexpr);
                }
                this.readThis(113);
                break;
            }
            case 67: {
                this.read();
                this.readThis(101);
                r = this.readOr();
                this.readThis(104);
                Expression thenelse = new Expression(70, new Expression(0, null), r);
                r = new Expression(21, r, this.readOr());
                r = new Expression(62, r, thenelse);
                this.readThis(102);
                break;
            }
            case 60: 
            case 69: {
                this.read();
                this.readThis(101);
                Expression leaf = null;
                while (true) {
                    Expression current = this.readOr();
                    Expression condition = new Expression(21, current, new Expression(0, null));
                    Expression alternatives = new Expression(70, new Expression(0, null), current);
                    Expression casewhen = new Expression(62, condition, alternatives);
                    if (r == null) {
                        r = casewhen;
                    } else {
                        leaf.setLeftExpression(casewhen);
                    }
                    leaf = alternatives;
                    if (this.iToken == 102) {
                        this.readThis(102);
                        break block0;
                    }
                    this.readThis(104);
                }
            }
            case 61: {
                int type = this.iToken;
                this.read();
                this.readThis(101);
                r = this.readOr();
                this.readThis(104);
                int t = Types.getTypeNr(this.sToken);
                int p = 0;
                int s = 0;
                if (Types.acceptsPrecisionCreateParam(t) && this.tokenizer.isGetThis("(")) {
                    p = this.tokenizer.getInt();
                    if (Types.acceptsScaleCreateParam(t) && this.tokenizer.isGetThis(",")) {
                        s = this.tokenizer.getInt();
                    }
                    this.tokenizer.getThis(")");
                }
                if (r.isParam()) {
                    r.setDataType(t);
                }
                r = new Expression(type, r, null);
                r.setDataType(t);
                this.read();
                this.readThis(102);
                break;
            }
            case 107: {
                this.read();
                this.readThis(101);
                r = this.readOr();
                this.readThis(122);
                int t = Types.getTypeNr(this.sToken);
                int p = 0;
                int s = 0;
                if (Types.acceptsPrecisionCreateParam(t) && this.tokenizer.isGetThis("(")) {
                    p = this.tokenizer.getInt();
                    if (Types.acceptsScaleCreateParam(t) && this.tokenizer.isGetThis(",")) {
                        s = this.tokenizer.getInt();
                    }
                    this.tokenizer.getThis(")");
                }
                if (r.isParam()) {
                    r.setDataType(t);
                }
                r = new Expression(61, r, null);
                r.setDataType(t);
                this.read();
                this.readThis(102);
                break;
            }
            case 63: {
                this.read();
                this.readThis(101);
                String name = this.sToken;
                if (!Expression.SQL_EXTRACT_FIELD_NAMES.contains(name)) {
                    throw Trace.error(11, this.sToken);
                }
                this.readToken();
                this.readThis(124);
                Function f = new Function(name, name, false);
                f.setArgument(0, this.readOr());
                this.readThis(102);
                r = new Expression(f);
                break;
            }
            case 65: {
                Expression trailing;
                Expression leading;
                String trimstr;
                this.read();
                this.readThis(101);
                String type = this.sToken;
                if (Expression.SQL_TRIM_SPECIFICATION.contains(type)) {
                    this.read();
                } else {
                    type = "BOTH";
                }
                if (this.sToken.length() == 1) {
                    trimstr = this.sToken;
                    this.read();
                } else {
                    trimstr = " ";
                }
                this.readThis(124);
                Expression trim = new Expression(1, (Object)trimstr);
                if (type.equals("LEADING")) {
                    leading = new Expression(true);
                    trailing = new Expression(false);
                } else if (type.equals("TRAILING")) {
                    leading = new Expression(false);
                    trailing = new Expression(true);
                } else {
                    leading = trailing = new Expression(true);
                }
                Function f = new Function("TRIM", "org.hsqldb.Library.trim", false);
                f.setArgument(0, this.readOr());
                f.setArgument(1, trim);
                f.setArgument(2, leading);
                f.setArgument(3, trailing);
                this.readThis(102);
                r = new Expression(f);
                break;
            }
            case 64: {
                this.read();
                this.readThis(101);
                Function f = new Function("POSITION", "org.hsqldb.Library.position", false);
                f.setArgument(0, this.readTerm());
                this.readThis(30);
                f.setArgument(1, this.readOr());
                this.readThis(102);
                r = new Expression(f);
                break;
            }
            case 66: {
                boolean commas = false;
                this.read();
                this.readThis(101);
                Function f = new Function("SUBSTRING", "org.hsqldb.Library.substring", false);
                f.setArgument(0, this.readTerm());
                if (this.iToken == 124) {
                    this.readThis(124);
                } else {
                    this.readThis(104);
                    commas = true;
                }
                f.setArgument(1, this.readOr());
                Expression count = null;
                if (!commas && this.iToken == 123) {
                    this.readThis(123);
                    count = this.readTerm();
                } else if (commas && this.iToken == 104) {
                    this.readThis(104);
                    count = this.readTerm();
                }
                f.setArgument(2, count);
                this.readThis(102);
                r = new Expression(f);
                break;
            }
            default: {
                if (Expression.isAggregate(this.iToken)) {
                    r = this.readAggregate();
                    break;
                }
                throw Trace.error(11, this.sToken);
            }
        }
        return r;
    }

    Expression readDefaultClause() throws HsqlException {
        Expression r = null;
        this.read();
        switch (this.iToken) {
            case 2: {
                String name = this.sToken;
                String javaName = (String)simpleFunctions.get(name);
                if (javaName != null) {
                    Function f = new Function(name, javaName, true);
                    r = new Expression(f);
                    break;
                }
                throw Trace.error(46, this.sToken);
            }
            case 10: {
                int type = this.iToken;
                this.read();
                if (this.iToken == 1) {
                    r = new Expression(type, new Expression(this.iType, this.oData), null);
                    break;
                }
                throw Trace.error(46, this.sToken);
            }
            case 1: {
                r = new Expression(this.iType, this.oData);
                break;
            }
            default: {
                throw Trace.error(46, this.sToken);
            }
        }
        return r;
    }

    Expression parseCaseWhen(Expression r) throws HsqlException {
        this.readThis(110);
        Expression condition = r == null ? this.readOr() : new Expression(21, r, this.readOr());
        this.readThis(111);
        Expression current = this.readOr();
        Expression alternatives = new Expression(70, current, new Expression(0, null));
        Expression casewhen = new Expression(62, condition, alternatives);
        return casewhen;
    }

    private void read() throws HsqlException {
        this.sToken = this.tokenizer.getString();
        this.sName = this.tokenizer.getCurrentUnalteredString();
        if (this.tokenizer.wasValue()) {
            this.iToken = 1;
            this.oData = this.tokenizer.getAsValue();
            this.iType = this.tokenizer.getType();
        } else if (this.tokenizer.wasName()) {
            this.iToken = 2;
            Enumeration keys = this.metaDataMap.keys();
            String tableName = null;
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                XTMetaData md = (XTMetaData)this.metaDataMap.get(key);
                if (md.nameToOrdinal(this.sName) == -1) continue;
                tableName = key;
                break;
            }
            this.sTable = tableName;
        } else if (this.tokenizer.wasLongName()) {
            this.sTable = this.tokenizer.getLongNameFirst();
            this.iToken = this.sToken.equals("*") ? 13 : 2;
        } else if (this.sToken.length() == 0) {
            this.iToken = 108;
        } else {
            this.iToken = tokenSet.get((Object)this.sToken, -1);
            if (this.iToken == -1) {
                this.iToken = 108;
            }
            switch (this.iToken) {
                case 9: 
                case 10: 
                case 14: 
                case 15: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 71: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    break;
                }
                case 13: {
                    this.sTable = null;
                    break;
                }
                case 109: {
                    this.sToken = this.tokenizer.getString();
                    if (this.sToken.equals("NOT")) {
                        this.iToken = 26;
                        break;
                    }
                    this.iToken = 21;
                    this.tokenizer.back();
                    break;
                }
                default: {
                    this.iToken = 108;
                }
            }
        }
    }

    private void readToken() throws HsqlException {
        this.sToken = this.tokenizer.getString();
        this.iToken = tokenSet.get((Object)this.sToken, -1);
    }

    Expression[] getParameters() {
        Expression[] result = this.parameters.size() == 0 ? noParameters : (Expression[])this.parameters.toArray(new Expression[this.parameters.size()]);
        this.parameters.clear();
        return result;
    }

    void clearParameters() {
        this.parameters.clear();
    }

    SubQuery[] getSortedSubqueries() {
        if (this.subQueryList.size() == 0) {
            return noSubqueries;
        }
        this.subQueryList.sort((SubQuery)this.subQueryList.get(0));
        SubQuery[] subqueries = new SubQuery[this.subQueryList.size()];
        this.subQueryList.toArray(subqueries);
        this.subQueryList.clear();
        return subqueries;
    }

    CompiledStatement compileCallStatement() throws HsqlException {
        this.clearParameters();
        Expression expression = this.parseExpression();
        CompiledStatement cs = new CompiledStatement(expression, this.getParameters());
        cs.subqueries = this.getSortedSubqueries();
        return cs;
    }

    CompiledStatement compileDeleteStatement() throws HsqlException {
        String tname;
        this.clearParameters();
        this.tokenizer.getThis("FROM");
        String token = tname = this.tokenizer.getName();
        token = this.tokenizer.getString();
        Expression condition = null;
        if (token.equals("WHERE")) {
            condition = this.parseExpression();
        } else {
            this.tokenizer.back();
        }
        CompiledStatement cs = new CompiledStatement(tname, true, condition, this.getParameters());
        cs.subqueries = this.getSortedSubqueries();
        return cs;
    }

    private void getInsertColumnValueExpressions(XTMetaData md, Expression[] acve, int len) throws HsqlException {
        int i;
        boolean enclosed = false;
        this.tokenizer.getThis("(");
        for (i = 0; i < len; ++i) {
            Expression cve = this.parseExpression();
            cve.resolveTables(null);
            cve.resolveTypes();
            acve[i] = cve;
            String token = this.tokenizer.getString();
            if (token.equals(",")) continue;
            if (token.equals(")")) {
                enclosed = true;
                break;
            }
            throw Trace.error(11, token);
        }
        if (!enclosed || i != len - 1) {
            throw Trace.error(5);
        }
    }

    CompiledStatement compileInsertStatement() throws HsqlException {
        int i;
        this.clearParameters();
        this.tokenizer.getThis("INTO");
        boolean[] columnCheckList = null;
        int[] columnMap = null;
        int len = 0;
        String token = this.tokenizer.getString();
        String alias = this.tokenizer.getCurrentUnalteredString();
        HsqlArrayList columnNames = null;
        columnCheckList = null;
        XTMetaData md = (XTMetaData)this.metaDataMap.get(alias);
        int numColumns = md.getNumColumns();
        columnMap = new int[numColumns];
        for (i = 0; i < numColumns; ++i) {
            columnMap[i] = i;
        }
        len = numColumns;
        token = this.tokenizer.getString();
        if (token.equals("(")) {
            columnNames = this.getColumnNames(md, this.tokenizer, false);
            if (columnNames.size() > len) {
                throw Trace.error(5);
            }
            len = columnNames.size();
            columnCheckList = new boolean[numColumns];
            columnMap = new int[len];
            for (i = 0; i < len; ++i) {
                int ci;
                columnMap[i] = ci = md.nameToOrdinal((String)columnNames.get(i));
                columnCheckList[ci] = true;
            }
            token = this.tokenizer.getString();
        }
        if (token.equals("VALUES")) {
            Expression[] acve = new Expression[len];
            this.getInsertColumnValueExpressions(md, acve, len);
            CompiledStatement cs = new CompiledStatement(columnMap, acve, columnCheckList, this.getParameters());
            cs.subqueries = this.getSortedSubqueries();
            cs.tableName = alias;
            token = this.tokenizer.getString();
            while (token.equals("VALUES")) {
                Expression[] acve2 = new Expression[len];
                this.getInsertColumnValueExpressions(md, acve2, len);
                for (int i2 = 0; i2 < len; ++i2) {
                    cs.columnValues[i2].valueData.add(acve2[i2].getValue());
                }
                token = this.tokenizer.getString();
            }
            return cs;
        }
        if (token.equals("SELECT")) {
            Select select = this.parseSelect(false);
            if (len != select.iResultLen) {
                throw Trace.error(5);
            }
            CompiledStatement cs = new CompiledStatement(columnMap, columnCheckList, select, this.getParameters());
            cs.subqueries = this.getSortedSubqueries();
            cs.tableName = alias;
            return cs;
        }
        throw Trace.error(11, token);
    }

    CompiledStatement compileSelectStatement(boolean isview) throws HsqlException {
        this.clearParameters();
        Select select = this.parseSelect(isview);
        if (select.sIntoTable != null) {
            String string = select.sIntoTable.name;
        }
        CompiledStatement cs = new CompiledStatement(select, this.getParameters());
        cs.subqueries = this.getSortedSubqueries();
        return cs;
    }

    CompiledStatement compileUpdateStatement() throws HsqlException {
        String token;
        this.clearParameters();
        String alias = token = this.tokenizer.getName();
        if (!this.tokenizer.isGetThis("SET", true)) {
            alias = this.tokenizer.getIdentifier();
            this.tokenizer.getThis("SET");
        }
        XTMetaData md = (XTMetaData)this.metaDataMap.get(token);
        int numColumns = md.getNumColumns();
        Expression[] exprList = new Expression[numColumns];
        int[] colList = new int[numColumns];
        int len = 0;
        token = null;
        do {
            int ci = md.nameToOrdinal(this.tokenizer.getName());
            this.tokenizer.getThis("=");
            Expression cve = this.parseExpression();
            if (len == numColumns) {
                throw Trace.error(5);
            }
            colList[len] = ci;
            exprList[len] = cve;
            token = this.tokenizer.getString();
            ++len;
        } while (token.equals(","));
        Expression condition = null;
        if (token.equals("WHERE")) {
            condition = this.parseExpression();
        } else {
            this.tokenizer.back();
        }
        colList = (int[])ArrayUtil.resizeArray(colList, len);
        exprList = (Expression[])ArrayUtil.resizeArray(exprList, len);
        CompiledStatement cs = new CompiledStatement(alias, colList, exprList, condition, this.getParameters());
        cs.subqueries = this.getSortedSubqueries();
        return cs;
    }

    static {
        simpleFunctions.put("CURRENT_DATE", "org.hsqldb.Library.curdate");
        simpleFunctions.put("CURRENT_TIME", "org.hsqldb.Library.curtime");
        simpleFunctions.put("CURRENT_TIMESTAMP", "org.hsqldb.Library.now");
        simpleFunctions.put("CURRENT_USER", "org.hsqldb.Library.user");
        simpleFunctions.put("SYSDATE", "org.hsqldb.Library.curdate");
        simpleFunctions.put("NOW", "org.hsqldb.Library.now");
        simpleFunctions.put("TODAY", "org.hsqldb.Library.curdate");
        tokenSet = new IntValueHashMap(37);
        tokenSet.put(",", 104);
        tokenSet.put("=", 21);
        tokenSet.put("!=", 26);
        tokenSet.put("<>", 26);
        tokenSet.put("<", 24);
        tokenSet.put(">", 23);
        tokenSet.put("<=", 25);
        tokenSet.put(">=", 22);
        tokenSet.put("AND", 28);
        tokenSet.put("NOT", 20);
        tokenSet.put("OR", 29);
        tokenSet.put("IN", 30);
        tokenSet.put("EXISTS", 31);
        tokenSet.put("BETWEEN", 106);
        tokenSet.put("+", 100);
        tokenSet.put("-", 10);
        tokenSet.put("*", 13);
        tokenSet.put("/", 14);
        tokenSet.put("||", 105);
        tokenSet.put("(", 101);
        tokenSet.put(")", 102);
        tokenSet.put("SELECT", 103);
        tokenSet.put("LIKE", 27);
        tokenSet.put("STDDEV", 46);
        tokenSet.put("VARIANCE", 45);
        tokenSet.put("COUNT", 40);
        tokenSet.put("SUM", 41);
        tokenSet.put("MIN", 42);
        tokenSet.put("MAX", 43);
        tokenSet.put("AVG", 44);
        tokenSet.put("IFNULL", 60);
        tokenSet.put("NULLIF", 67);
        tokenSet.put("CONVERT", 61);
        tokenSet.put("CAST", 107);
        tokenSet.put("NEXT", 71);
        tokenSet.put("CASE", 68);
        tokenSet.put("WHEN", 110);
        tokenSet.put("THEN", 111);
        tokenSet.put("ELSE", 112);
        tokenSet.put("END", 113);
        tokenSet.put("CASEWHEN", 62);
        tokenSet.put("CONCAT", 15);
        tokenSet.put("COALESCE", 69);
        tokenSet.put("EXTRACT", 63);
        tokenSet.put("POSITION", 64);
        tokenSet.put("FROM", 124);
        tokenSet.put("TRIM", 65);
        tokenSet.put("SUBSTRING", 66);
        tokenSet.put("FOR", 123);
        tokenSet.put("AS", 122);
        tokenSet.put("IS", 109);
        tokenSet.put("?", 9);
        noParameters = new Expression[0];
        noSubqueries = new SubQuery[0];
    }
}

