/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql.lib;

import com.insightful.miner.sql.lib.BaseList;
import com.insightful.miner.sql.lib.HsqlList;
import com.insightful.miner.sql.lib.ObjectComparator;
import com.insightful.miner.sql.lib.Sort;
import java.lang.reflect.Array;

public class HsqlArrayList
extends BaseList
implements HsqlList {
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private static final float DEFAULT_RESIZE_FACTOR = 2.0f;
    private Object[] elementData;

    public HsqlArrayList() {
        this.elementData = new Object[10];
    }

    public HsqlArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new NegativeArraySizeException("Invalid initial capacity given");
        }
        this.elementData = initialCapacity == 0 ? new Object[1] : new Object[initialCapacity];
        this.elementCount = 0;
    }

    public void add(int index, Object element) {
        if (index > this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + ">" + this.elementCount);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " < 0");
        }
        if (this.elementCount >= this.elementData.length) {
            this.increaseCapacity();
        }
        for (int i = this.elementCount; i > index; --i) {
            this.elementData[i] = this.elementData[i - 1];
        }
        this.elementData[index] = element;
        ++this.elementCount;
    }

    public boolean add(Object element) {
        if (this.elementCount >= this.elementData.length) {
            this.increaseCapacity();
        }
        this.elementData[this.elementCount] = element;
        ++this.elementCount;
        return true;
    }

    public Object get(int index) {
        if (index >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " < 0");
        }
        return this.elementData[index];
    }

    public Object remove(int index) {
        if (index >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " < 0");
        }
        Object removedObj = this.elementData[index];
        for (int i = index; i < this.elementCount - 1; ++i) {
            this.elementData[i] = this.elementData[i + 1];
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
        return removedObj;
    }

    public Object set(int index, Object element) {
        if (index >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " < 0");
        }
        Object replacedObj = this.elementData[index];
        this.elementData[index] = element;
        return replacedObj;
    }

    public final int size() {
        return this.elementCount;
    }

    private void increaseCapacity() {
        Object[] newArray = new Object[(int)((float)this.elementData.length * 2.0f)];
        System.arraycopy(this.elementData, 0, newArray, 0, this.elementData.length);
        this.elementData = newArray;
        newArray = null;
    }

    public void trim() {
        Object[] newArray = null;
        newArray = this.elementCount == 0 ? new Object[1] : new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, newArray, 0, this.elementCount);
        this.elementData = newArray;
        newArray = null;
    }

    public void clear() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public void setSize(int newSize) {
        if (newSize < this.elementCount) {
            for (int i = newSize; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
        }
        this.elementCount = newSize;
        while (this.elementCount > this.elementData.length) {
            this.increaseCapacity();
        }
    }

    public Object[] toArray() {
        Object[] a = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, a, 0, this.elementCount);
        return a;
    }

    public Object toArray(Object a) {
        if (Array.getLength(a) < this.elementCount) {
            a = Array.newInstance(a.getClass().getComponentType(), this.elementCount);
        }
        System.arraycopy(this.elementData, 0, a, 0, this.elementCount);
        return a;
    }

    public void sort(ObjectComparator c) {
        if (this.elementCount < 2) {
            return;
        }
        Sort.sort(this.elementData, c, 0, this.elementCount - 1);
    }

    public void remove(Object obj) {
        for (int i = 0; i < this.elementCount; ++i) {
            if ((obj != null || this.elementData[i] != null) && !obj.equals(this.elementData[i])) continue;
            this.remove(i);
            return;
        }
    }
}

