/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql.lib;

import com.insightful.miner.sql.lib.ArrayUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UTFDataFormatException;

public class StringConverter {
    private static final char[] HEXCHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String HEXINDEX = "0123456789abcdef0123456789ABCDEF";

    byte[] stringToFullByteArray(String s) {
        int length = s.length();
        byte[] buffer = new byte[length * 2];
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            buffer[i * 2] = (byte)((c & 0xFF00) >> 8);
            buffer[i * 2 + 1] = (byte)(c & 0xFF);
        }
        return buffer;
    }

    public static byte[] hexToByte(String s) throws IOException {
        int l = s.length() / 2;
        byte[] data = new byte[l];
        int j = 0;
        if (s.length() % 2 != 0) {
            throw new IOException("hexadecimal string with odd number of characters");
        }
        for (int i = 0; i < l; ++i) {
            char c;
            int n;
            if ((n = HEXINDEX.indexOf(c = s.charAt(j++))) == -1) {
                throw new IOException("hexadecimal string contains non hex character");
            }
            int b = (n & 0xF) << 4;
            c = s.charAt(j++);
            n = HEXINDEX.indexOf(c);
            data[i] = (byte)(b += n & 0xF);
        }
        return data;
    }

    public static String byteToHex(byte[] b) {
        int len = b.length;
        char[] s = new char[len * 2];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            int c = b[i] & 0xFF;
            s[j++] = HEXCHAR[c >> 4 & 0xF];
            s[j++] = HEXCHAR[c & 0xF];
        }
        return new String(s);
    }

    public static String byteToString(byte[] b, String charset) {
        try {
            return charset == null ? new String(b) : new String(b, charset);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String hexStringToUnicode(String s) throws IOException {
        byte[] b = StringConverter.hexToByte(s);
        return StringConverter.readUTF(b, 0, b.length);
    }

    public static int unicodeToAscii(OutputStream b, String s, boolean doubleSingleQuotes) throws IOException {
        int count = 0;
        if (s == null || s.length() == 0) {
            return 0;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                if (i < len - 1 && s.charAt(i + 1) == 'u') {
                    b.write(c);
                    b.write(117);
                    b.write(48);
                    b.write(48);
                    b.write(53);
                    b.write(99);
                    count += 6;
                    continue;
                }
                b.write(c);
                ++count;
                continue;
            }
            if (c >= ' ' && c <= '\u007f') {
                b.write(c);
                ++count;
                if (c != '\'' || !doubleSingleQuotes) continue;
                b.write(c);
                ++count;
                continue;
            }
            b.write(92);
            b.write(117);
            b.write(HEXCHAR[c >> 12 & 0xF]);
            b.write(HEXCHAR[c >> 8 & 0xF]);
            b.write(HEXCHAR[c >> 4 & 0xF]);
            b.write(HEXCHAR[c & 0xF]);
            count += 6;
        }
        return count;
    }

    public static String asciiToUnicode(byte[] s, int offset, int length) {
        if (length == 0) {
            return "";
        }
        char[] b = new char[length];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            byte c = s[offset + i];
            if (c == 92 && i < length - 5) {
                byte c1 = s[offset + i + 1];
                if (c1 == 117) {
                    ++i;
                    int k = HEXINDEX.indexOf(s[offset + ++i]) << 12;
                    k += HEXINDEX.indexOf(s[offset + ++i]) << 8;
                    k += HEXINDEX.indexOf(s[offset + ++i]) << 4;
                    b[j++] = (char)(k += HEXINDEX.indexOf(s[offset + ++i]));
                    continue;
                }
                b[j++] = (char)c;
                continue;
            }
            b[j++] = (char)c;
        }
        return new String(b, 0, j);
    }

    public static String asciiToUnicode(String s) {
        if (s == null || s.indexOf("\\u") == -1) {
            return s;
        }
        int len = s.length();
        char[] b = new char[len];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\\' && i < len - 5) {
                char c1 = s.charAt(i + 1);
                if (c1 == 'u') {
                    ++i;
                    int k = HEXINDEX.indexOf(s.charAt(++i)) << 12;
                    k += HEXINDEX.indexOf(s.charAt(++i)) << 8;
                    k += HEXINDEX.indexOf(s.charAt(++i)) << 4;
                    b[j++] = (char)(k += HEXINDEX.indexOf(s.charAt(++i)));
                    continue;
                }
                b[j++] = c;
                continue;
            }
            b[j++] = c;
        }
        return new String(b, 0, j);
    }

    public static String readUTF(byte[] bytearr, int offset, int length) throws IOException {
        char[] buf = new char[length * 2];
        int bcount = 0;
        int count = 0;
        block4: while (count < length) {
            int c = bytearr[offset + count];
            if (bcount > buf.length - 4) {
                buf = (char[])ArrayUtil.resizeArray(buf, buf.length + length);
            }
            if (c > 0) {
                ++count;
                buf[bcount++] = (char)c;
                continue;
            }
            switch ((c &= 0xFF) >> 4) {
                case 12: 
                case 13: {
                    if ((count += 2) > length) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[offset + count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    buf[bcount++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block4;
                }
                case 14: {
                    if ((count += 3) > length) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[offset + count - 2];
                    byte char3 = bytearr[offset + count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    buf[bcount++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block4;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(buf, 0, bcount);
    }

    public static int writeUTF(String str, OutputStream out) throws IOException {
        int strlen = str.length();
        boolean utflen = false;
        int count = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                out.write(c);
                ++count;
                continue;
            }
            if (c > '\u07ff') {
                out.write(0xE0 | c >> 12 & 0xF);
                out.write(0x80 | c >> 6 & 0x3F);
                out.write(0x80 | c >> 0 & 0x3F);
                count += 3;
                continue;
            }
            out.write(0xC0 | c >> 6 & 0x1F);
            out.write(0x80 | c >> 0 & 0x3F);
            count += 2;
        }
        return count;
    }

    public static int getUTFSize(String s) {
        int len = s == null ? 0 : s.length();
        int l = 0;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++l;
                continue;
            }
            if (c > '\u07ff') {
                l += 3;
                continue;
            }
            l += 2;
        }
        return l;
    }

    public static String inputStreamToString(InputStream x, int length) throws IOException {
        int read;
        InputStreamReader in = new InputStreamReader(x);
        StringWriter writer = new StringWriter();
        int blocksize = 8192;
        char[] buffer = new char[blocksize];
        for (int left = length; left > 0 && (read = in.read(buffer, 0, left > blocksize ? blocksize : left)) != -1; left -= read) {
            writer.write(buffer, 0, read);
        }
        writer.close();
        return writer.toString();
    }

    public static String toQuotedString(String s, char quoteChar, boolean extraQuote) {
        if (s == null) {
            return null;
        }
        int count = extraQuote ? StringConverter.count(s, quoteChar) : 0;
        int len = s.length();
        char[] b = new char[2 + count + len];
        int j = 0;
        b[j++] = quoteChar;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            b[j++] = c;
            if (!extraQuote || c != quoteChar) continue;
            b[j++] = c;
        }
        b[j] = quoteChar;
        return new String(b);
    }

    static int count(String s, char c) {
        int count = 0;
        if (s != null) {
            int i = s.length();
            while (--i >= 0) {
                char chr = s.charAt(i);
                if (chr != c) continue;
                ++count;
            }
        }
        return count;
    }
}

