/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.tree.gui;

import com.insightful.miner.MinerApp;
import com.insightful.miner.ModifiableViewerFrame;
import com.insightful.miner.tree.gui.ClassificationTreeGUI;
import com.insightful.miner.tree.gui.TreeComparisonTableModel;
import com.insightful.miner.tree.model.ClassificationRegressionTreeNode;
import com.insightful.miner.tree.model.TreeCollection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class TreeComparisonTableFrame
extends ModifiableViewerFrame {
    private TreeCollection treeCollection = null;
    private JPanel backgroundPanel = new JPanel();
    double maxDev = 0.0;
    int SINGLE_CHAR_PIXELS = 8;

    public TreeComparisonTableFrame(TreeCollection tc) {
        this.treeCollection = tc;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(550, 232));
        this.setTitle("Tree Comparison");
        this.setIconImage(MinerApp.getResourceManager().getImage("minerapp.gif"));
        this.getContentPane().setLayout(new BorderLayout());
        this.backgroundPanel.setBackground(Color.white);
        this.backgroundPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.backgroundPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 10, 10);
        String deviance = "";
        String crit = this.treeCollection.getCriterion();
        if (this.treeCollection.isRegression()) {
            deviance = ClassificationTreeGUI.getText("treecomptableframe_gui_sumsquarederror");
        } else if (this.treeCollection.miningSchema_attribute_entropy_value.equals(crit)) {
            deviance = ClassificationTreeGUI.getText("treecomptableframe_gui_entropy");
        } else if (this.treeCollection.miningSchema_attribute_gini_value.equals(crit)) {
            deviance = ClassificationTreeGUI.getText("treecomptableframe_gui_gini");
        } else {
            System.out.println("Error: unsupported tree type (" + crit + ").");
            deviance = ClassificationTreeGUI.getText("treecomptableframe_gui_deviance");
        }
        String[] columnNames = new String[]{ClassificationTreeGUI.getText("treecomptableframe_gui_trees"), ClassificationTreeGUI.getText("treecomptableframe_gui_topsplit"), deviance, ClassificationTreeGUI.getText("treecomptableframe_gui_nodecount")};
        String[] treeTitles = this.createTreeTitles(this.treeCollection);
        String[] topSplits = this.getTopSplits(this.treeCollection);
        String[] devVals = this.getDevianceVals(this.treeCollection);
        String[] nodeCounts = this.getNodeCounts(this.treeCollection);
        Object[][] data = new Object[topSplits.length][4];
        for (int i = 0; i < data.length; ++i) {
            data[i][0] = treeTitles[i];
            data[i][1] = topSplits[i];
            data[i][2] = devVals[i];
            data[i][3] = nodeCounts[i];
        }
        TreeComparisonTableModel model = new TreeComparisonTableModel(data, columnNames);
        JTable table = new JTable(model);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
        scrollPane.getViewport().setBackground(Color.white);
        this.backgroundPanel.add((Component)scrollPane, gbc);
        this.getContentPane().add((Component)this.backgroundPanel, "Center");
        this.backgroundPanel.registerKeyboardAction(new EscapeListener(this), KeyStroke.getKeyStroke("ESCAPE"), 2);
    }

    private String[] createTreeTitles(TreeCollection tc) {
        int numTrees = tc.getNumberTrees();
        String[] titleArray = new String[numTrees];
        for (int i = 0; i < numTrees; ++i) {
            titleArray[i] = "Tree " + (i + 1);
        }
        return titleArray;
    }

    private String[] getTopSplits(TreeCollection tc) {
        String split = "";
        int numTrees = tc.getNumberTrees();
        String[] splitArray = new String[numTrees];
        ClassificationRegressionTreeNode root = null;
        for (int i = 0; i < numTrees; ++i) {
            root = tc.getTree(i).getRootNode();
            if (root != null && root.getChildCount() > 0) {
                split = ((ClassificationRegressionTreeNode)root.getChildAt(0)).getNodeSplit();
            }
            splitArray[i] = split;
        }
        return splitArray;
    }

    private String[] getDevianceVals(TreeCollection tc) {
        int numTrees = tc.getNumberTrees();
        String[] devArray = new String[numTrees];
        for (int i = 0; i < numTrees; ++i) {
            devArray[i] = MinerApp.formatDouble(tc.getTree(i).getRootNode().getDeviance());
        }
        return devArray;
    }

    private String[] getNodeCounts(TreeCollection tc) {
        int numTrees = tc.getNumberTrees();
        String[] countArray = new String[numTrees];
        for (int i = 0; i < numTrees; ++i) {
            countArray[i] = Integer.toString(tc.getTree(i).getNodeCount());
        }
        return countArray;
    }

    private void printArray(String[] array, String name) {
        System.out.println("Printing array " + name + ":");
        for (int i = 0; i < array.length; ++i) {
            System.out.print(array[i] + " ");
        }
        System.out.println();
    }

    private class EscapeListener
    implements ActionListener {
        private JFrame m_frame;

        public EscapeListener(JFrame frame) {
            this.m_frame = frame;
        }

        public void actionPerformed(ActionEvent e) {
            this.m_frame.dispose();
        }
    }
}

