/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.AssocRulesEngineNode;
import com.insightful.miner.AssocRulesIMEngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import com.insightful.miner.graphdlg.controls.MinerControlMetrics;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AssocRulesIMDialog
extends NodeDialog {
    private static AssocRulesIMDialog m_instance = null;
    private NodeDialog.SortingScrollPane m_availableColumnsScrollPane;
    private NodeDialog.SortingScrollPane m_itemColumnsScrollPane;
    private NodeDialog.SortingScrollPane m_idColumnsScrollPane;
    private NodeDialog.DNDList m_availableColumnsList;
    private NodeDialog.DNDListModel m_availableColumnsListModel;
    private NodeDialog.DNDList m_itemColumnsList;
    private NodeDialog.DNDListModel m_itemColumnsListModel;
    private NodeDialog.DNDList m_idColumnsList;
    private NodeDialog.DNDListModel m_idColumnsListModel;
    private JTextField m_minSupportTextField;
    private JTextField m_minConfidenceTextField;
    private JTextField m_minRuleItemsTextField;
    private JTextField m_maxRuleItemsTextField;
    private JCheckBox m_prescanItemsCheckBox;
    private JCheckBox m_outputRuleStringsCheckBox;
    private JCheckBox m_outputRuleItemsCheckBox;
    private JCheckBox m_outputRuleSizesCheckBox;
    private JCheckBox m_outputMeasuresCheckBox;
    private JCheckBox m_outputCountsCheckBox;
    private HashMap m_inItemColumnsList;
    private HashMap m_inIdColumnsList;
    private static final String[] m_inputFormatComboLabels = new String[]{"Item List", "Column Value", "Column Flag", "Transaction Id"};
    private static final String[] m_inputFormatComboValues = new String[]{AssocRulesEngineNode.INPUT_FORMAT_ITEM_LIST, AssocRulesEngineNode.INPUT_FORMAT_COLUMN_VALUE, AssocRulesEngineNode.INPUT_FORMAT_COLUMN_FLAG, AssocRulesEngineNode.INPUT_FORMAT_TRANSACTION_ID};
    private JComboBox m_inputFormatComboBox;
    private JCheckBox m_sortIdColumnsCheckBox;
    private AbstractAction m_addItemColumnsAction;
    private AbstractAction m_removeItemColumnsAction;
    private AbstractAction m_addIdColumnsAction;
    private AbstractAction m_removeIdColumnsAction;

    protected AssocRulesIMDialog() {
        this.chunkTextField.setEnabled(false);
        this.chunkButtons[0].setEnabled(false);
        this.chunkButtons[1].setEnabled(false);
        this.pack();
        Dimension rootSize = this.getRootPane().getMinimumSize();
        int paddedHeight = rootSize.height + MinerControlMetrics.getLabelDimension().height * 2;
        int paddedWidth = rootSize.width + 30;
        Dimension paddedSize = new Dimension(paddedWidth, paddedHeight);
        this.setMinimumSize(paddedSize);
        this.setSize(paddedSize);
        this.pack();
    }

    public static AssocRulesIMDialog getInstance() {
        m_instance = new AssocRulesIMDialog();
        return m_instance;
    }

    public void restoreProperties() {
        XTMetaData metaData;
        super.restoreProperties();
        this.m_availableColumnsListModel.removeAllElements();
        this.m_itemColumnsListModel.removeAllElements();
        this.m_idColumnsListModel.removeAllElements();
        XTProps props = this.getNodeModel().getXTProps();
        try {
            metaData = this.getNodeModel().getInputMetaData(0);
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
            e.printStackTrace();
            return;
        }
        Vector names = metaData.getColumnNames();
        Vector types = metaData.getColumnTypes();
        Vector roles = metaData.getColumnRoles();
        String inputFormat = props.getValue(AssocRulesEngineNode.INPUT_FORMAT_TAG, AssocRulesEngineNode.INPUT_FORMAT_ITEM_LIST);
        Vector itemColumns = props.getSubProperties(AssocRulesEngineNode.ITEM_COLUMNS_TAG);
        Vector idColumns = props.getSubProperties(AssocRulesEngineNode.ID_COLUMNS_TAG);
        double minSupport = props.getDouble(AssocRulesEngineNode.MIN_SUPPORT_TAG, 0.1);
        double minConfidence = props.getDouble(AssocRulesEngineNode.MIN_CONFIDENCE_TAG, 0.8);
        int minRuleItems = props.getInt(AssocRulesEngineNode.MIN_RULE_ITEMS_TAG, 1);
        int maxRuleItems = props.getInt(AssocRulesEngineNode.MAX_RULE_ITEMS_TAG, 5);
        boolean outputRuleStrings = props.getBoolean(AssocRulesEngineNode.OUTPUT_RULE_STRINGS_TAG, true);
        boolean outputRuleItems = props.getBoolean(AssocRulesEngineNode.OUTPUT_RULE_ITEMS_TAG, false);
        boolean outputRuleSizes = props.getBoolean(AssocRulesEngineNode.OUTPUT_RULE_SIZES_TAG, false);
        boolean outputMeasures = props.getBoolean(AssocRulesEngineNode.OUTPUT_MEASURES_TAG, true);
        boolean outputCounts = props.getBoolean(AssocRulesEngineNode.OUTPUT_COUNTS_TAG, false);
        boolean debug = props.getBoolean(AssocRulesEngineNode.DEBUG_TAG, false);
        boolean prescanItems = props.getBoolean(AssocRulesIMEngineNode.PRESCAN_ITEMS_TAG, false);
        boolean sortIdColumns = props.getBoolean(AssocRulesIMEngineNode.SORT_ID_COLUMNS_TAG, true);
        for (int iMethod = 0; iMethod < m_inputFormatComboValues.length; ++iMethod) {
            if (!inputFormat.equals(m_inputFormatComboValues[iMethod])) continue;
            this.m_inputFormatComboBox.setSelectedIndex(iMethod);
            break;
        }
        this.m_sortIdColumnsCheckBox.setSelected(sortIdColumns);
        this.m_inItemColumnsList = new HashMap();
        this.m_inIdColumnsList = new HashMap();
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            String role = (String)roles.get(i);
            String type = (String)types.get(i);
            NodeDialog.ColumnInformationObject info = new NodeDialog.ColumnInformationObject(name, type, role, false, i);
            if (itemColumns.indexOf(name) >= 0) {
                this.m_itemColumnsListModel.addElement(info);
                this.m_inItemColumnsList.put(name, name);
                continue;
            }
            if (idColumns.indexOf(name) >= 0) {
                this.m_idColumnsListModel.addElement(info);
                this.m_inIdColumnsList.put(name, name);
                continue;
            }
            this.m_availableColumnsListModel.addElement(info);
        }
        this.m_minSupportTextField.setText(Double.toString(minSupport));
        this.m_minConfidenceTextField.setText(Double.toString(minConfidence));
        this.m_minRuleItemsTextField.setText(Integer.toString(minRuleItems));
        this.m_maxRuleItemsTextField.setText(Integer.toString(maxRuleItems));
        this.m_prescanItemsCheckBox.setSelected(prescanItems);
        this.m_outputRuleStringsCheckBox.setSelected(outputRuleStrings);
        this.m_outputRuleItemsCheckBox.setSelected(outputRuleItems);
        this.m_outputRuleSizesCheckBox.setSelected(outputRuleSizes);
        this.m_outputMeasuresCheckBox.setSelected(outputMeasures);
        this.m_outputCountsCheckBox.setSelected(outputCounts);
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        props.set(AssocRulesEngineNode.INPUT_FORMAT_TAG, m_inputFormatComboValues[this.m_inputFormatComboBox.getSelectedIndex()]);
        props.set(AssocRulesIMEngineNode.SORT_ID_COLUMNS_TAG, this.m_sortIdColumnsCheckBox.isSelected());
        props.removeProperty(new String[]{AssocRulesEngineNode.ITEM_COLUMNS_TAG});
        props.removeProperty(new String[]{AssocRulesEngineNode.ID_COLUMNS_TAG});
        NodeDialog.ColumnInformationObject object = null;
        Enumeration itemColumns = this.m_itemColumnsListModel.elements();
        while (itemColumns.hasMoreElements()) {
            object = (NodeDialog.ColumnInformationObject)itemColumns.nextElement();
            props.set(AssocRulesEngineNode.ITEM_COLUMNS_TAG, object.getText(), "");
        }
        itemColumns = null;
        Enumeration idColumns = this.m_idColumnsListModel.elements();
        while (idColumns.hasMoreElements()) {
            object = (NodeDialog.ColumnInformationObject)idColumns.nextElement();
            props.set(AssocRulesEngineNode.ID_COLUMNS_TAG, object.getText(), "");
        }
        idColumns = null;
        props.set(AssocRulesEngineNode.MIN_SUPPORT_TAG, this.m_minSupportTextField.getText());
        props.set(AssocRulesEngineNode.MIN_CONFIDENCE_TAG, this.m_minConfidenceTextField.getText());
        props.set(AssocRulesEngineNode.MIN_RULE_ITEMS_TAG, this.m_minRuleItemsTextField.getText());
        props.set(AssocRulesEngineNode.MAX_RULE_ITEMS_TAG, this.m_maxRuleItemsTextField.getText());
        props.set(AssocRulesIMEngineNode.PRESCAN_ITEMS_TAG, this.m_prescanItemsCheckBox.isSelected());
        props.set(AssocRulesEngineNode.OUTPUT_RULE_STRINGS_TAG, this.m_outputRuleStringsCheckBox.isSelected());
        props.set(AssocRulesEngineNode.OUTPUT_RULE_ITEMS_TAG, this.m_outputRuleItemsCheckBox.isSelected());
        props.set(AssocRulesEngineNode.OUTPUT_RULE_SIZES_TAG, this.m_outputRuleSizesCheckBox.isSelected());
        props.set(AssocRulesEngineNode.OUTPUT_MEASURES_TAG, this.m_outputMeasuresCheckBox.isSelected());
        props.set(AssocRulesEngineNode.OUTPUT_COUNTS_TAG, this.m_outputCountsCheckBox.isSelected());
    }

    public JPanel createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.getSelectColumnsPanel(), "Center");
        panel.add((Component)this.getOptionsPanel(), "South");
        return panel;
    }

    private JPanel getSelectColumnsPanel() {
        JPanel selectColumnsPanel = new JPanel(new GridBagLayout());
        selectColumnsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Select Columns"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel availableLabel = new JLabel("Available Columns");
        availableLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.m_availableColumnsListModel = new NodeDialog.DNDListModel();
        this.m_availableColumnsList = new NodeDialog.DNDList(this.m_availableColumnsListModel);
        NodeDialog.ColumnInformationRenderer renderer = new NodeDialog.ColumnInformationRenderer();
        this.m_availableColumnsList.setCellRenderer(renderer);
        this.m_availableColumnsList.setSelectionMode(2);
        this.m_availableColumnsScrollPane = new NodeDialog.SortingScrollPane(this.m_availableColumnsList);
        this.m_availableColumnsScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        constraints.gridheight = 1;
        constraints.gridwidth = 5;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 17;
        selectColumnsPanel.add((Component)availableLabel, constraints);
        constraints.gridy = 1;
        constraints.gridheight = 17;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        selectColumnsPanel.add((Component)this.m_availableColumnsScrollPane, constraints);
        JButton addItemColumnsButton = new JButton(this.m_addItemColumnsAction);
        JButton removeItemColumnsButton = new JButton(this.m_removeItemColumnsAction);
        JButton addIdColumnsButton = new JButton(this.m_addIdColumnsAction);
        JButton removeIdColumnsButton = new JButton(this.m_removeIdColumnsAction);
        constraints.gridx = 5;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(3, 10, 3, 10);
        constraints.fill = 0;
        selectColumnsPanel.add((Component)addItemColumnsButton, constraints);
        constraints.gridy = 2;
        selectColumnsPanel.add((Component)removeItemColumnsButton, constraints);
        constraints.gridy = 7;
        selectColumnsPanel.add((Component)addIdColumnsButton, constraints);
        constraints.gridy = 8;
        selectColumnsPanel.add((Component)removeIdColumnsButton, constraints);
        JLabel itemColumnsLabel = new JLabel("Item Columns");
        itemColumnsLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.m_itemColumnsListModel = new NodeDialog.DNDListModel();
        this.m_itemColumnsList = new NodeDialog.DNDList(this.m_itemColumnsListModel);
        this.m_itemColumnsList.setCellRenderer(renderer);
        this.m_itemColumnsScrollPane = new NodeDialog.SortingScrollPane(this.m_itemColumnsList);
        this.m_itemColumnsScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        JLabel idColumnsLabel = new JLabel("Transaction ID Columns");
        idColumnsLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.m_idColumnsListModel = new NodeDialog.DNDListModel();
        this.m_idColumnsList = new NodeDialog.DNDList(this.m_idColumnsListModel);
        this.m_idColumnsList.setCellRenderer(renderer);
        this.m_idColumnsScrollPane = new NodeDialog.SortingScrollPane(this.m_idColumnsList);
        this.m_idColumnsScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        constraints.gridx = 6;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 5;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.anchor = 17;
        constraints.fill = 1;
        selectColumnsPanel.add((Component)itemColumnsLabel, constraints);
        constraints.gridy = 1;
        constraints.gridheight = 4;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        selectColumnsPanel.add((Component)this.m_itemColumnsScrollPane, constraints);
        constraints.gridy = 6;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        selectColumnsPanel.add((Component)idColumnsLabel, constraints);
        constraints.gridy = 7;
        constraints.gridheight = 4;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        selectColumnsPanel.add((Component)this.m_idColumnsScrollPane, constraints);
        return selectColumnsPanel;
    }

    private JPanel getOptionsPanel() {
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        optionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Input Format"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel inputFormatLabel = new JLabel("Input Format:");
        this.m_inputFormatComboBox = new JComboBox<String>(m_inputFormatComboLabels);
        inputFormatLabel.setLabelFor(this.m_inputFormatComboBox);
        this.m_sortIdColumnsCheckBox = new JCheckBox("Sort ID Columns");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        optionsPanel.add((Component)this.m_inputFormatComboBox, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 15, 0, 0);
        constraints.anchor = 12;
        optionsPanel.add((Component)this.m_sortIdColumnsCheckBox, constraints);
        return optionsPanel;
    }

    public Vector createOtherTabs() {
        Vector<JPanel> panels = new Vector<JPanel>();
        panels.add(this.createAssocRulesOptionsPanel());
        panels.add(this.createAssocRulesOutputPanel());
        return panels;
    }

    public JPanel createAssocRulesOptionsPanel() {
        JLabel minSupportLabel = new JLabel("Minimum Support: ");
        this.m_minSupportTextField = new JTextField();
        minSupportLabel.setLabelFor(this.m_minSupportTextField);
        JLabel minConfidenceLabel = new JLabel("Minimum Confidence: ");
        this.m_minConfidenceTextField = new JTextField();
        minConfidenceLabel.setLabelFor(this.m_minConfidenceTextField);
        JLabel minRuleItemsLabel = new JLabel("Minimum Rule Items: ");
        this.m_minRuleItemsTextField = new JTextField();
        minRuleItemsLabel.setLabelFor(this.m_minRuleItemsTextField);
        JLabel maxRuleItemsLabel = new JLabel("Maximum Rule Items: ");
        this.m_maxRuleItemsTextField = new JTextField();
        maxRuleItemsLabel.setLabelFor(this.m_maxRuleItemsTextField);
        this.m_prescanItemsCheckBox = new JCheckBox("Prescan Items");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Rule Generation Options"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        panel.add((Component)minSupportLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        panel.add((Component)this.m_minSupportTextField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        panel.add((Component)minConfidenceLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        panel.add((Component)this.m_minConfidenceTextField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        panel.add((Component)minRuleItemsLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        panel.add((Component)this.m_minRuleItemsTextField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        panel.add((Component)maxRuleItemsLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        panel.add((Component)this.m_maxRuleItemsTextField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        panel.add((Component)this.m_prescanItemsCheckBox, gbc);
        panel.setName("Options");
        return panel;
    }

    public JPanel createAssocRulesOutputPanel() {
        this.m_outputRuleStringsCheckBox = new JCheckBox("Output Rule Strings (rule)");
        this.m_outputRuleItemsCheckBox = new JCheckBox("Output Rule Items (con1, ant1, ant2, ...)");
        this.m_outputRuleSizesCheckBox = new JCheckBox("Output Rule Sizes (conSize, antSize, ruleSize)");
        this.m_outputMeasuresCheckBox = new JCheckBox("Output Measures (support, confidence, lift)");
        this.m_outputCountsCheckBox = new JCheckBox("Output Counts (conCount, antCount, ruleCount, transCount, itemCount)");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Output Options"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        panel.add((Component)this.m_outputRuleStringsCheckBox, gbc);
        ++gbc.gridy;
        panel.add((Component)this.m_outputRuleItemsCheckBox, gbc);
        ++gbc.gridy;
        panel.add((Component)this.m_outputRuleSizesCheckBox, gbc);
        ++gbc.gridy;
        panel.add((Component)this.m_outputMeasuresCheckBox, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        panel.add((Component)this.m_outputCountsCheckBox, gbc);
        panel.setName("Output");
        return panel;
    }

    public void createActions() {
        super.createActions();
        this.m_addItemColumnsAction = new AbstractAction(">>"){

            public void actionPerformed(ActionEvent e) {
                if (!AssocRulesIMDialog.this.m_availableColumnsList.isSelectionEmpty()) {
                    Object[] values = AssocRulesIMDialog.this.m_availableColumnsList.getSelectedValues();
                    AssocRulesIMDialog.this.m_availableColumnsListModel.removeListDataListeners();
                    AssocRulesIMDialog.this.m_itemColumnsListModel.removeListDataListeners();
                    for (int i = 0; i < values.length; ++i) {
                        String name = ((NodeDialog.ColumnInformationObject)values[i]).getText();
                        if (AssocRulesIMDialog.this.m_inItemColumnsList.get(name) != null) continue;
                        AssocRulesIMDialog.this.m_inItemColumnsList.put(name, values[i]);
                        AssocRulesIMDialog.this.m_itemColumnsListModel.addElement(values[i]);
                        AssocRulesIMDialog.this.m_availableColumnsListModel.removeElement(values[i]);
                    }
                    AssocRulesIMDialog.this.m_availableColumnsListModel.undoRemoveListDataListeners();
                    AssocRulesIMDialog.this.m_itemColumnsListModel.undoRemoveListDataListeners();
                    AssocRulesIMDialog.this.m_itemColumnsScrollPane.sort();
                    AssocRulesIMDialog.this.m_availableColumnsListModel.listContentsChanged();
                    AssocRulesIMDialog.this.m_itemColumnsListModel.listContentsChanged();
                    Object var2_2 = null;
                }
            }
        };
        this.m_removeItemColumnsAction = new AbstractAction("<<"){

            public void actionPerformed(ActionEvent e) {
                if (!AssocRulesIMDialog.this.m_itemColumnsList.isSelectionEmpty()) {
                    Object[] values = AssocRulesIMDialog.this.m_itemColumnsList.getSelectedValues();
                    int[] indices = AssocRulesIMDialog.this.m_itemColumnsList.getSelectedIndices();
                    AssocRulesIMDialog.this.m_itemColumnsList.getSelectionModel().clearSelection();
                    AssocRulesIMDialog.this.m_availableColumnsListModel.removeListDataListeners();
                    AssocRulesIMDialog.this.m_itemColumnsListModel.removeListDataListeners();
                    for (int i = 0; i < indices.length; ++i) {
                        String name = ((NodeDialog.ColumnInformationObject)values[i]).getText();
                        AssocRulesIMDialog.this.m_inItemColumnsList.remove(name);
                        AssocRulesIMDialog.this.m_itemColumnsListModel.removeElementAt(indices[i] - i);
                        AssocRulesIMDialog.this.m_availableColumnsListModel.addElement(values[i]);
                    }
                    AssocRulesIMDialog.this.m_availableColumnsListModel.undoRemoveListDataListeners();
                    AssocRulesIMDialog.this.m_itemColumnsListModel.undoRemoveListDataListeners();
                    AssocRulesIMDialog.this.m_availableColumnsScrollPane.sort();
                    AssocRulesIMDialog.this.m_availableColumnsListModel.listContentsChanged();
                    AssocRulesIMDialog.this.m_itemColumnsListModel.listContentsChanged();
                    indices = null;
                    Object var2_2 = null;
                }
            }
        };
        this.m_addIdColumnsAction = new AbstractAction(">>"){

            public void actionPerformed(ActionEvent e) {
                if (!AssocRulesIMDialog.this.m_availableColumnsList.isSelectionEmpty()) {
                    Object[] values = AssocRulesIMDialog.this.m_availableColumnsList.getSelectedValues();
                    AssocRulesIMDialog.this.m_availableColumnsListModel.removeListDataListeners();
                    AssocRulesIMDialog.this.m_idColumnsListModel.removeListDataListeners();
                    for (int i = 0; i < values.length; ++i) {
                        String name = ((NodeDialog.ColumnInformationObject)values[i]).getText();
                        if (AssocRulesIMDialog.this.m_inIdColumnsList.get(name) != null) continue;
                        AssocRulesIMDialog.this.m_inIdColumnsList.put(name, values[i]);
                        AssocRulesIMDialog.this.m_idColumnsListModel.addElement(values[i]);
                        AssocRulesIMDialog.this.m_availableColumnsListModel.removeElement(values[i]);
                    }
                    AssocRulesIMDialog.this.m_availableColumnsListModel.undoRemoveListDataListeners();
                    AssocRulesIMDialog.this.m_idColumnsListModel.undoRemoveListDataListeners();
                    AssocRulesIMDialog.this.m_idColumnsScrollPane.sort();
                    AssocRulesIMDialog.this.m_availableColumnsListModel.listContentsChanged();
                    AssocRulesIMDialog.this.m_idColumnsListModel.listContentsChanged();
                    Object var2_2 = null;
                }
            }
        };
        this.m_removeIdColumnsAction = new AbstractAction("<<"){

            public void actionPerformed(ActionEvent e) {
                if (!AssocRulesIMDialog.this.m_idColumnsList.isSelectionEmpty()) {
                    Object[] values = AssocRulesIMDialog.this.m_idColumnsList.getSelectedValues();
                    int[] indices = AssocRulesIMDialog.this.m_idColumnsList.getSelectedIndices();
                    AssocRulesIMDialog.this.m_idColumnsList.getSelectionModel().clearSelection();
                    AssocRulesIMDialog.this.m_availableColumnsListModel.removeListDataListeners();
                    AssocRulesIMDialog.this.m_idColumnsListModel.removeListDataListeners();
                    for (int i = 0; i < indices.length; ++i) {
                        String name = ((NodeDialog.ColumnInformationObject)values[i]).getText();
                        AssocRulesIMDialog.this.m_inIdColumnsList.remove(name);
                        AssocRulesIMDialog.this.m_idColumnsListModel.removeElementAt(indices[i] - i);
                        AssocRulesIMDialog.this.m_availableColumnsListModel.addElement(values[i]);
                    }
                    AssocRulesIMDialog.this.m_availableColumnsListModel.undoRemoveListDataListeners();
                    AssocRulesIMDialog.this.m_idColumnsListModel.undoRemoveListDataListeners();
                    AssocRulesIMDialog.this.m_availableColumnsScrollPane.sort();
                    AssocRulesIMDialog.this.m_availableColumnsListModel.listContentsChanged();
                    AssocRulesIMDialog.this.m_idColumnsListModel.listContentsChanged();
                    indices = null;
                    Object var2_2 = null;
                }
            }
        };
    }
}

