/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcSplusTransform;
import com.insightful.miner.AssocRulesEngineNode;
import com.insightful.miner.SplusScriptEngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.Vector;

public class AssocRulesIMEngineNode
extends SplusScriptEngineNode {
    public static String SORT_ID_COLUMNS_TAG = "sortIdColumns";
    public static String PRESCAN_ITEMS_TAG = "prescanItems";

    public boolean isSampleRequired() {
        return false;
    }

    public boolean isBigdataScript() {
        return true;
    }

    private void addStringVectorSplusCode(StringBuffer buf, Vector vec) {
        if (vec.size() < 1) {
            buf.append("character(0)");
            return;
        }
        buf.append("c(");
        for (int i = 0; i < vec.size(); ++i) {
            String str = (String)vec.get(i);
            if (str.indexOf("\"") >= 0) {
                str = str.replaceAll("\"", "\\\"");
            }
            if (i > 0) {
                buf.append(",");
            }
            buf.append("\"");
            buf.append(str);
            buf.append("\"");
        }
        buf.append(")");
    }

    public String getTransformFunctionBody() {
        XTProps props = (XTProps)this.getNodeProperties().copy();
        StringBuffer buf = new StringBuffer();
        buf.append("\nbd.internal.miner.execute.bigdata.script(IM=IM,");
        buf.append("num.inputs=1, num.outputs=1, user.fn=function(IM) {\n");
        buf.append("if(IM$test) {return(list(dynamic.outputs=T))}\n");
        String inputFormat = props.getValue(AssocRulesEngineNode.INPUT_FORMAT_TAG, AssocRulesEngineNode.INPUT_FORMAT_ITEM_LIST);
        Vector itemColumns = props.getSubProperties(AssocRulesEngineNode.ITEM_COLUMNS_TAG);
        Vector idColumns = props.getSubProperties(AssocRulesEngineNode.ID_COLUMNS_TAG);
        double minSupport = props.getDouble(AssocRulesEngineNode.MIN_SUPPORT_TAG, 0.1);
        double minConfidence = props.getDouble(AssocRulesEngineNode.MIN_CONFIDENCE_TAG, 0.8);
        int maxRuleItems = props.getInt(AssocRulesEngineNode.MAX_RULE_ITEMS_TAG, 5);
        int minRuleItems = props.getInt(AssocRulesEngineNode.MIN_RULE_ITEMS_TAG, 1);
        boolean outputRuleStrings = props.getBoolean(AssocRulesEngineNode.OUTPUT_RULE_STRINGS_TAG, true);
        boolean outputRuleItems = props.getBoolean(AssocRulesEngineNode.OUTPUT_RULE_ITEMS_TAG, false);
        boolean outputRuleSizes = props.getBoolean(AssocRulesEngineNode.OUTPUT_RULE_SIZES_TAG, false);
        boolean outputMeasures = props.getBoolean(AssocRulesEngineNode.OUTPUT_MEASURES_TAG, true);
        boolean outputCounts = props.getBoolean(AssocRulesEngineNode.OUTPUT_COUNTS_TAG, false);
        boolean debug = props.getBoolean(AssocRulesEngineNode.DEBUG_TAG, false);
        boolean prescanItems = props.getBoolean(PRESCAN_ITEMS_TAG, false);
        boolean sortIdColumns = props.getBoolean(SORT_ID_COLUMNS_TAG, true);
        buf.append("item.columns <- ");
        this.addStringVectorSplusCode(buf, itemColumns);
        buf.append("\n");
        buf.append("id.columns <- ");
        this.addStringVectorSplusCode(buf, idColumns);
        buf.append("\n");
        buf.append("bd.assoc.rules(IM$in1,item.columns=item.columns,id.columns=id.columns,\n");
        buf.append("input.format=\"" + inputFormat + "\",\n");
        buf.append("id.sort=" + (sortIdColumns ? "T" : "F") + ",\n");
        buf.append("prescan.items=" + (prescanItems ? "T" : "F") + ",\n");
        buf.append("init.items=NULL,\n");
        buf.append("min.support=" + minSupport + ",\n");
        buf.append("min.confidence=" + minConfidence + ",\n");
        buf.append("min.rule.items=" + minRuleItems + ",\n");
        buf.append("max.rule.items=" + maxRuleItems + ",\n");
        buf.append("output.rule.strings=" + (outputRuleStrings ? "T" : "F") + ",\n");
        buf.append("output.rule.items=" + (outputRuleItems ? "T" : "F") + ",\n");
        buf.append("output.rule.sizes=" + (outputRuleSizes ? "T" : "F") + ",\n");
        buf.append("output.measures=" + (outputMeasures ? "T" : "F") + ",\n");
        buf.append("output.counts=" + (outputCounts ? "T" : "F") + ",\n");
        buf.append(")\n");
        buf.append("\n}\n)\n");
        String fn = buf.toString();
        fn = this.getSafeTransformFunction(fn);
        return fn;
    }

    public void procSetProperties(CNKProc proc) {
        super.procSetProperties(proc);
        CNKProcSplusTransform xform = (CNKProcSplusTransform)proc;
        xform.setMangleColumnNames(false);
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        XTMetaData inputMD = this.getInputMetaData(0);
        XTProps props = this.getNodeProperties();
        int defaultStringSize = this.getNetworkManager().getDefaultStringSize();
        XTMetaData md = AssocRulesEngineNode.calculateAssocRulesOutputMD(inputMD, props, defaultStringSize);
        return md;
    }

    public long procGetEstimatedNumRows(CNKProc proc) {
        XTMetaData inputMD = this.getInputMetaData(0);
        XTProps props = this.getNodeProperties();
        long inputRows = inputMD.getNumRows();
        int maxRuleItems = props.getInt(AssocRulesEngineNode.MAX_RULE_ITEMS_TAG, 5);
        return inputRows * (long)maxRuleItems;
    }
}

