/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.ActivityNodeComputed;
import com.insightful.miner.ActivityNodeConfigured;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.BaseLink;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.XTNetwork;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPort;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CollapsedLink
extends BaseLink {
    protected Vector fromPortsRepresented = new Vector();
    protected Vector toPortsRepresented = new Vector();
    protected Vector orthogRepresented = new Vector();

    public CollapsedLink() {
    }

    public CollapsedLink(JGoPort from, JGoPort to) {
        super(from, to);
    }

    public void addRepresentedLink(JGoPort from, JGoPort to, boolean orthog) {
        for (int i = this.fromPortsRepresented.size() - 1; i >= 0; --i) {
            if (from != this.fromPortsRepresented.get(i) || to != this.toPortsRepresented.get(i)) continue;
            return;
        }
        this.fromPortsRepresented.add(from);
        this.toPortsRepresented.add(to);
        this.orthogRepresented.add(new Boolean(orthog));
    }

    public void addRepresentedLink(CollapsedLink link) {
        for (int i = link.getNumLinksRepresented() - 1; i >= 0; --i) {
            JGoPort from = link.getOriginalFromPortAt(i);
            JGoPort to = link.getOriginalToPortAt(i);
            boolean orthog = (Boolean)link.orthogRepresented.get(i);
            this.addRepresentedLink(from, to, orthog);
        }
    }

    public void setOrthogonal(boolean b) {
        super.setOrthogonal(b);
        Boolean newOrth = new Boolean(b);
        for (int i = 0; i < this.orthogRepresented.size(); ++i) {
            this.orthogRepresented.set(i, newOrth);
        }
    }

    public XTNetwork.ExternalLinkInfo createExternalLinkInfo(XTNetwork net) {
        XTNetwork.ExternalLinkInfo info = new XTNetwork.ExternalLinkInfo();
        info.fromNodeID = Integer.toString(this.getFromNode().getID());
        info.fromPort = this.getFromPortIndex();
        info.toNodeID = Integer.toString(this.getToNode().getID());
        info.toPort = this.getToPortIndex();
        info.isOrthog = this.isOrthogonal();
        XTNetwork.LinkInfo link = null;
        for (int i = this.fromPortsRepresented.size() - 1; i >= 0; --i) {
            link = new XTNetwork.LinkInfo();
            link.setFromInfo(Integer.toString(this.getOriginalFromNodeAt(i).getID()), this.getOriginalFromPortIndexAt(i));
            link.setToInfo(Integer.toString(this.getOriginalToNodeAt(i).getID()), this.getOriginalToPortIndexAt(i));
            link.inExternal = true;
            link.isOrthog = this.getOrthogonalAt(i);
            info.links.add(link);
            net.addFlatLink(link);
        }
        return info;
    }

    public Element createXMLElement(Document document) {
        Element link = document.createElement(XTNetwork.LINK_NODE_TAG);
        link.setAttribute(XTNetwork.FROM_NODE_ATTRIBUTE_TAG, Integer.toString(this.getFromNode().getID()));
        link.setAttribute(XTNetwork.FROM_PORT_ATTRIBUTE_TAG, Integer.toString(this.getFromPortIndex()));
        link.setAttribute(XTNetwork.TO_NODE_ATTRIBUTE_TAG, Integer.toString(this.getToNode().getID()));
        link.setAttribute(XTNetwork.TO_PORT_ATTRIBUTE_TAG, Integer.toString(this.getToPortIndex()));
        Element linkHistory = null;
        for (int i = this.fromPortsRepresented.size() - 1; i >= 0; --i) {
            linkHistory = document.createElement(XTNetwork.LINK_HISTORY_NODE_TAG);
            linkHistory.setAttribute(XTNetwork.FROM_NODE_ATTRIBUTE_TAG, Integer.toString(this.getOriginalFromNodeAt(i).getID()));
            linkHistory.setAttribute(XTNetwork.FROM_PORT_ATTRIBUTE_TAG, Integer.toString(this.getOriginalFromPortIndexAt(i)));
            linkHistory.setAttribute(XTNetwork.TO_NODE_ATTRIBUTE_TAG, Integer.toString(this.getOriginalToNodeAt(i).getID()));
            linkHistory.setAttribute(XTNetwork.TO_PORT_ATTRIBUTE_TAG, Integer.toString(this.getOriginalToPortIndexAt(i)));
            link.appendChild(linkHistory);
        }
        return link;
    }

    public static BaseLink buildLinkFromInfo(XTNetwork.ExternalLinkInfo info, WorksheetDocument doc) {
        BaseLink blink = null;
        boolean canCreate = false;
        int fromNodeID = Integer.parseInt(info.fromNodeID);
        int fromPortID = info.fromPort;
        int toNodeID = Integer.parseInt(info.toNodeID);
        int toPortID = info.toPort;
        BaseNodeArea from = doc.findNodeByID(fromNodeID);
        BaseNodeArea to = doc.findNodeByID(toNodeID);
        if (from == null && to == null) {
            to = doc.findFlatNodeByID(toNodeID);
            from = doc.findFlatNodeByID(toNodeID);
        }
        boolean bl = canCreate = from != null && to != null && from.getOutputPorts() != null && to.getInputPorts() != null && from.getOutputPorts().size() != 0 && to.getInputPorts().size() != 0;
        if (!canCreate) {
            return null;
        }
        JGoPort fromPort = (JGoPort)from.getOutputPorts().elementAt(fromPortID);
        JGoPort toPort = (JGoPort)to.getInputPorts().elementAt(toPortID);
        blink = doc.newCollapsedLink(new CollapsedLink(fromPort, toPort));
        blink.setOrthogonal(info.isOrthog);
        for (int i = info.links.size() - 1; i >= 0; --i) {
            XTNetwork.LinkInfo link = (XTNetwork.LinkInfo)info.links.get(i);
            fromNodeID = Integer.parseInt(link.getFromNodeID());
            fromPortID = link.getFromOutputPort();
            toNodeID = Integer.parseInt(link.getToNodeID());
            toPortID = link.getToInputPort();
            to = doc.findFlatNodeByID(toNodeID);
            from = doc.findFlatNodeByID(fromNodeID);
            if (to == null || from == null) continue;
            fromPort = (JGoPort)from.getOutputPorts().elementAt(fromPortID);
            toPort = (JGoPort)to.getInputPorts().elementAt(toPortID);
            ((CollapsedLink)blink).addRepresentedLink(fromPort, toPort, link.isOrthog);
            BaseLink innerLink = doc.newLink(fromPort, toPort, true);
            innerLink.setOrthogonal(link.isOrthog);
            WorksheetDocument.storeForRemoval((JGoObject)innerLink);
        }
        return blink;
    }

    public static BaseLink buildLinkFromXML(Element link, WorksheetDocument doc) {
        BaseLink blink = null;
        boolean canCreate = false;
        int fromNodeID = Integer.parseInt(link.getAttribute(XTNetwork.FROM_NODE_ATTRIBUTE_TAG));
        int fromPortID = Integer.parseInt(link.getAttribute(XTNetwork.FROM_PORT_ATTRIBUTE_TAG));
        int toNodeID = Integer.parseInt(link.getAttribute(XTNetwork.TO_NODE_ATTRIBUTE_TAG));
        int toPortID = Integer.parseInt(link.getAttribute(XTNetwork.TO_PORT_ATTRIBUTE_TAG));
        BaseNodeArea from = doc.findNodeByID(fromNodeID);
        BaseNodeArea to = doc.findNodeByID(toNodeID);
        if (from == null && to == null) {
            to = doc.findFlatNodeByID(toNodeID);
            from = doc.findFlatNodeByID(toNodeID);
        }
        boolean bl = canCreate = from != null && to != null && from.getOutputPorts() != null && to.getInputPorts() != null && from.getOutputPorts().size() != 0 && to.getInputPorts().size() != 0;
        if (!canCreate) {
            return null;
        }
        JGoPort fromPort = (JGoPort)from.getOutputPorts().elementAt(fromPortID);
        JGoPort toPort = (JGoPort)to.getInputPorts().elementAt(toPortID);
        blink = doc.newCollapsedLink(new CollapsedLink(fromPort, toPort));
        NodeList linkHistoryList = link.getChildNodes();
        for (int i = linkHistoryList.getLength() - 1; i >= 0; --i) {
            Element linkHistory = (Element)linkHistoryList.item(i);
            fromNodeID = Integer.parseInt(linkHistory.getAttribute(XTNetwork.FROM_NODE_ATTRIBUTE_TAG));
            fromPortID = Integer.parseInt(linkHistory.getAttribute(XTNetwork.FROM_PORT_ATTRIBUTE_TAG));
            toNodeID = Integer.parseInt(linkHistory.getAttribute(XTNetwork.TO_NODE_ATTRIBUTE_TAG));
            toPortID = Integer.parseInt(linkHistory.getAttribute(XTNetwork.TO_PORT_ATTRIBUTE_TAG));
            to = doc.findFlatNodeByID(toNodeID);
            from = doc.findFlatNodeByID(fromNodeID);
            if (to == null || from == null) continue;
            fromPort = (JGoPort)from.getOutputPorts().elementAt(fromPortID);
            toPort = (JGoPort)to.getInputPorts().elementAt(toPortID);
            ((CollapsedLink)blink).addRepresentedLink(fromPort, toPort, doc.isOrthogonalFlows());
            WorksheetDocument.storeForRemoval((JGoObject)doc.newLink(fromPort, toPort, true));
        }
        return blink;
    }

    public boolean shouldLinksBeCombined(CollapsedLink test) {
        int fromID = super.getFromNode().getID();
        int toID = super.getToNode().getID();
        int testFromID = test.getFromNode().getID();
        int testToID = test.getToNode().getID();
        if (fromID == testFromID && toID == testToID && (this.getFromPort() != test.getFromPort() || this.getToPort() != test.getToPort())) {
            testToID = 0;
        }
        return this.getFromPort() == test.getFromPort() && this.getToPort() == test.getToPort();
    }

    public int getNumLinksRepresented() {
        return this.fromPortsRepresented.size();
    }

    public JGoPort getOriginalFromPortAt(int position) {
        if (position >= this.fromPortsRepresented.size()) {
            return null;
        }
        return (JGoPort)this.fromPortsRepresented.get(position);
    }

    public int getOriginalFromPortIndexAt(int position) {
        if (position >= this.fromPortsRepresented.size()) {
            return -1;
        }
        return this.getOriginalFromNodeAt(position).getOutputPorts().indexOf(this.getOriginalFromPortAt(position));
    }

    public BaseNodeArea getOriginalFromNodeAt(int position) {
        if (position >= this.fromPortsRepresented.size()) {
            return null;
        }
        return (BaseNodeArea)((JGoPort)this.fromPortsRepresented.get(position)).getParent();
    }

    public JGoPort getOriginalToPortAt(int position) {
        if (position >= this.toPortsRepresented.size()) {
            return null;
        }
        return (JGoPort)this.toPortsRepresented.get(position);
    }

    public int getOriginalToPortIndexAt(int position) {
        if (position >= this.toPortsRepresented.size()) {
            return -1;
        }
        return this.getOriginalToNodeAt(position).getInputPorts().indexOf(this.getOriginalToPortAt(position));
    }

    public BaseNodeArea getOriginalToNodeAt(int position) {
        if (position >= this.toPortsRepresented.size()) {
            return null;
        }
        return (BaseNodeArea)((JGoPort)this.toPortsRepresented.get(position)).getParent();
    }

    public boolean getOrthogonalAt(int position) {
        if (position >= this.orthogRepresented.size()) {
            return false;
        }
        return (Boolean)this.orthogRepresented.get(position);
    }

    public void ownerChange(Object oldOwner, Object newOwner) {
        ActivityNodeModel fromModel = null;
        ActivityNodeModel toModel = null;
        if (oldOwner != null && newOwner == null) {
            WorksheetDocument doc = (WorksheetDocument)((Object)oldOwner);
            if (doc.isCollapsing()) {
                return;
            }
            doc.setEngineNetworkDirty();
            for (int i = this.fromPortsRepresented.size() - 1; i >= 0; --i) {
                toModel = ((ActivityNodeArea)this.getOriginalToNodeAt(i)).getNodeModel();
                fromModel = ((ActivityNodeArea)this.getOriginalFromNodeAt(i)).getNodeModel();
                fromModel.removeChangeListener(toModel);
                toModel.removeParentModel(fromModel);
                toModel.getState().changeState(toModel);
                if (toModel.getNumInputs() != -1 || toModel.getState() != ActivityNodeComputed.instance()) continue;
                toModel.setState(ActivityNodeConfigured.instance());
            }
        } else if (oldOwner == null && newOwner != null) {
            WorksheetDocument doc = (WorksheetDocument)((Object)newOwner);
            if (doc.isCollapsing()) {
                return;
            }
            doc.setEngineNetworkDirty();
            for (int i = this.fromPortsRepresented.size() - 1; i >= 0; --i) {
                toModel = ((ActivityNodeArea)this.getOriginalToNodeAt(i)).getNodeModel();
                fromModel = ((ActivityNodeArea)this.getOriginalFromNodeAt(i)).getNodeModel();
                fromModel.addChangeListener(toModel);
                toModel.addParentModel(fromModel);
                toModel.getState().changeState(toModel);
            }
        }
        super.ownerChange(oldOwner, newOwner);
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        CollapsedLink obj = (CollapsedLink)super.copyObject(env);
        obj.fromPortsRepresented.removeAllElements();
        obj.toPortsRepresented.removeAllElements();
        obj.orthogRepresented.removeAllElements();
        for (int i = this.fromPortsRepresented.size() - 1; i >= 0; --i) {
            BaseNodeArea fromArea = (BaseNodeArea)env.get((Object)this.getOriginalFromNodeAt(i));
            BaseNodeArea toArea = (BaseNodeArea)env.get((Object)this.getOriginalToNodeAt(i));
            JGoPort fromPort = (JGoPort)env.get((Object)this.getOriginalFromPortAt(i));
            JGoPort toPort = (JGoPort)env.get((Object)this.getOriginalToPortAt(i));
            obj.addRepresentedLink(fromPort, toPort, this.getOrthogonalAt(i));
            ActivityNodeModel toModel = ((ActivityNodeArea)toArea).getNodeModel();
            ActivityNodeModel fromModel = ((ActivityNodeArea)fromArea).getNodeModel();
            fromModel.addChangeListener(toModel);
            toModel.addParentModel(fromModel);
            toModel.getState().changeState(toModel);
        }
        return obj;
    }

    public String toString() {
        String physical = "Physical link (" + this.getFromNode().getID() + ", " + this.getToNode().getID() + ")\n";
        String represented = "Represented links ";
        for (int i = this.getNumLinksRepresented() - 1; i >= 0; --i) {
            represented = represented + "(" + this.getOriginalFromNodeAt(i).getID() + ", " + this.getOriginalToNodeAt(i).getID() + ") ";
        }
        return physical + represented;
    }
}

