/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.AppAction;
import com.insightful.miner.BaseLink;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.BaseNodePort;
import com.insightful.miner.CollapsedLink;
import com.insightful.miner.CollapsedNodeArea;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerTextNode;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.PMMLExportable;
import com.insightful.miner.PMMLImportable;
import com.insightful.miner.PredictorLink;
import com.insightful.miner.WideFileChooser;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.WorksheetView;
import com.insightful.miner.XTNetwork;
import com.insightful.splus.SplusSystem;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoObjectSimpleCollection;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoSelection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CollapsedNodeDialog
extends JDialog
implements WindowFocusListener {
    private static CollapsedNodeView g_view = null;
    private static Vector g_cNodes = new Vector();
    private static Vector g_cDialogs = new Vector();
    private CollapsedNodeView m_view = null;
    private CollapsedNodeArea m_area;
    private CollapsedNodeDialog m_parent;
    private CNTableModel m_inputTableModel;
    private CNTableModel m_outputTableModel;
    private RowNumberModel m_inputRNModel;
    private RowNumberModel m_outputRNModel;
    private JList m_inputRNList;
    private JList m_outputRNList;
    private NodeDialog.DialogTable m_inputTable;
    private NodeDialog.DialogTable m_outputTable;
    private JTextField m_helpTextField;
    private JTextField m_largeIconTextField;
    private JTextField m_smallIconTextField;
    private static final int DIALOG_WIDTH = 600;
    private static final int DIALOG_HEIGHT = 450;
    private static final int ROW_HEADER_WIDTH = 50;
    private static final int NAME_COLUMN_WIDTH = 150;
    private static final int PORT_COLUMN_WIDTH = 40;
    private static final int TOOLTIP_COLUMN_WIDTH = 230;

    public CollapsedNodeDialog(CollapsedNodeArea area) {
        this(area, null);
    }

    public CollapsedNodeDialog(CollapsedNodeArea area, CollapsedNodeDialog parent) {
        super((Frame)MinerApp.getMainFrame(), area.getText().replaceAll("\n", "") + " " + MinerApp.getText("CollapsedNodeDialog_properties"));
        this.m_area = area;
        this.m_parent = parent;
        g_cNodes.add(area);
        g_cDialogs.add(this);
        this.init();
        Dimension dim = new Dimension(600, 450);
        this.setSize(dim);
        this.setLocationRelativeTo(MinerApp.getMainFrame());
        this.addWindowFocusListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                CollapsedNodeDialog.this.dispose();
            }
        });
    }

    protected void init() {
        JTabbedPane tabPane = this.createTabPane();
        JPanel buttonsPanel = this.createBottomButtonPanel();
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        container.add((Component)tabPane, gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 5, 0);
        container.add((Component)buttonsPanel, gbc);
    }

    public void dispose() {
        g_cNodes.remove(this.m_area);
        g_cDialogs.remove(this);
        if (g_view == this.m_view) {
            g_view = g_cDialogs.size() > 0 ? ((CollapsedNodeDialog)CollapsedNodeDialog.g_cDialogs.get((int)0)).m_view : null;
        }
        this.m_view.dispose();
        this.m_view = null;
        super.dispose();
        AppAction.updateAllActions();
        this.m_area.addStateVisualCue();
    }

    public void windowGainedFocus(WindowEvent e) {
        g_view = this.m_view;
    }

    public void windowLostFocus(WindowEvent e) {
    }

    public static WorksheetView getView() {
        return g_view;
    }

    public static boolean alreadyViewing(CollapsedNodeArea area) {
        int index = g_cNodes.indexOf(area);
        if (index > -1) {
            ((CollapsedNodeDialog)g_cDialogs.get(index)).requestFocus();
            return true;
        }
        return false;
    }

    protected JPanel createBottomButtonPanel() {
        JButton okButton = new JButton(new AppAction(MinerApp.getText("NodeDialog_ok")){

            public void actionPerformed(ActionEvent e) {
                CollapsedNodeDialog.this.saveResults();
                CollapsedNodeDialog.this.dispose();
            }
        });
        okButton.setMnemonic(MinerApp.getText("NodeDialog_okHotkey").charAt(0));
        AppAction cancelAction = new AppAction(MinerApp.getText("NodeDialog_cancel")){

            public void actionPerformed(ActionEvent e) {
                CollapsedNodeDialog.this.m_area.addStateVisualCue();
                CollapsedNodeDialog.this.dispose();
            }
        };
        JButton cancelButton = new JButton(cancelAction);
        cancelButton.setMnemonic(MinerApp.getText("NodeDialog_cancelHotkey").charAt(0));
        JButton helpButton = new JButton(new AppAction(MinerApp.getText("NodeDialog_help")){

            public void actionPerformed(ActionEvent e) {
                CollapsedNodeDialog.this.m_area.showHelp();
            }
        });
        helpButton.setMnemonic(MinerApp.getText("NodeDialog_helpHotkey").charAt(0));
        Dimension stdDim = cancelButton.getPreferredSize();
        okButton.setPreferredSize(stdDim);
        helpButton.setPreferredSize(stdDim);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(okButton);
        buttonsPanel.add(Box.createHorizontalStrut(5));
        buttonsPanel.add(cancelButton);
        buttonsPanel.add(Box.createHorizontalStrut(5));
        buttonsPanel.add(helpButton);
        cancelButton.registerKeyboardAction(cancelAction, KeyStroke.getKeyStroke("ESCAPE"), 2);
        return buttonsPanel;
    }

    protected JTabbedPane createTabPane() {
        JPanel contentsPanel = this.createContentsPanel();
        JPanel portPanel = this.createPortPanel();
        JPanel appearancePanel = this.createAppearancePanel();
        JTabbedPane tabPane = new JTabbedPane(1);
        tabPane.add(contentsPanel);
        tabPane.add(portPanel);
        tabPane.add(appearancePanel);
        return tabPane;
    }

    protected JPanel createContentsPanel() {
        WorksheetDocument doc = this.m_area.getDoc();
        if (doc == null) {
            doc = new WorksheetDocument(true);
            doc.addObjectAtHead((JGoObject)this.m_area);
        }
        this.m_view = new CollapsedNodeView(new DummyDocument(true, doc, this.m_area), this.m_area);
        if (g_view == null) {
            g_view = this.m_view;
        }
        this.m_view.setBorder(new JTextField().getBorder());
        JPanel contentsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        contentsPanel.add((Component)((Object)this.m_view), gbc);
        contentsPanel.setName(MinerApp.getText("CollapsedNodeDialog_contentsPanel"));
        return contentsPanel;
    }

    private void onBrowseHelp() {
        File test;
        for (test = new File((str = this.m_helpTextField.getText()).length() == 0 ? SplusSystem.getCwd().getAbsolutePath() : str); test != null && !test.exists(); test = test.getParentFile()) {
        }
        WideFileChooser wfc = new WideFileChooser(test.getAbsolutePath());
        wfc.setAcceptAllFileFilterUsed(false);
        CHMFileFilter chmFF = new CHMFileFilter();
        wfc.addChoosableFileFilter(chmFF);
        wfc.addChoosableFileFilter(new HTMLFileFilter());
        wfc.setFileFilter(chmFF);
        int choice = wfc.showOpenDialog(this);
        while (choice == 0) {
            File selFile = wfc.getSelectedFile();
            String fullPath = selFile.getAbsolutePath();
            if (selFile.getName().indexOf(".") == -1) {
                fullPath = wfc.getFileFilter() instanceof CHMFileFilter ? fullPath + ".chm" : fullPath + ".htm";
            }
            if (selFile.exists()) {
                this.m_helpTextField.setText(fullPath);
                return;
            }
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("CollapsedNodeDialog_helpError"));
            choice = wfc.showOpenDialog(this);
        }
    }

    protected JPanel createAppearancePanel() {
        JLabel helpLabel = new JLabel(MinerApp.getText("CollapsedNodeDialog_help"));
        this.m_helpTextField = new JTextField(this.m_area.helpFile == null ? "" : this.m_area.helpFile);
        helpLabel.setDisplayedMnemonic(MinerApp.getText("CollapsedNodeDialog_helpHotkey").charAt(0));
        helpLabel.setLabelFor(this.m_helpTextField);
        JButton browse = new JButton(new AbstractAction(MinerApp.getText("CollapsedNodeDialog_browse")){

            public void actionPerformed(ActionEvent e) {
                CollapsedNodeDialog.this.onBrowseHelp();
            }
        });
        browse.setMnemonic(MinerApp.getText("CollapsedNodeDialog_browseHotkey").charAt(0));
        JLabel largeIconLabel = new JLabel(MinerApp.getText("SplusScriptDialog_largeIcon"));
        this.m_largeIconTextField = new JTextField(this.m_area.largeIcon == null ? "" : this.m_area.largeIcon);
        largeIconLabel.setDisplayedMnemonic(MinerApp.getText("SplusScriptDialog_largeIconHotkey").charAt(0));
        largeIconLabel.setLabelFor(this.m_largeIconTextField);
        JLabel smallIconLabel = new JLabel(MinerApp.getText("SplusScriptDialog_smallIcon"));
        this.m_smallIconTextField = new JTextField(this.m_area.smallIcon == null ? "" : this.m_area.smallIcon);
        smallIconLabel.setDisplayedMnemonic(MinerApp.getText("SplusScriptDialog_smallIconHotkey").charAt(0));
        smallIconLabel.setLabelFor(this.m_smallIconTextField);
        JPanel iconsPanel = new JPanel(new GridBagLayout());
        iconsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("SplusScriptDialog_iconsPanel")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        iconsPanel.add((Component)largeIconLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 15, 0, 0);
        iconsPanel.add((Component)this.m_largeIconTextField, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        iconsPanel.add((Component)smallIconLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 15, 0, 0);
        iconsPanel.add((Component)this.m_smallIconTextField, gbc);
        JPanel helpPanel = new JPanel(new GridBagLayout());
        helpPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("CollapsedNodeDialog_helpPanel")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        helpPanel.add((Component)helpLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 15, 0, 0);
        helpPanel.add((Component)this.m_helpTextField, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        helpPanel.add((Component)browse, gbc);
        JPanel centerPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        centerPanel.add((Component)iconsPanel, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        centerPanel.add((Component)helpPanel, gbc);
        JPanel displayInfoPanel = new JPanel(new BorderLayout());
        displayInfoPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        displayInfoPanel.add((Component)centerPanel, "Center");
        displayInfoPanel.setName(MinerApp.getText("CollapsedNodeDialog_appearancePanel"));
        return displayInfoPanel;
    }

    protected JPanel createPortPanel() {
        this.createTableModels(this.m_area);
        JButton inputUpButton = new JButton(new AppAction(MinerApp.getText("CollapsedNodeDialog_up")){

            public void actionPerformed(ActionEvent e) {
                CollapsedNodeDialog.this.moveRow(true, true);
            }
        });
        inputUpButton.setMnemonic(MinerApp.getText("CollapsedNodeDialog_upHotkey").charAt(0));
        JButton inputDownButton = new JButton(new AppAction(MinerApp.getText("CollapsedNodeDialog_down")){

            public void actionPerformed(ActionEvent e) {
                CollapsedNodeDialog.this.moveRow(true, false);
            }
        });
        inputDownButton.setMnemonic(MinerApp.getText("CollapsedNodeDialog_downHotkey").charAt(0));
        inputUpButton.setPreferredSize(inputDownButton.getPreferredSize());
        JButton outputUpButton = new JButton(new AppAction(MinerApp.getText("CollapsedNodeDialog_up")){

            public void actionPerformed(ActionEvent e) {
                CollapsedNodeDialog.this.moveRow(false, true);
            }
        });
        outputUpButton.setMnemonic(MinerApp.getText("CollapsedNodeDialog_upHotkey2").charAt(0));
        JButton outputDownButton = new JButton(new AppAction(MinerApp.getText("CollapsedNodeDialog_down")){

            public void actionPerformed(ActionEvent e) {
                CollapsedNodeDialog.this.moveRow(false, false);
            }
        });
        outputDownButton.setMnemonic(MinerApp.getText("CollapsedNodeDialog_downHotkey2").charAt(0));
        outputUpButton.setPreferredSize(outputDownButton.getPreferredSize());
        Dimension stdDim = inputDownButton.getPreferredSize();
        inputUpButton.setPreferredSize(stdDim);
        outputUpButton.setPreferredSize(stdDim);
        outputDownButton.setPreferredSize(stdDim);
        JPanel inputPanel = this.createTablePanel(MinerApp.getText("CollapsedNodeDialog_input"), this.m_inputTable, this.m_inputTableModel, this.m_inputRNModel, this.m_inputRNList, inputUpButton, inputDownButton);
        JPanel outputPanel = this.createTablePanel(MinerApp.getText("CollapsedNodeDialog_output"), this.m_outputTable, this.m_outputTableModel, this.m_outputRNModel, this.m_outputRNList, outputUpButton, outputDownButton);
        JPanel portPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weighty = 0.5;
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        portPanel.add((Component)inputPanel, gbc);
        ++gbc.gridy;
        portPanel.add((Component)outputPanel, gbc);
        portPanel.setName(MinerApp.getText("CollapsedNodeDialog_portPanel"));
        return portPanel;
    }

    private void moveRow(boolean input, boolean up) {
        NodeDialog.DialogTable table = null;
        CNTableModel model = null;
        if (input) {
            table = this.m_inputTable;
            model = this.m_inputTableModel;
        } else {
            table = this.m_outputTable;
            model = this.m_outputTableModel;
        }
        int row = table.getSelectedRow();
        if (row < 0 || up && row == 0 || !up && row == table.getRowCount() - 1) {
            return;
        }
        Port rowData = (Port)model.getRow(row);
        int new_row = up ? row - 1 : row + 1;
        model.removeRow(row);
        model.insertRowAt(rowData, new_row);
        table.setRowSelectionInterval(new_row, new_row);
        Rectangle val = table.getVisibleRect();
        val.y = table.getCellRect((int)new_row, (int)table.getSelectedColumn(), (boolean)true).y;
        table.scrollRectToVisible(val);
    }

    private JPanel createTablePanel(String panelTitle, JTable table, CNTableModel model, RowNumberModel rnModel, JList rowNumbers, JButton up, JButton down) {
        rowNumbers.setFixedCellWidth(50);
        rowNumbers.setFixedCellHeight(table.getRowHeight());
        rowNumbers.setCellRenderer(new NodeDialog.RowHeaderRenderer(table));
        rowNumbers.setOpaque(false);
        JScrollPane sp = new JScrollPane(table);
        JButton ulCorner = new JButton();
        ulCorner.setEnabled(false);
        sp.setCorner("UPPER_LEFT_CORNER", ulCorner);
        JButton llCorner = new JButton();
        llCorner.setEnabled(false);
        sp.setCorner("LOWER_LEFT_CORNER", llCorner);
        sp.setRowHeaderView(rowNumbers);
        Insets none = new Insets(3, 3, 3, 3);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(panelTitle), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = none;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weighty = 0.5;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        panel.add((Component)sp, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        panel.add((Component)this.createUpDownPanel(up, down), gbc);
        return panel;
    }

    private JPanel createUpDownPanel(JButton up, JButton down) {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 5, 0);
        buttonsPanel.add((Component)up, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 0, 0, 0);
        buttonsPanel.add((Component)down, gbc);
        return buttonsPanel;
    }

    protected void saveResults() {
        String smallIconName;
        String largeIconName;
        int numInputRows = this.m_inputTableModel.getRowCount();
        int numOutputRows = this.m_outputTableModel.getRowCount();
        Vector inputPorts = this.m_area.getInputPorts();
        inputPorts.removeAllElements();
        for (int row = 0; row < numInputRows; ++row) {
            Port tablePortInfo = (Port)this.m_inputTableModel.getRow(row);
            this.m_area.setPortInfoVisibleFeatures((Object)tablePortInfo.port.getRepresentedPort(), tablePortInfo.visible, tablePortInfo.toolTip);
            inputPorts.add(tablePortInfo.port);
        }
        this.m_area.layoutPorts(true);
        Vector outputPorts = this.m_area.getOutputPorts();
        outputPorts.removeAllElements();
        for (int row = 0; row < numOutputRows; ++row) {
            Port tablePortInfo = (Port)this.m_outputTableModel.getRow(row);
            this.m_area.setPortInfoVisibleFeatures((Object)tablePortInfo.port.getRepresentedPort(), tablePortInfo.visible, tablePortInfo.toolTip);
            outputPorts.add(tablePortInfo.port);
        }
        this.m_area.layoutPorts(false);
        String helpFileLocation = this.m_helpTextField.getText();
        if (helpFileLocation.length() > 0) {
            this.m_area.helpFile = helpFileLocation;
        }
        if ((largeIconName = this.m_largeIconTextField.getText()).length() > 0) {
            this.m_area.largeIcon = largeIconName;
            this.m_area.loadIconImage(this.m_area.getLargeIconName(), false);
        }
        if ((smallIconName = this.m_smallIconTextField.getText()).length() > 0) {
            this.m_area.smallIcon = smallIconName;
        }
    }

    protected void createTableModels(CollapsedNodeArea area) {
        String toolTip;
        String label;
        ActivityNodeArea ana;
        boolean isVisible;
        XTNetwork.PortInfo info;
        BaseNodePort port;
        CollapsedNodeArea.CollapsedNodePort cPort;
        int i;
        this.m_inputTableModel = new CNTableModel();
        this.m_inputTable = new NodeDialog.DialogTable(this.m_inputTableModel);
        this.m_inputTable.setAutoResizeMode(0);
        this.m_inputTable.getTableHeader().setReorderingAllowed(false);
        this.m_inputTable.setRowSelectionAllowed(true);
        this.m_inputTable.setRowHeight(25);
        this.m_outputTableModel = new CNTableModel();
        this.m_outputTable = new NodeDialog.DialogTable(this.m_outputTableModel);
        this.m_outputTable.setAutoResizeMode(0);
        this.m_outputTable.getTableHeader().setReorderingAllowed(false);
        this.m_outputTable.setRowSelectionAllowed(true);
        this.m_outputTable.setRowHeight(25);
        this.m_inputTable.setDefaultRenderer(String.class, new NodeDialog.LeftJustifiedStringRenderer());
        this.m_outputTable.setDefaultRenderer(String.class, new NodeDialog.LeftJustifiedStringRenderer());
        this.m_inputTable.setDefaultRenderer(Integer.class, new NodeDialog.LeftJustifiedStringRenderer());
        this.m_outputTable.setDefaultRenderer(Integer.class, new NodeDialog.LeftJustifiedStringRenderer());
        TableColumnModel inputCM = this.m_inputTable.getColumnModel();
        TableColumnModel outputCM = this.m_outputTable.getColumnModel();
        JCheckBox testWidth = new JCheckBox();
        inputCM.getColumn(0).setCellEditor(new DefaultCellEditor(testWidth));
        inputCM.getColumn(0).setCellRenderer(new BooleanRenderer());
        outputCM.getColumn(0).setCellEditor(new DefaultCellEditor(new JCheckBox()));
        outputCM.getColumn(0).setCellRenderer(new BooleanRenderer());
        inputCM.getColumn(0).setPreferredWidth(testWidth.getPreferredSize().width);
        outputCM.getColumn(0).setPreferredWidth(testWidth.getPreferredSize().width);
        inputCM.getColumn(1).setPreferredWidth(150);
        outputCM.getColumn(1).setPreferredWidth(150);
        inputCM.getColumn(2).setPreferredWidth(40);
        outputCM.getColumn(2).setPreferredWidth(40);
        inputCM.getColumn(3).setPreferredWidth(230);
        outputCM.getColumn(3).setPreferredWidth(230);
        Port rowData = null;
        Vector ports = area.getInputPorts();
        for (i = 0; i < ports.size(); ++i) {
            cPort = (CollapsedNodeArea.CollapsedNodePort)((Object)ports.get(i));
            port = cPort.getRepresentedPort();
            info = area.getPortInfo((Object)port);
            isVisible = area.getPortInfoVisibility((Object)port);
            if (info == null || (ana = area.findNodeByID(Integer.parseInt(info.nodeID))) == null) continue;
            label = ana.getNodeModel().getLabelText();
            toolTip = info.toolTip == null ? cPort.formatToolTip(info.input, label, info.portNum + 1) : info.toolTip;
            rowData = new Port(cPort, label, new Integer(info.portNum + 1), new Boolean(isVisible), toolTip);
            this.m_inputTableModel.addRow(rowData);
        }
        ports = area.getOutputPorts();
        for (i = 0; i < ports.size(); ++i) {
            cPort = (CollapsedNodeArea.CollapsedNodePort)((Object)ports.get(i));
            port = cPort.getRepresentedPort();
            info = area.getPortInfo((Object)port);
            isVisible = area.getPortInfoVisibility((Object)port);
            if (info == null || (ana = area.findNodeByID(Integer.parseInt(info.nodeID))) == null) continue;
            label = ana.getNodeModel().getLabelText();
            toolTip = info.toolTip == null ? cPort.formatToolTip(info.input, label, info.portNum + 1) : info.toolTip;
            rowData = new Port(cPort, label, new Integer(info.portNum + 1), new Boolean(isVisible), toolTip);
            this.m_outputTableModel.addRow(rowData);
        }
        this.m_inputRNModel = new RowNumberModel(this.m_inputTableModel);
        this.m_outputRNModel = new RowNumberModel(this.m_outputTableModel);
        this.m_inputRNList = new JList(this.m_inputRNModel);
        this.m_outputRNList = new JList(this.m_outputRNModel);
    }

    private boolean isExternallyLinked(JGoPort port) {
        CollapsedNodeArea.CollapsedNodePort testPort = null;
        Vector ports = port.isValidDestination() ? this.m_area.getInputPorts() : this.m_area.getOutputPorts();
        for (int i = 0; i < ports.size(); ++i) {
            CollapsedNodeArea.CollapsedNodePort cnp = (CollapsedNodeArea.CollapsedNodePort)((Object)ports.get(i));
            if (cnp.getRepresentedPort() != port) continue;
            testPort = cnp;
            break;
        }
        if (testPort == null) {
            return false;
        }
        JGoListPosition pos = testPort.getFirstLinkPos();
        while (pos != null) {
            JGoLink link = testPort.getLinkAtPos(pos);
            pos = testPort.getNextLinkPos(pos);
            if (this.m_area.links.contains(link)) continue;
            return true;
        }
        if (this.m_parent != null && this.m_parent.m_area.nodes.contains(this.m_area)) {
            return this.m_parent.isExternallyLinked(port);
        }
        return false;
    }

    public class DummyDocument
    extends WorksheetDocument {
        WorksheetDocument m_actualDoc;
        CollapsedNodeArea m_cna;
        boolean m_initializing;

        public DummyDocument(boolean init, WorksheetDocument doc, CollapsedNodeArea cna) {
            super(init);
            this.m_actualDoc = doc;
            this.m_cna = cna;
            this.m_initializing = true;
            this.createUncollapsedDocument();
            this.m_initializing = false;
        }

        public int getNextNodeID() {
            return this.m_actualDoc.getNextNodeID();
        }

        public String getWorksheetID() {
            return this.m_actualDoc.getWorksheetID();
        }

        public void setEngineNetworkDirty() {
            super.setEngineNetworkDirty();
            this.m_actualDoc.setEngineNetworkDirty();
        }

        public void resetEngineNetworkDirty() {
            super.resetEngineNetworkDirty();
            this.m_actualDoc.resetEngineNetworkDirty();
        }

        public void setModified(boolean mod) {
            super.setModified(mod);
            if (this.m_actualDoc != null) {
                this.m_actualDoc.setModified(mod);
            }
        }

        public BaseNodeArea findFlatNodeByID(int id) {
            return this.m_actualDoc.findFlatNodeByID(id);
        }

        public XTNetwork createNetwork() {
            if (!this.isEngineNetworkDirty()) {
                return this.m_actualDoc.createNetwork();
            }
            this.updateCollapsedNodeArea();
            XTNetwork ret = this.m_actualDoc.createNetwork();
            this.createUncollapsedDocument();
            return ret;
        }

        public JGoCopyEnvironment copyFromCollection(JGoObjectSimpleCollection coll, Point offset, JGoCopyEnvironment map) {
            JGoCopyEnvironment env = super.copyFromCollection(coll, offset, map);
            this.setEngineNetworkDirty();
            if (coll instanceof JGoSelection) {
                JGoListPosition pos = coll.getFirstObjectPos();
                while (pos != null) {
                    JGoObject obj = coll.getObjectAtPos(pos);
                    pos = coll.getNextObjectPos(pos);
                    if (!obj.isTopLevel() || !(obj instanceof BaseNodeArea)) continue;
                    g_view.addOrRemoveNodeToCNADialog((BaseNodeArea)env.get((Object)obj), true);
                }
            } else if (coll instanceof BaseNodeArea) {
                g_view.addOrRemoveNodeToCNADialog((BaseNodeArea)env.get((Object)coll), true);
            }
            return env;
        }

        public void updateCollapsedNodeArea() {
            boolean isActualCollapsing = this.m_actualDoc.isCollapsing();
            this.m_actualDoc.setCollapseTransaction(true);
            boolean isCollapsing = this.isCollapsing();
            this.setCollapseTransaction(true);
            this.m_cna.nodes.removeAllElements();
            this.m_cna.links.removeAllElements();
            this.m_cna.textNodes.removeAllElements();
            this.m_cna.modelLinks.removeAllElements();
            JGoListPosition pos = this.getFirstObjectPos();
            while (pos != null) {
                JGoObject obj = this.getObjectAtPos(pos);
                pos = this.getNextObjectPos(pos);
                this.addToArea(obj);
            }
            this.getFirstLayer().removeAll();
            this.setCollapseTransaction(isCollapsing);
            this.m_actualDoc.setCollapseTransaction(isActualCollapsing);
        }

        public void createUncollapsedDocument() {
            boolean isActualCollapsing = this.m_actualDoc.isCollapsing();
            this.m_actualDoc.setCollapseTransaction(true);
            boolean isCollapsing = this.isCollapsing();
            this.setCollapseTransaction(true);
            HashMap<JGoObject, JGoObject> modMap = new HashMap<JGoObject, JGoObject>();
            Vector nodeList = this.m_cna.nodes;
            for (int i = 0; i < nodeList.size(); ++i) {
                JGoObject obj = (JGoObject)nodeList.get(i);
                this.addObjectAtTail(obj);
                if (obj instanceof ActivityNodeArea) {
                    ActivityNodeModel anm = ((ActivityNodeArea)obj).getNodeModel();
                    if (anm instanceof PMMLImportable || anm instanceof PMMLExportable) {
                        modMap.put(obj, obj);
                    }
                    anm.setDocument(this);
                    continue;
                }
                ((CollapsedNodeArea)obj).setDocument(this);
            }
            Vector textList = this.m_cna.textNodes;
            for (int i = 0; i < textList.size(); ++i) {
                JGoObject obj = (JGoObject)textList.get(i);
                this.addObjectAtTail(obj);
            }
            Vector linkList = this.m_cna.links;
            for (int i = 0; i < linkList.size(); ++i) {
                BaseLink l;
                Object obj = (JGoLink)linkList.get(i);
                if (obj instanceof BaseLink) {
                    l = this.newLink(obj.getFromPort(), obj.getToPort(), true);
                    l.setOrthogonal(obj.isOrthogonal());
                    obj = l;
                } else if (obj instanceof CollapsedLink) {
                    l = this.newCollapsedLink((CollapsedLink)((Object)obj));
                    l.setOrthogonal(obj.isOrthogonal());
                    obj = l;
                }
                this.addObjectAtHead((JGoObject)obj);
                linkList.set(i, obj);
            }
            Vector modelLinkList = this.m_cna.modelLinks;
            for (int i = 0; i < modelLinkList.size(); ++i) {
                PredictorLink p1 = (PredictorLink)((Object)modelLinkList.get(i));
                boolean isInvisible = modMap.get(p1.getToNode()) == null || modMap.get(p1.getFromNode()) == null;
                PredictorLink p2 = PredictorLink.newPredictionLink(p1.getFromNode().getID(), p1.getToNode().getID(), this);
                p2.setVisible(!isInvisible);
                p2.setOrthogonal(p1.isOrthogonal());
                this.addObjectAtHead((JGoObject)p2);
                modelLinkList.set(i, p2);
            }
            this.setCollapseTransaction(isCollapsing);
            this.m_actualDoc.setCollapseTransaction(isActualCollapsing);
        }

        private void addToArea(JGoObject obj) {
            if (this.m_initializing) {
                return;
            }
            obj.setVisible(true);
            if (obj instanceof BaseNodeArea) {
                this.m_cna.addNode((BaseNodeArea)obj);
                if (obj instanceof ActivityNodeArea) {
                    ((ActivityNodeArea)obj).getNodeModel().setDocument(this.m_actualDoc);
                } else if (obj instanceof CollapsedNodeArea) {
                    ((CollapsedNodeArea)obj).setDocument(this.m_actualDoc);
                }
            } else if (obj instanceof MinerTextNode) {
                this.m_cna.textNodes.add(obj);
            } else if (obj instanceof PredictorLink) {
                this.m_cna.addPredictorLink((PredictorLink)obj);
            } else if (obj instanceof BaseLink) {
                this.m_cna.addInternalLink((JGoLink)((BaseLink)obj));
            }
        }
    }

    private class CollapsedNodeView
    extends WorksheetView {
        private WorksheetDocument m_actualDoc;
        private DummyDocument m_dummyDoc;
        private CollapsedNodeArea m_area;

        public CollapsedNodeView(DummyDocument doc, CollapsedNodeArea area) {
            super(doc);
            this.m_area = area;
            this.m_dummyDoc = doc;
            this.m_actualDoc = area.getDoc();
            Rectangle rect = null;
            JGoListPosition pos = this.m_dummyDoc.getFirstObjectPos();
            while (pos != null) {
                JGoObject obj = this.m_dummyDoc.getObjectAtPos(pos);
                pos = this.m_dummyDoc.getNextObjectPos(pos);
                if (!obj.isTopLevel()) continue;
                if (rect == null) {
                    rect = new Rectangle(obj.getBoundingRect());
                    continue;
                }
                if (!obj.isTopLevel()) continue;
                Rectangle tRect = obj.getBoundingRect();
                int tBotLeftX = tRect.x + tRect.width;
                int tBotLeftY = tRect.y + tRect.height;
                if (rect.x > tRect.x) {
                    rect.x = tRect.x;
                }
                if (rect.y > tRect.y) {
                    rect.y = tRect.y;
                }
                rect.width = tBotLeftX - rect.x;
                rect.height = tBotLeftY - rect.y;
            }
            if (rect != null) {
                this.scrollRectToVisible(rect);
            }
        }

        public void dispose() {
            this.m_dummyDoc.updateCollapsedNodeArea();
        }

        void editCollapsed(CollapsedNodeArea cnode) {
            if (CollapsedNodeDialog.alreadyViewing(cnode)) {
                return;
            }
            CollapsedNodeDialog dialog = new CollapsedNodeDialog(cnode, CollapsedNodeDialog.this);
            dialog.show();
        }

        public void onKeyEvent(KeyEvent evt) {
            Vector<BaseNodeArea> cannotDeleteList = new Vector<BaseNodeArea>();
            if (evt.getKeyCode() == 127) {
                BaseNodeArea bna;
                JGoSelection sel = this.getSelection();
                JGoListPosition pos = sel.getFirstObjectPos();
                while (pos != null) {
                    JGoObject obj = sel.getObjectAtPos(pos);
                    pos = sel.getNextObjectPos(pos);
                    if (!obj.isTopLevel() || !(obj instanceof BaseNodeArea)) continue;
                    bna = (BaseNodeArea)obj;
                    for (int o = 0; o < 2; ++o) {
                        Vector ports = o == 0 ? bna.getInputPorts() : bna.getOutputPorts();
                        for (int i = 0; i < ports.size(); ++i) {
                            XTNetwork.PortInfo pi;
                            BaseNodePort port = (BaseNodePort)((Object)ports.get(i));
                            if (port instanceof CollapsedNodeArea.CollapsedNodePort) {
                                port = ((CollapsedNodeArea.CollapsedNodePort)port).getRepresentedPort();
                            }
                            if (this.m_area.portInfo.get((Object)port) == null || (pi = this.m_area.getPortInfo((Object)port)) == null || !CollapsedNodeDialog.this.isExternallyLinked(port)) continue;
                            cannotDeleteList.add(bna);
                        }
                    }
                }
                for (int i = 0; i < cannotDeleteList.size(); ++i) {
                    JGoObject obj = (JGoObject)cannotDeleteList.get(i);
                    sel.toggleSelection(obj);
                }
                pos = sel.getFirstObjectPos();
                while (pos != null) {
                    JGoObject obj = sel.getObjectAtPos(pos);
                    pos = sel.getNextObjectPos(pos);
                    if (!obj.isTopLevel() || !(obj instanceof BaseNodeArea)) continue;
                    bna = (BaseNodeArea)obj;
                    this.addOrRemoveNodeToCNADialog(bna, false);
                }
            }
            super.onKeyEvent(evt);
            if (cannotDeleteList.size() > 0) {
                AcceleratorOptionPane.showOKDialog(CollapsedNodeDialog.this, "Cannot delete externally linked nodes");
            }
            AppAction.updateAllActions();
            this.repaint();
        }

        public boolean doMouseUp(int modifiers, Point dc, Point vc) {
            boolean ret = super.doMouseUp(modifiers, dc, vc);
            AppAction.updateAllActions();
            return ret;
        }

        public boolean doMouseDown(int modifiers, Point dc, Point vc) {
            boolean ret = super.doMouseDown(modifiers, dc, vc);
            AppAction.updateAllActions();
            return ret;
        }

        public boolean doMouseClick(int modifiers, Point dc, Point vc) {
            boolean ret = super.doMouseClick(modifiers, dc, vc);
            AppAction.updateAllActions();
            return ret;
        }

        protected void addObjectToDoc(JGoObject object, JGoDocument doc, boolean head) {
            super.addObjectToDoc(object, doc, head);
            this.m_dummyDoc.setEngineNetworkDirty();
            if (object instanceof BaseNodeArea) {
                this.addOrRemoveNodeToCNADialog((ActivityNodeArea)object, true);
            }
        }

        public void newLink(JGoPort from, JGoPort to) {
            super.newLink(from, to);
            this.m_dummyDoc.setEngineNetworkDirty();
        }

        private void addOrRemoveNodeToCNADialog(BaseNodeArea area, boolean add) {
            BaseNodePort port;
            int i;
            Iterator iter = this.m_area.portInfo.values().iterator();
            int inputPorts = 0;
            int outputPorts = 0;
            while (iter.hasNext()) {
                XTNetwork.PortInfo pi = (XTNetwork.PortInfo)iter.next();
                if (pi.input) {
                    ++inputPorts;
                    continue;
                }
                ++outputPorts;
            }
            String areaID = Integer.toString(area.getID());
            String label = area instanceof ActivityNodeArea ? ((ActivityNodeArea)area).getNodeModel().getLabelText() : ((CollapsedNodeArea)area).getText().replaceAll("\n", "");
            for (i = 0; i < area.getInputPorts().size(); ++i) {
                port = (BaseNodePort)((Object)area.getInputPorts().get(i));
                if (port instanceof CollapsedNodeArea.CollapsedNodePort) {
                    port = ((CollapsedNodeArea.CollapsedNodePort)port).getRepresentedPort();
                }
                if (add) {
                    this.addPort(port, inputPorts++, areaID, label, i);
                    continue;
                }
                this.removePort(port);
            }
            for (i = 0; i < area.getOutputPorts().size(); ++i) {
                port = (BaseNodePort)((Object)area.getOutputPorts().get(i));
                if (port instanceof CollapsedNodeArea.CollapsedNodePort) {
                    port = ((CollapsedNodeArea.CollapsedNodePort)port).getRepresentedPort();
                }
                if (add) {
                    this.addPort(port, outputPorts++, areaID, label, i);
                    continue;
                }
                this.removePort(port);
            }
            if (add) {
                this.m_area.addNode(area);
                if (area instanceof ActivityNodeArea) {
                    ((ActivityNodeArea)area).getNodeModel().addChangeListener(this.m_area);
                } else if (area instanceof CollapsedNodeArea) {
                    ((CollapsedNodeArea)area).addChangeListener(this.m_area);
                }
                CollapsedNodeDialog.this.saveResults();
            } else {
                this.m_area.nodes.remove(area);
            }
        }

        private void addPort(BaseNodePort bnp, int portNum, String ID, String label, int origPortNum) {
            boolean input = bnp.isInput();
            Vector portList = input ? this.m_area.getInputPorts() : this.m_area.getOutputPorts();
            CNTableModel model = input ? CollapsedNodeDialog.this.m_inputTableModel : CollapsedNodeDialog.this.m_outputTableModel;
            JList list = input ? CollapsedNodeDialog.this.m_inputRNList : CollapsedNodeDialog.this.m_outputRNList;
            CollapsedNodeArea.CollapsedNodePort cPort = new CollapsedNodeArea.CollapsedNodePort(bnp, this.m_area);
            this.m_area.addCollapsedPort(bnp, input, false, ID, null, origPortNum);
            portList.add(cPort);
            XTNetwork.PortInfo info = this.m_area.getPortInfo((Object)bnp);
            String toolTip = info.toolTip == null ? cPort.formatToolTip(info.input, label, origPortNum + 1) : info.toolTip;
            Port rowData = new Port(cPort, label, new Integer(origPortNum + 1), new Boolean(true), toolTip);
            model.addRow(rowData);
            model.fireTableChanged(new TableModelEvent(model));
            list.updateUI();
        }

        private void removePort(BaseNodePort bnp) {
            if (this.m_area.portInfo.get((Object)bnp) == null) {
                return;
            }
            XTNetwork.PortInfo pi = this.m_area.getPortInfo((Object)bnp);
            if (pi != null) {
                boolean input = bnp.isInput();
                Vector portList = input ? this.m_area.getInputPorts() : this.m_area.getOutputPorts();
                CNTableModel model = input ? CollapsedNodeDialog.this.m_inputTableModel : CollapsedNodeDialog.this.m_outputTableModel;
                NodeDialog.DialogTable table = input ? CollapsedNodeDialog.this.m_inputTable : CollapsedNodeDialog.this.m_outputTable;
                this.m_area.portInfo.remove((Object)bnp);
                for (int i = 0; i < portList.size(); ++i) {
                    CollapsedNodeArea.CollapsedNodePort cnp = (CollapsedNodeArea.CollapsedNodePort)((Object)portList.get(i));
                    if (cnp.getRepresentedPort() != bnp) continue;
                    portList.remove(i);
                    model.removeRow(i);
                    JGoListPosition pos = this.m_area.findObject((JGoObject)cnp);
                    if (pos == null) break;
                    this.m_area.removeObject((JGoObject)cnp);
                    this.m_area.layoutPorts(input);
                    break;
                }
                model.fireTableChanged(new TableModelEvent(model));
                table.updateUI();
            }
        }
    }

    private class BooleanRenderer
    implements TableCellRenderer {
        private JCheckBox rend = new JCheckBox();

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null || !(value instanceof Boolean)) {
                return null;
            }
            this.rend.setSelected((Boolean)value);
            this.rend.setHorizontalAlignment(0);
            this.rend.setEnabled(table.getModel().isCellEditable(row, column));
            return this.rend;
        }
    }

    private class CNTableModel
    implements TableModel {
        private String[] tableColumnNames = new String[]{" ", MinerApp.getText("CollapsedNodeDialog_nodeName"), MinerApp.getText("CollapsedNodeDialog_port"), MinerApp.getText("CollapsedNodeDialog_toolTip")};
        private Vector rowData = new Vector();
        private Vector listeners = new Vector();

        private CNTableModel() {
        }

        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Integer.class;
                }
                case 3: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public int getColumnCount() {
            return this.tableColumnNames.length;
        }

        public String getColumnName(int col) {
            return this.tableColumnNames[col];
        }

        public int getRowCount() {
            return this.rowData.size();
        }

        public Object getRow(int row) {
            return this.rowData.get(row);
        }

        public void setValueAt(Object aValue, int row, int column) {
            Port port = (Port)this.rowData.elementAt(row);
            switch (column) {
                case 0: {
                    port.visible = (Boolean)aValue;
                    break;
                }
                case 1: {
                    port.labelText = (String)aValue;
                    break;
                }
                case 2: {
                    port.portNum = (Integer)aValue;
                    break;
                }
                case 3: {
                    port.toolTip = (String)aValue;
                }
            }
        }

        public Object getValueAt(int row, int column) {
            Port port = (Port)this.rowData.elementAt(row);
            switch (column) {
                case 0: {
                    return port.visible;
                }
                case 1: {
                    return port.labelText;
                }
                case 2: {
                    return port.portNum;
                }
                case 3: {
                    return port.toolTip;
                }
            }
            return null;
        }

        public void addRow(Port row) {
            this.rowData.add(row);
            this.fireTableChanged(new TableModelEvent(this));
        }

        public void insertRowAt(Port row, int rowNum) {
            this.rowData.insertElementAt(row, rowNum);
            this.fireTableChanged(new TableModelEvent(this));
        }

        public void removeRow(int row) {
            this.rowData.remove(row);
            this.fireTableChanged(new TableModelEvent(this));
        }

        public void clearTable() {
            this.rowData.removeAllElements();
            this.fireTableChanged(new TableModelEvent(this));
        }

        public boolean isCellEditable(int row, int col) {
            if (col == 3) {
                return true;
            }
            Port port = (Port)this.rowData.get(row);
            return !CollapsedNodeDialog.this.isExternallyLinked(port.port.getRepresentedPort());
        }

        public void fireTableChanged(TableModelEvent e) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((TableModelListener)this.listeners.get(i)).tableChanged(e);
            }
        }
    }

    private class RowNumberModel
    extends AbstractListModel {
        private CNTableModel m_model;

        public RowNumberModel(CNTableModel model) {
            this.m_model = model;
        }

        public int getSize() {
            return this.m_model.getRowCount();
        }

        public Object getElementAt(int index) {
            return "" + (index + 1);
        }
    }

    private class Port {
        public Integer portNum;
        public String labelText;
        public Boolean visible;
        public String toolTip;
        public CollapsedNodeArea.CollapsedNodePort port;

        public Port(CollapsedNodeArea.CollapsedNodePort pt, String l, Integer p, Boolean v, String t) {
            this.portNum = p;
            this.labelText = l;
            this.port = pt;
            this.visible = v;
            this.toolTip = t;
        }
    }

    private class HTMLFileFilter
    extends FileFilter {
        public static final String FILTER_DESCRIPTION = "HTML Files (*.htm*)";
        public static final String FILTER_EXTENSION = ".htm";

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().indexOf(FILTER_EXTENSION) > 0;
        }

        public String getDescription() {
            return FILTER_DESCRIPTION;
        }
    }

    private class CHMFileFilter
    extends FileFilter {
        public static final String FILTER_DESCRIPTION = "CHM Files (*.chm)";
        public static final String FILTER_EXTENSION = ".chm";

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(FILTER_EXTENSION);
        }

        public String getDescription() {
            return FILTER_DESCRIPTION;
        }
    }
}

