/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import com.insightful.miner.XMLTree;
import com.insightful.miner.comments.InvalidXMLCommentException;
import com.insightful.miner.comments.XMLCommentEditor;
import com.insightful.miner.comments.XMLCommentEditorFactory;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class CommentUtilities {
    public static final String COMMENTS_XSL_FILE = XMLTree.XSL_DIRECTORY + "CommentsStylesheet.xsl";
    public static final String COMPONENT_COMMENTS_NODE_TAG = "ComponentComments";
    public static final String AUTHOR_COMMENTS_NODE_TAG = "AuthorComments";
    public static final String AUTHOR_NAME_NODE_TAG = "AuthorName";
    public static final String AUTHOR_TITLE_NODE_TAG = "AuthorCommentTitle";
    public static final String AUTHOR_DATE_NODE_TAG = "AuthorCommentDateCreated";
    public static final String AUTHOR_TEXT_NODE_TAG = "AuthorCommentText";
    public static final String DISCUSSION_COMMENTS_NODE_TAG = "DiscussionComments";
    public static final String COMMENT_NODE_TAG = "Comment";
    public static final String COMMENT_AUTHOR_NODE_TAG = "CommentAuthor";
    public static final String COMMENT_DATE_NODE_TAG = "CommentDateCreated";
    public static final String COMMENT_TITLE_NODE_TAG = "CommentTitle";
    public static final String COMMENT_TEXT_NODE_TAG = "CommentText";
    public static final String NOT_PROVIDED_TAG = "Not Provided";
    private static XMLCommentEditorFactory g_editorFactory = null;

    public static Element editComments(Element commentsElement, String componentName) throws InvalidXMLCommentException {
        int resultValue;
        if (g_editorFactory == null) {
            g_editorFactory = new XMLCommentEditorFactory(new File(COMMENTS_XSL_FILE));
        }
        XMLCommentEditor editor = g_editorFactory.createXMLCommentEditor(XMLCommentEditorFactory.SIMPLE_XML_COMMENT_EDITOR);
        editor.setUserName(MinerApp.getUserName());
        editor.setComponentName(componentName);
        if (commentsElement != null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.newDocument();
                Element el = (Element)document.importNode(commentsElement, true);
                document.appendChild(el);
                editor.setCommentElement(el);
            }
            catch (Exception e) {
                editor.setCommentElement(commentsElement);
            }
        }
        if ((resultValue = editor.showEditorDialog(MinerApp.getMainFrame(), "Comment Editor")) == 2) {
            commentsElement = editor.getCommentElement();
        }
        return commentsElement;
    }

    public static Element createNewComments(Document document, String user, String time) {
        if (document == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                document = builder.newDocument();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        Element compComment = document.createElement(COMPONENT_COMMENTS_NODE_TAG);
        Element authComment = document.createElement(AUTHOR_COMMENTS_NODE_TAG);
        Element authorChild = document.createElement(AUTHOR_NAME_NODE_TAG);
        Text text = document.createTextNode(user);
        authorChild.appendChild(text);
        authComment.appendChild(authorChild);
        authorChild = document.createElement(AUTHOR_TITLE_NODE_TAG);
        text = document.createTextNode(NOT_PROVIDED_TAG);
        authorChild.appendChild(text);
        authComment.appendChild(authorChild);
        authorChild = document.createElement(AUTHOR_DATE_NODE_TAG);
        text = document.createTextNode(time);
        authorChild.appendChild(text);
        authComment.appendChild(authorChild);
        authorChild = document.createElement(AUTHOR_TEXT_NODE_TAG);
        text = document.createTextNode(NOT_PROVIDED_TAG);
        authorChild.appendChild(text);
        authComment.appendChild(authorChild);
        Element discComment = document.createElement(DISCUSSION_COMMENTS_NODE_TAG);
        Element comment = document.createElement(COMMENT_NODE_TAG);
        Element commentChild = document.createElement(COMMENT_AUTHOR_NODE_TAG);
        text = document.createTextNode(NOT_PROVIDED_TAG);
        commentChild.appendChild(text);
        comment.appendChild(commentChild);
        commentChild = document.createElement(COMMENT_DATE_NODE_TAG);
        text = document.createTextNode(NOT_PROVIDED_TAG);
        commentChild.appendChild(text);
        comment.appendChild(commentChild);
        commentChild = document.createElement(COMMENT_TITLE_NODE_TAG);
        text = document.createTextNode(NOT_PROVIDED_TAG);
        commentChild.appendChild(text);
        comment.appendChild(commentChild);
        commentChild = document.createElement(COMMENT_TEXT_NODE_TAG);
        text = document.createTextNode(NOT_PROVIDED_TAG);
        commentChild.appendChild(text);
        comment.appendChild(commentChild);
        discComment.appendChild(comment);
        compComment.appendChild(authComment);
        compComment.appendChild(discComment);
        return compComment;
    }

    public static final Element getChildCommentsElement(Element elt) {
        Element result = null;
        NodeList nodes = elt.getElementsByTagName(COMPONENT_COMMENTS_NODE_TAG);
        if (nodes != null) {
            result = (Element)nodes.item(0);
        }
        return result;
    }
}

