/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.AppAction;
import com.insightful.miner.FixedFormatDictionary;
import com.insightful.miner.MinerApp;
import com.insightful.miner.ModifyColumnsPanel;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.WideFileChooser;
import com.insightful.miner.XTMetaData;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.util.FileUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class CreateDictionaryDialog
extends JDialog {
    public boolean success = false;
    public String filename = "";
    private FFTableModel tableModel;
    private NodeDialog.DialogTable table;
    private NodeDialog.TableSorter sortingModel;
    private JScrollPane scrollingTable;
    private static final String[] typeStrings = new String[]{XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG, XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG, XTMetaData.STRING_TYPE_ATTRIBUTE_TAG, XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG};
    private static final String[] roleStrings = new String[]{XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG, XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG};

    public CreateDictionaryDialog(JDialog dialog, String initialFilename) {
        super(dialog, MinerApp.getText("ReadFixedFormatFileDialog_createEditDictionary"), true);
        File file;
        this.filename = initialFilename;
        int rowHeight = 25;
        int rowWidth = 79;
        int iconWidth = 75;
        this.tableModel = new FFTableModel();
        Object[] ids = new Object[]{MinerApp.getText("CreateDictionaryDialog_name"), MinerApp.getText("CreateDictionaryDialog_type"), MinerApp.getText("CreateDictionaryDialog_role"), MinerApp.getText("CreateDictionaryDialog_start"), MinerApp.getText("CreateDictionaryDialog_width"), MinerApp.getText("CreateDictionaryDialog_decimals")};
        this.tableModel.setColumnIdentifiers(ids);
        JComboBox<String> typeCB = new JComboBox<String>(typeStrings);
        JComboBox<String> roleCB = new JComboBox<String>(roleStrings);
        this.sortingModel = new NodeDialog.TableSorter(this.tableModel);
        this.table = new NodeDialog.DialogTable(this.sortingModel);
        this.sortingModel.addMouseListenerToHeaderInTable(this.table);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setAutoResizeMode(0);
        this.table.setRowHeight(rowHeight);
        this.table.setFocusTraversalKeysEnabled(true);
        int columnCount = this.tableModel.getColumnCount();
        JTextField integerEditor = new JTextField();
        integerEditor.setDocument(new NodeDialog.InputIntegerDoc());
        for (int i = 0; i < columnCount; ++i) {
            TableColumn column = this.table.getColumn(this.table.getColumnName(i));
            column.setPreferredWidth(iconWidth);
            if (i == 1 || i == 2) {
                column.setCellRenderer(new IconCellRenderer());
                JComboBox<String> comboBox = i == 1 ? typeCB : roleCB;
                column.setCellEditor(new DefaultCellEditor(comboBox));
                continue;
            }
            if (i <= 2) continue;
            column.setCellEditor(new DefaultCellEditor(integerEditor));
        }
        this.table.getColumn(this.table.getColumnName(1)).setPreferredWidth(rowWidth);
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    int col = CreateDictionaryDialog.this.table.getSelectedColumn();
                    int row = CreateDictionaryDialog.this.table.getSelectedRow();
                    if (col != CreateDictionaryDialog.this.table.getEditingColumn() || row != CreateDictionaryDialog.this.table.getEditingRow()) {
                        CreateDictionaryDialog.this.table.editCellAt(row, col, new EventObject(CreateDictionaryDialog.this.table));
                        CreateDictionaryDialog.this.table.getEditorComponent().requestFocusInWindow();
                        CreateDictionaryDialog.this.table.updateUI();
                        e.consume();
                    }
                }
            }
        });
        JScrollPane scrollingTable = new JScrollPane(this.table);
        scrollingTable.setPreferredSize(new Dimension(400, 150));
        final TextFileFilter tff = new TextFileFilter();
        final CSVFileFilter cff = new CSVFileFilter();
        final XMLFileFilter xff = new XMLFileFilter();
        JButton save = new JButton(new AbstractAction(MinerApp.getText("CreateDictionaryDialog_save")){

            public void actionPerformed(ActionEvent e) {
                File file;
                if (CreateDictionaryDialog.this.table.getRowCount() == 0) {
                    return;
                }
                if (CreateDictionaryDialog.this.table.isEditing()) {
                    CreateDictionaryDialog.this.table.getCellEditor().stopCellEditing();
                }
                String defaultPath = CreateDictionaryDialog.this.filename.equals("") ? SplusSystem.getCwd().getAbsolutePath() : MinerApp.getAbsolutePath(CreateDictionaryDialog.this.filename);
                WideFileChooser fc = new WideFileChooser(defaultPath);
                fc.setAcceptAllFileFilterUsed(false);
                fc.addChoosableFileFilter(cff);
                fc.addChoosableFileFilter(tff);
                fc.addChoosableFileFilter(xff);
                fc.setFileFilter(cff);
                if (!CreateDictionaryDialog.this.filename.equals("") && !(file = new File(CreateDictionaryDialog.this.filename)).isDirectory()) {
                    if (xff.accept(file)) {
                        fc.setFileFilter(xff);
                    } else if (tff.accept(file)) {
                        fc.setFileFilter(tff);
                    } else if (cff.accept(file)) {
                        fc.setFileFilter(cff);
                    }
                    fc.setSelectedFile(file);
                }
                int result = fc.showSaveDialog(CreateDictionaryDialog.this);
                while (result == 0) {
                    boolean csv;
                    File newFile = fc.getSelectedFile();
                    CreateDictionaryDialog.this.filename = newFile.getAbsolutePath();
                    boolean xml = fc.getFileFilter() == xff;
                    boolean bl = csv = fc.getFileFilter() == cff;
                    if (newFile.getName().indexOf(".") == -1) {
                        CreateDictionaryDialog.this.filename = xml ? CreateDictionaryDialog.this.filename + ".xml" : (csv ? CreateDictionaryDialog.this.filename + ".csv" : CreateDictionaryDialog.this.filename + ".txt");
                        newFile = new File(CreateDictionaryDialog.this.filename);
                    }
                    if (!FileUtilities.confirmSaveAs((Component)CreateDictionaryDialog.this, (String)newFile.getAbsolutePath())) {
                        result = fc.showSaveDialog(CreateDictionaryDialog.this);
                        continue;
                    }
                    CreateDictionaryDialog.this.saveFile(newFile, xml);
                    CreateDictionaryDialog.this.success = true;
                    CreateDictionaryDialog.this.dispose();
                    break;
                }
            }
        });
        save.setMnemonic('s');
        JButton load = new JButton(new AbstractAction(MinerApp.getText("CreateDictionaryDialog_load")){

            public void actionPerformed(ActionEvent e) {
                int result;
                File file;
                if (CreateDictionaryDialog.this.table.isEditing()) {
                    CreateDictionaryDialog.this.table.getCellEditor().stopCellEditing();
                }
                String defaultPath = CreateDictionaryDialog.this.filename.equals("") ? SplusSystem.getCwd().getAbsolutePath() : MinerApp.getAbsolutePath(CreateDictionaryDialog.this.filename);
                WideFileChooser fc = new WideFileChooser(defaultPath);
                fc.setFileSelectionMode(0);
                fc.addChoosableFileFilter(cff);
                fc.addChoosableFileFilter(tff);
                fc.addChoosableFileFilter(xff);
                fc.setFileFilter(cff);
                if (!CreateDictionaryDialog.this.filename.equals("") && !(file = new File(CreateDictionaryDialog.this.filename)).isDirectory()) {
                    if (xff.accept(file)) {
                        fc.setFileFilter(xff);
                    } else if (tff.accept(file)) {
                        fc.setFileFilter(tff);
                    } else if (cff.accept(file)) {
                        fc.setFileFilter(cff);
                    }
                    fc.setSelectedFile(file);
                }
                if ((result = fc.showOpenDialog(CreateDictionaryDialog.this)) == 0) {
                    File newFile = fc.getSelectedFile();
                    CreateDictionaryDialog.this.filename = newFile.getAbsolutePath();
                    if (newFile.getName().indexOf(".") == -1 && !newFile.exists()) {
                        CreateDictionaryDialog.this.filename = fc.getFileFilter() == xff ? CreateDictionaryDialog.this.filename + ".xml" : (fc.getFileFilter() == cff ? CreateDictionaryDialog.this.filename + ".csv" : CreateDictionaryDialog.this.filename + ".txt");
                        newFile = new File(CreateDictionaryDialog.this.filename);
                    }
                    if (!newFile.exists()) {
                        String msg = MinerApp.getText("CreateDictionaryDialog_message_file") + " (" + CreateDictionaryDialog.this.filename + ") " + MinerApp.getText("CreateDictionaryDialog_message_notFound");
                        AcceleratorOptionPane.showOKDialog(CreateDictionaryDialog.this, msg, MinerApp.getText("CreateDictionaryDialog_message_fileNotFound"), 0);
                        return;
                    }
                    CreateDictionaryDialog.this.loadFile(newFile);
                }
            }
        });
        load.setMnemonic('l');
        JButton up = new JButton(new AbstractAction(MinerApp.getText("CreateDictionaryDialog_up")){

            public void actionPerformed(ActionEvent e) {
                int selRow;
                if (CreateDictionaryDialog.this.table.isEditing()) {
                    CreateDictionaryDialog.this.table.getCellEditor().stopCellEditing();
                }
                if ((selRow = CreateDictionaryDialog.this.table.getSelectedRow()) > 0) {
                    int newRow = selRow - 1;
                    CreateDictionaryDialog.this.tableModel.moveRow(selRow, selRow, newRow);
                    CreateDictionaryDialog.this.tableModel.fireTableRowsUpdated(newRow, selRow);
                    CreateDictionaryDialog.this.table.setRowSelectionInterval(newRow, newRow);
                }
            }
        });
        up.setMnemonic('u');
        JButton down = new JButton(new AbstractAction(MinerApp.getText("CreateDictionaryDialog_down")){

            public void actionPerformed(ActionEvent e) {
                int selRow;
                if (CreateDictionaryDialog.this.table.isEditing()) {
                    CreateDictionaryDialog.this.table.getCellEditor().stopCellEditing();
                }
                if ((selRow = CreateDictionaryDialog.this.table.getSelectedRow()) != -1 && selRow < CreateDictionaryDialog.this.table.getRowCount() - 2) {
                    int newRow = selRow + 1;
                    CreateDictionaryDialog.this.tableModel.moveRow(selRow, selRow, newRow);
                    CreateDictionaryDialog.this.tableModel.fireTableRowsUpdated(selRow, newRow);
                    CreateDictionaryDialog.this.table.setRowSelectionInterval(newRow, newRow);
                }
            }
        });
        down.setMnemonic('d');
        JButton insert = new JButton(new AbstractAction(MinerApp.getText("CreateDictionaryDialog_insert")){

            public void actionPerformed(ActionEvent e) {
                if (CreateDictionaryDialog.this.table.isEditing()) {
                    CreateDictionaryDialog.this.table.getCellEditor().stopCellEditing();
                }
                int insertPoint = CreateDictionaryDialog.this.tableModel.getRowCount();
                CreateDictionaryDialog.this.tableModel.addRow(new Object[]{"", "", "", "", "", ""});
                CreateDictionaryDialog.this.tableModel.fireTableRowsInserted(insertPoint, insertPoint);
            }
        });
        insert.setMnemonic('i');
        JButton delete = new JButton(new AbstractAction(MinerApp.getText("CreateDictionaryDialog_delete")){

            public void actionPerformed(ActionEvent e) {
                if (CreateDictionaryDialog.this.table.isEditing()) {
                    CreateDictionaryDialog.this.table.getCellEditor().stopCellEditing();
                }
                int[] selRows = CreateDictionaryDialog.this.table.getSelectedRows();
                int num = 0;
                for (int i = 0; i < selRows.length; ++i) {
                    CreateDictionaryDialog.this.tableModel.removeRow(selRows[i] - num++);
                }
                if (selRows.length > 0) {
                    CreateDictionaryDialog.this.tableModel.fireTableRowsDeleted(selRows[0], selRows[selRows.length - 1]);
                }
            }
        });
        delete.setMnemonic('e');
        insert.setPreferredSize(delete.getPreferredSize());
        down.setPreferredSize(delete.getPreferredSize());
        up.setPreferredSize(delete.getPreferredSize());
        JButton cancel = new JButton(new AbstractAction(MinerApp.getText("NodeDialog_cancel")){

            public void actionPerformed(ActionEvent e) {
                CreateDictionaryDialog.this.dispose();
            }
        });
        cancel.setMnemonic('c');
        cancel.setPreferredSize(save.getPreferredSize());
        cancel.registerKeyboardAction(cancel.getAction(), KeyStroke.getKeyStroke("ESCAPE"), 2);
        int gridy = 0;
        GridBagConstraints optionsConstraints = new GridBagConstraints();
        JPanel moreOptionsPanel = new JPanel(new GridBagLayout());
        JPanel editPanel = new JPanel(new GridBagLayout());
        editPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("CreateDictionaryDialog_editDataDictionary")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints editConstraints = new GridBagConstraints();
        editConstraints.gridy = 0;
        editConstraints.gridx = 0;
        editConstraints.weightx = 1.0;
        editConstraints.weighty = 1.0;
        editConstraints.insets = new Insets(5, 5, 10, 5);
        editConstraints.gridwidth = 0;
        editConstraints.fill = 1;
        JPanel ioPanel = new JPanel();
        ioPanel.setLayout(new BoxLayout(ioPanel, 0));
        ioPanel.add(Box.createGlue());
        ioPanel.add(load);
        editPanel.add((Component)ioPanel, editConstraints);
        editConstraints.gridy = 1;
        editConstraints.insets = new Insets(5, 5, 5, 5);
        editPanel.add((Component)scrollingTable, editConstraints);
        JPanel manipulationPanel = new JPanel();
        manipulationPanel.setLayout(new BoxLayout(manipulationPanel, 0));
        manipulationPanel.add(up);
        manipulationPanel.add(Box.createHorizontalStrut(5));
        manipulationPanel.add(down);
        manipulationPanel.add(Box.createGlue());
        manipulationPanel.add(insert);
        manipulationPanel.add(Box.createHorizontalStrut(5));
        manipulationPanel.add(delete);
        editConstraints.gridy = 2;
        editConstraints.insets = new Insets(5, 5, 10, 5);
        editPanel.add((Component)manipulationPanel, editConstraints);
        optionsConstraints.gridy = gridy++;
        optionsConstraints.gridx = 0;
        optionsConstraints.weightx = 1.0;
        optionsConstraints.weighty = 1.0;
        optionsConstraints.insets = new Insets(5, 5, 5, 5);
        optionsConstraints.gridwidth = 0;
        optionsConstraints.fill = 1;
        moreOptionsPanel.add((Component)editPanel, optionsConstraints);
        JPanel okPanel = new JPanel();
        okPanel.setLayout(new BoxLayout(okPanel, 0));
        okPanel.add(Box.createGlue());
        okPanel.add(save);
        okPanel.add(Box.createHorizontalStrut(5));
        okPanel.add(cancel);
        optionsConstraints.gridy = gridy++;
        moreOptionsPanel.add((Component)okPanel, optionsConstraints);
        this.getContentPane().add(moreOptionsPanel);
        this.pack();
        this.setLocationRelativeTo(dialog);
        if (initialFilename != null && initialFilename.length() > 0 && (file = new File(initialFilename)).exists() && !file.isDirectory()) {
            this.loadFile(file);
        }
        AppAction.updateAllActions();
    }

    private void saveFile(File file, boolean xml) {
        try {
            FileOutputStream outs = new FileOutputStream(file);
            FixedFormatDictionary ffd = this.createFixedFormatDictionary();
            if (xml) {
                ffd.saveXML(outs);
            } else {
                ffd.saveCSV(outs);
            }
            outs.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadFile(File file) {
        FixedFormatDictionary ffd = new FixedFormatDictionary(file);
        if (ffd == null || ffd.isEmpty()) {
            String msg = MinerApp.getText("CreateDictionaryDialog_message_noValidDirectory") + " \n" + file.getAbsolutePath();
            AcceleratorOptionPane.showOKDialog(this, msg);
            return;
        }
        this.updateFixedFormatDictionaryTable(ffd);
    }

    private FixedFormatDictionary createFixedFormatDictionary() {
        FixedFormatDictionary ffd = new FixedFormatDictionary();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            String name = (String)this.table.getValueAt(i, 0);
            if (name.length() < 1) continue;
            Object start = this.table.getValueAt(i, 3);
            Object width = this.table.getValueAt(i, 4);
            Object decimals = this.table.getValueAt(i, 5);
            ffd.addEntry(name, (String)this.table.getValueAt(i, 1), (String)this.table.getValueAt(i, 2), start instanceof Integer ? (Integer)start : new Integer(-1), width instanceof Integer ? (Integer)width : new Integer(-1), decimals instanceof Integer ? (Integer)decimals : new Integer(-1));
        }
        return ffd;
    }

    private void updateFixedFormatDictionaryTable(FixedFormatDictionary ffd) {
        int i;
        this.tableModel.clearTable();
        List columns = ffd.getNames();
        TableModelListener[] listeners = this.tableModel.getTableModelListeners();
        for (i = 0; i < listeners.length; ++i) {
            this.tableModel.removeTableModelListener(listeners[i]);
        }
        for (i = 0; i < columns.size(); ++i) {
            String name = (String)columns.get(i);
            int start = ffd.getStart(name);
            int width = ffd.getWidth(name);
            int decimals = ffd.getDecimals(name);
            Object[] row = new Object[]{name, ffd.getType(name), ffd.getRole(name), start != -1 ? new Integer(start) : "", width != -1 ? new Integer(width) : "", decimals != -1 ? new Integer(decimals) : ""};
            this.tableModel.addRow(row);
        }
        for (i = 0; i < listeners.length; ++i) {
            this.tableModel.addTableModelListener(listeners[i]);
        }
        this.tableModel.fireTableDataChanged();
    }

    private Object getIcon(String value) {
        return ModifyColumnsPanel.getIconForString(value);
    }

    public static class XMLFileFilter
    extends FileFilter {
        public static final String FILTER_DESCRIPTION = "XML Files (*.xml)";
        public static final String FILTER_EXTENSION = ".xml";

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(FILTER_EXTENSION);
        }

        public String getDescription() {
            return FILTER_DESCRIPTION;
        }
    }

    public static class CSVFileFilter
    extends FileFilter {
        public static final String FILTER_DESCRIPTION = "CSV Files (*.csv)";
        public static final String FILTER_EXTENSION = ".csv";

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(FILTER_EXTENSION);
        }

        public String getDescription() {
            return FILTER_DESCRIPTION;
        }
    }

    public static class TextFileFilter
    extends FileFilter {
        public static final String FILTER_DESCRIPTION = "Text Files (*.txt)";
        public static final String FILTER_EXTENSION = ".txt";

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(FILTER_EXTENSION);
        }

        public String getDescription() {
            return FILTER_DESCRIPTION;
        }
    }

    private class FFTableModel
    extends DefaultTableModel {
        private FFTableModel() {
        }

        public void setValueAt(Object aValue, int row, int column) {
            Vector rowVector = (Vector)this.dataVector.elementAt(row);
            if (aValue instanceof String) {
                String str = (String)aValue;
                if (column > 2 && str.length() > 0) {
                    rowVector.setElementAt(new Integer(str), column);
                } else {
                    rowVector.setElementAt(str, column);
                }
            }
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }

        public void clearTable() {
            this.dataVector.removeAllElements();
            this.fireTableDataChanged();
        }
    }

    public class IconCellRenderer
    extends NodeDialog.GeneralRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSel, boolean hasFocus, int row, int col) {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                Object obj = CreateDictionaryDialog.this.getIcon((String)value);
                return super.getTableCellRendererComponent(table, obj, isSel, hasFocus, row, col);
            }
            return super.getTableCellRendererComponent(table, value, isSel, hasFocus, row, col);
        }
    }
}

