/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AggregateEngineNode;
import com.insightful.miner.CrosstabulateEngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.SelectColumnsPanel;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class CrosstabulateDialog
extends NodeDialog {
    private JTextField lowBoundsTextField;
    private JCheckBox visualCheckBox;
    private JCheckBox tableCheckBox;
    private SelectColumnsPanel selectColumnsPanel;
    private JRadioButton[] tableTypeRadioButton;
    private String[] tableTypes = new String[]{CrosstabulateEngineNode.ABSOLUTE_COUNT_ATTRIBUTE_TAG, CrosstabulateEngineNode.ROW_PERCENT_ATTRIBUTE_TAG, CrosstabulateEngineNode.COLUMN_PERCENT_ATTRIBUTE_TAG, CrosstabulateEngineNode.TOTAL_PERCENT_ATTRIBUTE_TAG};
    private JCheckBox sortCheckBox;
    private static final String availableColumnsString = "CrosstabulateDialog_availableColumns";
    private static final String crosstabColumnsString = "CrosstabulateDialog_crosstabColumns";
    private static final String visualizationsString = "CrosstabulateDialog_visualizations";
    private static final String displayCrosstabsTableString = "CrosstabulateDialog_displayCrosstabsTable";
    private static final String displayVisualCrosstabsString = "CrosstabulateDialog_displayVisualCrosstabs";
    private static final String crosstabsTableHotkeyString = "CrosstabulateDialog_displayCrosstabsTableHotkey";
    private static final String visualCrosstabsHotkeyString = "CrosstabulateDialog_displayVisualCrosstabsHotkey";
    private static CrosstabulateDialog instance = null;

    public static CrosstabulateDialog getInstance() {
        if (instance == null) {
            instance = new CrosstabulateDialog();
        }
        return instance;
    }

    private CrosstabulateDialog() {
        Dimension min = new Dimension(550, 500);
        this.setMinimumSize(min);
        this.setSize(min);
    }

    public void restoreProperties() {
        double val;
        super.restoreProperties();
        this.selectColumnsPanel.restoreProperties(this.getNodeModel());
        XTProps props = this.getNodeModel().getXTProps();
        this.visualCheckBox.setSelected(props.getBoolean(CrosstabulateEngineNode.CHART_ATTRIBUTE_TAG, false));
        this.tableCheckBox.setSelected(props.getBoolean(CrosstabulateEngineNode.TABULAR_ATTRIBUTE_TAG, true));
        this.sortCheckBox.setSelected(props.getBoolean(CrosstabulateEngineNode.SORT_ATTRIBUTE_TAG, true));
        String tableType = props.getValue(CrosstabulateEngineNode.TABLE_CELL_TYPE_ATTRIBUTE_TAG, this.tableTypes[0]);
        for (int i = 0; i < this.tableTypes.length; ++i) {
            if (!tableType.equals(this.tableTypes[i])) continue;
            this.tableTypeRadioButton[i].setSelected(true);
            this.tableTypeRadioButton[i].doClick();
            break;
        }
        String str = (val = props.getDouble(CrosstabulateEngineNode.LOWER_BOUND_PERCENT_ATTRIBUTE_TAG, -1.0)) >= 0.0 ? Double.toString(val) : "";
        this.lowBoundsTextField.setText(str);
    }

    public void saveProperties() throws NodeDialog.DialogException {
        double lowBoundsVal;
        super.saveProperties();
        String lowBounds = this.lowBoundsTextField.getText();
        if (lowBounds.length() != 0 && ((lowBoundsVal = Double.parseDouble(lowBounds)) < 0.0 || lowBoundsVal > 100.0)) {
            throw new NodeDialog.DialogException(MinerApp.getText("CrosstabulateDialog_lowBoundsError"));
        }
        this.selectColumnsPanel.saveProperties(this.getNodeModel());
        XTProps props = this.getNodeModel().getXTProps();
        props.set(CrosstabulateEngineNode.CHART_ATTRIBUTE_TAG, this.visualCheckBox.isSelected());
        props.set(CrosstabulateEngineNode.TABULAR_ATTRIBUTE_TAG, this.tableCheckBox.isSelected());
        String columnsString = "outgoingColumns";
        Vector names = props.getSubProperties(columnsString);
        Vector types = props.getSubPropertyValues(columnsString);
        props.removeProperty(new String[]{CrosstabulateEngineNode.LOWER_BOUND_PERCENT_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{CrosstabulateEngineNode.CROSSTABULATE_COLUMNS_ATTRIBUTE_TAG});
        String[] path = new String[]{CrosstabulateEngineNode.CROSSTABULATE_COLUMNS_ATTRIBUTE_TAG, ""};
        int length = names.size() - 1;
        if (length >= 0) {
            path[1] = (String)names.get(length);
            props.set(path, (String)types.get(length));
            for (int i = 0; i < length; ++i) {
                path[1] = (String)names.get(i);
                props.set(path, (String)types.get(i));
            }
            props.removeProperty(new String[]{AggregateEngineNode.SUMMARY_COLUMNS_ATTRIBUTE_TAG});
            String[] propertyString = new String[]{AggregateEngineNode.SUMMARY_COLUMNS_ATTRIBUTE_TAG, CrosstabulateEngineNode.COUNT_ATTRIBUTE_TAG, ""};
            propertyString[2] = AggregateEngineNode.SUMMARY_METHOD_ATTRIBUTE_TAG;
            props.set(propertyString, AggregateEngineNode.COUNT_METHOD_ATTRIBUTE_TAG);
            propertyString[2] = AggregateEngineNode.INPUT_NAME_ATTRIBUTE_TAG;
            props.set(propertyString, (String)names.get(length));
        }
        for (int i = 0; i < this.tableTypes.length; ++i) {
            if (!this.tableTypeRadioButton[i].isSelected()) continue;
            props.set(CrosstabulateEngineNode.TABLE_CELL_TYPE_ATTRIBUTE_TAG, this.tableTypes[i]);
            break;
        }
        props.set(CrosstabulateEngineNode.SORT_ATTRIBUTE_TAG, this.sortCheckBox.isSelected());
        if (lowBounds.length() > 0) {
            props.set(CrosstabulateEngineNode.LOWER_BOUND_PERCENT_ATTRIBUTE_TAG, lowBounds);
        }
    }

    protected JPanel createSortOptionsPanel() {
        JPanel globalPanel = new JPanel(new GridBagLayout());
        globalPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("NodeDialog_sortOptions")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.sortCheckBox = new JCheckBox(MinerApp.getText("NodeDialog_sortRequired"));
        GridBagConstraints c = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        globalPanel.add((Component)this.sortCheckBox, c);
        return globalPanel;
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel();
        this.selectColumnsPanel = new SelectColumnsPanel(this.okAction, MinerApp.getText(availableColumnsString), MinerApp.getText(crosstabColumnsString));
        this.selectColumnsPanel.setExcludedColumnType(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG);
        this.selectColumnsPanel.setExcludedColumnType(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG);
        this.selectColumnsPanel.setExcludedColumnType(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG);
        this.selectColumnsPanel.setExcludedColumnType(XTMetaData.BLOB_TYPE_ATTRIBUTE_TAG);
        JLabel lowBoundsLabel = new JLabel(MinerApp.getText("CrosstabulateDialog_lowBounds"));
        lowBoundsLabel.setDisplayedMnemonic(MinerApp.getText("CrosstabulateDialog_lowBoundsHotkey").charAt(0));
        this.lowBoundsTextField = new JTextField(10);
        this.lowBoundsTextField.setDocument(new NodeDialog.InputDoubleDoc());
        lowBoundsLabel.setLabelFor(this.lowBoundsTextField);
        this.tableCheckBox = new JCheckBox(new AbstractAction(MinerApp.getText(displayCrosstabsTableString)){

            public void actionPerformed(ActionEvent e) {
                boolean isTable = CrosstabulateDialog.this.tableCheckBox.isSelected();
                CrosstabulateDialog.this.tableTypeRadioButton[0].setEnabled(isTable);
                CrosstabulateDialog.this.tableTypeRadioButton[1].setEnabled(isTable);
                CrosstabulateDialog.this.tableTypeRadioButton[2].setEnabled(isTable);
                CrosstabulateDialog.this.tableTypeRadioButton[3].setEnabled(isTable);
            }
        });
        this.tableCheckBox.setMnemonic(MinerApp.getText(crosstabsTableHotkeyString).charAt(0));
        this.visualCheckBox = new JCheckBox(MinerApp.getText(displayVisualCrosstabsString));
        this.visualCheckBox.setMnemonic(MinerApp.getText(visualCrosstabsHotkeyString).charAt(0));
        this.tableTypeRadioButton = new JRadioButton[4];
        ButtonGroup bg = new ButtonGroup();
        this.tableTypeRadioButton[0] = new JRadioButton(MinerApp.getText("CrosstabulateDialog_useAbsolute"));
        this.tableTypeRadioButton[0].setMnemonic(MinerApp.getText("CrosstabulateDialog_useAbsoluteHotkey").charAt(0));
        bg.add(this.tableTypeRadioButton[0]);
        this.tableTypeRadioButton[1] = new JRadioButton(MinerApp.getText("CrosstabulateDialog_useRowPercent"));
        this.tableTypeRadioButton[1].setMnemonic(MinerApp.getText("CrosstabulateDialog_useRowPercentHotkey").charAt(0));
        bg.add(this.tableTypeRadioButton[1]);
        this.tableTypeRadioButton[2] = new JRadioButton(MinerApp.getText("CrosstabulateDialog_useColumnPercent"));
        this.tableTypeRadioButton[2].setMnemonic(MinerApp.getText("CrosstabulateDialog_useColumnPercentHotkey").charAt(0));
        bg.add(this.tableTypeRadioButton[2]);
        this.tableTypeRadioButton[3] = new JRadioButton(MinerApp.getText("CrosstabulateDialog_useTotalPercent"));
        this.tableTypeRadioButton[3].setMnemonic(MinerApp.getText("CrosstabulateDialog_useTotalPercentHotkey").charAt(0));
        bg.add(this.tableTypeRadioButton[3]);
        JPanel visualizationsPanel = new JPanel(new GridBagLayout());
        visualizationsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText(visualizationsString)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        visualizationsPanel.add((Component)lowBoundsLabel, gbc);
        gbc.weightx = 1.0;
        ++gbc.gridx;
        visualizationsPanel.add((Component)this.lowBoundsTextField, gbc);
        gbc.weightx = 0.0;
        ++gbc.gridy;
        gbc.gridx = 0;
        visualizationsPanel.add((Component)this.tableCheckBox, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 15, 0, 0);
        visualizationsPanel.add((Component)this.tableTypeRadioButton[0], gbc);
        ++gbc.gridy;
        visualizationsPanel.add((Component)this.tableTypeRadioButton[1], gbc);
        ++gbc.gridy;
        visualizationsPanel.add((Component)this.tableTypeRadioButton[2], gbc);
        ++gbc.gridy;
        visualizationsPanel.add((Component)this.tableTypeRadioButton[3], gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        visualizationsPanel.add((Component)this.visualCheckBox, gbc);
        JPanel sortOptionsPanel = this.createSortOptionsPanel();
        JPanel bottomPanel = new JPanel(new GridLayout(0, 2));
        bottomPanel.add(visualizationsPanel);
        bottomPanel.add(sortOptionsPanel);
        optionsPanel.setLayout(new BorderLayout());
        optionsPanel.add((Component)this.selectColumnsPanel, "Center");
        optionsPanel.add((Component)bottomPanel, "South");
        return optionsPanel;
    }
}

