/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProcIGLM;
import com.insightful.miner.LogisticRegressionEngineNode;
import com.insightful.miner.PredictEngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.Vector;

public class GLMEngineNode
extends LogisticRegressionEngineNode {
    public String getDepVar(XTProps props, XTMetaData md) {
        String catDep = PredictEngineNode.getFirstDependentVar(props, md, XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
        String contDep = PredictEngineNode.getFirstDependentVar(props, md, XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG);
        if (catDep == null && contDep != null) {
            return contDep;
        }
        if (contDep == null && catDep != null) {
            return catDep;
        }
        return contDep;
    }

    protected boolean checkDepVar(String depVar, XTMetaData md) {
        if (depVar == null) {
            this.printlnError("can't create model: no dependent variable");
            return false;
        }
        return true;
    }

    public String getDataDictionaryAsString() throws Exception {
        XTProps props = this.getNodeProperties();
        XTMetaData mdModel = this.getDataDictionayMetaData();
        String actualDepCol = this.getDepVar(props, mdModel);
        if (props.getValue("probabilityFor").equals("specifiedCategory")) {
            Vector levels = mdModel.getCategoricalDataFieldLevels(actualDepCol);
            String levelSpec = props.getValue("specifiedCategory", "");
            if (levelSpec.length() == 0) {
                throw new Exception("Must specify a category");
            }
            int levelSpecIndex = levels.indexOf(levelSpec);
            if (levelSpecIndex > 0) {
                String swap = (String)levels.get(0);
                levels.set(0, levelSpec);
                levels.set(levelSpecIndex, swap);
                mdModel.reorderCategoricalLevels(actualDepCol, levels);
            }
        } else if (mdModel.isCategoricalColumn(actualDepCol)) {
            Vector sorted = mdModel.getSortedCategoricalDataFieldLevels(actualDepCol);
            Vector reverseSorted = new Vector();
            for (int i = sorted.size() - 1; i >= 0; --i) {
                reverseSorted.add(sorted.get(i));
            }
            mdModel.reorderCategoricalLevels(actualDepCol, reverseSorted);
        }
        return mdModel.writeToString();
    }

    protected void setMean(CNKProcIGLM proc1, XTProps props) throws Exception {
        proc1.setMean(props.getValue(MEAN_TAG, ""));
    }

    protected void setCNKProcProps(CNKProcIGLM proc1, XTProps props) throws Exception {
        proc1.setFamily(props.getValue(FAMILY_TAG, ""));
        proc1.setLink(props.getValue(LINK_TAG, ""));
        proc1.setVar(props.getValue(VAR_TAG, ""));
        super.setCNKProcProps(proc1, props);
    }

    public String getModelAsString() throws Exception {
        XTProps props = this.getNodeProperties();
        XTMetaData md = this.getInputMetaData(0);
        String depCol = this.getDepVar(props, md);
        String modelXML = this.getDataDictionaryAsString();
        int i = modelXML.indexOf("</IMML>", 0);
        if (i > 0) {
            modelXML = modelXML.substring(0, i - 1);
            modelXML = modelXML + "\n";
        }
        modelXML = modelXML + BEGIN_GENERALREGRESSIONMODEL;
        modelXML = depCol != null ? modelXML + GLMEngineNode.xmlQuote(depCol) : modelXML + "\"?????\"";
        modelXML = modelXML + MODEL_TYPE + "\"" + this.getModelType() + "\"/>\n";
        modelXML = modelXML + this.getTermsAsString();
        String family = props.getValue(FAMILY_TAG, "");
        String link = props.getValue(LINK_TAG, "");
        String mean = props.getValue(MEAN_TAG, "");
        String var = props.getValue(VAR_TAG, "");
        if (family.length() > 0 || link.length() > 0 || mean.length() > 0 || var.length() > 0) {
            StringBuffer extra = new StringBuffer("<ModelExtraInfo>\n");
            if (family.length() > 0) {
                extra.append("<Family val=\"");
                extra.append(family);
                extra.append("\" />\n");
            }
            if (link.length() > 0) {
                extra.append("<Link val=\"");
                extra.append(link);
                extra.append("\" />\n");
            }
            if (mean.length() > 0) {
                extra.append("<Mean val=\"");
                extra.append(mean);
                extra.append("\" />\n");
            }
            if (var.length() > 0) {
                extra.append("<Var val=\"");
                extra.append(var);
                extra.append("\" />\n");
            }
            extra.append("</ModelExtraInfo>\n");
            modelXML = modelXML + extra.toString();
        }
        modelXML = modelXML + "</IMML>\n";
        return modelXML;
    }
}

