/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.ClassificationAgreementNodeModel;
import com.insightful.miner.ClassificationAssessmentEngineNode;
import com.insightful.miner.ClassificationAssessmentNodeModel;
import com.insightful.miner.EngineOrderNodeModelInputIterator;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.RegressionAgreementEngineNode;
import com.insightful.miner.RegressionAgreementNodeModel;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DragGestureEvent;
import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ModelEvaluationDialog
extends NodeDialog {
    private boolean m_sorting = false;
    private JLabel m_depLabel;
    private int m_firstColumnWidth;
    private JPanel m_evalPanel;
    private CardLayout m_cardLayout;
    private JComboBox m_depCol;
    private JComboBox m_evalCol;
    private JComboBox m_classAssessCol;
    private JComboBox m_classAgreeCol;
    private JComboBox m_regrAgreeCol;
    private JRadioButton m_fitRB;
    private JRadioButton m_residRB;
    private JRadioButton m_roleInformation;
    private JRadioButton m_userSpecified;
    private int[] m_lastSelectedIndices;
    private Vector m_inputs;
    private NodeDialog.DNDListModel m_inputListModel;
    private NodeDialog.DNDList m_inputList;
    private static ModelEvaluationDialog instance = null;

    public static ModelEvaluationDialog getInstance() {
        if (instance == null) {
            instance = new ModelEvaluationDialog();
        }
        return instance;
    }

    private ModelEvaluationDialog() {
        Dimension dim = new Dimension(575, 500);
        this.setMinimumSize(dim);
        this.setSize(dim);
    }

    private void fillComboBoxes(int[] inputs) {
        try {
            int j;
            int numDepColumns;
            XTMetaData md;
            int i;
            Vector depColumns = null;
            Vector evalColumns = null;
            JComboBox evalCB = null;
            if (this.getNodeModel() instanceof ClassificationAssessmentNodeModel) {
                for (i = 0; i < inputs.length; ++i) {
                    md = this.getNodeModel().getInputMetaData(inputs[i]);
                    if (i == 0) {
                        depColumns = md.getDataFieldsWithType(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
                        evalColumns = md.getDataFieldsWithType(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG);
                        continue;
                    }
                    numDepColumns = depColumns.size();
                    for (j = numDepColumns - 1; j >= 0; --j) {
                        if (md.nameToOrdinal((String)depColumns.get(j)) != -1) continue;
                        depColumns.remove(j);
                    }
                    int numEvalColumns = evalColumns.size();
                    for (int j2 = numEvalColumns - 1; j2 >= 0; --j2) {
                        if (md.nameToOrdinal((String)evalColumns.get(j2)) != -1) continue;
                        evalColumns.remove(j2);
                    }
                }
                evalCB = this.m_classAssessCol;
            } else if (this.getNodeModel() instanceof ClassificationAgreementNodeModel) {
                for (i = 0; i < inputs.length; ++i) {
                    md = this.getNodeModel().getInputMetaData(inputs[i]);
                    if (i == 0) {
                        depColumns = md.getDataFieldsWithType(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
                        continue;
                    }
                    numDepColumns = depColumns.size();
                    for (j = numDepColumns - 1; j >= 0; --j) {
                        if (md.nameToOrdinal((String)depColumns.get(j)) != -1) continue;
                        depColumns.remove(j);
                    }
                }
                evalColumns = depColumns;
                evalCB = this.m_classAgreeCol;
            } else if (this.getNodeModel() instanceof RegressionAgreementNodeModel) {
                for (i = 0; i < inputs.length; ++i) {
                    md = this.getNodeModel().getInputMetaData(inputs[i]);
                    if (i == 0) {
                        depColumns = md.getDataFieldsWithType(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG);
                        continue;
                    }
                    numDepColumns = depColumns.size();
                    for (j = numDepColumns - 1; j >= 0; --j) {
                        if (md.nameToOrdinal((String)depColumns.get(j)) != -1) continue;
                        depColumns.remove(j);
                    }
                }
                evalColumns = depColumns;
                evalCB = this.m_regrAgreeCol;
            }
            this.m_depCol.removeAllItems();
            if (depColumns != null) {
                for (i = 0; i < depColumns.size(); ++i) {
                    this.m_depCol.addItem(depColumns.get(i));
                }
            }
            evalCB.removeAllItems();
            if (evalColumns != null && evalCB != null) {
                for (i = 0; i < evalColumns.size(); ++i) {
                    evalCB.addItem(evalColumns.get(i));
                }
            }
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
            e.printStackTrace();
            return;
        }
    }

    public void restoreProperties() {
        this.m_lastSelectedIndices = null;
        super.restoreProperties();
        XTProps props = this.getNodeModel().getXTProps();
        ActivityNodeModel thisModel = this.getNodeModel();
        this.m_inputs.removeAllElements();
        this.m_inputListModel.removeAllElements();
        String[] path = new String[]{ClassificationAssessmentEngineNode.INPUTS_ATTRIBUTE_TAG, "", ""};
        String[] oldPath = new String[]{ClassificationAssessmentEngineNode.INPUTS_ATTRIBUTE_TAG, "", ""};
        EngineOrderNodeModelInputIterator iterator = new EngineOrderNodeModelInputIterator(thisModel);
        while (iterator.hasNext()) {
            int i = iterator.getInputNumber();
            ActivityNodeModel aModel = (ActivityNodeModel)iterator.next();
            int nodeID = aModel.getID();
            path[1] = ClassificationAssessmentEngineNode.INPUT_PREFIX_TAG + Integer.toString(i);
            oldPath[1] = Integer.toString(nodeID);
            oldPath[2] = path[2] = ClassificationAssessmentEngineNode.USE_ROLE_INFO_ATTRIBUTE_TAG;
            boolean useRoles = props.getBoolean(path, props.getBoolean(oldPath, true));
            oldPath[2] = path[2] = ClassificationAssessmentEngineNode.DEPENDENT_COLUMN_ATTRIBUTE_TAG;
            String dep = props.getValue(path, props.getValue(oldPath, ""));
            oldPath[2] = path[2] = ClassificationAssessmentEngineNode.EVAL_COLUMN_ATTRIBUTE_TAG;
            String eval = props.getValue(path, props.getValue(oldPath, ""));
            oldPath[2] = path[2] = RegressionAgreementEngineNode.FITTED_ATTRIBUTE_TAG;
            boolean fit = props.getBoolean(path, props.getBoolean(oldPath, true));
            Information info = new Information(aModel, dep, eval, fit, useRoles);
            this.m_inputs.add(info);
            this.m_inputListModel.addElement(info);
        }
        this.m_inputList.setSelectedIndex(-1);
        String card = "";
        this.m_evalCol = null;
        if (this.getNodeModel() instanceof ClassificationAssessmentNodeModel) {
            card = "classificationAssessment";
            this.m_evalCol = this.m_classAssessCol;
        } else if (this.getNodeModel() instanceof ClassificationAgreementNodeModel) {
            card = "classificationAgreement";
            this.m_evalCol = this.m_classAgreeCol;
        } else if (this.getNodeModel() instanceof RegressionAgreementNodeModel) {
            card = "regressionAgreement";
            this.m_evalCol = this.m_regrAgreeCol;
        }
        boolean useRole = props.getBoolean(ClassificationAssessmentEngineNode.USE_ROLE_INFO_ATTRIBUTE_TAG, true);
        boolean fit = props.getBoolean(RegressionAgreementEngineNode.FITTED_ATTRIBUTE_TAG, true);
        String depCol = props.getValue(ClassificationAssessmentEngineNode.DEPENDENT_COLUMN_ATTRIBUTE_TAG);
        String evalCol = props.getValue(ClassificationAssessmentEngineNode.EVAL_COLUMN_ATTRIBUTE_TAG);
        this.m_roleInformation.setSelected(useRole);
        this.m_userSpecified.setSelected(!useRole);
        this.m_fitRB.setSelected(fit);
        this.m_residRB.setSelected(!fit);
        this.m_depCol.setSelectedItem(depCol);
        this.m_evalCol.setSelectedItem(evalCol);
        this.setUserSpecEnabled();
        this.m_cardLayout.show(this.m_evalPanel, card);
    }

    private String getNodeNameWithID(ActivityNodeModel aModel) {
        String idString;
        String ret = aModel.toString().replaceAll("\n", "");
        if (!ret.endsWith(idString = " (" + aModel.getID() + ")")) {
            ret = ret + idString;
        }
        return ret;
    }

    public void saveProperties() throws NodeDialog.DialogException {
        this.doApply();
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        props.removeProperty(new String[]{ClassificationAssessmentEngineNode.INPUTS_ATTRIBUTE_TAG});
        String[] path = new String[]{ClassificationAssessmentEngineNode.INPUTS_ATTRIBUTE_TAG, "", ""};
        int numInputs = this.m_inputListModel.getSize();
        for (int i = 0; i < numInputs; ++i) {
            Information info = (Information)this.m_inputListModel.get(i);
            path[1] = ClassificationAssessmentEngineNode.INPUT_PREFIX_TAG + Integer.toString(i);
            path[2] = ClassificationAssessmentEngineNode.USE_ROLE_INFO_ATTRIBUTE_TAG;
            props.set(path, info.useRoleInfo);
            path[2] = RegressionAgreementEngineNode.FITTED_ATTRIBUTE_TAG;
            props.set(path, info.fitted);
            path[2] = ClassificationAssessmentEngineNode.DEPENDENT_COLUMN_ATTRIBUTE_TAG;
            props.set(path, info.depColumn);
            path[2] = ClassificationAssessmentEngineNode.EVAL_COLUMN_ATTRIBUTE_TAG;
            props.set(path, info.evalColumn);
        }
    }

    private void setUserSpecEnabled() {
        boolean select = this.m_inputList.getSelectedIndex() != -1;
        boolean enable = this.m_userSpecified.isSelected() && select;
        this.m_roleInformation.setEnabled(select);
        this.m_userSpecified.setEnabled(select);
        this.m_depCol.setEnabled(enable);
        this.m_classAssessCol.setEnabled(enable);
        this.m_classAgreeCol.setEnabled(enable);
        this.m_regrAgreeCol.setEnabled(enable);
        this.m_fitRB.setEnabled(enable);
        this.m_residRB.setEnabled(enable);
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        this.m_roleInformation = new JRadioButton(new AbstractAction(MinerApp.getText("ModelAssessmentDialog_useRoleInformation")){

            public void actionPerformed(ActionEvent e) {
                ModelEvaluationDialog.this.setUserSpecEnabled();
            }
        });
        this.m_roleInformation.setMnemonic(MinerApp.getText("ModelAssessmentDialog_useRoleInformationHotkey").charAt(0));
        this.m_userSpecified = new JRadioButton(new AbstractAction(MinerApp.getText("ModelAssessmentDialog_userSpecifiedRoles")){

            public void actionPerformed(ActionEvent e) {
                ModelEvaluationDialog.this.setUserSpecEnabled();
            }
        });
        this.m_userSpecified.setMnemonic(MinerApp.getText("ModelAssessmentDialog_userSpecifiedRolesHotkey").charAt(0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_roleInformation);
        bg.add(this.m_userSpecified);
        this.m_inputs = new Vector();
        this.m_inputListModel = new NodeDialog.DNDListModel();
        this.m_inputList = new NodeDialog.DNDList(this.m_inputListModel){

            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            }
        };
        this.m_inputList.setPreferredSize(new Dimension(100, 200));
        this.m_inputList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ModelEvaluationDialog.this.doListSelectionChanged();
            }
        });
        ScrollingPane sp = new ScrollingPane(this.m_inputList);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(10, 5, 2, 0);
        optionsPanel.add((Component)this.m_roleInformation, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 5, 0, 0);
        optionsPanel.add((Component)this.m_userSpecified, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 15, 0, 0);
        optionsPanel.add((Component)this.getUserSpecifiedPanel(), gbc);
        JPanel totalPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.5;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        totalPanel.add((Component)sp, gbc);
        ++gbc.gridx;
        totalPanel.add((Component)optionsPanel, gbc);
        return totalPanel;
    }

    private void doApply() {
        if (this.m_lastSelectedIndices == null) {
            return;
        }
        if (this.m_sorting) {
            return;
        }
        for (int i = 0; i < this.m_lastSelectedIndices.length; ++i) {
            Information information = (Information)this.m_inputList.getModel().getElementAt(this.m_lastSelectedIndices[i]);
            information.depColumn = (String)this.m_depCol.getSelectedItem();
            information.evalColumn = (String)this.m_evalCol.getSelectedItem();
            information.fitted = this.m_evalCol == this.m_regrAgreeCol ? this.m_fitRB.isSelected() : false;
            information.useRoleInfo = this.m_roleInformation.isSelected();
        }
    }

    private void doListSelectionChanged() {
        this.doApply();
        this.m_lastSelectedIndices = this.m_inputList.getSelectedIndices();
        this.fillComboBoxes(this.m_lastSelectedIndices);
        if (this.m_lastSelectedIndices.length > 0) {
            Information info = (Information)this.m_inputList.getSelectedValue();
            this.m_depCol.setSelectedItem(info.depColumn);
            this.m_evalCol.setSelectedItem(info.evalColumn);
            this.m_fitRB.setSelected(info.fitted);
            this.m_residRB.setSelected(!info.fitted);
            this.m_roleInformation.setSelected(info.useRoleInfo);
            this.m_userSpecified.setSelected(!info.useRoleInfo);
        }
        this.setUserSpecEnabled();
    }

    protected JPanel getUserSpecifiedPanel() {
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        JTextField testSize = new JTextField(10);
        Dimension dim = testSize.getPreferredSize();
        this.m_depCol = new JComboBox();
        this.m_depLabel = new JLabel(MinerApp.getText("ModelAssessmentDialog_dependent"));
        this.m_depLabel.setDisplayedMnemonic(MinerApp.getText("ModelAssessmentDialog_dependentHotkey").charAt(0));
        this.m_depLabel.setLabelFor(this.m_depCol);
        this.m_firstColumnWidth = (int)((double)this.m_depLabel.getPreferredSize().width * 1.1);
        this.m_depCol.setPreferredSize(dim);
        this.m_classAssessCol = new JComboBox();
        this.m_classAssessCol.setPreferredSize(dim);
        this.m_classAgreeCol = new JComboBox();
        this.m_classAgreeCol.setPreferredSize(dim);
        this.m_regrAgreeCol = new JComboBox();
        this.m_regrAgreeCol.setPreferredSize(dim);
        this.m_cardLayout = new CardLayout();
        this.m_evalPanel = new JPanel(this.m_cardLayout);
        this.m_evalPanel.add("classificationAssessment", this.getClassAssessPanel());
        this.m_evalPanel.add("classificationAgreement", this.getClassAgreePanel());
        this.m_evalPanel.add("regressionAgreement", this.getRegrAgreePanel());
        Insets none = new Insets(0, 0, 0, 0);
        Insets secondColumn = new Insets(0, this.m_firstColumnWidth, 0, 0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.insets = none;
        optionsPanel.add((Component)this.m_depLabel, gbc);
        gbc.weightx = 1.0;
        gbc.insets = secondColumn;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        optionsPanel.add((Component)this.m_depCol, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = none;
        optionsPanel.add((Component)this.m_evalPanel, gbc);
        return optionsPanel;
    }

    private JPanel getClassAssessPanel() {
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        JLabel evalLabel = new JLabel(MinerApp.getText("ModelAssessmentDialog_probability"));
        evalLabel.setLabelFor(this.m_classAssessCol);
        evalLabel.setDisplayedMnemonic(MinerApp.getText("ModelAssessmentDialog_probabilityHotkey").charAt(0));
        Insets none = new Insets(0, 0, 0, 0);
        Insets secondColumn = new Insets(0, this.m_firstColumnWidth, 0, 0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 18;
        gbc.weighty = 1.0;
        gbc.insets = none;
        optionsPanel.add((Component)evalLabel, gbc);
        gbc.weightx = 1.0;
        gbc.insets = secondColumn;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        optionsPanel.add((Component)this.m_classAssessCol, gbc);
        return optionsPanel;
    }

    private JPanel getClassAgreePanel() {
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        JLabel evalLabel = new JLabel(MinerApp.getText("ModelAssessmentDialog_classification"));
        evalLabel.setLabelFor(this.m_classAgreeCol);
        evalLabel.setDisplayedMnemonic(MinerApp.getText("ModelAssessmentDialog_classificationHotkey").charAt(0));
        Insets none = new Insets(0, 0, 0, 0);
        Insets secondColumn = new Insets(0, this.m_firstColumnWidth, 0, 0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = none;
        gbc.weighty = 1.0;
        optionsPanel.add((Component)evalLabel, gbc);
        gbc.weightx = 1.0;
        gbc.insets = secondColumn;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        optionsPanel.add((Component)this.m_classAgreeCol, gbc);
        return optionsPanel;
    }

    private JPanel getRegrAgreePanel() {
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        JLabel columnLabel = new JLabel(MinerApp.getText("ModelAssessmentDialog_evaluation"));
        columnLabel.setLabelFor(this.m_regrAgreeCol);
        columnLabel.setDisplayedMnemonic(MinerApp.getText("ModelAssessmentDialog_evaluationHotkey").charAt(0));
        this.m_residRB = new JRadioButton(MinerApp.getText("ModelAssessmentDialog_residuals"));
        this.m_residRB.setMnemonic(MinerApp.getText("ModelAssessmentDialog_residualsHotkey").charAt(0));
        this.m_fitRB = new JRadioButton(MinerApp.getText("ModelAssessmentDialog_fitted"));
        this.m_fitRB.setMnemonic(MinerApp.getText("ModelAssessmentDialog_fittedHotkey").charAt(0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_residRB);
        bg.add(this.m_fitRB);
        Insets none = new Insets(0, 0, 0, 0);
        Insets secondColumn = new Insets(0, this.m_firstColumnWidth, 0, 0);
        Insets indent = new Insets(0, 10, 0, 0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.insets = none;
        optionsPanel.add((Component)columnLabel, gbc);
        gbc.weightx = 1.0;
        gbc.insets = secondColumn;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        optionsPanel.add((Component)this.m_regrAgreeCol, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.insets = indent;
        gbc.gridwidth = 0;
        optionsPanel.add((Component)this.m_fitRB, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        optionsPanel.add((Component)this.m_residRB, gbc);
        return optionsPanel;
    }

    private class ScrollingPane
    extends NodeDialog.SortingScrollPane {
        public ScrollingPane(JList list) {
            super(list);
        }

        public void sort() {
            ModelEvaluationDialog.this.m_sorting = true;
            if (this.currentComparator == null) {
                ModelEvaluationDialog.this.m_inputListModel.removeAllElements();
                ModelEvaluationDialog.this.m_inputListModel.addElements(ModelEvaluationDialog.this.m_inputs.toArray());
                this.repaint();
            } else {
                super.sort();
            }
            ModelEvaluationDialog.this.m_sorting = false;
        }

        protected void setComparators() {
            this.azSortCompare = new myAZSortComparator();
            this.zaSortCompare = new myZASortComparator();
        }

        class myAZSortComparator
        implements Comparator {
            myAZSortComparator() {
            }

            public int compare(Object o1, Object o2) {
                String str1 = o1.toString();
                String str2 = o2.toString();
                return str1.compareTo(str2);
            }
        }

        class myZASortComparator
        implements Comparator {
            myZASortComparator() {
            }

            public int compare(Object o1, Object o2) {
                String str1 = o1.toString();
                String str2 = o2.toString();
                return str2.compareTo(str1);
            }
        }
    }

    private class Information {
        public ActivityNodeModel model;
        public String depColumn;
        public String evalColumn;
        public boolean fitted;
        public boolean useRoleInfo;

        public Information(ActivityNodeModel anm, String dep, String eval, boolean fit, boolean useRole) {
            this.model = anm;
            this.depColumn = dep;
            this.evalColumn = eval;
            this.fitted = fit;
            this.useRoleInfo = useRole;
        }

        public String toString() {
            return ModelEvaluationDialog.this.getNodeNameWithID(this.model);
        }
    }
}

