/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ExecViewer;
import com.insightful.miner.HtmlFrame;
import com.insightful.miner.InsNNErrorGraphPanel;
import com.insightful.miner.MinerAboutBox;
import com.insightful.miner.MinerApp;
import com.insightful.miner.ModifiableViewerFrame;
import com.insightful.miner.NeuralNetGraphPanel;
import com.insightful.miner.NeuralNetPanel;
import com.insightful.miner.NeuralNetSettingsPanel;
import com.insightful.miner.PredictEngineNode;
import com.insightful.miner.PrintPreview;
import com.insightful.miner.WideFileChooser;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.util.FileUtilities;
import com.jrefinery.ui.JRefineryUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NeuralNetViewer
extends ModifiableViewerFrame
implements Printable {
    private static ResourceBundle neuralNetBundles = null;
    private JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu();
    private JMenuItem fileMenuExit = new JMenuItem();
    private JMenuItem fileMenuPrint = new JMenuItem();
    private JMenuItem fileMenuPrintPreview = new JMenuItem();
    public JMenuItem fileMenuSave = new JMenuItem();
    public JMenuItem fileMenuLoad = new JMenuItem();
    private NeuralNetPanel networkPanel = null;
    private NeuralNetGraphPanel graphPanel = null;
    private NeuralNetSettingsPanel controlPanel = null;
    private JPanel backgroundPanel = null;
    private JMenu viewMenu = new JMenu();
    private JMenuItem viewMenuExpand = new JMenuItem();
    private JMenuItem viewHTMLMenu = new JMenuItem();
    private JMenu helpMenu = new JMenu();
    private JMenuItem helpMenuUserGuide = new JMenuItem();
    private JMenuItem helpMenuAbout = new JMenuItem();
    private ExecViewer execViewer = null;
    private JScrollPane networkPanelScrollPane = null;
    private boolean isRegression = true;
    private JFrame smallFrame = null;
    private JButton closeButton = null;
    private JButton openViewerButton = null;
    private AbstractAction closeAction;
    private AbstractAction openViewerAction;
    private boolean myPrintBegun = false;
    private Dimension myPrintDocSize = null;
    private Point myPrintDocTopLeft = null;
    private Rectangle2D.Double myPrintPageRect = null;
    private int myPrintNumPagesAcross = 1;
    private int myPrintNumPagesDown = 1;
    private double myPrintHorizScale = 1.0;
    private double myPrintVertScale = 1.0;
    public static final int TOTAL_HEIGHT = 555;
    public static final int TOTAL_WIDTH = 625;
    public static final int NETWORK_PANEL_HEIGHT = 200;
    public static final int NETWORK_PANEL_WIDTH = 270;
    public static final int GRAPH_PANEL_HEIGHT = 230;
    public static final int GRAPH_PANEL_WIDTH = 270;
    public static final int NEURAL_NET_PANEL_HEIGHT = 500;
    public static final int NEURAL_NET_PANEL_WIDTH = 320;
    public static final String ERROR_WEIGHT_CACHE_TAG = "NNerrorWeightCache";
    private int numEpochs = 0;
    private boolean networkIsExpanded = false;
    private boolean dontGetWeights = false;
    private XTProps xtprops = null;
    private XTMetaData xtmetadata = null;
    private String m_nodeID;
    private String m_worksheetID = "";
    private boolean getDataFromCache = false;
    private String htmlReportString = "";
    private String frameTitle = "";
    public static Font bigLabelFont = MinerApp.getFont(1, 12);
    public static Font smallLabelFont = MinerApp.getFont(1, 9);

    public NeuralNetViewer(ExecViewer ev, String htmlString, boolean currentlyRunning) {
        this.htmlReportString = htmlString;
        this.execViewer = ev;
        if (currentlyRunning) {
            this.viewHTMLMenu.setEnabled(false);
        } else {
            this.viewHTMLMenu.setEnabled(true);
        }
        try {
            this.jbInit();
            this.setIconImage(MinerApp.getResourceManager().getImage("minerapp.gif"));
            Container contentPane = this.getContentPane();
            contentPane.add(this.backgroundPanel);
            this.setSize(625, 555);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ActionListener cancelListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralNetViewer.this.exitFunction();
            }
        };
        this.getJMenuBar().registerKeyboardAction(cancelListener, KeyStroke.getKeyStroke("ESCAPE"), 2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                NeuralNetViewer.this.exitFunction();
            }
        });
        if (this.execViewer == null) {
            this.getDataFromCache = true;
        } else {
            this.createActions();
        }
    }

    public void initializeDialog() {
        this.controlPanel.initializeDialog();
        this.execViewer.initialize();
    }

    private void exitFunction() {
        this.getNeuralNetViewer().setVisible(false);
        if (this.getExecViewer() != null && this.getExecViewer().isUserStopRequested()) {
            if (this.smallFrame != null) {
                this.smallFrame.setVisible(false);
                this.smallFrame.dispose();
            }
            this.releaseMemory();
            return;
        }
        if (this.getExecViewer() != null && this.getExecViewer().isUserPauseRequested()) {
            this.controlPanel.pauseContinueButton.doClick();
        } else if (this.getExecViewer() != null) {
            if (this.smallFrame != null) {
                this.smallFrame.setVisible(true);
                this.smallFrame.requestFocus();
            }
        } else {
            this.releaseMemory();
        }
    }

    public void setIsRegression(boolean b) {
        this.isRegression = b;
        this.controlPanel.reset(b);
    }

    public boolean getIsRegression() {
        return this.isRegression;
    }

    public String getNodeId() {
        return this.m_nodeID;
    }

    public String getWorksheetId() {
        return this.m_worksheetID;
    }

    public void setNodeId(String id) {
        this.m_nodeID = id;
    }

    public void setWorksheetId(String s) {
        this.m_worksheetID = s;
    }

    public NeuralNetGraphPanel getGraphPanel() {
        return this.graphPanel;
    }

    public void setConfigData(XTProps props, XTMetaData metadata, XMLTree fittedModel) {
        this.xtprops = props;
        this.xtmetadata = metadata;
        this.controlPanel.restoreProperties(props);
        if (fittedModel != null) {
            Element xmlModel = fittedModel.getXML();
            NodeList layers = xmlModel.getElementsByTagName("NeuralLayer");
            int numHidLayers = layers.getLength() - 1;
            int numHidUnits = numHidLayers > 0 ? layers.item(0).getChildNodes().getLength() : 0;
            this.networkPanel.setHiddenLayer(numHidLayers, numHidUnits);
            NodeList errorWeights = xmlModel.getElementsByTagName("ErrorWeights");
            try {
                XTProps errorProps = new XTProps((Element)errorWeights.item(0).getFirstChild());
                this.numEpochs = errorProps.getSubProperties("ErrorValues").size();
            }
            catch (Exception e) {
                this.numEpochs = Integer.parseInt("50");
            }
        } else {
            String numHidLayers = props.getValue("hiddenLayers");
            String numHidUnits = props.getValue("numNodesHiddenLayer");
            this.networkPanel.setHiddenLayer(Integer.parseInt(numHidLayers), Integer.parseInt(numHidUnits));
            this.numEpochs = Integer.parseInt(props.getValue("epochs", "50"));
        }
        this.graphPanel.initChart(this.numEpochs);
        this.setInputs(props, metadata);
        String depVar = "";
        if (this.isRegression) {
            Vector<String> v = new Vector<String>(1);
            v.add(PredictEngineNode.getFirstDependentVar(props, metadata, XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG));
            this.networkPanel.setOutputs(v);
            this.controlPanel.setNumOutputs(1);
        } else {
            depVar = PredictEngineNode.getFirstDependentVar(props, metadata, XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
            Vector vv = metadata.getCategoricalDataFieldLevels(depVar);
            this.networkPanel.setOutputs(vv);
            this.controlPanel.setNumOutputs(vv.size());
        }
        if (this.getDataFromCache) {
            this.setWeightsAndGraphFromCacheFile(fittedModel);
        }
    }

    private void setInputs(XTProps props, XTMetaData metadata) {
        Vector indVars = PredictEngineNode.getIndependentVars(props, metadata);
        Vector<Integer> numLevelsPerVar = new Vector<Integer>();
        String s = "";
        int numLevels = 1;
        Vector levels = null;
        Vector<String> allVarsAndLevels = new Vector<String>();
        for (int i = 0; i < indVars.size(); ++i) {
            s = (String)indVars.elementAt(i);
            levels = metadata.getCategoricalDataFieldLevels(s);
            numLevels = levels.size();
            if (numLevels == 0) {
                allVarsAndLevels.add(s);
                numLevelsPerVar.addElement(new Integer(1));
            } else {
                numLevelsPerVar.addElement(new Integer(numLevels));
                for (int j = 0; j < numLevels; ++j) {
                    allVarsAndLevels.add(s + ":" + (String)levels.elementAt(j));
                }
            }
            s = s + " (" + (numLevels == 0 ? 1 : numLevels) + ")";
            indVars.set(i, s);
        }
        int size = allVarsAndLevels.size();
        this.controlPanel.setNumInputs(size);
        if (!this.networkIsExpanded) {
            this.networkPanel.setInputs(indVars, numLevelsPerVar, size, false);
        } else {
            this.networkPanel.setInputs(allVarsAndLevels, numLevelsPerVar, size, true);
        }
    }

    public XTProps getProperties() {
        return this.xtprops;
    }

    public void setViewerTitle(String title) {
        String title_text = NeuralNetViewer.getText("nnvis_gui_title");
        this.frameTitle = title;
        this.setTitle(title_text + "  " + this.frameTitle);
        if (this.smallFrame != null) {
            this.smallFrame.setTitle(NeuralNetViewer.getText("nnvis_gui_drill_down_title") + ": " + this.frameTitle);
        }
    }

    private void jbInit() throws Exception {
        this.backgroundPanel = new JPanel(new BorderLayout());
        this.controlPanel = new NeuralNetSettingsPanel(this);
        this.networkPanel = new NeuralNetPanel(this);
        this.graphPanel = new NeuralNetGraphPanel(this);
        Dimension graphPaneMinSize = new Dimension(270, 230);
        Dimension networkPanePrefSize = new Dimension(320, 500);
        Dimension splitPanePrefSize = new Dimension(625, 555);
        Dimension control_dim = this.controlPanel.getPreferredSize();
        this.networkPanel.setBackground(Color.white);
        this.graphPanel.setBackground(Color.white);
        JSplitPane leftSplitPane = new JSplitPane(0);
        leftSplitPane.setDividerSize(5);
        leftSplitPane.setDividerLocation(control_dim.height + 10);
        leftSplitPane.setOneTouchExpandable(true);
        leftSplitPane.setTopComponent(new JScrollPane(this.controlPanel));
        this.graphPanel.setPreferredSize(graphPaneMinSize);
        leftSplitPane.setBottomComponent(new JScrollPane(this.graphPanel));
        leftSplitPane.setResizeWeight(1.0);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setDividerSize(5);
        splitPane.setDividerLocation(control_dim.width + 10);
        splitPane.setOneTouchExpandable(true);
        splitPane.setPreferredSize(splitPanePrefSize);
        splitPane.setLeftComponent(leftSplitPane);
        this.networkPanel.setPreferredSize(networkPanePrefSize);
        this.networkPanelScrollPane = new JScrollPane(this.networkPanel);
        splitPane.setRightComponent(this.networkPanelScrollPane);
        this.backgroundPanel.add((Component)splitPane, "Center");
        String filemenu = NeuralNetViewer.getText("nnvis_gui_filemenu");
        this.fileMenu.setText(filemenu);
        this.fileMenu.setMnemonic(70);
        String fileexit = NeuralNetViewer.getText("nnvis_gui_fileexit");
        this.fileMenuExit.setText(fileexit);
        this.fileMenuExit.setMnemonic(69);
        this.fileMenuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralNetViewer.this.exitFunction();
            }
        });
        String fileprint = NeuralNetViewer.getText("nnvis_gui_fileprint");
        this.fileMenuPrint.setText(fileprint);
        this.fileMenuPrint.setMnemonic(80);
        this.fileMenuPrint.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.fileMenuPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralNetViewer.this.print();
            }
        });
        String fileprintpreview = NeuralNetViewer.getText("nnvis_gui_fileprintpreview");
        this.fileMenuPrintPreview.setText(fileprintpreview);
        this.fileMenuPrintPreview.setMnemonic(82);
        this.fileMenuPrintPreview.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.fileMenuPrintPreview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralNetViewer.this.printPreview();
            }
        });
        String filesave = NeuralNetViewer.getText("nnvis_gui_filesavecurrent");
        this.fileMenuSave.setText(filesave);
        this.fileMenuSave.setEnabled(false);
        this.fileMenuSave.setMnemonic(83);
        this.fileMenuSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.fileMenuSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((NeuralNetViewer)NeuralNetViewer.this).controlPanel.saveButton.doClick();
            }
        });
        this.fileMenuLoad.setText(NeuralNetViewer.getText("nnvis_gui_fileload"));
        this.fileMenuLoad.setEnabled(false);
        this.fileMenuLoad.setMnemonic(76);
        this.fileMenuLoad.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.fileMenuLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((NeuralNetViewer)NeuralNetViewer.this).controlPanel.loadWeightsButton.doClick();
            }
        });
        String viewText = NeuralNetViewer.getText("nnvis_gui_viewMenu");
        this.viewMenu.setText(viewText);
        this.viewMenu.setMnemonic(86);
        if (this.networkIsExpanded) {
            this.viewMenuExpand.setText(NeuralNetViewer.getText("nnvis_gui_collapseNet"));
            this.viewMenuExpand.setAccelerator(KeyStroke.getKeyStroke(73, 2));
            this.viewMenuExpand.setMnemonic(73);
        } else {
            this.viewMenuExpand.setText(NeuralNetViewer.getText("nnvis_gui_expandNet"));
            this.viewMenuExpand.setAccelerator(KeyStroke.getKeyStroke(73, 2));
            this.viewMenuExpand.setMnemonic(73);
        }
        this.viewMenuExpand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (NeuralNetViewer.this.networkIsExpanded) {
                    NeuralNetViewer.this.networkIsExpanded = false;
                    NeuralNetViewer.this.viewMenuExpand.setText(NeuralNetViewer.getText("nnvis_gui_expandNet"));
                } else {
                    NeuralNetViewer.this.networkIsExpanded = true;
                    NeuralNetViewer.this.viewMenuExpand.setText(NeuralNetViewer.getText("nnvis_gui_collapseNet"));
                }
                NeuralNetViewer.this.setInputs(NeuralNetViewer.this.xtprops, NeuralNetViewer.this.xtmetadata);
                NeuralNetViewer.this.networkPanel.setNetworkLocation();
                NeuralNetViewer.this.networkPanel.setSize(NeuralNetViewer.this.networkPanel.getPreferredSize());
                NeuralNetViewer.this.networkPanel.repaint();
            }
        });
        this.viewHTMLMenu.setText(NeuralNetViewer.getText("nnvis_gui_showHtml"));
        this.viewHTMLMenu.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.viewHTMLMenu.setMnemonic(76);
        this.viewHTMLMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HtmlFrame hf = new HtmlFrame(NeuralNetViewer.this.htmlReportString);
            }
        });
        String help = NeuralNetViewer.getText("nnvis_gui_help");
        this.helpMenu.setText(help);
        this.helpMenu.setMnemonic(72);
        String helpsystem = NeuralNetViewer.getText("nnvis_gui_helpsystem");
        this.helpMenuUserGuide.setText(helpsystem);
        this.helpMenuUserGuide.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpMenuUserGuide.setMnemonic(84);
        this.helpMenuUserGuide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralNetViewer.this.handleHelp();
            }
        });
        String helpabout = NeuralNetViewer.getText("nnvis_gui_helpabout");
        this.helpMenuAbout.setText(helpabout);
        this.helpMenuAbout.setMnemonic(65);
        this.helpMenuAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralNetViewer.this.handleAboutBox();
            }
        });
        this.fileMenu.add(this.fileMenuLoad);
        this.fileMenu.add(this.fileMenuSave);
        this.fileMenu.add(this.fileMenuPrintPreview);
        this.fileMenu.add(this.fileMenuPrint);
        this.fileMenu.add(this.fileMenuExit);
        this.viewMenu.add(this.viewMenuExpand);
        this.viewMenu.add(this.viewHTMLMenu);
        this.helpMenu.add(this.helpMenuUserGuide);
        this.helpMenu.add(this.helpMenuAbout);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.viewMenu);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
    }

    public NeuralNetViewer getNeuralNetViewer() {
        return this;
    }

    public ExecViewer getExecViewer() {
        return this.execViewer;
    }

    public JScrollPane getNetworkScrollPane() {
        return this.networkPanelScrollPane;
    }

    public void updateGUI(Hashtable h) {
        this.graphPanel.updateData(h);
        this.networkPanel.updateDisplay(h);
        this.controlPanel.updateData(h);
    }

    public void updateLabels() {
        this.controlPanel.updateLabels();
    }

    public void setNumEpochs(int num) {
        this.graphPanel.setNumEpochs(num);
    }

    public void addArrow() {
        this.graphPanel.addArrow();
    }

    public void saveBestArrow() {
        this.graphPanel.saveBestArrow();
    }

    public void closeSmallGraphWindow() {
        if (this.smallFrame != null) {
            this.smallFrame.setVisible(false);
            this.smallFrame = null;
        }
    }

    public void showGraph() {
        this.smallFrame = new ModifiableViewerFrame();
        this.smallFrame.setIconImage(MinerApp.getResourceManager().getImage("minerapp.gif"));
        InsNNErrorGraphPanel panel = this.graphPanel.createSmallGraphPanel();
        JPanel backgroundPanel = new JPanel(new BorderLayout());
        backgroundPanel.add((Component)((Object)panel), "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(Color.white);
        buttonPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        this.openViewerButton = new JButton(this.openViewerAction);
        this.openViewerButton.setMnemonic('O');
        this.openViewerButton.setPreferredSize(new Dimension(120, 20));
        gbc.gridx = 1;
        buttonPanel.add((Component)this.openViewerButton, gbc);
        backgroundPanel.add((Component)buttonPanel, "South");
        this.smallFrame.getContentPane().add(backgroundPanel);
        this.smallFrame.setSize(350, 250);
        ActionListener cancelListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExecViewer ev = NeuralNetViewer.this.getExecViewer();
                if (ev != null) {
                    ev.unlinkExecViewer();
                }
                if (NeuralNetViewer.this.smallFrame != null) {
                    NeuralNetViewer.this.smallFrame.dispose();
                }
            }
        };
        this.openViewerButton.registerKeyboardAction(cancelListener, KeyStroke.getKeyStroke("ESCAPE"), 2);
        this.smallFrame.setLocation(MinerApp.getNextWindowLocation());
        this.smallFrame.show();
    }

    public void showEnlargedChart() {
        ModifiableViewerFrame drillDownFrame = new ModifiableViewerFrame(NeuralNetViewer.getText("nnvis_gui_drill_down_title"));
        drillDownFrame.setIconImage(MinerApp.getResourceManager().getImage("minerapp.gif"));
        InsNNErrorGraphPanel panel = this.graphPanel.enlargeGraphPanel();
        drillDownFrame.getContentPane().add((Component)((Object)panel));
        drillDownFrame.setSize(500, 500);
        JRefineryUtilities.positionFrameRandomly((JFrame)drillDownFrame);
        drillDownFrame.show();
    }

    protected void handleAboutBox() {
        new MinerAboutBox().show(this);
    }

    protected void handleHelp() {
        MinerApp.getHelpManager().showContents();
        MinerApp.getHelpManager().showTopic("Neural_Network_Viewer");
    }

    public void releaseMemory() {
    }

    public int getNumEpochs() {
        return this.numEpochs;
    }

    public int getCurrentEpoch() {
        return this.graphPanel.getCurrentEpoch();
    }

    public int getBestEpoch() {
        return this.graphPanel.getBestEpoch();
    }

    private void createActions() {
        this.closeAction = new AbstractAction(NeuralNetViewer.getText("nnvis_small_graph_closeButtonText")){

            public void actionPerformed(ActionEvent e) {
                if (NeuralNetViewer.this.smallFrame != null) {
                    NeuralNetViewer.this.smallFrame.setVisible(false);
                }
            }
        };
        this.openViewerAction = new AbstractAction(NeuralNetViewer.getText("nnvis_small_graph_openViewerText")){

            public void actionPerformed(ActionEvent e) {
                NeuralNetViewer.this.getNeuralNetViewer().setVisible(true);
                if (NeuralNetViewer.this.smallFrame != null) {
                    NeuralNetViewer.this.smallFrame.setVisible(false);
                }
            }
        };
    }

    public static String getText(String key) {
        if (neuralNetBundles == null) {
            neuralNetBundles = MinerApp.getBundle("neuralNetBundles");
        }
        String string = MinerApp.getBundleString(neuralNetBundles, key);
        return string;
    }

    public static double roundToThousandths(double d) {
        if (Double.isNaN(d)) {
            return d;
        }
        d *= 1000.0;
        long e = (long)Math.floor(d += 0.5);
        double x = (double)e / 1000.0;
        return x;
    }

    public File getConfigFile(boolean saveNotLoad, int epoch, String path, String defaultName) {
        int fcresult;
        File curFile;
        block9: {
            Frame f = new Frame();
            f.setTitle(NeuralNetViewer.getText("nnvis_gui_load_file_dialog_text"));
            curFile = null;
            if (path == null) {
                path = SplusSystem.getCwd().getAbsolutePath();
            }
            WideFileChooser chooser = new WideFileChooser(path);
            chooser.setFileFilter(new XMLFileFilter());
            chooser.setDialogTitle("Save As");
            fcresult = -1;
            if (saveNotLoad) {
                if (defaultName != null) {
                    chooser.setSelectedFile(new File(path + "\\" + defaultName + ".epoch" + epoch + ".xml"));
                }
                while ((fcresult = chooser.showSaveDialog(this)) == 0) {
                    curFile = chooser.getSelectedFile();
                    if (!curFile.getName().endsWith(XMLFileFilter.m_extension)) {
                        String name = curFile.getName() + "." + XMLFileFilter.m_extension;
                        curFile = new File(curFile.getParentFile(), name);
                    }
                    if (!FileUtilities.confirmSaveAs((Component)this, (String)curFile.getAbsolutePath())) {
                        continue;
                    }
                    break block9;
                }
                curFile = null;
            } else {
                fcresult = chooser.showOpenDialog(this);
                if (fcresult == 0) {
                    curFile = chooser.getSelectedFile();
                }
            }
        }
        if (fcresult == 0) {
            SplusSystem.setCwd((File)curFile);
            return curFile;
        }
        return null;
    }

    public void createCacheFile() {
        Object[] data = new Object[4];
        Hashtable h = this.graphPanel.getErrorGraphData();
        Vector mseTrainVector = (Vector)h.get(NeuralNetGraphPanel.TRAINING_ERROR_VAL_VECTOR_TAG);
        Vector mseValidateVector = (Vector)h.get(NeuralNetGraphPanel.TEST_ERROR_VAL_VECTOR_TAG);
        Vector epochVector = (Vector)h.get(NeuralNetGraphPanel.EPOCH_VECTOR_TAG);
        Vector saveArrows = (Vector)h.get(NeuralNetGraphPanel.SAVE_ARROWS_TAG);
        data[0] = epochVector;
        data[1] = mseTrainVector;
        data[2] = mseValidateVector;
        data[3] = saveArrows;
        this.execViewer.sendMessageToEngineNode("createCacheFile", data);
    }

    public void loadFinalWeights(String XML) {
        NodeList lweights;
        int n;
        if (XML == null || !this.isVisible()) {
            this.releaseMemory();
            return;
        }
        XMLTree fit = XMLTree.readFromString(XML);
        NodeList lpars = fit.getDocument().getElementsByTagName("NeuralParameters");
        if (lpars.getLength() > 0) {
            Node ni = lpars.item(0);
            NamedNodeMap nm = ni.getAttributes();
            String score = "";
            String nobs = "";
            if (nm != null) {
                ni = nm.getNamedItem("score");
                score = ni.getNodeValue();
                ni = nm.getNamedItem("nobs");
                if (ni != null) {
                    long lnobs = 1L;
                    nobs = ni.getNodeValue();
                    try {
                        lnobs = Long.parseLong(nobs);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    score = Double.toString(Double.parseDouble(score) / (double)lnobs);
                }
            }
            this.controlPanel.setEntropyLabel(score);
        }
        if ((n = (lweights = fit.getDocument().getElementsByTagName("Con")).getLength()) == 0) {
            return;
        }
        double[] dweights = new double[n];
        for (int i = 0; i < n; ++i) {
            Node ni = lweights.item(i);
            NamedNodeMap nm = ni.getAttributes();
            if (nm != null) {
                ni = nm.getNamedItem("weight");
                dweights[i] = Double.parseDouble(ni.getNodeValue());
                continue;
            }
            dweights[i] = 0.0;
        }
        this.networkPanel.setWeights(dweights);
        this.networkPanel.repaint();
        this.htmlReportString = fit.getHtmlString(XMLTree.NEURAL_NETWORK_XSL_FILE, this.frameTitle);
        this.viewHTMLMenu.setEnabled(true);
    }

    public void setWeightsAndGraphFromCacheFile(XMLTree fit) {
        XMLTree tree = null;
        try {
            Element errorWeights = (Element)fit.getXML().getElementsByTagName("NeuralNetwork").item(0);
            errorWeights = (Element)errorWeights.getElementsByTagName("ErrorWeights").item(0);
            tree = new XMLTree(errorWeights);
        }
        catch (Exception e) {
            // empty catch block
        }
        Vector v = new Vector();
        StringTokenizer st = null;
        try {
            XTProps props = tree != null ? new XTProps(tree) : null;
            NodeList lweights = fit.getDocument().getElementsByTagName("Con");
            int n = lweights.getLength();
            double[] dweights = new double[n];
            for (int i = 0; i < n; ++i) {
                Node ni = lweights.item(i);
                NamedNodeMap nm = ni.getAttributes();
                if (nm != null) {
                    ni = nm.getNamedItem("weight");
                    dweights[i] = Double.parseDouble(ni.getNodeValue());
                    continue;
                }
                dweights[i] = 0.0;
            }
            this.networkPanel.setWeights(dweights);
            this.networkPanel.repaint();
            String xyvals = "";
            v = props == null ? new Vector() : props.getSubPropertyValues("ErrorValues");
            Vector<String> epochs = new Vector<String>(v.size());
            Vector<String> trainingVals = new Vector<String>(v.size());
            Vector<String> testVals = new Vector<String>(v.size());
            for (int epoch = 0; epoch < v.size(); ++epoch) {
                epochs.addElement(Integer.toString(epoch + 1));
                xyvals = (String)v.elementAt(epoch);
                st = new StringTokenizer(xyvals, " ");
                trainingVals.addElement(st.nextToken());
                testVals.addElement(st.nextToken());
            }
            this.graphPanel.recreateErrorGraph(epochs, trainingVals, testVals);
            this.controlPanel.doStopButton();
            this.controlPanel.setRunResultLabels((String)epochs.elementAt(epochs.size() - 1), (String)trainingVals.elementAt(trainingVals.size() - 1));
            v.removeAllElements();
            String arrows = props.getValue("ArrowValues");
            st = new StringTokenizer(arrows, " ");
            String arrow = "";
            while (st.hasMoreTokens()) {
                arrow = st.nextToken();
                v.addElement(new Double(Double.parseDouble(arrow)));
            }
            this.graphPanel.resetArrows(v);
            this.graphPanel.repaintGraph();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printPreview() {
        Thread runner = new Thread(){

            public void run() {
                Component comp = MinerApp.getMainFrame().getGlassPane();
                Cursor oldCursor = comp.getCursor();
                comp.setCursor(Cursor.getPredefinedCursor(3));
                comp.setVisible(true);
                new PrintPreview(NeuralNetViewer.this.getNeuralNetViewer(), NeuralNetViewer.this.getNeuralNetViewer().backgroundPanel);
                comp.setCursor(oldCursor);
                comp.setVisible(false);
            }
        };
        runner.start();
    }

    public void print() {
        PrintThread thrd = new PrintThread(this);
        thrd.start();
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        double x = pf.getImageableX();
        double y = pf.getImageableY();
        double w = pf.getImageableWidth();
        double h1 = pf.getImageableHeight() * 0.5;
        double h2 = pf.getImageableHeight();
        this.graphPanel.getChart().draw(g2, (Rectangle2D)new Rectangle2D.Double(x, y + h1, w, h2 - h1), null);
        this.networkPanel.print(g2, pf, pageIndex, new Rectangle2D.Double(x, y, w, h1));
        return 0;
    }

    protected class PrintThread
    extends Thread {
        private NeuralNetViewer m_ui;

        public PrintThread(NeuralNetViewer ui) {
            this.m_ui = ui;
        }

        public void run() {
            PrinterJob pj = PrinterJob.getPrinterJob();
            if (pj.printDialog(MinerApp.getPrintAttributeSet())) {
                PageFormat pf = pj.validatePage(MinerApp.getDefaultPageFormat());
                Paper paper = pf.getPaper();
                double margin = 36.0;
                paper.setImageableArea(margin, margin, paper.getWidth() - margin * 2.0, paper.getHeight() - margin * 2.0);
                pf.setPaper(paper);
                pj.setPrintable(this.m_ui, pf);
                new MinerApp.GenericPrintThread(pj).start();
            }
            MinerApp.getMainFrame().requestFocus();
            this.m_ui.requestFocus();
        }
    }

    public static class XMLFileFilter
    extends FileFilter {
        public static String m_extension = "xml";

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null) {
                return extension.equals(m_extension);
            }
            return false;
        }

        public String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }

        public String getDescription() {
            return "XML files";
        }
    }
}

