/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.SplitEngineNode;
import com.insightful.miner.XTProps;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SplitDialog
extends NodeDialog {
    private JTextArea qualifierTextArea;
    private NodeDialog.ExistingColumnInformationPanel existVarPanel;
    private static SplitDialog instance = null;

    public static SplitDialog getInstance() {
        if (instance == null) {
            instance = new SplitDialog();
        }
        return instance;
    }

    private SplitDialog() {
        this.setMinimumSize(new Dimension(400, 400));
    }

    public boolean displaySeedPanel() {
        return true;
    }

    public void restoreProperties() {
        super.restoreProperties();
        XTProps props = this.getNodeModel().getXTProps();
        this.qualifierTextArea.setText(props.getValue(SplitEngineNode.TEST_EXPRESSION_ATTRIBUTE_TAG, ""));
        try {
            this.existVarPanel.restoreProperties(this.getNodeModel().getInputMetaData(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        props.set(SplitEngineNode.TEST_EXPRESSION_ATTRIBUTE_TAG, this.qualifierTextArea.getText());
    }

    public JPanel createOptionsPanel() {
        this.existVarPanel = new NodeDialog.ExistingColumnInformationPanel(false, 400, 100);
        JPanel centerPanel = new JPanel(new GridBagLayout());
        centerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ReadTextFileDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel qualifierLabel = new JLabel(MinerApp.getText("SplitDialog_qualifier"));
        this.qualifierTextArea = new JTextArea(7, 40);
        qualifierLabel.setDisplayedMnemonic('q');
        qualifierLabel.setLabelFor(this.qualifierTextArea);
        this.qualifierTextArea.setBorder(BorderFactory.createLoweredBevelBorder());
        JScrollPane scrollPane = new JScrollPane(this.qualifierTextArea);
        scrollPane.getViewport().setPreferredSize(this.qualifierTextArea.getPreferredSize());
        JButton parseButton = new JButton(new AbstractAction("Parse Qualifier"){

            public void actionPerformed(ActionEvent e) {
                SplitDialog.this.tryParsingExpression();
            }
        });
        parseButton.setMnemonic('P');
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        centerPanel.add((Component)qualifierLabel, constraints);
        constraints.gridx = 1;
        constraints.weighty = 1.0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 15, 0, 0);
        constraints.fill = 1;
        centerPanel.add((Component)scrollPane, constraints);
        JPanel middle = new JPanel();
        middle.setLayout(new BoxLayout(middle, 0));
        middle.add(Box.createGlue());
        middle.add(parseButton);
        constraints.gridy = 2;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(5, 0, 5, 0);
        constraints.gridwidth = 0;
        constraints.fill = 2;
        centerPanel.add((Component)middle, constraints);
        constraints.gridy = 3;
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 2.0;
        constraints.insets = new Insets(5, 0, 5, 0);
        constraints.fill = 1;
        centerPanel.add((Component)this.existVarPanel, constraints);
        return centerPanel;
    }

    private void tryParsingExpression() {
        String parseErrors = "";
        try {
            XTProps props = (XTProps)this.getNodeModel().getXTProps().clone();
            props.set(SplitEngineNode.TEST_EXPRESSION_ATTRIBUTE_TAG, this.qualifierTextArea.getText());
            this.getNodeModel().saveGuiNetworkToEngine();
            parseErrors = (String)this.getNodeModel().sendMessageToEngine("getParseErrors", new Object[]{props});
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (parseErrors == null || parseErrors.equals("")) {
            parseErrors = "No parsing errors found.";
        }
        JTextArea errorText = new JTextArea(8, 30);
        errorText.setText(parseErrors);
        errorText.setEditable(false);
        errorText.setBorder(BorderFactory.createLoweredBevelBorder());
        JScrollPane errorScrollPane = new JScrollPane(errorText);
        errorScrollPane.getViewport().setPreferredSize(errorText.getPreferredSize());
        AcceleratorOptionPane.showOKDialog(this.tabbedPane, errorScrollPane, MinerApp.getText("SplitDialog_msg_parsingErrors"), 1);
    }
}

