/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ExecViewer;
import com.insightful.miner.MinerAboutBox;
import com.insightful.miner.MinerApp;
import com.insightful.miner.ModifiableViewerFrame;
import com.insightful.miner.PrintPreview;
import com.insightful.miner.SurvivalGraphPanel;
import com.insightful.miner.SurvivalStatsPanel;
import com.insightful.miner.XMLTree;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;

public class SurvivalViewer
extends ModifiableViewerFrame
implements Printable {
    private XMLTree m_model = null;
    private String m_worksheetId = null;
    private int m_nodeId = -1;
    private ExecViewer m_execViewer = null;
    private SurvivalGraphPanel m_graphPanel = null;
    private SurvivalStatsPanel m_statsPanel = null;
    private JPanel m_backgroundPanel = null;
    public static final int TOTAL_HEIGHT = 550;
    public static final int TOTAL_WIDTH = 790;
    public static final int GRAPH_PANEL_HEIGHT = 300;
    public static final int GRAPH_PANEL_WIDTH = 770;
    public static final int STATS_PANEL_WIDTH = 770;
    public static final int STATS_PANEL_HEIGHT = 230;

    public SurvivalViewer() {
    }

    public SurvivalViewer(XMLTree model, String worksheetId, int nodeId, String title) {
        try {
            this.init();
            this.setTitle(title);
            this.setId(worksheetId, nodeId);
            this.setModel(model);
            this.m_graphPanel.createGraph();
            this.m_statsPanel.createDocument();
            Container contentPane = this.getContentPane();
            contentPane.add(this.m_backgroundPanel);
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.m_backgroundPanel = new JPanel(new BorderLayout());
        this.m_backgroundPanel.setPreferredSize(new Dimension(790, 550));
        this.m_graphPanel = new SurvivalGraphPanel(this);
        this.m_graphPanel.setBackground(Color.white);
        this.m_backgroundPanel.setBackground(Color.white);
        this.m_graphPanel.setPreferredSize(new Dimension(770, 300));
        this.m_statsPanel = new SurvivalStatsPanel(this);
        this.m_statsPanel.setBackground(Color.white);
        this.m_statsPanel.setPreferredSize(new Dimension(770, 230));
        this.setIconImage(MinerApp.getResourceManager().getImage("minerapp.gif"));
        JSplitPane vertSplitPane = new JSplitPane(0);
        vertSplitPane.setDividerSize(9);
        vertSplitPane.setDividerLocation(230);
        vertSplitPane.setOneTouchExpandable(true);
        JScrollPane botScrollPane = new JScrollPane();
        botScrollPane.getViewport().add(this.m_graphPanel);
        botScrollPane.setHorizontalScrollBarPolicy(30);
        botScrollPane.setVerticalScrollBarPolicy(20);
        JPanel botScrollPaneHolder = new JPanel();
        botScrollPaneHolder.setLayout(new BorderLayout());
        botScrollPaneHolder.add((Component)botScrollPane, "Center");
        vertSplitPane.setBottomComponent(botScrollPaneHolder);
        JScrollPane topScrollPane = new JScrollPane();
        topScrollPane.getViewport().add(this.m_statsPanel);
        topScrollPane.setHorizontalScrollBarPolicy(30);
        topScrollPane.setVerticalScrollBarPolicy(20);
        JPanel topScrollPaneHolder = new JPanel();
        topScrollPaneHolder.setLayout(new BorderLayout());
        topScrollPaneHolder.add((Component)topScrollPane, "Center");
        vertSplitPane.setTopComponent(topScrollPaneHolder);
        vertSplitPane.setResizeWeight(1.0);
        this.m_backgroundPanel.add((Component)vertSplitPane, "Center");
        JMenu fileMenu = new JMenu(MinerApp.getText("MinerApp_menu_file"));
        fileMenu.setMnemonic(70);
        JMenuItem fileMenuExit = new JMenuItem(MinerApp.getText("MinerApp_menu_item_close"));
        fileMenuExit.setMnemonic(69);
        fileMenuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SurvivalViewer.this.exitFunction();
            }
        });
        JMenuItem fileMenuPrint = new JMenuItem(MinerApp.getText("MinerApp_menu_item_print"));
        fileMenuPrint.setMnemonic(80);
        fileMenuPrint.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        fileMenuPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SurvivalViewer.this.print();
            }
        });
        JMenuItem fileMenuPrintPreview = new JMenuItem(MinerApp.getText("MinerApp_menu_item_print_preview"));
        fileMenuPrintPreview.setMnemonic(82);
        fileMenuPrintPreview.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        fileMenuPrintPreview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SurvivalViewer.this.printPreview();
            }
        });
        fileMenu.add(fileMenuPrintPreview);
        fileMenu.add(fileMenuPrint);
        fileMenu.add(fileMenuExit);
        JMenu helpMenu = new JMenu(MinerApp.getText("MinerApp_menu_help"));
        helpMenu.setMnemonic(72);
        JMenuItem helpMenuUserGuide = new JMenuItem("Cox Regression" + MinerApp.getText("MinerApp_menu_help"));
        helpMenuUserGuide.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        helpMenuUserGuide.setMnemonic(67);
        helpMenuUserGuide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SurvivalViewer.this.handleHelp();
            }
        });
        JMenuItem helpMenuAbout = new JMenuItem(MinerApp.getText("MinerApp_menu_item_about"));
        helpMenuAbout.setMnemonic(65);
        helpMenuAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SurvivalViewer.this.handleAboutBox();
            }
        });
        helpMenu.add(helpMenuUserGuide);
        helpMenu.add(helpMenuAbout);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(helpMenu);
        this.setJMenuBar(menuBar);
    }

    public void setTitle(String title) {
        super.setTitle(title);
    }

    public void setId(String worksheetId, int nodeId) {
        this.m_worksheetId = worksheetId;
        this.m_nodeId = nodeId;
    }

    public void setModel(XMLTree model) throws Exception {
        this.m_model = model;
        if (!this.m_graphPanel.setSurvival(this.m_model)) {
            throw new Exception("Survival viewer failed to extract survival from the model");
        }
    }

    public XMLTree getModel() {
        return this.m_model;
    }

    public void show() {
        super.show();
    }

    protected void handleAboutBox() {
        new MinerAboutBox().show(this);
    }

    protected void handleHelp() {
        MinerApp.getHelpManager().showContents();
        MinerApp.getHelpManager().showTopic("Cox Regression");
    }

    public Printable getPrintableViewer() {
        return this;
    }

    public JComponent getPreviewComponent() {
        return this.m_backgroundPanel;
    }

    private void printPreview() {
        Thread runner = new Thread(){

            public void run() {
                Component comp = MinerApp.getMainFrame().getGlassPane();
                Cursor oldCursor = comp.getCursor();
                comp.setCursor(Cursor.getPredefinedCursor(3));
                comp.setVisible(true);
                new PrintPreview(SurvivalViewer.this.getPrintableViewer(), SurvivalViewer.this.getPreviewComponent());
                comp.setCursor(oldCursor);
                comp.setVisible(false);
            }
        };
        runner.start();
    }

    public int print() {
        PrintThread thrd = new PrintThread(this);
        thrd.start();
        return 1;
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        int ok = 1;
        Graphics2D g2 = (Graphics2D)g;
        if (pageIndex == 0) {
            ok = this.m_statsPanel.print(g2, pf, pageIndex);
        } else if (pageIndex == 1) {
            double x = pf.getImageableX();
            double y = pf.getImageableY();
            double w = pf.getImageableWidth();
            double h = pf.getImageableHeight();
            this.m_graphPanel.getChart().draw(g2, (Rectangle2D)new Rectangle2D.Double(x, y, w, h), null);
            ok = 0;
        }
        return ok;
    }

    private void exitFunction() {
        this.setVisible(false);
        this.releaseMemory();
    }

    public void releaseMemory() {
        this.m_graphPanel.releaseMemory();
        this.m_graphPanel = null;
        this.m_statsPanel.releaseMemory();
        this.m_statsPanel = null;
        this.dispose();
    }

    protected class PrintThread
    extends Thread {
        private SurvivalViewer m_ui;

        public PrintThread(SurvivalViewer ui) {
            this.m_ui = ui;
        }

        public void run() {
            PrinterJob pj = PrinterJob.getPrinterJob();
            if (pj.printDialog(MinerApp.getPrintAttributeSet())) {
                PageFormat pf = pj.validatePage(MinerApp.getDefaultPageFormat());
                Paper paper = pf.getPaper();
                double margin = 36.0;
                paper.setImageableArea(margin, margin, paper.getWidth() - margin * 2.0, paper.getHeight() - margin * 2.0);
                pf.setPaper(paper);
                pj.setPrintable(this.m_ui, pf);
                new MinerApp.GenericPrintThread(pj).start();
            }
            MinerApp.getMainFrame().requestFocus();
            this.m_ui.requestFocus();
        }
    }
}

