/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.ReadOtherFileDialog;
import com.insightful.miner.ReadTextFileDialog;
import com.insightful.miner.WriteOtherFileDialog;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class WriteTextFileDialog
extends NodeDialog {
    private JComboBox m_encodingComboBox;
    private JComboBox m_delimiterComboBox;
    private JTextField m_userDefinedDelimiterTextField;
    private JTextField m_fileNameTextField;
    private JCheckBox m_writeColumnNamesCheckBox;
    private JTextField m_NAStringTextField;
    private NodeDialog.DateOutputFormatComboBox m_timeDateFormatComboBox;
    private static final String[] m_encodingStrings = new String[]{"ASCII", "UTF-8"};
    private static final String[] m_delimiters = new String[]{"comma delimited", "tab delimited", "single space delimited", "single quote delimited", "user defined"};
    private static final String[] m_delimiterChars = new String[]{",", "\t", " ", "'", ""};
    private static String[] m_typeDescriptionList = new String[]{"Text files (*.txt; *.dat; *.asc; *.csv; *.prn)", "Text File (*.txt)", "Data File (*.dat)", "ASCII File (*.asc)", "Comma Separated Values File (*.csv)", "Print Format File (*.prn)"};
    private static String[][] m_extensionList = new String[][]{{".txt", ".dat", ".asc", ".csv", ".prn"}, {".txt"}, {".dat"}, {".asc"}, {".csv"}, {".prn"}};
    private AbstractAction fileNameTextFieldAction;
    private AbstractAction saveAsAction;
    private static WriteTextFileDialog instance = null;

    public static WriteTextFileDialog getInstance() {
        if (instance == null) {
            instance = new WriteTextFileDialog();
        }
        return instance;
    }

    private WriteTextFileDialog() {
        this.setResizable(true);
        Dimension min = new Dimension(500, 400);
        this.setMinimumSize(min);
        this.setSize(min);
    }

    public void onOk() {
        if (WriteOtherFileDialog.hasFilenameChanged(this.m_fileNameTextField, this.getNodeModel().getXTProps()) && !ReadOtherFileDialog.checkOverWriteFile(this, this.m_fileNameTextField.getText())) {
            return;
        }
        super.onOk();
    }

    public void restoreProperties() {
        super.restoreProperties();
        XTProps props = this.getNodeModel().getXTProps();
        ReadTextFileDialog.restoreDelimiterComboBox(this.m_delimiterComboBox, m_delimiterChars, this.m_userDefinedDelimiterTextField, props);
        this.m_fileNameTextField.setText(props.getValue("filePath", ""));
        this.m_writeColumnNamesCheckBox.setSelected(props.getBoolean("useColumnNames", true));
        this.m_NAStringTextField.setText(props.getValue("NAString", ""));
        this.m_timeDateFormatComboBox.setText(props.getValue("timeDateFormat", MinerApp.getWorksheetPropertiesManager().getDateFormatString()));
        ReadTextFileDialog.restoreComboBoxChoice(this.m_encodingComboBox, m_encodingStrings, 0, props.getValue("textEncoding", "ASCII"));
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        String path = this.m_fileNameTextField.getText();
        WriteOtherFileDialog.directoryCreationCheck(this.tabbedPane, path);
        props.set("filePath", path);
        ReadTextFileDialog.saveDelimiterFromComboBox(this.m_delimiterComboBox, m_delimiterChars, this.m_userDefinedDelimiterTextField, props);
        props.set("useColumnNames", this.m_writeColumnNamesCheckBox.isSelected());
        props.set("NAString", this.m_NAStringTextField.getText());
        props.set("timeDateFormat", this.m_timeDateFormatComboBox.getText());
        props.set("textEncoding", ReadTextFileDialog.getComboBoxChoice(this.m_encodingComboBox, m_encodingStrings, 0));
    }

    public void createActions() {
        super.createActions();
        this.fileNameTextFieldAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.checkWriteFileName(WriteTextFileDialog.this.m_fileNameTextField, m_extensionList, null);
            }
        };
        this.saveAsAction = new AbstractAction(MinerApp.getText("WriteTextFileDialog_browse")){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.browseWriteFileName(instance, WriteTextFileDialog.this.m_fileNameTextField, m_extensionList, m_typeDescriptionList, null);
            }
        };
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel saveFilePanel = new JPanel(new GridBagLayout());
        this.m_timeDateFormatComboBox = new NodeDialog.DateOutputFormatComboBox();
        Dimension minSize = this.m_timeDateFormatComboBox.getPreferredSize();
        this.m_timeDateFormatComboBox.setMinimumSize(minSize);
        this.m_fileNameTextField = new JTextField(25);
        this.m_fileNameTextField.setAction(this.fileNameTextFieldAction);
        this.m_fileNameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary() && WriteOtherFileDialog.hasFilenameChanged(WriteTextFileDialog.this.m_fileNameTextField, WriteTextFileDialog.this.getNodeModel().getXTProps())) {
                    ReadOtherFileDialog.checkWriteFileName(WriteTextFileDialog.this.m_fileNameTextField, m_extensionList, null);
                }
            }
        });
        JLabel fileNameLabel = new JLabel(MinerApp.getText("WriteTextFileDialog_filename"));
        fileNameLabel.setDisplayedMnemonic(70);
        JButton browseButton = new JButton(this.saveAsAction);
        browseButton.setMnemonic('b');
        fileNameLabel.setLabelFor(browseButton);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridwidth = 2;
        constraints.weightx = 0.0;
        saveFilePanel.add((Component)fileNameLabel, constraints);
        constraints.gridwidth = 6;
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        saveFilePanel.add((Component)this.m_fileNameTextField, constraints);
        constraints.gridx = 8;
        constraints.weightx = 0.0;
        constraints.gridwidth = 2;
        constraints.fill = 0;
        saveFilePanel.add((Component)browseButton, constraints);
        JPanel moreOptionsPanel = new JPanel(new GridBagLayout());
        moreOptionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ReadTextFileDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.m_writeColumnNamesCheckBox = new JCheckBox(MinerApp.getText("WriteTextFileDialog_writeColumnNames"));
        this.m_writeColumnNamesCheckBox.setMnemonic('w');
        JLabel encodingLabel = new JLabel(MinerApp.getText("WriteTextFileDialog_encodingLabel"));
        encodingLabel.setDisplayedMnemonic(88);
        this.m_encodingComboBox = new JComboBox<String>(m_encodingStrings);
        encodingLabel.setLabelFor(this.m_encodingComboBox);
        this.m_encodingComboBox.setEditable(false);
        JLabel delimiterLabel = new JLabel(MinerApp.getText("WriteTextFileDialog_delimiter"));
        delimiterLabel.setDisplayedMnemonic(68);
        this.m_delimiterComboBox = new JComboBox<String>(m_delimiters);
        this.m_delimiterComboBox.setEditable(false);
        this.m_userDefinedDelimiterTextField = new JTextField(10);
        delimiterLabel.setLabelFor(this.m_delimiterComboBox);
        JLabel naLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_missingValString"));
        this.m_NAStringTextField = new JTextField(15);
        this.m_delimiterComboBox.setPreferredSize(this.m_timeDateFormatComboBox.getPreferredSize());
        naLabel.setDisplayedMnemonic('v');
        naLabel.setLabelFor(this.m_NAStringTextField);
        this.m_delimiterComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean userDef = WriteTextFileDialog.this.m_delimiterComboBox.getSelectedIndex() == m_delimiters.length - 1;
                WriteTextFileDialog.this.m_userDefinedDelimiterTextField.setEnabled(userDef);
            }
        });
        JLabel timeDateFormatLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_dateTimeFormat"));
        timeDateFormatLabel.setDisplayedMnemonic('f');
        timeDateFormatLabel.setLabelFor(this.m_timeDateFormatComboBox);
        int gridy = 0;
        Insets bigIndent = new Insets(0, 15, 0, 0);
        Insets smallIndent = new Insets(0, 5, 0, 0);
        Insets none = new Insets(0, 0, 0, 0);
        GridBagConstraints optionsConstraints = new GridBagConstraints();
        optionsConstraints.gridy = gridy++;
        optionsConstraints.anchor = 18;
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.m_writeColumnNamesCheckBox, optionsConstraints);
        optionsConstraints.gridx = 0;
        optionsConstraints.gridy = gridy++;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.insets = none;
        moreOptionsPanel.add((Component)encodingLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 0.4;
        optionsConstraints.insets = bigIndent;
        moreOptionsPanel.add((Component)this.m_encodingComboBox, optionsConstraints);
        optionsConstraints.gridx = 0;
        optionsConstraints.gridy = gridy++;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.insets = none;
        moreOptionsPanel.add((Component)delimiterLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 0.4;
        optionsConstraints.insets = bigIndent;
        moreOptionsPanel.add((Component)this.m_delimiterComboBox, optionsConstraints);
        optionsConstraints.gridx = 2;
        optionsConstraints.weightx = 0.6;
        optionsConstraints.insets = smallIndent;
        moreOptionsPanel.add((Component)this.m_userDefinedDelimiterTextField, optionsConstraints);
        optionsConstraints.gridx = 0;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.gridy = gridy++;
        optionsConstraints.insets = none;
        moreOptionsPanel.add((Component)naLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 0.4;
        optionsConstraints.insets = bigIndent;
        moreOptionsPanel.add((Component)this.m_NAStringTextField, optionsConstraints);
        optionsConstraints.gridy = gridy++;
        optionsConstraints.gridx = 0;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.insets = none;
        moreOptionsPanel.add((Component)timeDateFormatLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 0.4;
        optionsConstraints.weighty = 1.0;
        optionsConstraints.insets = bigIndent;
        moreOptionsPanel.add((Component)this.m_timeDateFormatComboBox, optionsConstraints);
        optionsPanel.add((Component)saveFilePanel, "North");
        optionsPanel.add((Component)moreOptionsPanel, "Center");
        return optionsPanel;
    }
}

