/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.dndtree;

import com.insightful.miner.dndtree.Copyable;
import com.insightful.miner.dndtree.DragOverData;
import com.insightful.miner.dndtree.NodeInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;

public class DefaultNodeInfo
implements Serializable,
NodeInfo,
Copyable,
DragOverData {
    static int INITIALSIZE = 5;
    static int SIZEINCREMENT = 10;
    private DefaultStyledDocument m_document = new DefaultStyledDocument();
    private String m_header;
    private transient int m_nDragOverEffect = 0;

    public DefaultNodeInfo() {
        this("<unnamed node>", "");
    }

    public DefaultNodeInfo(String newhead) {
        this(newhead, "");
    }

    public DefaultNodeInfo(String newhead, String newtxt) {
        this.setTitle(newhead);
        this.setContents(newtxt);
    }

    public DefaultNodeInfo(NodeInfo ni) {
        this(ni.getTitle(), ni.getContents());
    }

    public String getContents() {
        try {
            return this.m_document.getText(0, this.m_document.getLength());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public void setContents(String newtxt) {
        try {
            if (newtxt == null) {
                newtxt = "";
            }
            this.m_document.remove(0, this.m_document.getLength());
            this.m_document.insertString(0, newtxt, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public Object getContentsModel() {
        return this.m_document;
    }

    public String getTitle() {
        return this.m_header;
    }

    public void copyFrom(NodeInfo ni) {
        this.setTitle(ni.getTitle());
        this.setContents(ni.getContents());
    }

    public void setTitle(String newhead) {
        if (newhead == null) {
            newhead = "";
        }
        this.m_header = newhead;
    }

    public String toString() {
        return this.m_header;
    }

    void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    public Copyable copy() {
        return new DefaultNodeInfo(this);
    }

    public int getCurrentEffect() {
        return this.m_nDragOverEffect;
    }

    public void setCurrentEffect(int effect) {
        this.m_nDragOverEffect = effect;
    }
}

