/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.expression;

import com.insightful.cnkjava.CNKObj;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcSplusTransform;
import com.insightful.cnkjava.CNKSplusDateFormat;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerRandom;
import com.insightful.miner.WorksheetPropertiesManager;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.expression.ExpressionParser;
import com.insightful.miner.expression.ParseException;
import com.insightful.miner.expression.SimpleNode;
import com.insightful.miner.expression.Token;
import com.insightful.miner.expression.TokenMgrError;
import com.insightful.splus.util.StringUtilities;
import java.lang.reflect.Constructor;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Random;
import java.util.TimeZone;
import java.util.Vector;

public class ExpressionEvaluator {
    private String m_expression_string = null;
    private boolean m_parse_ok = false;
    private boolean m_eval_tree_ok = false;
    private SimpleNode m_parse_tree_head = null;
    private EvalNode m_eval_tree_head = null;
    private int m_error_line = -1;
    private int m_error_column = -1;
    private String m_error_string = null;
    private XTMetaData[] m_metaDataArray = null;
    private WorksheetPropertiesManager m_worksheetPropertiesManager = null;
    private CNKProcJavaTransform m_dataSourceProc = null;
    private int m_dataSourceRow = 0;
    private long m_dataSourceChunkPosition = 0L;
    private int m_dataSourceChunkRows = 0;
    private int m_expressionType = 0;
    private Random m_random = new MinerRandom();
    private Vector m_evalErrors = new Vector();
    private Date m_date = new Date();
    private Calendar m_calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    private Hashtable m_newColumnHash = null;
    private Vector m_inputDataAccessPrevArrays = null;
    private int m_maxNext = 0;
    public static final int EXPRESSION_TYPE_DOUBLE = 0;
    public static final int EXPRESSION_TYPE_STRING = 1;
    public static final int EXPRESSION_TYPE_DATE_TIME = 2;
    public static final int EXPRESSION_TYPE_LOGICAL = 3;
    public static final int EXPRESSION_TYPE_ANY = 4;
    private double m_lastEvalToDouble;
    private String m_lastEvalToString;
    private long m_lastEvalToDateTime;
    private static LogicalValue m_logicalTrue = new LogicalValue();
    private static LogicalValue m_logicalFalse = new LogicalValue();
    private static LogicalValue m_logicalNA = new LogicalValue();
    private static final double MSECS_PER_DAY = 8.64E7;
    private boolean m_allowDummyTempVars = false;
    private Hashtable m_tempVarHash = null;
    private Vector m_tempVarDefns = null;

    public void setDataSourceMetaData(XTMetaData md) {
        this.setDataSourceMetaData(new XTMetaData[]{md});
    }

    public void setDataSourceMetaData(XTMetaData[] md) {
        this.m_metaDataArray = md;
    }

    public void setDataSource(CNKProcJavaTransform proc) {
        this.m_dataSourceProc = proc;
    }

    public void setWorksheetPropertiesManager(WorksheetPropertiesManager wpm) {
        this.m_worksheetPropertiesManager = wpm;
    }

    public void setDataSourceRow(int row) {
        this.m_dataSourceRow = row;
    }

    public void updatePrevData(int row, int inputRows, int inputRowsAvailable) {
        if (this.m_inputDataAccessPrevArrays != null) {
            for (int i = 0; i < this.m_inputDataAccessPrevArrays.size(); ++i) {
                DataAccessPrevArray la = (DataAccessPrevArray)this.m_inputDataAccessPrevArrays.get(i);
                la.updatePrevData(this.m_dataSourceChunkPosition, inputRows, inputRowsAvailable, row);
            }
        }
        this.tempVarsCalcPushValue();
        this.tempVarsCalcNextValue();
    }

    public void setDataSourceChunkRows(int rows) {
        this.m_dataSourceChunkRows = rows;
    }

    public void setDataSourceChunkPosition(long row) {
        this.m_dataSourceChunkPosition = row;
    }

    public void setExpressionString(String str) {
        this.m_expression_string = str;
        this.m_parse_ok = false;
        this.m_eval_tree_ok = false;
        this.m_error_line = -1;
        this.m_error_column = -1;
        this.m_error_string = null;
    }

    public void setExpressionType(int type) {
        this.m_expressionType = type;
    }

    public void setRandom(Random random) {
        this.m_random = random;
    }

    public void setNewColumnHash(Hashtable tab) {
        this.m_newColumnHash = tab;
    }

    public Vector getReferencedNames() {
        Vector v = new Vector();
        if (this.m_eval_tree_head != null) {
            this.m_eval_tree_head.collectReferencedNames(v);
        }
        return v;
    }

    public boolean constructParseTree() {
        this.m_parse_ok = false;
        this.m_eval_tree_ok = false;
        if (this.m_expression_string == null || this.m_expression_string.trim().equals("")) {
            this.setError(0, 0, MinerApp.getText("ExpressionEvaluater_nullExpressionString"));
            return false;
        }
        try {
            this.m_parse_tree_head = ExpressionParser.parseString(this.m_expression_string);
            this.m_parse_ok = true;
        }
        catch (ParseException ex) {
            this.setError(ex.currentToken.next, MinerApp.getText("ExpressionEvaluater_parseError"));
        }
        catch (TokenMgrError tokenErr) {
            int line = -1;
            int col = -1;
            try {
                String msg = tokenErr.getMessage();
                int lineIndex = msg.indexOf("line ") + 5;
                int lineIndex2 = msg.indexOf(",", lineIndex);
                int colIndex = msg.indexOf("column ", lineIndex2) + 7;
                int colIndex2 = msg.indexOf(".", colIndex);
                line = Integer.parseInt(msg.substring(lineIndex, lineIndex2));
                col = Integer.parseInt(msg.substring(colIndex, colIndex2));
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.setError(line, col, MinerApp.getText("ExpressionEvaluater_parseError"));
        }
        return this.m_parse_ok;
    }

    public String getError() {
        String err = "";
        if (this.m_error_line >= 0 && this.m_error_column >= 0) {
            err = err + "[" + this.m_error_line + "," + this.m_error_column + "] ";
        }
        err = this.m_error_string == null ? err + "unknown error!" : err + this.m_error_string;
        return err;
    }

    public boolean hasError() {
        return this.m_error_string != null;
    }

    public void clearEvalErrors() {
        this.m_evalErrors.clear();
    }

    public boolean hasEvalErrors() {
        return this.m_evalErrors.size() > 0;
    }

    public void addEvalError(String str) {
        this.m_evalErrors.add(str);
    }

    public Vector getEvalErrors() {
        return this.m_evalErrors;
    }

    public String getFormattedError() {
        StringBuffer str = new StringBuffer(this.m_error_string == null ? "no error" : this.m_error_string);
        if (this.m_expression_string != null) {
            int endIndex;
            int line = this.m_error_line;
            int col = this.m_error_column;
            if (line > 1 && col > 0) {
                str.append("    (at line " + line + ", column " + col + ")");
            }
            int strIndex = 0;
            String exprStr = this.m_expression_string;
            for (int i = 1; i < line && strIndex >= 0 && strIndex < exprStr.length(); ++i) {
                if ((strIndex = exprStr.indexOf("\n", strIndex)) < 0) continue;
                ++strIndex;
            }
            if (strIndex >= 0) {
                exprStr = exprStr.substring(strIndex);
            }
            if ((endIndex = exprStr.indexOf("\n")) >= 0) {
                exprStr = exprStr.substring(0, endIndex);
            }
            str.append("\n   " + exprStr);
            if (line > 0 && col > 0) {
                str.append("\n   ");
                for (int j = 1; j < col; ++j) {
                    str.append("-");
                }
                str.append("^");
            }
        }
        return str.toString();
    }

    public boolean constructEvalTree() {
        this.m_allowDummyTempVars = true;
        boolean ok = this.constructEvalTreeInner();
        if (!ok) {
            return false;
        }
        Vector tempVarsDummies = this.m_eval_tree_head.collectNodesInClass(new Class[]{DataAccessTempVarDummy.class});
        if (this.m_tempVarDefns == null && tempVarsDummies == null) {
            return true;
        }
        this.m_allowDummyTempVars = false;
        this.m_tempVarHash = new Hashtable();
        this.tempVarsCalcInitValue();
        ok = this.constructEvalTreeInner();
        return ok;
    }

    private boolean constructEvalTreeInner() {
        this.m_eval_tree_ok = false;
        if (!this.m_parse_ok) {
            this.setError(MinerApp.getText("ExpressionEvaluater_paseNotSuccessful"));
            return false;
        }
        if (this.m_metaDataArray == null) {
            this.setError(MinerApp.getText("ExpressionEvaluater_nullMetaData"));
            return false;
        }
        try {
            this.m_eval_tree_head = this.createEvalNode(this.m_parse_tree_head);
            switch (this.m_expressionType) {
                case 0: {
                    if (this.m_eval_tree_head instanceof EvalToDouble || this.m_eval_tree_head instanceof EvalToLogical) break;
                    throw new EvalTreeException(this.m_eval_tree_head, MinerApp.getText("ExpressionEvaluater_expressionValueMustbeContinuous"));
                }
                case 1: {
                    if (this.m_eval_tree_head instanceof EvalToString) break;
                    throw new EvalTreeException(this.m_eval_tree_head, MinerApp.getText("ExpressionEvaluater_expressionValuemustbeString"));
                }
                case 2: {
                    if (this.m_eval_tree_head instanceof EvalToDateTime) break;
                    throw new EvalTreeException(this.m_eval_tree_head, MinerApp.getText("ExpressionEvaluater_expressionValueMustbeDate"));
                }
                case 3: {
                    if (this.m_eval_tree_head instanceof EvalToLogical) break;
                    throw new EvalTreeException(this.m_eval_tree_head, MinerApp.getText("ExpressionEvaluater_expressionValueMustbeLogical"));
                }
                default: {
                    if (this.m_expressionType == 4) break;
                    throw new EvalTreeException(this.m_eval_tree_head, MinerApp.getText("ExpressionEvaluater_unknownExpressionValueType"));
                }
            }
            this.m_tempVarDefns = this.m_eval_tree_head.collectNodesInClass(new Class[]{DefineTempVar.class});
            this.m_eval_tree_ok = true;
        }
        catch (EvalTreeException ex) {
            this.m_error_line = ex.m_error_line;
            this.m_error_column = ex.m_error_column;
            this.m_error_string = ex.m_error_string;
        }
        return this.m_eval_tree_ok;
    }

    public double getLastEvalToDouble() {
        return this.m_lastEvalToDouble;
    }

    public String getLastEvalToString() {
        return this.m_lastEvalToString;
    }

    public long getLastEvalToDateTime() {
        return this.m_lastEvalToDateTime;
    }

    public double evalToDouble() {
        LogicalValue val;
        this.m_lastEvalToDouble = this.m_eval_tree_head instanceof EvalToDouble ? ((EvalToDouble)((Object)this.m_eval_tree_head)).evalToDouble() : (this.m_eval_tree_head instanceof EvalToLogical ? (ExpressionEvaluator.isLogicalNA(val = ((EvalToLogical)((Object)this.m_eval_tree_head)).evalToLogical()) ? CNKObj.getDoubleNA() : (ExpressionEvaluator.isLogicalFalse(val) ? 0.0 : 1.0)) : CNKObj.getDoubleNA());
        return this.m_lastEvalToDouble;
    }

    public String evalToString() {
        this.m_lastEvalToString = ((EvalToString)((Object)this.m_eval_tree_head)).evalToString();
        return this.m_lastEvalToString;
    }

    public int estimateMaxStringWidth() {
        if (this.m_eval_tree_head == null || !(this.m_eval_tree_head instanceof EvalToString)) {
            return 0;
        }
        int val = ((EvalToString)((Object)this.m_eval_tree_head)).estimateMaxStringWidth();
        return val;
    }

    public long evalToDateTime() {
        this.m_lastEvalToDateTime = ((EvalToDateTime)((Object)this.m_eval_tree_head)).evalToDateTime();
        return this.m_lastEvalToDateTime;
    }

    public LogicalValue evalToLogical() {
        LogicalValue val = ((EvalToLogical)((Object)this.m_eval_tree_head)).evalToLogical();
        this.m_lastEvalToDouble = ExpressionEvaluator.isLogicalNA(val) ? CNKObj.getDoubleNA() : (ExpressionEvaluator.isLogicalTrue(val) ? 1.0 : 0.0);
        return val;
    }

    public void beginEval(CNKProcJavaTransform proc, Random random) {
        this.setDataSource(proc);
        this.setRandom(random);
        this.initDataAccessPrevArrays();
        this.beginChunk(0L, 0);
    }

    private DataAccessPrevArray lookupDataAccessPrevArray(int inputNum, int columnNum) {
        if (this.m_inputDataAccessPrevArrays == null) {
            return null;
        }
        for (int i = 0; i < this.m_inputDataAccessPrevArrays.size(); ++i) {
            DataAccessPrevArray la = (DataAccessPrevArray)this.m_inputDataAccessPrevArrays.get(i);
            if (inputNum != la.getInputNum() || columnNum != la.getColumnNum()) continue;
            return la;
        }
        return null;
    }

    private void initDataAccessPrevArrays() {
        DataAccessPrevArray la;
        int i;
        Vector prevArrayVector = this.m_eval_tree_head.getRequiredDataAccessPrevArrays();
        if (prevArrayVector == null) {
            return;
        }
        this.m_inputDataAccessPrevArrays = null;
        for (i = 0; i < prevArrayVector.size(); ++i) {
            DataAccessPrevArray prevLA;
            la = (DataAccessPrevArray)prevArrayVector.get(i);
            int inputNum = la.getInputNum();
            int columnNum = la.getColumnNum();
            if (this.m_inputDataAccessPrevArrays == null) {
                this.m_inputDataAccessPrevArrays = new Vector();
            }
            if ((prevLA = this.lookupDataAccessPrevArray(inputNum, columnNum)) != null) {
                this.m_inputDataAccessPrevArrays.remove(prevLA);
                la.setPrevMinMax(Math.min(la.getPrevMin(), prevLA.getPrevMin()), Math.max(la.getPrevMax(), prevLA.getPrevMax()));
            }
            this.m_inputDataAccessPrevArrays.add(la);
        }
        this.m_maxNext = 0;
        for (i = 0; this.m_inputDataAccessPrevArrays != null && i < this.m_inputDataAccessPrevArrays.size(); ++i) {
            la = (DataAccessPrevArray)this.m_inputDataAccessPrevArrays.get(i);
            la.initUpdatePrevData();
            this.m_maxNext = Math.max(this.m_maxNext, -la.getPrevMin());
        }
    }

    public int getMaxNext() {
        return this.m_maxNext;
    }

    public void beginChunk(long inputPosition, int inputRows) {
        this.setDataSourceChunkPosition(inputPosition);
        this.setDataSourceChunkRows(inputRows);
        this.beginChunk();
        this.clearEvalErrors();
    }

    public void beginChunk() {
        if (this.m_inputDataAccessPrevArrays != null) {
            for (int i = 0; i < this.m_inputDataAccessPrevArrays.size(); ++i) {
                DataAccessPrevArray la = (DataAccessPrevArray)this.m_inputDataAccessPrevArrays.get(i);
                la.beginChunk();
            }
        }
        this.m_eval_tree_head.beginChunk();
    }

    public void endChunk() {
        this.m_eval_tree_head.endChunk();
    }

    public void cleanup() {
        this.m_inputDataAccessPrevArrays = null;
        if (this.m_eval_tree_head != null) {
            this.m_eval_tree_head.cleanup();
        }
    }

    public void dumpParseTree() {
        this.m_parse_tree_head.dump("");
    }

    public void dumpEvalTree() {
        this.m_eval_tree_head.dump("");
    }

    public boolean needsDataSummary() {
        return this.m_eval_tree_head.needsDataSummary();
    }

    private EvalNode createEvalNode(SimpleNode parseNode) throws EvalTreeException {
        String parseNodeName = parseNode.getName();
        if (parseNodeName.equals("Start")) {
            return this.createEvalNode(ExpressionEvaluator.getNodeChild(parseNode, 0));
        }
        if (parseNodeName.equals("Op")) {
            EvalNode lastEvalNode = this.createEvalNode(ExpressionEvaluator.getNodeChild(parseNode, 0));
            int numChildren = ExpressionEvaluator.getNumChildren(parseNode);
            int opIdx = 1;
            while (opIdx + 1 < numChildren) {
                SimpleNode opParseNode = ExpressionEvaluator.getNodeChild(parseNode, opIdx);
                EvalNode nextEvalNode = this.createEvalNode(ExpressionEvaluator.getNodeChild(parseNode, opIdx + 1));
                lastEvalNode = this.createOpEvalNode(opParseNode, lastEvalNode, nextEvalNode);
                opIdx += 2;
            }
            return lastEvalNode;
        }
        if (parseNodeName.equals("RightAssocOp")) {
            int numChildren = ExpressionEvaluator.getNumChildren(parseNode);
            EvalNode lastEvalNode = this.createEvalNode(ExpressionEvaluator.getNodeChild(parseNode, numChildren - 1));
            for (int opIdx = numChildren - 2; opIdx > 0; opIdx -= 2) {
                SimpleNode opParseNode = ExpressionEvaluator.getNodeChild(parseNode, opIdx);
                EvalNode nextEvalNode = this.createEvalNode(ExpressionEvaluator.getNodeChild(parseNode, opIdx - 1));
                lastEvalNode = this.createOpEvalNode(opParseNode, nextEvalNode, lastEvalNode);
            }
            return lastEvalNode;
        }
        if (parseNodeName.equals("UnaryOp")) {
            SimpleNode opParseNode = ExpressionEvaluator.getNodeChild(parseNode, 0);
            EvalNode argEvalNode = this.createEvalNode(ExpressionEvaluator.getNodeChild(parseNode, 1));
            EvalNode opNode = this.createUnaryOpEvalNode(opParseNode, argEvalNode);
            return opNode;
        }
        if (parseNodeName.equals("Function")) {
            if (ExpressionEvaluator.getNumChildren(parseNode) == 1 && ExpressionEvaluator.getNodeChild(parseNode, 0).getName().equals("Identifier")) {
                String id = ExpressionEvaluator.getNodeChild(parseNode, 0).getValue();
                EvalNode node = this.createDataAccessNode(parseNode, id);
                return node;
            }
            if (ExpressionEvaluator.getNumChildren(parseNode) > 1 && ExpressionEvaluator.getNodeChild(parseNode, 0).getName().equals("Identifier") && ExpressionEvaluator.getNodeChild(parseNode, 1).getName().equals("FunctionArgs")) {
                String fnName = ExpressionEvaluator.getNodeChild(parseNode, 0).getValue();
                EvalNode[] args = new EvalNode[ExpressionEvaluator.getNumChildren(parseNode) - 2];
                for (int i = 2; i < ExpressionEvaluator.getNumChildren(parseNode); ++i) {
                    args[i - 2] = this.createEvalNode(ExpressionEvaluator.getNodeChild(parseNode, i));
                }
                EvalNode node = this.createFunctionEvalNode(parseNode, fnName, args);
                return node;
            }
            throw new EvalTreeException(parseNode, MinerApp.getText("ExpressionEvaluater_badFunctionNode"));
        }
        if (parseNodeName.equals("DoubleConstant")) {
            return new DoubleConstant(parseNode, parseNode.getValue());
        }
        if (parseNodeName.equals("StringConstant")) {
            return new StringConstant(parseNode, parseNode.getValue());
        }
        throw new EvalTreeException(parseNode, MinerApp.getText("ExpressionEvaluater_unknownParseNode"));
    }

    private EvalNode createOpEvalNode(SimpleNode opNode, EvalNode arg1, EvalNode arg2) throws EvalTreeException {
        String opSubclassName = "Op_" + opNode.getName();
        EvalNode node = this.getSubclassInstance(opSubclassName);
        if (node == null) {
            throw new EvalTreeException(opNode, MinerApp.getText("ExpressionEvaluater_unknownOperator"));
        }
        node = node.setArgs(opNode, new EvalNode[]{arg1, arg2});
        return node;
    }

    private EvalNode createUnaryOpEvalNode(SimpleNode opNode, EvalNode arg1) throws EvalTreeException {
        String opSubclassName = "UnaryOp_" + opNode.getName();
        EvalNode node = this.getSubclassInstance(opSubclassName);
        if (node == null) {
            throw new EvalTreeException(opNode, MinerApp.getText("ExpressionEvaluater_unknownOperator"));
        }
        node = node.setArgs(opNode, new EvalNode[]{arg1});
        return node;
    }

    public static int getStringUTF8Length(String val) {
        int ret = 0;
        if (val != null) {
            try {
                ret = val.length();
                ret = val.getBytes("UTF-8").length;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    private EvalNode createDataAccessNode(SimpleNode parseNode, String id) throws EvalTreeException {
        DataAccess node;
        DataInfo dat = new DataInfo(id);
        if (!dat.ok()) {
            DataAccessTempVar tempVarNode = this.createDataAccessTempVar(id);
            if (tempVarNode == null) {
                throw new EvalTreeException(parseNode, "unknown column: \"" + ExpressionEvaluator.addEscapeChars(id) + "\"");
            }
            tempVarNode.setArgs(parseNode, new EvalNode[0]);
            return tempVarNode;
        }
        XTMetaData md = this.m_metaDataArray[dat.m_inputNum];
        if (md.isCategoricalColumn(dat.m_colNum) || md.isStringColumn(dat.m_colNum)) {
            node = new DataAccessString();
        } else if (md.isContinuousColumn(dat.m_colNum)) {
            node = new DataAccessDouble();
        } else if (md.isDateTimeColumn(dat.m_colNum)) {
            node = new DataAccessDateTime();
        } else {
            throw new EvalTreeException(parseNode, "unknown type for column: \"" + ExpressionEvaluator.addEscapeChars(id) + "\"");
        }
        node.setColumnInfo(dat);
        EvalNode initNode = node.setArgs(parseNode, new EvalNode[0]);
        return initNode;
    }

    private EvalNode createFunctionEvalNode(SimpleNode opNode, String fnName, EvalNode[] args) throws EvalTreeException {
        String opSubclassName = "Function_" + fnName;
        EvalNode node = this.getSubclassInstance(opSubclassName);
        if (node == null) {
            throw new EvalTreeException(opNode, MinerApp.getText("ExpressionEvaluater_unknownFunction") + " " + fnName);
        }
        node = node.setArgs(opNode, args);
        return node;
    }

    private EvalNode createNegativeNode(EvalNode arg) throws EvalTreeException {
        EvalNode node = new UnaryOp_Minus();
        node = node.setArgs(new EvalNode[]{arg});
        return node;
    }

    private EvalNode createCoerceToStringNode(EvalNode arg) throws EvalTreeException {
        EvalNode node = new Function_asString();
        node = node.setArgs(new EvalNode[]{arg});
        return node;
    }

    public static LogicalValue getLogicalNA() {
        return m_logicalNA;
    }

    public static LogicalValue getLogicalTrue() {
        return m_logicalTrue;
    }

    public static LogicalValue getLogicalFalse() {
        return m_logicalFalse;
    }

    public static LogicalValue convertByteToLogicalValue(byte val) {
        if (val == 0) {
            return m_logicalFalse;
        }
        if (val == 1) {
            return m_logicalTrue;
        }
        return m_logicalNA;
    }

    public static boolean isLogicalNA(LogicalValue val) {
        return val == null || val == m_logicalNA;
    }

    public static boolean isLogicalTrue(LogicalValue val) {
        return val == m_logicalTrue;
    }

    public static boolean isLogicalFalse(LogicalValue val) {
        return val == m_logicalFalse;
    }

    private EvalNode getSubclassInstance(String subclassName) {
        EvalNode obj = null;
        try {
            int dot;
            String trueSubclassName = subclassName;
            while ((dot = trueSubclassName.indexOf(".")) >= 0) {
                trueSubclassName = trueSubclassName.substring(0, dot) + "DOT" + trueSubclassName.substring(dot + 1);
            }
            Class<?> thisClass = this.getClass();
            Class<?> subclass = Class.forName(thisClass.getName() + "$" + trueSubclassName);
            Constructor<?> subclassConstructor = subclass.getConstructor(thisClass);
            obj = (EvalNode)subclassConstructor.newInstance(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return obj;
    }

    private void setError(int error_line, int error_column, String error_string) {
        this.m_error_line = error_line;
        this.m_error_column = error_column;
        this.m_error_string = error_string;
    }

    private void setError(String error_string) {
        this.setError(-1, -1, error_string);
    }

    private void setError(Token tok, String error_string) {
        this.setError(tok.beginLine, tok.beginColumn, error_string);
    }

    private static int getNumChildren(SimpleNode parseNode) {
        return parseNode.jjtGetNumChildren();
    }

    private static SimpleNode getNodeChild(SimpleNode parseNode, int childNum) {
        return (SimpleNode)parseNode.jjtGetChild(childNum);
    }

    public static String addEscapeChars(String str) {
        StringBuffer retval = new StringBuffer();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }

    public static String removeEscapeChars(String str) throws Exception {
        int numChars = str.length();
        StringBuffer buf = new StringBuffer(numChars);
        for (int i = 0; i < numChars; ++i) {
            if (str.charAt(i) == '\\') {
                char c;
                if ((c = str.charAt(++i)) == 'b') {
                    buf.append('\b');
                    continue;
                }
                if (c == 't') {
                    buf.append('\t');
                    continue;
                }
                if (c == 'n') {
                    buf.append('\n');
                    continue;
                }
                if (c == 'f') {
                    buf.append('\f');
                    continue;
                }
                if (c == 'r') {
                    buf.append('\r');
                    continue;
                }
                if (c == '\"') {
                    buf.append('\"');
                    continue;
                }
                if (c == '\'') {
                    buf.append('\'');
                    continue;
                }
                if (c == '\\') {
                    buf.append('\\');
                    continue;
                }
                buf.append((char)Integer.parseInt(str.substring(i, i + 3), 8));
                i += 2;
                continue;
            }
            buf.append(str.charAt(i));
        }
        return buf.toString();
    }

    public String evalClassToSimpleString(Class cl) {
        if (EvalToDouble.class.isAssignableFrom(cl)) {
            return "double";
        }
        if (EvalToString.class.isAssignableFrom(cl)) {
            return "string";
        }
        if (EvalToDateTime.class.isAssignableFrom(cl)) {
            return "date";
        }
        if (EvalToLogical.class.isAssignableFrom(cl)) {
            return "logical";
        }
        return "?";
    }

    public static int getStringOrFactorWidth(XTMetaData md, int colNum) {
        if (md.isStringColumn(colNum)) {
            double maxCharsInData = md.getColumnMax(colNum);
            int columnWidth = md.getStringDataFieldWidth(colNum) - 1;
            if (!CNKObj.isDoubleNA(maxCharsInData) && maxCharsInData > 0.0 && maxCharsInData < (double)columnWidth) {
                return (int)maxCharsInData;
            }
            return columnWidth;
        }
        if (md.isCategoricalColumn(colNum)) {
            Vector levels = md.getCategoricalDataFieldLevels(md.ordinalToName(colNum));
            int numLevels = levels.size();
            int maxLen = 0;
            for (int i = 0; i < numLevels; ++i) {
                String levelString = (String)levels.get(i);
                maxLen = Math.max(maxLen, ExpressionEvaluator.getStringUTF8Length(levelString));
            }
            return maxLen;
        }
        return 0;
    }

    public boolean isDoubleConstant(EvalNode node) {
        if (node == null) {
            return false;
        }
        if (node instanceof DoubleConstant) {
            return true;
        }
        return (node instanceof UnaryOp_Minus || node instanceof UnaryOp_Plus) && node.m_args.length == 1 && node.m_args[0] instanceof DoubleConstant;
    }

    public double getDoubleConstantValue(EvalNode node) {
        double val = CNKObj.getDoubleNA();
        if (node != null) {
            if (node instanceof DoubleConstant) {
                val = ((DoubleConstant)node).evalToDouble();
            } else if (node instanceof UnaryOp_Minus && node.m_args.length == 1 && node.m_args[0] instanceof DoubleConstant) {
                val = -((DoubleConstant)node.m_args[0]).evalToDouble();
            } else if (node instanceof UnaryOp_Plus && node.m_args.length == 1 && node.m_args[0] instanceof DoubleConstant) {
                val = ((DoubleConstant)node.m_args[0]).evalToDouble();
            }
        }
        return val;
    }

    private DataAccessTempVar createDataAccessTempVar(String varName) {
        DataAccessTempVar var = null;
        if (this.m_allowDummyTempVars) {
            var = new DataAccessTempVarDummy();
        } else {
            Object obj = this.m_tempVarHash.get(varName);
            if (obj != null) {
                if (obj instanceof double[]) {
                    var = new DataAccessTempVarDouble();
                } else if (obj instanceof String[]) {
                    var = new DataAccessTempVarString();
                } else if (obj instanceof long[]) {
                    var = new DataAccessTempVarDateTime();
                } else if (obj instanceof LogicalValue[]) {
                    var = new DataAccessTempVarLogical();
                }
            }
        }
        if (var != null) {
            var.setTempVarName(varName);
        }
        return var;
    }

    public void tempVarsCalcInitValue() {
        if (this.m_tempVarDefns != null) {
            for (int i = 0; i < this.m_tempVarDefns.size(); ++i) {
                DefineTempVar expr = (DefineTempVar)this.m_tempVarDefns.get(i);
                expr.calcInitValue();
            }
        }
    }

    public void tempVarsCalcNextValue() {
        if (this.m_tempVarDefns != null) {
            for (int i = 0; i < this.m_tempVarDefns.size(); ++i) {
                DefineTempVar expr = (DefineTempVar)this.m_tempVarDefns.get(i);
                expr.calcNextValue();
            }
        }
    }

    public void tempVarsCalcPushValue() {
        if (this.m_tempVarDefns != null) {
            for (int i = 0; i < this.m_tempVarDefns.size(); ++i) {
                DefineTempVar expr = (DefineTempVar)this.m_tempVarDefns.get(i);
                expr.calcPushValue();
            }
        }
    }

    public class DataAccessNewString
    extends DataAccessString {
        public String evalToString() {
            ExpressionEvaluator expr = this.getNewExpr();
            return expr == null ? CNKObj.getStringNA() : expr.getLastEvalToString();
        }

        public void collectReferencedNames(Vector v) {
            if (this.m_dat != null && this.m_dat.m_id != null) {
                v.add(this.m_dat.m_id);
            }
        }

        public int estimateMaxStringWidth() {
            int val = ExpressionEvaluator.this.m_worksheetPropertiesManager.getDefaultStringSize() - 1;
            ExpressionEvaluator expr = this.getNewExpr();
            if (expr != null) {
                val = expr.estimateMaxStringWidth();
            }
            return val;
        }
    }

    public class DataAccessNewDateTime
    extends DataAccessDateTime {
        public long evalToDateTime() {
            ExpressionEvaluator expr = this.getNewExpr();
            return expr == null ? CNKObj.getTimeDateNA() : expr.getLastEvalToDateTime();
        }

        public void collectReferencedNames(Vector v) {
            if (this.m_dat != null && this.m_dat.m_id != null) {
                v.add(this.m_dat.m_id);
            }
        }
    }

    public class DataAccessNewDouble
    extends DataAccessDouble {
        public double evalToDouble() {
            ExpressionEvaluator expr = this.getNewExpr();
            return expr == null ? CNKObj.getDoubleNA() : expr.getLastEvalToDouble();
        }

        public void collectReferencedNames(Vector v) {
            if (this.m_dat != null && this.m_dat.m_id != null) {
                v.add(this.m_dat.m_id);
            }
        }
    }

    public class Function_getNew
    extends EvalNode {
        public EvalNode initArgs() throws EvalTreeException {
            DataAccess node;
            int colType;
            this.checkArgs(1);
            String id = null;
            if (this.m_args[0] instanceof DataAccess) {
                id = ((DataAccess)this.m_args[0]).getColumnName();
            } else if (this.m_args[0] instanceof DataAccessTempVar) {
                id = ((DataAccessTempVar)this.m_args[0]).getTempVarName();
            } else if (this.m_args[0] instanceof StringConstant) {
                id = ((StringConstant)this.m_args[0]).evalToString();
            } else {
                throw new EvalTreeException(this.m_parseNode, "getNew's argument must be an identifier or a string constant");
            }
            Object obj = id == null || ExpressionEvaluator.this.m_newColumnHash == null ? null : ExpressionEvaluator.this.m_newColumnHash.get(id);
            int n = colType = obj == null || !(obj instanceof Integer) ? -1 : (Integer)obj;
            if (obj == null || colType < 0) {
                throw new EvalTreeException(this.m_parseNode, "unknown new column");
            }
            DataInfo dat = new DataInfo(id);
            if (colType == 1) {
                node = new DataAccessNewString();
            } else if (colType == 2) {
                node = new DataAccessNewDateTime();
            } else if (colType == 0) {
                node = new DataAccessNewDouble();
            } else {
                throw new EvalTreeException(this.m_parseNode, "unknown type for column: \"" + ExpressionEvaluator.addEscapeChars(id) + "\"");
            }
            node.setColumnInfo(dat);
            EvalNode initNode = node.setArgs(this.m_parseNode, new EvalNode[0]);
            return initNode;
        }
    }

    public class DefineTempVarLogical
    extends DefineTempVar
    implements EvalToLogical {
        public LogicalValue evalToLogical() {
            return ((LogicalValue[])this.getTempObject())[1];
        }

        public void calcInitValue() {
            LogicalValue[] vals = new LogicalValue[2];
            vals[0] = vals[1] = ((EvalToLogical)((Object)this.m_args[1])).evalToLogical();
            this.setTempObject(vals);
        }

        public void calcNextValue() {
            LogicalValue[] vals = (LogicalValue[])this.getTempObject();
            vals[1] = ((EvalToLogical)((Object)this.m_args[2])).evalToLogical();
        }

        public void calcPushValue() {
            LogicalValue[] vals = (LogicalValue[])this.getTempObject();
            vals[0] = vals[1];
        }
    }

    public class DefineTempVarDateTime
    extends DefineTempVar
    implements EvalToDateTime {
        public long evalToDateTime() {
            return ((long[])this.getTempObject())[1];
        }

        public void calcInitValue() {
            long[] vals = new long[2];
            vals[0] = vals[1] = ((EvalToDateTime)((Object)this.m_args[1])).evalToDateTime();
            this.setTempObject(vals);
        }

        public void calcNextValue() {
            long[] vals = (long[])this.getTempObject();
            vals[1] = ((EvalToDateTime)((Object)this.m_args[2])).evalToDateTime();
        }

        public void calcPushValue() {
            long[] vals = (long[])this.getTempObject();
            vals[0] = vals[1];
        }
    }

    public class DefineTempVarDouble
    extends DefineTempVar
    implements EvalToDouble {
        public double evalToDouble() {
            return ((double[])this.getTempObject())[1];
        }

        public void calcInitValue() {
            double[] vals = new double[2];
            vals[0] = vals[1] = ((EvalToDouble)((Object)this.m_args[1])).evalToDouble();
            this.setTempObject(vals);
        }

        public void calcNextValue() {
            double[] vals = (double[])this.getTempObject();
            vals[1] = ((EvalToDouble)((Object)this.m_args[2])).evalToDouble();
        }

        public void calcPushValue() {
            double[] vals = (double[])this.getTempObject();
            vals[0] = vals[1];
        }
    }

    public class DefineTempVarString
    extends DefineTempVar
    implements EvalToString {
        public String evalToString() {
            return ((String[])this.getTempObject())[1];
        }

        public int estimateMaxStringWidth() {
            int newVal;
            int val = ExpressionEvaluator.this.m_worksheetPropertiesManager.getDefaultStringSize() - 1;
            try {
                newVal = ((EvalToString)((Object)this.m_args[1])).estimateMaxStringWidth();
                if (newVal > val) {
                    val = newVal;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                newVal = ((EvalToString)((Object)this.m_args[2])).estimateMaxStringWidth();
                if (newVal > val) {
                    val = newVal;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return val;
        }

        public void calcInitValue() {
            String[] vals = new String[2];
            vals[0] = vals[1] = ((EvalToString)((Object)this.m_args[1])).evalToString();
            this.setTempObject(vals);
        }

        public void calcNextValue() {
            String[] vals = (String[])this.getTempObject();
            vals[1] = ((EvalToString)((Object)this.m_args[2])).evalToString();
        }

        public void calcPushValue() {
            String[] vals = (String[])this.getTempObject();
            vals[0] = vals[1];
        }
    }

    public abstract class DefineTempVar
    extends EvalNode {
        public String m_tempVarName;

        public DefineTempVar() {
            this.m_tempVarName = null;
        }

        public void setTempVarName(String val) {
            this.m_tempVarName = val;
        }

        public String getTempVarName() {
            return this.m_tempVarName;
        }

        public Object getTempObject() {
            return ExpressionEvaluator.this.m_tempVarHash.get(this.m_tempVarName);
        }

        public void setTempObject(Object obj) {
            ExpressionEvaluator.this.m_tempVarHash.put(this.m_tempVarName, obj);
        }

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(3);
            return this;
        }

        public abstract void calcInitValue();

        public abstract void calcNextValue();

        public abstract void calcPushValue();
    }

    public class DataAccessTempVarDummy
    extends DataAccessTempVar
    implements EvalToLogical,
    EvalToDateTime,
    EvalToDouble,
    EvalToString {
        public double evalToDouble() {
            return CNKObj.getDoubleNA();
        }

        public String evalToString() {
            return CNKObj.getStringNA();
        }

        public long evalToDateTime() {
            return CNKObj.getTimeDateNA();
        }

        public LogicalValue evalToLogical() {
            return ExpressionEvaluator.getLogicalNA();
        }

        public int estimateMaxStringWidth() {
            return 0;
        }
    }

    public class DataAccessTempVarLogical
    extends DataAccessTempVar
    implements EvalToLogical {
        public LogicalValue evalToLogical() {
            return ((LogicalValue[])this.getTempObject())[0];
        }
    }

    public class DataAccessTempVarDateTime
    extends DataAccessTempVar
    implements EvalToDateTime {
        public long evalToDateTime() {
            return ((long[])this.getTempObject())[0];
        }
    }

    public class DataAccessTempVarDouble
    extends DataAccessTempVar
    implements EvalToDouble {
        public double evalToDouble() {
            return ((double[])this.getTempObject())[0];
        }
    }

    public class DataAccessTempVarString
    extends DataAccessTempVar
    implements EvalToString {
        public String evalToString() {
            return ((String[])this.getTempObject())[0];
        }

        public int estimateMaxStringWidth() {
            int val = ExpressionEvaluator.this.m_worksheetPropertiesManager.getDefaultStringSize() - 1;
            try {
                int newVal = ExpressionEvaluator.getStringUTF8Length(this.evalToString());
                if (newVal > val) {
                    val = newVal;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return val;
        }
    }

    public class DataAccessTempVar
    extends EvalNode {
        public String m_tempVarName;

        public DataAccessTempVar() {
            this.m_tempVarName = null;
        }

        public void setTempVarName(String val) {
            this.m_tempVarName = val;
        }

        public String getTempVarName() {
            return this.m_tempVarName;
        }

        public Object getTempObject() {
            return ExpressionEvaluator.this.m_tempVarHash.get(this.m_tempVarName);
        }
    }

    public class Function_tempvar
    extends EvalNode {
        String m_tempVarName;

        public Function_tempvar() {
            this.m_tempVarName = null;
        }

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(3);
            EvalNode arg1 = this.m_args[0];
            if (!(arg1 instanceof StringConstant)) {
                throw new EvalTreeException(this.m_parseNode, "first argument must be a string constant");
            }
            this.m_tempVarName = ((StringConstant)arg1).evalToString();
            EvalNode arg2 = this.m_args[1];
            Vector tempVarNodes = arg2.collectNodesInClass(new Class[]{DataAccessTempVar.class, DefineTempVar.class, DataAccess.class, DataAccessPrev.class});
            if (tempVarNodes != null) {
                throw new EvalTreeException(this.m_parseNode, "second argument cannot reference any variables");
            }
            DefineTempVar node = null;
            Class dataClass = null;
            if (arg2 instanceof EvalToDouble) {
                dataClass = EvalToDouble.class;
                node = new DefineTempVarDouble();
            } else if (arg2 instanceof EvalToString) {
                dataClass = EvalToString.class;
                node = new DefineTempVarString();
            } else if (arg2 instanceof EvalToDateTime) {
                dataClass = EvalToDateTime.class;
                node = new DefineTempVarDateTime();
            } else if (arg2 instanceof EvalToLogical) {
                dataClass = EvalToLogical.class;
                node = new DefineTempVarLogical();
            } else {
                throw new EvalTreeException(this.m_parseNode, "unknown type for temp variable: \"" + ExpressionEvaluator.addEscapeChars(this.m_tempVarName) + "\"");
            }
            EvalNode arg3 = this.m_args[2];
            if (dataClass == null || !dataClass.isInstance(arg3)) {
                throw new EvalTreeException(this.m_parseNode, "second and third argument types don't match");
            }
            tempVarNodes = arg3.collectNodesInClass(new Class[]{DefineTempVar.class});
            if (tempVarNodes != null) {
                throw new EvalTreeException(this.m_parseNode, "third argument cannot reference any temp variable definitions");
            }
            node.setTempVarName(this.m_tempVarName);
            EvalNode initNode = node.setArgs(this.m_parseNode, new EvalNode[]{arg1, arg2, arg3});
            return initNode;
        }
    }

    public class Function_Inf
    extends EvalNode
    implements EvalToDouble {
        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(0);
            return this;
        }

        public double evalToDouble() {
            return Double.POSITIVE_INFINITY;
        }
    }

    public class Function_dateUnaryMinus
    extends EvalNode
    implements EvalToDateTime {
        EvalToDateTime m_arg1;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToDateTime.class});
            this.m_arg1 = (EvalToDateTime)((Object)this.m_args[0]);
            return this;
        }

        public long evalToDateTime() {
            long v1 = this.m_arg1.evalToDateTime();
            if (CNKObj.isTimeDateNA(v1)) {
                return CNKObj.getTimeDateNA();
            }
            long val = -v1;
            return val;
        }
    }

    public class Function_dateMinus
    extends EvalNode
    implements EvalToDateTime {
        EvalToDateTime m_arg1;
        EvalToDateTime m_arg2;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToDateTime.class, EvalToDateTime.class});
            this.m_arg1 = (EvalToDateTime)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToDateTime)((Object)this.m_args[1]);
            return this;
        }

        public long evalToDateTime() {
            long v1 = this.m_arg1.evalToDateTime();
            long v2 = this.m_arg2.evalToDateTime();
            if (CNKObj.isTimeDateNA(v1) || CNKObj.isTimeDateNA(v2)) {
                return CNKObj.getTimeDateNA();
            }
            long val = v1 - v2;
            return val;
        }
    }

    public class Function_datePlus
    extends EvalNode
    implements EvalToDateTime {
        EvalToDateTime m_arg1;
        EvalToDateTime m_arg2;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToDateTime.class, EvalToDateTime.class});
            this.m_arg1 = (EvalToDateTime)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToDateTime)((Object)this.m_args[1]);
            return this;
        }

        public long evalToDateTime() {
            long v1 = this.m_arg1.evalToDateTime();
            long v2 = this.m_arg2.evalToDateTime();
            if (CNKObj.isTimeDateNA(v1) || CNKObj.isTimeDateNA(v2)) {
                return CNKObj.getTimeDateNA();
            }
            long val = v1 + v2;
            return val;
        }
    }

    public class Function_asCategorical
    extends Function_asString {
        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(1);
            return super.initArgs();
        }
    }

    public class Function_columnSum
    extends OneIDArgEvalToMetaDataDouble {
        public double getMetaDataValue(int colNum) {
            double meanVal = this.getInputMD().getColumnMean(this.m_colNum);
            double totalRows = this.getInputMD().getNumRows();
            return totalRows * meanVal;
        }
    }

    public class Function_parseDate
    extends Function_asDateFromStringFormat {
    }

    public class Function_formatDate
    extends Function_asStringFromDateTimeFormat {
    }

    public class Function_parseDouble
    extends EvalNode
    implements EvalToDouble {
        EvalToString m_arg1;
        EvalToString m_arg2;
        WorksheetPropertiesManager m_wpm;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToString.class, EvalToString.class});
            this.m_arg1 = (EvalToString)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToString)((Object)this.m_args[1]);
            this.m_wpm = null;
            return this;
        }

        public double evalToDouble() {
            String v1 = this.m_arg1.evalToString();
            if (CNKObj.isStringNA(v1)) {
                return CNKObj.getDoubleNA();
            }
            String v2 = this.m_arg2.evalToString();
            if (CNKObj.isStringNA(v2)) {
                return CNKObj.getDoubleNA();
            }
            if (this.m_wpm == null || !this.m_wpm.getDecimalSymbols().equals(v2)) {
                this.m_wpm = WorksheetPropertiesManager.createWPMForDecimalFormat(v2, 1);
            }
            double val = this.m_wpm.parseFreeDouble(v1);
            return val;
        }
    }

    public class Function_formatDouble
    extends EvalNode
    implements EvalToString {
        EvalToDouble m_arg1;
        EvalToString m_arg2;
        EvalToDouble m_arg3;
        WorksheetPropertiesManager m_wpm;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToDouble.class, EvalToString.class, EvalToDouble.class});
            this.m_arg1 = (EvalToDouble)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToString)((Object)this.m_args[1]);
            this.m_arg3 = (EvalToDouble)((Object)this.m_args[2]);
            this.m_wpm = null;
            return this;
        }

        public String evalToString() {
            double v1 = this.m_arg1.evalToDouble();
            if (CNKObj.isDoubleNA(v1)) {
                return CNKObj.getStringNA();
            }
            String v2 = this.m_arg2.evalToString();
            if (CNKObj.isStringNA(v2)) {
                return CNKObj.getStringNA();
            }
            double v3 = this.m_arg3.evalToDouble();
            if (CNKObj.isDoubleNA(v3)) {
                return CNKObj.getStringNA();
            }
            if (this.m_wpm == null || !this.m_wpm.getDecimalSymbols().equals(v2) || this.m_wpm.getNumDigitsInViewers() != (int)v3) {
                this.m_wpm = WorksheetPropertiesManager.createWPMForDecimalFormat(v2, (int)v3);
            }
            String val = this.m_wpm.formatDouble(v1);
            return val;
        }

        public int estimateMaxStringWidth() {
            return 20;
        }
    }

    public class Function_intToChar
    extends EvalNode
    implements EvalToString {
        EvalToDouble m_arg1;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToDouble.class});
            this.m_arg1 = (EvalToDouble)((Object)this.m_args[0]);
            return this;
        }

        public String evalToString() {
            double dVal = this.m_arg1.evalToDouble();
            if (CNKObj.isDoubleNA(dVal)) {
                return CNKObj.getStringNA();
            }
            int charInt = (int)dVal;
            String val = new String(new char[]{(char)charInt});
            return val;
        }

        public int estimateMaxStringWidth() {
            return 4;
        }
    }

    public class Function_charToInt
    extends EvalNode
    implements EvalToDouble {
        EvalToString m_arg1;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToString.class});
            this.m_arg1 = (EvalToString)((Object)this.m_args[0]);
            return this;
        }

        public double evalToDouble() {
            String v1 = this.m_arg1.evalToString();
            if (CNKObj.isStringNA(v1) || v1.length() < 1) {
                return CNKObj.getDoubleNA();
            }
            char c = v1.charAt(0);
            return c;
        }
    }

    public class Function_totalRows
    extends EvalNode
    implements EvalToDouble {
        boolean m_valOK;
        double m_val;

        public Function_totalRows() {
            this.m_valOK = false;
        }

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(0);
            this.m_valOK = false;
            return this;
        }

        public double evalToDouble() {
            if (!this.m_valOK) {
                this.m_val = ExpressionEvaluator.this.m_metaDataArray[0].getNumRows();
                this.m_valOK = true;
            }
            return this.m_val;
        }

        public void cleanup() {
            this.m_valOK = false;
        }

        public boolean needsDataSummary() {
            return true;
        }
    }

    public class Function_countMissing
    extends OneIDArgEvalToMetaDataDouble {
        public double getMetaDataValue(int colNum) {
            double val = this.getInputMD().getColumnMissingCount(this.m_colNum);
            return val;
        }
    }

    public class Function_columnStdev
    extends OneIDArgEvalToMetaDataDouble {
        public double getMetaDataValue(int colNum) {
            double val = this.getInputMD().getColumnStandardDeviation(this.m_colNum);
            return val;
        }
    }

    public class Function_columnMean
    extends OneIDArgEvalToMetaDataDouble {
        public double getMetaDataValue(int colNum) {
            double val = this.getInputMD().getColumnMean(this.m_colNum);
            return val;
        }
    }

    public class Function_columnMax
    extends OneIDArgEvalToMetaDataDouble {
        public double getMetaDataValue(int colNum) {
            double val = this.getInputMD().getColumnMax(this.m_colNum);
            return val;
        }
    }

    public class Function_columnMin
    extends OneIDArgEvalToMetaDataDouble {
        public double getMetaDataValue(int colNum) {
            double val = this.getInputMD().getColumnMin(this.m_colNum);
            return val;
        }
    }

    public abstract class OneIDArgEvalToMetaDataDouble
    extends EvalNode
    implements EvalToDouble {
        String m_colName;
        int m_colNum;
        int m_inputNum;
        boolean m_valOK;
        double m_val;

        public OneIDArgEvalToMetaDataDouble() {
            this.m_valOK = false;
        }

        public EvalNode initArgs() throws EvalTreeException {
            DataInfo dat;
            this.checkArgs(1);
            if (this.m_args[0] instanceof DataAccess) {
                dat = ((DataAccess)this.m_args[0]).getDataInfo();
            } else if (this.m_args[0] instanceof StringConstant) {
                dat = new DataInfo(((StringConstant)this.m_args[0]).evalToString());
            } else {
                throw new EvalTreeException(this.m_parseNode, MinerApp.getText("ExpressionEvaluater_anIdentifieroraStringConstant"));
            }
            if (!dat.ok()) {
                throw new EvalTreeException(this.m_parseNode, "unknown column: \"" + ExpressionEvaluator.addEscapeChars(dat.m_id) + "\"");
            }
            this.m_colName = dat.m_id;
            this.m_colNum = dat.m_colNum;
            this.m_inputNum = dat.m_inputNum;
            this.m_valOK = false;
            return this;
        }

        public double evalToDouble() {
            if (!this.m_valOK) {
                this.m_val = this.getMetaDataValue(this.m_colNum);
                this.m_valOK = true;
            }
            return this.m_val;
        }

        public void cleanup() {
            this.m_valOK = false;
        }

        public boolean needsDataSummary() {
            return true;
        }

        public abstract double getMetaDataValue(int var1);

        public XTMetaData getInputMD() {
            return ExpressionEvaluator.this.m_metaDataArray[this.m_inputNum];
        }
    }

    public class Function_quarter
    extends OneDateTimeArgEvalToDoubleWithCalendar {
        public double getValFromCalendar(Calendar cal) {
            double val = cal.get(2) / 3 + 1;
            return val;
        }
    }

    public class Function_yearday
    extends OneDateTimeArgEvalToDoubleWithCalendar {
        public double getValFromCalendar(Calendar cal) {
            double val = cal.get(6);
            return val;
        }
    }

    public class Function_workday
    extends EvalNode
    implements EvalToLogical {
        EvalToDateTime m_arg1;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToDateTime.class});
            this.m_arg1 = (EvalToDateTime)((Object)this.m_args[0]);
            return this;
        }

        public LogicalValue evalToLogical() {
            long v1 = this.m_arg1.evalToDateTime();
            if (CNKObj.isTimeDateNA(v1)) {
                return ExpressionEvaluator.getLogicalNA();
            }
            ExpressionEvaluator.this.m_date.setTime(v1);
            ExpressionEvaluator.this.m_calendar.setTime(ExpressionEvaluator.this.m_date);
            double dayOfWeek = ExpressionEvaluator.this.m_calendar.get(7) - 1;
            LogicalValue val = dayOfWeek > 0.0 && dayOfWeek < 6.0 ? ExpressionEvaluator.getLogicalTrue() : ExpressionEvaluator.getLogicalFalse();
            return val;
        }
    }

    public class Function_weekday
    extends OneDateTimeArgEvalToDoubleWithCalendar {
        public double getValFromCalendar(Calendar cal) {
            double val = cal.get(7) - 1;
            return val;
        }
    }

    public class Function_msec
    extends OneDateTimeArgEvalToDoubleWithCalendar {
        public double getValFromCalendar(Calendar cal) {
            double val = cal.get(14);
            return val;
        }
    }

    public class Function_second
    extends OneDateTimeArgEvalToDoubleWithCalendar {
        public double getValFromCalendar(Calendar cal) {
            double val = cal.get(13);
            return val;
        }
    }

    public class Function_minute
    extends OneDateTimeArgEvalToDoubleWithCalendar {
        public double getValFromCalendar(Calendar cal) {
            double val = cal.get(12);
            return val;
        }
    }

    public class Function_hour
    extends OneDateTimeArgEvalToDoubleWithCalendar {
        public double getValFromCalendar(Calendar cal) {
            double val = cal.get(11);
            return val;
        }
    }

    public class Function_day
    extends OneDateTimeArgEvalToDoubleWithCalendar {
        public double getValFromCalendar(Calendar cal) {
            double val = cal.get(5);
            return val;
        }
    }

    public class Function_month
    extends OneDateTimeArgEvalToDoubleWithCalendar {
        public double getValFromCalendar(Calendar cal) {
            double val = cal.get(2) + 1;
            return val;
        }
    }

    public class Function_year
    extends OneDateTimeArgEvalToDoubleWithCalendar {
        public double getValFromCalendar(Calendar cal) {
            double val = cal.get(1);
            return val;
        }
    }

    public abstract class OneDateTimeArgEvalToDoubleWithCalendar
    extends OneDateTimeArgEvalToDouble {
        public double evalToDouble() {
            long v1 = this.m_arg1.evalToDateTime();
            if (CNKObj.isTimeDateNA(v1)) {
                return CNKObj.getDoubleNA();
            }
            ExpressionEvaluator.this.m_date.setTime(v1);
            ExpressionEvaluator.this.m_calendar.setTime(ExpressionEvaluator.this.m_date);
            double val = this.getValFromCalendar(ExpressionEvaluator.this.m_calendar);
            return val;
        }

        public abstract double getValFromCalendar(Calendar var1);
    }

    public class Function_now
    extends EvalNode
    implements EvalToDateTime {
        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(0);
            return this;
        }

        public long evalToDateTime() {
            long val = System.currentTimeMillis();
            return val;
        }
    }

    public class Function_asDateFromYearMonthDayHourMinuteSecondMsec
    extends EvalNode
    implements EvalToDateTime {
        EvalToDouble m_arg1;
        EvalToDouble m_arg2;
        EvalToDouble m_arg3;
        EvalToDouble m_arg4;
        EvalToDouble m_arg5;
        EvalToDouble m_arg6;
        EvalToDouble m_arg7;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToDouble.class, EvalToDouble.class, EvalToDouble.class, EvalToDouble.class, EvalToDouble.class, EvalToDouble.class, EvalToDouble.class});
            this.m_arg1 = (EvalToDouble)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToDouble)((Object)this.m_args[1]);
            this.m_arg3 = (EvalToDouble)((Object)this.m_args[2]);
            this.m_arg4 = (EvalToDouble)((Object)this.m_args[3]);
            this.m_arg5 = (EvalToDouble)((Object)this.m_args[4]);
            this.m_arg6 = (EvalToDouble)((Object)this.m_args[5]);
            this.m_arg7 = (EvalToDouble)((Object)this.m_args[6]);
            return this;
        }

        public long evalToDateTime() {
            double v1 = this.m_arg1.evalToDouble();
            if (CNKObj.isDoubleNA(v1)) {
                return CNKObj.getTimeDateNA();
            }
            double v2 = this.m_arg2.evalToDouble();
            if (CNKObj.isDoubleNA(v2)) {
                return CNKObj.getTimeDateNA();
            }
            double v3 = this.m_arg3.evalToDouble();
            if (CNKObj.isDoubleNA(v3)) {
                return CNKObj.getTimeDateNA();
            }
            double v4 = this.m_arg4.evalToDouble();
            if (CNKObj.isDoubleNA(v4)) {
                return CNKObj.getTimeDateNA();
            }
            double v5 = this.m_arg5.evalToDouble();
            if (CNKObj.isDoubleNA(v5)) {
                return CNKObj.getTimeDateNA();
            }
            double v6 = this.m_arg6.evalToDouble();
            if (CNKObj.isDoubleNA(v6)) {
                return CNKObj.getTimeDateNA();
            }
            double v7 = this.m_arg7.evalToDouble();
            if (CNKObj.isDoubleNA(v7)) {
                return CNKObj.getTimeDateNA();
            }
            ExpressionEvaluator.this.m_calendar.clear();
            ExpressionEvaluator.this.m_calendar.set((int)v1, (int)v2 - 1, (int)v3, (int)v4, (int)v5, (int)v6);
            ExpressionEvaluator.this.m_calendar.set(14, (int)v7);
            long val = ExpressionEvaluator.this.m_calendar.getTime().getTime();
            return val;
        }
    }

    public class Function_asDateFromYearMonthDayHourMinuteSecond
    extends EvalNode
    implements EvalToDateTime {
        EvalToDouble m_arg1;
        EvalToDouble m_arg2;
        EvalToDouble m_arg3;
        EvalToDouble m_arg4;
        EvalToDouble m_arg5;
        EvalToDouble m_arg6;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToDouble.class, EvalToDouble.class, EvalToDouble.class, EvalToDouble.class, EvalToDouble.class, EvalToDouble.class});
            this.m_arg1 = (EvalToDouble)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToDouble)((Object)this.m_args[1]);
            this.m_arg3 = (EvalToDouble)((Object)this.m_args[2]);
            this.m_arg4 = (EvalToDouble)((Object)this.m_args[3]);
            this.m_arg5 = (EvalToDouble)((Object)this.m_args[4]);
            this.m_arg6 = (EvalToDouble)((Object)this.m_args[5]);
            return this;
        }

        public long evalToDateTime() {
            double v1 = this.m_arg1.evalToDouble();
            if (CNKObj.isDoubleNA(v1)) {
                return CNKObj.getTimeDateNA();
            }
            double v2 = this.m_arg2.evalToDouble();
            if (CNKObj.isDoubleNA(v2)) {
                return CNKObj.getTimeDateNA();
            }
            double v3 = this.m_arg3.evalToDouble();
            if (CNKObj.isDoubleNA(v3)) {
                return CNKObj.getTimeDateNA();
            }
            double v4 = this.m_arg4.evalToDouble();
            if (CNKObj.isDoubleNA(v4)) {
                return CNKObj.getTimeDateNA();
            }
            double v5 = this.m_arg5.evalToDouble();
            if (CNKObj.isDoubleNA(v5)) {
                return CNKObj.getTimeDateNA();
            }
            double v6 = this.m_arg6.evalToDouble();
            if (CNKObj.isDoubleNA(v6)) {
                return CNKObj.getTimeDateNA();
            }
            ExpressionEvaluator.this.m_calendar.clear();
            ExpressionEvaluator.this.m_calendar.set((int)v1, (int)v2 - 1, (int)v3, (int)v4, (int)v5, (int)v6);
            long val = ExpressionEvaluator.this.m_calendar.getTime().getTime();
            return val;
        }
    }

    public class Function_asDateFromYearMonthDay
    extends EvalNode
    implements EvalToDateTime {
        EvalToDouble m_arg1;
        EvalToDouble m_arg2;
        EvalToDouble m_arg3;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToDouble.class, EvalToDouble.class, EvalToDouble.class});
            this.m_arg1 = (EvalToDouble)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToDouble)((Object)this.m_args[1]);
            this.m_arg3 = (EvalToDouble)((Object)this.m_args[2]);
            return this;
        }

        public long evalToDateTime() {
            double v1 = this.m_arg1.evalToDouble();
            if (CNKObj.isDoubleNA(v1)) {
                return CNKObj.getTimeDateNA();
            }
            double v2 = this.m_arg2.evalToDouble();
            if (CNKObj.isDoubleNA(v2)) {
                return CNKObj.getTimeDateNA();
            }
            double v3 = this.m_arg3.evalToDouble();
            if (CNKObj.isDoubleNA(v3)) {
                return CNKObj.getTimeDateNA();
            }
            ExpressionEvaluator.this.m_calendar.clear();
            ExpressionEvaluator.this.m_calendar.set((int)v1, (int)v2 - 1, (int)v3);
            long val = ExpressionEvaluator.this.m_calendar.getTime().getTime();
            return val;
        }
    }

    public class Function_asDateFromDouble
    extends EvalNode
    implements EvalToDateTime {
        EvalToDouble m_arg1;

        public EvalNode initArgs() throws EvalTreeException {
            this.m_arg1 = (EvalToDouble)((Object)this.m_args[0]);
            return this;
        }

        public long evalToDateTime() {
            double v1 = this.m_arg1.evalToDouble();
            if (CNKObj.isDoubleNA(v1)) {
                return CNKObj.getTimeDateNA();
            }
            long val = (long)(v1 * 8.64E7 + (double)CNKObj.getDoubleDateEpoch());
            return val;
        }
    }

    public class Function_asJulianMsec
    extends OneDateTimeArgEvalToDouble {
        public double evalToDouble() {
            long v1 = this.m_arg1.evalToDateTime();
            if (CNKObj.isTimeDateNA(v1)) {
                return CNKObj.getDoubleNA();
            }
            long dayInEpoch = v1 - CNKObj.getDoubleDateEpoch();
            double startOfDayJulian = Math.floor((double)dayInEpoch / 8.64E7);
            long startOfDay = (long)(8.64E7 * startOfDayJulian);
            return dayInEpoch - startOfDay;
        }
    }

    public class Function_asJulianDay
    extends OneDateTimeArgEvalToDouble {
        public double evalToDouble() {
            long v1 = this.m_arg1.evalToDateTime();
            if (CNKObj.isTimeDateNA(v1)) {
                return CNKObj.getDoubleNA();
            }
            return Math.floor((double)(v1 - CNKObj.getDoubleDateEpoch()) / 8.64E7);
        }
    }

    public class Function_asJulian
    extends OneDateTimeArgEvalToDouble {
        public double evalToDouble() {
            long v1 = this.m_arg1.evalToDateTime();
            if (CNKObj.isTimeDateNA(v1)) {
                return CNKObj.getDoubleNA();
            }
            return (double)(v1 - CNKObj.getDoubleDateEpoch()) / 8.64E7;
        }
    }

    public class Function_translate
    extends EvalNode
    implements EvalToString {
        EvalToString m_arg1;
        EvalToString m_arg2;
        EvalToString m_arg3;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToString.class, EvalToString.class, EvalToString.class});
            this.m_arg1 = (EvalToString)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToString)((Object)this.m_args[1]);
            this.m_arg3 = (EvalToString)((Object)this.m_args[2]);
            return this;
        }

        public String evalToString() {
            String v1 = this.m_arg1.evalToString();
            if (CNKObj.isStringNA(v1)) {
                return CNKObj.getStringNA();
            }
            String v2 = this.m_arg2.evalToString();
            if (CNKObj.isStringNA(v2)) {
                return CNKObj.getStringNA();
            }
            String v3 = this.m_arg3.evalToString();
            if (CNKObj.isStringNA(v3)) {
                return CNKObj.getStringNA();
            }
            int toLen = v3.length();
            int len = v1.length();
            StringBuffer buf = new StringBuffer(len);
            for (int i = 0; i < len; ++i) {
                char c = v1.charAt(i);
                int fromCharIndex = v2.indexOf(c);
                if (fromCharIndex < 0) {
                    buf.append(c);
                    continue;
                }
                if (fromCharIndex >= toLen) continue;
                buf.append(v3.charAt(fromCharIndex));
            }
            return buf.toString();
        }

        public int estimateMaxStringWidth() {
            return this.m_arg1.estimateMaxStringWidth();
        }
    }

    public class Function_contains
    extends EvalNode
    implements EvalToLogical {
        EvalToString m_arg1;
        EvalToString m_arg2;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToString.class, EvalToString.class});
            this.m_arg1 = (EvalToString)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToString)((Object)this.m_args[1]);
            return this;
        }

        public LogicalValue evalToLogical() {
            String v1 = this.m_arg1.evalToString();
            if (CNKObj.isStringNA(v1)) {
                return ExpressionEvaluator.getLogicalNA();
            }
            String v2 = this.m_arg2.evalToString();
            if (CNKObj.isStringNA(v2)) {
                return ExpressionEvaluator.getLogicalNA();
            }
            if (v1.indexOf(v2) >= 0) {
                return ExpressionEvaluator.getLogicalTrue();
            }
            return ExpressionEvaluator.getLogicalFalse();
        }
    }

    public class Function_endsWith
    extends EvalNode
    implements EvalToLogical {
        EvalToString m_arg1;
        EvalToString m_arg2;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToString.class, EvalToString.class});
            this.m_arg1 = (EvalToString)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToString)((Object)this.m_args[1]);
            return this;
        }

        public LogicalValue evalToLogical() {
            String v1 = this.m_arg1.evalToString();
            if (CNKObj.isStringNA(v1)) {
                return ExpressionEvaluator.getLogicalNA();
            }
            String v2 = this.m_arg2.evalToString();
            if (CNKObj.isStringNA(v2)) {
                return ExpressionEvaluator.getLogicalNA();
            }
            if (v1.endsWith(v2)) {
                return ExpressionEvaluator.getLogicalTrue();
            }
            return ExpressionEvaluator.getLogicalFalse();
        }
    }

    public class Function_startsWith
    extends EvalNode
    implements EvalToLogical {
        EvalToString m_arg1;
        EvalToString m_arg2;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToString.class, EvalToString.class});
            this.m_arg1 = (EvalToString)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToString)((Object)this.m_args[1]);
            return this;
        }

        public LogicalValue evalToLogical() {
            String v1 = this.m_arg1.evalToString();
            if (CNKObj.isStringNA(v1)) {
                return ExpressionEvaluator.getLogicalNA();
            }
            String v2 = this.m_arg2.evalToString();
            if (CNKObj.isStringNA(v2)) {
                return ExpressionEvaluator.getLogicalNA();
            }
            if (v1.startsWith(v2)) {
                return ExpressionEvaluator.getLogicalTrue();
            }
            return ExpressionEvaluator.getLogicalFalse();
        }
    }

    public class Function_lastIndexOf
    extends Function_indexOf {
        public double evalToDouble() {
            double v3;
            String v1 = this.m_arg1.evalToString();
            if (CNKObj.isStringNA(v1)) {
                return CNKObj.getDoubleNA();
            }
            String v2 = this.m_arg2.evalToString();
            if (CNKObj.isStringNA(v2)) {
                return CNKObj.getDoubleNA();
            }
            int len = v1.length();
            if (this.m_arg3 == null) {
                v3 = len + 1;
            } else {
                v3 = this.m_arg3.evalToDouble();
                if (CNKObj.isDoubleNA(v3)) {
                    return CNKObj.getDoubleNA();
                }
            }
            int n3 = (int)Math.round(v3) - 1;
            int intVal = v1.lastIndexOf(v2, n3);
            return intVal < 0 ? -1.0 : (double)(intVal + 1);
        }
    }

    public class Function_indexOf
    extends EvalNode
    implements EvalToDouble {
        EvalToString m_arg1;
        EvalToString m_arg2;
        EvalToDouble m_arg3;

        public EvalNode initArgs() throws EvalTreeException {
            if (this.m_args.length == 2) {
                this.checkArgs(new Class[]{EvalToString.class, EvalToString.class});
                this.m_arg1 = (EvalToString)((Object)this.m_args[0]);
                this.m_arg2 = (EvalToString)((Object)this.m_args[1]);
                this.m_arg3 = null;
            } else if (this.m_args.length == 3) {
                this.checkArgs(new Class[]{EvalToString.class, EvalToString.class, EvalToDouble.class});
                this.m_arg1 = (EvalToString)((Object)this.m_args[0]);
                this.m_arg2 = (EvalToString)((Object)this.m_args[1]);
                this.m_arg3 = (EvalToDouble)((Object)this.m_args[2]);
            } else {
                throw new EvalTreeException(this.m_parseNode, MinerApp.getText("ExpressionEvaluater_given") + " " + this.m_args.length + " " + MinerApp.getText("ExpressionEvaluater_shouldHave2or3Args"));
            }
            return this;
        }

        public double evalToDouble() {
            double v3;
            String v1 = this.m_arg1.evalToString();
            if (CNKObj.isStringNA(v1)) {
                return CNKObj.getDoubleNA();
            }
            String v2 = this.m_arg2.evalToString();
            if (CNKObj.isStringNA(v2)) {
                return CNKObj.getDoubleNA();
            }
            if (this.m_arg3 == null) {
                v3 = 1.0;
            } else {
                v3 = this.m_arg3.evalToDouble();
                if (CNKObj.isDoubleNA(v3)) {
                    return CNKObj.getDoubleNA();
                }
            }
            int n3 = (int)Math.round(v3) - 1;
            int intVal = v1.indexOf(v2, n3);
            return intVal < 0 ? -1.0 : (double)(intVal + 1);
        }
    }

    public class Function_substring
    extends EvalNode
    implements EvalToString {
        EvalToString m_arg1;
        EvalToDouble m_arg2;
        EvalToDouble m_arg3;

        public EvalNode initArgs() throws EvalTreeException {
            if (this.m_args.length == 2) {
                this.checkArgs(new Class[]{EvalToString.class, EvalToDouble.class});
                this.m_arg1 = (EvalToString)((Object)this.m_args[0]);
                this.m_arg2 = (EvalToDouble)((Object)this.m_args[1]);
                this.m_arg3 = null;
            } else if (this.m_args.length == 3) {
                this.checkArgs(new Class[]{EvalToString.class, EvalToDouble.class, EvalToDouble.class});
                this.m_arg1 = (EvalToString)((Object)this.m_args[0]);
                this.m_arg2 = (EvalToDouble)((Object)this.m_args[1]);
                this.m_arg3 = (EvalToDouble)((Object)this.m_args[2]);
            } else {
                throw new EvalTreeException(this.m_parseNode, MinerApp.getText("ExpressionEvaluater_given") + " " + this.m_args.length + " " + MinerApp.getText("ExpressionEvaluater_shouldHave2or3Args"));
            }
            return this;
        }

        public String evalToString() {
            double v3;
            String v1 = this.m_arg1.evalToString();
            if (CNKObj.isStringNA(v1)) {
                return CNKObj.getStringNA();
            }
            double v2 = this.m_arg2.evalToDouble();
            if (CNKObj.isDoubleNA(v2)) {
                return CNKObj.getStringNA();
            }
            int len = v1.length();
            if (this.m_arg3 == null) {
                v3 = len;
            } else {
                v3 = this.m_arg3.evalToDouble();
                if (CNKObj.isDoubleNA(v3)) {
                    return CNKObj.getStringNA();
                }
            }
            int n2 = Math.max(0, Math.min(len, (int)Math.round(v2) - 1));
            int n3 = Math.max(n2, Math.min(len, (int)Math.round(v3)));
            String val = v1.substring(n2, n3);
            return val;
        }

        public int estimateMaxStringWidth() {
            return this.m_arg1.estimateMaxStringWidth();
        }
    }

    public class Function_lowerCase
    extends OneStringArgEvalToString {
        public String evalToString() {
            String v1 = this.m_arg1.evalToString();
            if (CNKObj.isStringNA(v1)) {
                return CNKObj.getStringNA();
            }
            return v1.toLowerCase();
        }

        public int estimateMaxStringWidth() {
            return this.m_arg1.estimateMaxStringWidth();
        }
    }

    public class Function_upperCase
    extends OneStringArgEvalToString {
        public String evalToString() {
            String v1 = this.m_arg1.evalToString();
            if (CNKObj.isStringNA(v1)) {
                return CNKObj.getStringNA();
            }
            return v1.toUpperCase();
        }

        public int estimateMaxStringWidth() {
            return this.m_arg1.estimateMaxStringWidth();
        }
    }

    public class Function_trim
    extends OneStringArgEvalToString {
        public String evalToString() {
            String v1 = this.m_arg1.evalToString();
            if (CNKObj.isStringNA(v1)) {
                return CNKObj.getStringNA();
            }
            return v1.trim();
        }

        public int estimateMaxStringWidth() {
            return this.m_arg1.estimateMaxStringWidth();
        }
    }

    public class Function_nchar
    extends EvalNode
    implements EvalToDouble {
        EvalToString m_arg1;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToString.class});
            this.m_arg1 = (EvalToString)((Object)this.m_args[0]);
            return this;
        }

        public double evalToDouble() {
            String v1 = this.m_arg1.evalToString();
            if (CNKObj.isStringNA(v1)) {
                return CNKObj.getDoubleNA();
            }
            return v1.length();
        }
    }

    public class Function_splusDate
    extends SplusEvalNode
    implements EvalToDateTime {
        long[] m_data;
        boolean m_evalOK;

        public Function_splusDate() {
            this.m_data = null;
        }

        public String getSplusTypeCoercion(String str) {
            return "as(" + str + ",\"timeDate\")";
        }

        public long evalToDateTime() {
            if (!this.m_chunkFetched) {
                if (this.m_data == null || this.m_data.length < ExpressionEvaluator.this.m_dataSourceChunkRows) {
                    this.m_data = new long[ExpressionEvaluator.this.m_dataSourceChunkRows];
                }
                this.m_evalOK = this.getSplusTransformProc().spyEvalToDateTimes(ExpressionEvaluator.this.m_dataSourceProc, this.m_data, ExpressionEvaluator.this.m_dataSourceChunkRows);
                if (!this.m_evalOK) {
                    this.reportSplusTransformError();
                }
                this.m_chunkFetched = true;
            }
            if (this.m_evalOK) {
                return this.m_data[ExpressionEvaluator.this.m_dataSourceRow];
            }
            return CNKObj.getTimeDateNA();
        }
    }

    public class Function_splusString
    extends SplusEvalNode
    implements EvalToString {
        String[] m_data;
        boolean m_evalOK;

        public Function_splusString() {
            this.m_data = null;
        }

        public String getSplusTypeCoercion(String str) {
            return "as.character(" + str + ")";
        }

        public String evalToString() {
            if (!this.m_chunkFetched) {
                if (this.m_data == null || this.m_data.length < ExpressionEvaluator.this.m_dataSourceChunkRows) {
                    this.m_data = new String[ExpressionEvaluator.this.m_dataSourceChunkRows];
                }
                this.m_evalOK = this.getSplusTransformProc().spyEvalToStrings(ExpressionEvaluator.this.m_dataSourceProc, this.m_data, ExpressionEvaluator.this.m_dataSourceChunkRows);
                if (!this.m_evalOK) {
                    this.reportSplusTransformError();
                }
                this.m_chunkFetched = true;
            }
            if (this.m_evalOK) {
                return this.m_data[ExpressionEvaluator.this.m_dataSourceRow];
            }
            return CNKObj.getStringNA();
        }

        public int estimateMaxStringWidth() {
            return 32;
        }
    }

    public class Function_splusLogical
    extends SplusEvalNode
    implements EvalToLogical {
        byte[] m_data;
        boolean m_evalOK;

        public Function_splusLogical() {
            this.m_data = null;
        }

        public String getSplusTypeCoercion(String str) {
            return "as.logical(" + str + ")";
        }

        public LogicalValue evalToLogical() {
            if (!this.m_chunkFetched) {
                if (this.m_data == null || this.m_data.length < ExpressionEvaluator.this.m_dataSourceChunkRows) {
                    this.m_data = new byte[ExpressionEvaluator.this.m_dataSourceChunkRows];
                }
                this.m_evalOK = this.getSplusTransformProc().spyEvalToLogicals(ExpressionEvaluator.this.m_dataSourceProc, this.m_data, ExpressionEvaluator.this.m_dataSourceChunkRows);
                if (!this.m_evalOK) {
                    this.reportSplusTransformError();
                }
                this.m_chunkFetched = true;
            }
            if (this.m_evalOK) {
                return ExpressionEvaluator.convertByteToLogicalValue(this.m_data[ExpressionEvaluator.this.m_dataSourceRow]);
            }
            return ExpressionEvaluator.getLogicalNA();
        }
    }

    public class Function_splusDouble
    extends SplusEvalNode
    implements EvalToDouble {
        double[] m_data;
        boolean m_evalOK;

        public Function_splusDouble() {
            this.m_data = null;
        }

        public String getSplusTypeCoercion(String str) {
            return "as.double(" + str + ")";
        }

        public double evalToDouble() {
            if (!this.m_chunkFetched) {
                if (this.m_data == null || this.m_data.length < ExpressionEvaluator.this.m_dataSourceChunkRows) {
                    this.m_data = new double[ExpressionEvaluator.this.m_dataSourceChunkRows];
                }
                this.m_evalOK = this.getSplusTransformProc().spyEvalToDoubles(ExpressionEvaluator.this.m_dataSourceProc, this.m_data, ExpressionEvaluator.this.m_dataSourceChunkRows);
                if (!this.m_evalOK) {
                    this.reportSplusTransformError();
                }
                this.m_chunkFetched = true;
            }
            if (this.m_evalOK) {
                return this.m_data[ExpressionEvaluator.this.m_dataSourceRow];
            }
            return CNKObj.getDoubleNA();
        }
    }

    public abstract class SplusEvalNode
    extends EvalNode {
        String m_splusExpr;
        CNKProcSplusTransform m_splusProc;
        boolean m_chunkFetched;

        public SplusEvalNode() {
            this.m_splusProc = null;
            this.m_chunkFetched = false;
        }

        public void beginChunk() {
            this.m_chunkFetched = false;
        }

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(1);
            if (!MinerApp.isSplusLicensed()) {
                throw new EvalTreeException(this.m_parseNode, MinerApp.getText("ExpressionEvaluater_splusComsNotInstalled"));
            }
            if (!(this.m_args[0] instanceof StringConstant)) {
                throw new EvalTreeException(this.m_parseNode, MinerApp.getText("ExpressionEvaluater_argumentMustbeStringConstant"));
            }
            this.m_splusExpr = ((StringConstant)this.m_args[0]).evalToString();
            if (!this.doesSplusExpressionParse(this.m_splusExpr)) {
                throw new EvalTreeException(this.m_args[0], MinerApp.getText("ExpressionEvaluater_splusArgumentDoesnotParse"));
            }
            return this;
        }

        protected boolean doesSplusExpressionParse(String expr) {
            CNKProcSplusTransform proc = new CNKProcSplusTransform();
            boolean ok = proc.doesSplusExpressionParse(expr);
            proc.destroyCNKObj();
            return ok;
        }

        protected CNKProcSplusTransform getSplusTransformProc() {
            if (this.m_splusProc == null) {
                this.m_splusProc = new CNKProcSplusTransform();
                String evalExpr = "eval(parse(text=\"" + StringUtilities.escapeSpecialCharacters((String)this.m_splusExpr.replace('\n', ' ')) + "\"),local=X)";
                String transformFn = "function(X){" + this.getSplusTypeCoercion(evalExpr) + "}";
                this.m_splusProc.setTransform(transformFn);
            }
            return this.m_splusProc;
        }

        public abstract String getSplusTypeCoercion(String var1);

        public void cleanup() {
            if (this.m_splusProc != null) {
                this.m_splusProc.destroyCNKObj();
                this.m_splusProc = null;
            }
        }

        public void reportSplusTransformError() {
            String fullError = "error evaluating Splus expression " + this.m_splusExpr.replace('\n', ' ') + " on rows " + (ExpressionEvaluator.this.m_dataSourceChunkPosition + 1L) + " through " + (ExpressionEvaluator.this.m_dataSourceChunkPosition + (long)ExpressionEvaluator.this.m_dataSourceChunkRows);
            if (this.m_splusProc != null && this.m_splusProc.hasError()) {
                fullError = fullError + ": " + this.m_splusProc.getError();
            }
            ExpressionEvaluator.this.addEvalError(fullError);
        }
    }

    public class Function_bitNOT
    extends OneDoubleArgEvalToDouble {
        public double evalToDouble() {
            double v1 = this.m_arg1.evalToDouble();
            if (CNKObj.isDoubleNA(v1)) {
                return CNKObj.getDoubleNA();
            }
            double val = ~((int)v1);
            return val;
        }
    }

    public class Function_bitXOR
    extends TwoDoubleArgEvalToDouble {
        public double evalToDouble() {
            double v1 = this.m_arg1.evalToDouble();
            if (CNKObj.isDoubleNA(v1)) {
                return CNKObj.getDoubleNA();
            }
            double v2 = this.m_arg2.evalToDouble();
            if (CNKObj.isDoubleNA(v2)) {
                return CNKObj.getDoubleNA();
            }
            double val = (int)v1 ^ (int)v2;
            return val;
        }
    }

    public class Function_bitOR
    extends TwoDoubleArgEvalToDouble {
        public double evalToDouble() {
            double v1 = this.m_arg1.evalToDouble();
            if (CNKObj.isDoubleNA(v1)) {
                return CNKObj.getDoubleNA();
            }
            double v2 = this.m_arg2.evalToDouble();
            if (CNKObj.isDoubleNA(v2)) {
                return CNKObj.getDoubleNA();
            }
            double val = (int)v1 | (int)v2;
            return val;
        }
    }

    public class Function_bitAND
    extends TwoDoubleArgEvalToDouble {
        public double evalToDouble() {
            double v1 = this.m_arg1.evalToDouble();
            if (CNKObj.isDoubleNA(v1)) {
                return CNKObj.getDoubleNA();
            }
            double v2 = this.m_arg2.evalToDouble();
            if (CNKObj.isDoubleNA(v2)) {
                return CNKObj.getDoubleNA();
            }
            double val = (int)v1 & (int)v2;
            return val;
        }
    }

    public class Function_randomGaussian
    extends Function_random {
        public double evalToDouble() {
            return ExpressionEvaluator.this.m_random.nextGaussian();
        }
    }

    public class Function_random
    extends EvalNode
    implements EvalToDouble {
        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(0);
            return this;
        }

        public double evalToDouble() {
            return ExpressionEvaluator.this.m_random.nextDouble();
        }
    }

    public class Function_atan
    extends OneDoubleArgEvalToDouble {
        public double evalToDouble() {
            double val = Math.atan(this.m_arg1.evalToDouble());
            return val;
        }
    }

    public class Function_acos
    extends OneDoubleArgEvalToDouble {
        public double evalToDouble() {
            double val = Math.acos(this.m_arg1.evalToDouble());
            return val;
        }
    }

    public class Function_asin
    extends OneDoubleArgEvalToDouble {
        public double evalToDouble() {
            double val = Math.asin(this.m_arg1.evalToDouble());
            return val;
        }
    }

    public class Function_tan
    extends OneDoubleArgEvalToDouble {
        public double evalToDouble() {
            double val = Math.tan(this.m_arg1.evalToDouble());
            return val;
        }
    }

    public class Function_cos
    extends OneDoubleArgEvalToDouble {
        public double evalToDouble() {
            double val = Math.cos(this.m_arg1.evalToDouble());
            return val;
        }
    }

    public class Function_sin
    extends OneDoubleArgEvalToDouble {
        public double evalToDouble() {
            double val = Math.sin(this.m_arg1.evalToDouble());
            return val;
        }
    }

    public class Function_sqrt
    extends OneDoubleArgEvalToDouble {
        public double evalToDouble() {
            double val = Math.sqrt(this.m_arg1.evalToDouble());
            return val;
        }
    }

    public class Op_Exponentiation
    extends TwoDoubleArgEvalToDouble {
        public double evalToDouble() {
            double val = Math.pow(this.m_arg1.evalToDouble(), this.m_arg2.evalToDouble());
            return val;
        }
    }

    public class Function_log10
    extends OneDoubleArgEvalToDouble {
        public double evalToDouble() {
            double val = Math.log(this.m_arg1.evalToDouble()) / Math.log(10.0);
            return val;
        }
    }

    public class Function_log
    extends OneDoubleArgEvalToDouble {
        public double evalToDouble() {
            double val = Math.log(this.m_arg1.evalToDouble());
            return val;
        }
    }

    public class Function_exp
    extends OneDoubleArgEvalToDouble {
        public double evalToDouble() {
            double val = Math.exp(this.m_arg1.evalToDouble());
            return val;
        }
    }

    public class Function_int
    extends OneDoubleArgEvalToDouble {
        public double evalToDouble() {
            double v1 = this.m_arg1.evalToDouble();
            if (CNKObj.isDoubleNA(v1)) {
                return CNKObj.getDoubleNA();
            }
            if (v1 >= 0.0) {
                return Math.floor(v1);
            }
            return Math.ceil(v1);
        }
    }

    public class Function_round
    extends OneDoubleArgEvalToDouble {
        public double evalToDouble() {
            double val = Math.rint(this.m_arg1.evalToDouble());
            return val;
        }
    }

    public class Function_floor
    extends OneDoubleArgEvalToDouble {
        public double evalToDouble() {
            double val = Math.floor(this.m_arg1.evalToDouble());
            return val;
        }
    }

    public class Function_ceiling
    extends OneDoubleArgEvalToDouble {
        public double evalToDouble() {
            double val = Math.ceil(this.m_arg1.evalToDouble());
            return val;
        }
    }

    public class Function_abs
    extends OneDoubleArgEvalToDouble {
        public double evalToDouble() {
            double val = Math.abs(this.m_arg1.evalToDouble());
            return val;
        }
    }

    public class Function_max
    extends TwoDoubleArgEvalToDouble {
        public double evalToDouble() {
            double val = Math.max(this.m_arg1.evalToDouble(), this.m_arg2.evalToDouble());
            return val;
        }
    }

    public class Function_min
    extends TwoDoubleArgEvalToDouble {
        public double evalToDouble() {
            double val = Math.min(this.m_arg1.evalToDouble(), this.m_arg2.evalToDouble());
            return val;
        }
    }

    public class Function_dataRow
    extends EvalNode
    implements EvalToDouble {
        public double evalToDouble() {
            return ExpressionEvaluator.this.m_dataSourceChunkPosition + (long)ExpressionEvaluator.this.m_dataSourceRow + 1L;
        }
    }

    public class Function_chunkNumRows
    extends EvalNode
    implements EvalToDouble {
        public double evalToDouble() {
            return ExpressionEvaluator.this.m_dataSourceChunkRows;
        }
    }

    public class Function_chunkRow
    extends EvalNode
    implements EvalToDouble {
        public double evalToDouble() {
            return (double)ExpressionEvaluator.this.m_dataSourceRow + 1.0;
        }
    }

    public class Function_asDouble
    extends EvalNode
    implements EvalToDouble {
        EvalToString m_arg1;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(1);
            this.checkArgClass(0, new Class[]{EvalToString.class, EvalToDouble.class});
            if (this.m_args[0] instanceof EvalToString) {
                this.m_arg1 = (EvalToString)((Object)this.m_args[0]);
                return this;
            }
            return this.m_args[0];
        }

        public double evalToDouble() {
            String v1 = this.m_arg1.evalToString();
            if (CNKObj.isStringNA(v1)) {
                return CNKObj.getDoubleNA();
            }
            try {
                double val = ExpressionEvaluator.this.m_worksheetPropertiesManager.parseFreeDouble(v1);
                return val;
            }
            catch (Exception ex) {
                return CNKObj.getDoubleNA();
            }
        }
    }

    public class Function_asDateFromStringFormat
    extends EvalNode
    implements EvalToDateTime {
        EvalToString m_arg1;
        EvalToString m_arg2;
        CNKSplusDateFormat m_parser;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToString.class, EvalToString.class});
            this.m_arg1 = (EvalToString)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToString)((Object)this.m_args[1]);
            this.m_parser = new CNKSplusDateFormat();
            this.m_parser.setFormat(ExpressionEvaluator.this.m_worksheetPropertiesManager.getDateParseString());
            this.m_parser.setCenturyCutoff(ExpressionEvaluator.this.m_worksheetPropertiesManager.getCenturyCutoff());
            return this;
        }

        public long evalToDateTime() {
            String v1 = this.m_arg1.evalToString();
            if (CNKObj.isStringNA(v1)) {
                return CNKObj.getTimeDateNA();
            }
            String v2 = this.m_arg2.evalToString();
            if (CNKObj.isStringNA(v2)) {
                return CNKObj.getTimeDateNA();
            }
            this.m_parser.setFormat(v2);
            long val = this.m_parser.convertStringToTimeDate(v1);
            return val;
        }
    }

    public class Function_asDateFromString
    extends EvalNode
    implements EvalToDateTime {
        EvalToString m_arg1;
        CNKSplusDateFormat m_parser;

        public EvalNode initArgs() throws EvalTreeException {
            this.m_arg1 = (EvalToString)((Object)this.m_args[0]);
            this.m_parser = ExpressionEvaluator.this.m_worksheetPropertiesManager.getDateParser();
            return this;
        }

        public long evalToDateTime() {
            String v1 = this.m_arg1.evalToString();
            long v2 = this.m_parser.convertStringToTimeDate(v1);
            return v2;
        }
    }

    public class Function_asDate
    extends EvalNode {
        public EvalNode initArgs() throws EvalTreeException {
            if (this.m_args.length == 2) {
                EvalNode node = new Function_asDateFromStringFormat();
                node = node.setArgs(this.m_parseNode, this.m_args);
                return node;
            }
            if (this.m_args.length == 3) {
                EvalNode node = new Function_asDateFromYearMonthDay();
                node = node.setArgs(this.m_parseNode, this.m_args);
                return node;
            }
            if (this.m_args.length == 6) {
                EvalNode node = new Function_asDateFromYearMonthDayHourMinuteSecond();
                node = node.setArgs(this.m_parseNode, this.m_args);
                return node;
            }
            if (this.m_args.length == 7) {
                EvalNode node = new Function_asDateFromYearMonthDayHourMinuteSecondMsec();
                node = node.setArgs(this.m_parseNode, this.m_args);
                return node;
            }
            if (this.m_args.length != 1) {
                throw new EvalTreeException(this.m_parseNode, MinerApp.getText("ExpressionEvaluater_badNumberArguments"));
            }
            this.checkArgs(1);
            EvalNode node = this.m_args[0];
            if (node instanceof EvalToString) {
                node = new Function_asDateFromString();
            } else if (node instanceof EvalToDouble) {
                node = new Function_asDateFromDouble();
            } else {
                if (node instanceof EvalToDateTime) {
                    return node;
                }
                throw new EvalTreeException(this.m_parseNode, MinerApp.getText("ExpressionEvaluater_badArgumentType"));
            }
            node = node.setArgs(this.m_parseNode, this.m_args);
            return node;
        }
    }

    public class Function_asDateFromJulianMsec
    extends EvalNode
    implements EvalToDateTime {
        EvalToDouble m_arg1;
        EvalToDouble m_arg2;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToDouble.class, EvalToDouble.class});
            this.m_arg1 = (EvalToDouble)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToDouble)((Object)this.m_args[1]);
            return this;
        }

        public long evalToDateTime() {
            double v1 = this.m_arg1.evalToDouble();
            if (CNKObj.isDoubleNA(v1)) {
                return CNKObj.getTimeDateNA();
            }
            double v2 = this.m_arg2.evalToDouble();
            if (CNKObj.isDoubleNA(v2)) {
                return CNKObj.getTimeDateNA();
            }
            long startOfDay = (long)(v1 * 8.64E7);
            long offsetInDay = (long)v2;
            return startOfDay + offsetInDay + CNKObj.getDoubleDateEpoch();
        }
    }

    public class Function_asDateFromJulian
    extends EvalNode {
        public EvalNode initArgs() throws EvalTreeException {
            if (this.m_args.length == 2) {
                EvalNode node = new Function_asDateFromJulianMsec();
                node = node.setArgs(this.m_parseNode, this.m_args);
                return node;
            }
            if (this.m_args.length != 1) {
                throw new EvalTreeException(this.m_parseNode, MinerApp.getText("ExpressionEvaluater_badNumberArguments"));
            }
            this.checkArgs(1);
            EvalNode node = this.m_args[0];
            if (!(node instanceof EvalToDouble)) {
                throw new EvalTreeException(this.m_parseNode, MinerApp.getText("ExpressionEvaluater_badArgumentType"));
            }
            node = new Function_asDateFromDouble();
            node = node.setArgs(this.m_parseNode, this.m_args);
            return node;
        }
    }

    public class Function_oneof
    extends EvalNode
    implements EvalToLogical {
        public boolean m_doubleObjs;
        public boolean m_dateTimeObjs;
        public boolean m_stringObjs;
        public boolean m_logicalObjs;

        public Function_oneof() {
            this.m_doubleObjs = false;
            this.m_dateTimeObjs = false;
            this.m_stringObjs = false;
            this.m_logicalObjs = false;
        }

        public EvalNode initArgs() throws EvalTreeException {
            if (this.m_args.length < 2) {
                throw new EvalTreeException(this.m_parseNode, "oneof() must take at least two arguments");
            }
            for (int i = 0; i < this.m_args.length; ++i) {
                if (this.m_args[i] != null) continue;
                throw new EvalTreeException(this.m_parseNode, "oneof() argument number " + (i + 1) + " is null");
            }
            boolean gotObj = false;
            for (int i = 0; i < this.m_args.length; ++i) {
                EvalNode obj = this.m_args[i];
                if (obj instanceof Function_NA) continue;
                if (!gotObj) {
                    if (obj instanceof EvalToDouble) {
                        this.m_doubleObjs = true;
                    } else if (obj instanceof EvalToDateTime) {
                        this.m_dateTimeObjs = true;
                    } else if (obj instanceof EvalToString) {
                        this.m_stringObjs = true;
                    } else if (obj instanceof EvalToLogical) {
                        this.m_logicalObjs = true;
                    } else {
                        throw new EvalTreeException(this.m_parseNode, "oneof() argument number " + (i + 1) + " has unknown type");
                    }
                    gotObj = true;
                    continue;
                }
                if (!(this.m_doubleObjs && !(obj instanceof EvalToDouble) || this.m_dateTimeObjs && !(obj instanceof EvalToDateTime) || this.m_stringObjs && !(obj instanceof EvalToString)) && (!this.m_logicalObjs || obj instanceof EvalToLogical)) continue;
                throw new EvalTreeException(this.m_parseNode, "oneof() argument number " + (i + 1) + " has wrong type");
            }
            if (!gotObj) {
                this.m_doubleObjs = true;
            }
            return this;
        }

        public LogicalValue evalToLogical() {
            LogicalValue logicalVal;
            double doubleVal = this.m_doubleObjs ? ((EvalToDouble)((Object)this.m_args[0])).evalToDouble() : 0.0;
            long dateTimeVal = this.m_dateTimeObjs ? ((EvalToDateTime)((Object)this.m_args[0])).evalToDateTime() : 0L;
            String stringVal = this.m_stringObjs ? ((EvalToString)((Object)this.m_args[0])).evalToString() : null;
            LogicalValue logicalValue = logicalVal = this.m_logicalObjs ? ((EvalToLogical)((Object)this.m_args[0])).evalToLogical() : null;
            if (this.m_doubleObjs && CNKObj.isDoubleNA(doubleVal) || this.m_dateTimeObjs && CNKObj.isTimeDateNA(dateTimeVal) || this.m_stringObjs && CNKObj.isStringNA(stringVal) || this.m_logicalObjs && ExpressionEvaluator.isLogicalNA(logicalVal)) {
                return ExpressionEvaluator.getLogicalNA();
            }
            for (int i = 1; i < this.m_args.length; ++i) {
                if (this.m_doubleObjs) {
                    double cmp = ((EvalToDouble)((Object)this.m_args[i])).evalToDouble();
                    if (CNKObj.isDoubleNA(cmp)) {
                        return ExpressionEvaluator.getLogicalNA();
                    }
                    if (cmp != doubleVal) continue;
                    return ExpressionEvaluator.getLogicalTrue();
                }
                if (this.m_dateTimeObjs) {
                    long cmp = ((EvalToDateTime)((Object)this.m_args[i])).evalToDateTime();
                    if (CNKObj.isTimeDateNA(cmp)) {
                        return ExpressionEvaluator.getLogicalNA();
                    }
                    if (cmp != dateTimeVal) continue;
                    return ExpressionEvaluator.getLogicalTrue();
                }
                if (this.m_stringObjs) {
                    String cmp = ((EvalToString)((Object)this.m_args[i])).evalToString();
                    if (CNKObj.isStringNA(cmp)) {
                        return ExpressionEvaluator.getLogicalNA();
                    }
                    if (!cmp.equals(stringVal)) continue;
                    return ExpressionEvaluator.getLogicalTrue();
                }
                if (!this.m_logicalObjs) continue;
                LogicalValue cmp = ((EvalToLogical)((Object)this.m_args[i])).evalToLogical();
                if (ExpressionEvaluator.isLogicalNA(cmp)) {
                    return ExpressionEvaluator.getLogicalNA();
                }
                if ((!ExpressionEvaluator.isLogicalTrue(cmp) || !ExpressionEvaluator.isLogicalTrue(logicalVal)) && (!ExpressionEvaluator.isLogicalFalse(cmp) || !ExpressionEvaluator.isLogicalFalse(logicalVal))) continue;
                return ExpressionEvaluator.getLogicalTrue();
            }
            return ExpressionEvaluator.getLogicalFalse();
        }
    }

    public class Function_ifequalLogical
    extends Function_ifequal
    implements EvalToLogical {
        public EvalNode initArgs() throws EvalTreeException {
            return this;
        }

        public LogicalValue evalToLogical() {
            int valIndex = this.getSelectedClause();
            if (valIndex < 1) {
                return ExpressionEvaluator.getLogicalNA();
            }
            return ((EvalToLogical)((Object)this.m_args[valIndex])).evalToLogical();
        }
    }

    public class Function_ifequalString
    extends Function_ifequal
    implements EvalToString {
        public EvalNode initArgs() throws EvalTreeException {
            return this;
        }

        public String evalToString() {
            int valIndex = this.getSelectedClause();
            if (valIndex < 1) {
                return CNKObj.getStringNA();
            }
            return ((EvalToString)((Object)this.m_args[valIndex])).evalToString();
        }

        public int estimateMaxStringWidth() {
            int ret = 0;
            for (int i = 2; i < this.m_args.length - 1; i += 2) {
                EvalToString v1 = (EvalToString)((Object)this.m_args[i]);
                ret = Math.max(ret, v1.estimateMaxStringWidth());
            }
            ret = Math.max(ret, ((EvalToString)((Object)this.m_args[this.m_args.length - 1])).estimateMaxStringWidth());
            return ret;
        }
    }

    public class Function_ifequalDateTime
    extends Function_ifequal
    implements EvalToDateTime {
        public EvalNode initArgs() throws EvalTreeException {
            return this;
        }

        public long evalToDateTime() {
            int valIndex = this.getSelectedClause();
            if (valIndex < 1) {
                return CNKObj.getTimeDateNA();
            }
            return ((EvalToDateTime)((Object)this.m_args[valIndex])).evalToDateTime();
        }
    }

    public class Function_ifequalDouble
    extends Function_ifequal
    implements EvalToDouble {
        public EvalNode initArgs() throws EvalTreeException {
            return this;
        }

        public double evalToDouble() {
            int valIndex = this.getSelectedClause();
            if (valIndex < 1) {
                return CNKObj.getDoubleNA();
            }
            return ((EvalToDouble)((Object)this.m_args[valIndex])).evalToDouble();
        }
    }

    public class Function_ifequal
    extends EvalNode {
        public boolean m_doubleObjs;
        public boolean m_dateTimeObjs;
        public boolean m_stringObjs;
        public boolean m_logicalObjs;

        public Function_ifequal() {
            this.m_doubleObjs = false;
            this.m_dateTimeObjs = false;
            this.m_stringObjs = false;
            this.m_logicalObjs = false;
        }

        public EvalNode initArgs() throws EvalTreeException {
            if (this.m_args.length < 4 || this.m_args.length % 2 != 0) {
                throw new EvalTreeException(this.m_parseNode, "ifequal must take an even number of arguments >=4");
            }
            for (int i = 0; i < this.m_args.length; ++i) {
                if (this.m_args[i] != null) continue;
                throw new EvalTreeException(this.m_parseNode, "ifequal argument number " + (i + 1) + " is null");
            }
            boolean gotObj = false;
            boolean doubleObjs = false;
            boolean dateTimeObjs = false;
            boolean stringObjs = false;
            boolean logicalObjs = false;
            int i = 0;
            while (i < this.m_args.length - 1) {
                EvalNode obj = this.m_args[i];
                if (!(obj instanceof Function_NA)) {
                    if (!gotObj) {
                        if (obj instanceof EvalToDouble) {
                            doubleObjs = true;
                        } else if (obj instanceof EvalToDateTime) {
                            dateTimeObjs = true;
                        } else if (obj instanceof EvalToString) {
                            stringObjs = true;
                        } else if (obj instanceof EvalToLogical) {
                            logicalObjs = true;
                        } else {
                            throw new EvalTreeException(this.m_parseNode, "ifequal argument number " + (i + 1) + " has unknown type");
                        }
                        gotObj = true;
                    } else if (doubleObjs && !(obj instanceof EvalToDouble) || dateTimeObjs && !(obj instanceof EvalToDateTime) || stringObjs && !(obj instanceof EvalToString) || logicalObjs && !(obj instanceof EvalToLogical)) {
                        throw new EvalTreeException(this.m_parseNode, "ifequal argument number " + (i + 1) + " has wrong type");
                    }
                }
                i = i == 0 ? i + 1 : i + 2;
            }
            if (!gotObj) {
                doubleObjs = true;
            }
            boolean gotVal = false;
            boolean doubleVals = false;
            boolean dateTimeVals = false;
            boolean stringVals = false;
            boolean logicalVals = false;
            int i2 = 2;
            while (i2 < this.m_args.length) {
                EvalNode val = this.m_args[i2];
                if (!(val instanceof Function_NA)) {
                    if (!gotVal) {
                        if (val instanceof EvalToDouble) {
                            doubleVals = true;
                        } else if (val instanceof EvalToDateTime) {
                            dateTimeVals = true;
                        } else if (val instanceof EvalToString) {
                            stringVals = true;
                        } else if (val instanceof EvalToLogical) {
                            logicalVals = true;
                        } else {
                            throw new EvalTreeException(this.m_parseNode, "ifequal argument number " + (i2 + 1) + " has unknown type");
                        }
                        gotVal = true;
                    } else if (doubleVals && !(val instanceof EvalToDouble) || dateTimeVals && !(val instanceof EvalToDateTime) || stringVals && !(val instanceof EvalToString) || logicalVals && !(val instanceof EvalToLogical)) {
                        throw new EvalTreeException(this.m_parseNode, "ifequal argument number " + (i2 + 1) + " has wrong type");
                    }
                }
                i2 = i2 == this.m_args.length - 2 ? i2 + 1 : i2 + 2;
            }
            if (!gotVal) {
                doubleVals = true;
            }
            Function_ifequal node = null;
            if (doubleVals) {
                node = new Function_ifequalDouble();
            } else if (dateTimeVals) {
                node = new Function_ifequalDateTime();
            } else if (stringVals) {
                node = new Function_ifequalString();
            } else if (logicalVals) {
                node = new Function_ifequalLogical();
            }
            node.m_doubleObjs = doubleObjs;
            node.m_dateTimeObjs = dateTimeObjs;
            node.m_stringObjs = stringObjs;
            node.m_logicalObjs = logicalObjs;
            node.setArgs(this.m_parseNode, this.m_args);
            return node;
        }

        protected int getSelectedClause() {
            LogicalValue logicalVal;
            double doubleVal = this.m_doubleObjs ? ((EvalToDouble)((Object)this.m_args[0])).evalToDouble() : 0.0;
            long dateTimeVal = this.m_dateTimeObjs ? ((EvalToDateTime)((Object)this.m_args[0])).evalToDateTime() : 0L;
            String stringVal = this.m_stringObjs ? ((EvalToString)((Object)this.m_args[0])).evalToString() : null;
            LogicalValue logicalValue = logicalVal = this.m_logicalObjs ? ((EvalToLogical)((Object)this.m_args[0])).evalToLogical() : null;
            if (this.m_doubleObjs && CNKObj.isDoubleNA(doubleVal) || this.m_dateTimeObjs && CNKObj.isTimeDateNA(dateTimeVal) || this.m_stringObjs && CNKObj.isStringNA(stringVal) || this.m_logicalObjs && ExpressionEvaluator.isLogicalNA(logicalVal)) {
                return 0;
            }
            for (int i = 1; i < this.m_args.length - 1; i += 2) {
                if (this.m_doubleObjs) {
                    double cmp = ((EvalToDouble)((Object)this.m_args[i])).evalToDouble();
                    if (CNKObj.isDoubleNA(cmp)) {
                        return 0;
                    }
                    if (cmp != doubleVal) continue;
                    return i + 1;
                }
                if (this.m_dateTimeObjs) {
                    long cmp = ((EvalToDateTime)((Object)this.m_args[i])).evalToDateTime();
                    if (CNKObj.isTimeDateNA(cmp)) {
                        return 0;
                    }
                    if (cmp != dateTimeVal) continue;
                    return i + 1;
                }
                if (this.m_stringObjs) {
                    String cmp = ((EvalToString)((Object)this.m_args[i])).evalToString();
                    if (CNKObj.isStringNA(cmp)) {
                        return 0;
                    }
                    if (!cmp.equals(stringVal)) continue;
                    return i + 1;
                }
                if (!this.m_logicalObjs) continue;
                LogicalValue cmp = ((EvalToLogical)((Object)this.m_args[i])).evalToLogical();
                if (ExpressionEvaluator.isLogicalNA(cmp)) {
                    return 0;
                }
                if ((!ExpressionEvaluator.isLogicalTrue(cmp) || !ExpressionEvaluator.isLogicalTrue(logicalVal)) && (!ExpressionEvaluator.isLogicalFalse(cmp) || !ExpressionEvaluator.isLogicalFalse(logicalVal))) continue;
                return i + 1;
            }
            return this.m_args.length - 1;
        }
    }

    public class Function_ifelseLogical
    extends Function_ifelse
    implements EvalToLogical {
        public EvalNode initArgs() throws EvalTreeException {
            return this;
        }

        public LogicalValue evalToLogical() {
            int valIndex = this.getSelectedClause();
            if (valIndex < 1) {
                return ExpressionEvaluator.getLogicalNA();
            }
            return ((EvalToLogical)((Object)this.m_args[valIndex])).evalToLogical();
        }
    }

    public class Function_ifelseString
    extends Function_ifelse
    implements EvalToString {
        public EvalNode initArgs() throws EvalTreeException {
            return this;
        }

        public String evalToString() {
            int valIndex = this.getSelectedClause();
            if (valIndex < 1) {
                return CNKObj.getStringNA();
            }
            return ((EvalToString)((Object)this.m_args[valIndex])).evalToString();
        }

        public int estimateMaxStringWidth() {
            int ret = 0;
            for (int i = 1; i < this.m_args.length - 1; i += 2) {
                EvalToString v1 = (EvalToString)((Object)this.m_args[i]);
                ret = Math.max(ret, v1.estimateMaxStringWidth());
            }
            ret = Math.max(ret, ((EvalToString)((Object)this.m_args[this.m_args.length - 1])).estimateMaxStringWidth());
            return ret;
        }
    }

    public class Function_ifelseDateTime
    extends Function_ifelse
    implements EvalToDateTime {
        public EvalNode initArgs() throws EvalTreeException {
            return this;
        }

        public long evalToDateTime() {
            int valIndex = this.getSelectedClause();
            if (valIndex < 1) {
                return CNKObj.getTimeDateNA();
            }
            return ((EvalToDateTime)((Object)this.m_args[valIndex])).evalToDateTime();
        }
    }

    public class Function_ifelseDouble
    extends Function_ifelse
    implements EvalToDouble {
        public EvalNode initArgs() throws EvalTreeException {
            return this;
        }

        public double evalToDouble() {
            int valIndex = this.getSelectedClause();
            if (valIndex < 1) {
                return CNKObj.getDoubleNA();
            }
            return ((EvalToDouble)((Object)this.m_args[valIndex])).evalToDouble();
        }
    }

    public class Function_ifelse
    extends EvalNode {
        public EvalNode initArgs() throws EvalTreeException {
            int i;
            if (this.m_args.length < 3 || this.m_args.length % 2 == 0) {
                throw new EvalTreeException(this.m_parseNode, "ifelse must take an odd number of arguments >=3");
            }
            for (i = 0; i < this.m_args.length; ++i) {
                if (this.m_args[i] != null) continue;
                throw new EvalTreeException(this.m_parseNode, "ifelse argument number " + (i + 1) + " is null");
            }
            for (i = 0; i < this.m_args.length - 1; i += 2) {
                if (this.m_args[i] instanceof EvalToLogical) continue;
                throw new EvalTreeException(this.m_parseNode, "ifelse argument number " + (i + 1) + " should be a logical expression");
            }
            boolean gotVal = false;
            boolean doubleVals = false;
            boolean dateTimeVals = false;
            boolean stringVals = false;
            boolean logicalVals = false;
            int i2 = 1;
            while (i2 < this.m_args.length) {
                EvalNode val = this.m_args[i2];
                if (!(val instanceof Function_NA)) {
                    if (!gotVal) {
                        if (val instanceof EvalToDouble) {
                            doubleVals = true;
                        } else if (val instanceof EvalToDateTime) {
                            dateTimeVals = true;
                        } else if (val instanceof EvalToString) {
                            stringVals = true;
                        } else if (val instanceof EvalToLogical) {
                            logicalVals = true;
                        } else {
                            throw new EvalTreeException(this.m_parseNode, "ifelse argument number " + (i2 + 1) + " has unknown type");
                        }
                        gotVal = true;
                    } else if (doubleVals && !(val instanceof EvalToDouble) || dateTimeVals && !(val instanceof EvalToDateTime) || stringVals && !(val instanceof EvalToString) || logicalVals && !(val instanceof EvalToLogical)) {
                        throw new EvalTreeException(this.m_parseNode, "ifelse argument number " + (i2 + 1) + " has wrong type");
                    }
                }
                i2 = i2 + 2 == this.m_args.length ? i2 + 1 : i2 + 2;
            }
            if (!gotVal) {
                doubleVals = true;
            }
            Function_ifelse node = null;
            if (doubleVals) {
                node = new Function_ifelseDouble();
            } else if (dateTimeVals) {
                node = new Function_ifelseDateTime();
            } else if (stringVals) {
                node = new Function_ifelseString();
            } else if (logicalVals) {
                node = new Function_ifelseLogical();
            }
            node.setArgs(this.m_parseNode, this.m_args);
            return node;
        }

        protected int getSelectedClause() {
            for (int i = 0; i < this.m_args.length - 1; i += 2) {
                LogicalValue v1 = ((EvalToLogical)((Object)this.m_args[i])).evalToLogical();
                if (ExpressionEvaluator.isLogicalNA(v1)) {
                    return 0;
                }
                if (!ExpressionEvaluator.isLogicalTrue(v1)) continue;
                return i + 1;
            }
            return this.m_args.length - 1;
        }
    }

    public class Function_isNALogical
    extends EvalNode
    implements EvalToLogical {
        EvalToLogical m_arg1;

        public EvalNode initArgs() throws EvalTreeException {
            this.m_arg1 = (EvalToLogical)((Object)this.m_args[0]);
            return this;
        }

        public LogicalValue evalToLogical() {
            LogicalValue v1 = this.m_arg1.evalToLogical();
            if (ExpressionEvaluator.isLogicalNA(v1)) {
                return ExpressionEvaluator.getLogicalTrue();
            }
            return ExpressionEvaluator.getLogicalFalse();
        }
    }

    public class Function_isNAString
    extends EvalNode
    implements EvalToLogical {
        EvalToString m_arg1;

        public EvalNode initArgs() throws EvalTreeException {
            this.m_arg1 = (EvalToString)((Object)this.m_args[0]);
            return this;
        }

        public LogicalValue evalToLogical() {
            String v1 = this.m_arg1.evalToString();
            if (CNKObj.isStringNA(v1)) {
                return ExpressionEvaluator.getLogicalTrue();
            }
            return ExpressionEvaluator.getLogicalFalse();
        }
    }

    public class Function_isNADateTime
    extends EvalNode
    implements EvalToLogical {
        EvalToDateTime m_arg1;

        public EvalNode initArgs() throws EvalTreeException {
            this.m_arg1 = (EvalToDateTime)((Object)this.m_args[0]);
            return this;
        }

        public LogicalValue evalToLogical() {
            long v1 = this.m_arg1.evalToDateTime();
            if (CNKObj.isTimeDateNA(v1)) {
                return ExpressionEvaluator.getLogicalTrue();
            }
            return ExpressionEvaluator.getLogicalFalse();
        }
    }

    public class Function_isNADouble
    extends EvalNode
    implements EvalToLogical {
        EvalToDouble m_arg1;

        public EvalNode initArgs() throws EvalTreeException {
            this.m_arg1 = (EvalToDouble)((Object)this.m_args[0]);
            return this;
        }

        public LogicalValue evalToLogical() {
            double v1 = this.m_arg1.evalToDouble();
            if (CNKObj.isDoubleNA(v1)) {
                return ExpressionEvaluator.getLogicalTrue();
            }
            return ExpressionEvaluator.getLogicalFalse();
        }
    }

    public class Function_isNA
    extends EvalNode {
        public EvalNode initArgs() throws EvalTreeException {
            EvalNode node;
            this.checkArgs(1);
            EvalNode arg1 = this.m_args[0];
            if (arg1 instanceof EvalToDouble) {
                node = new Function_isNADouble();
            } else if (arg1 instanceof EvalToDateTime) {
                node = new Function_isNADateTime();
            } else if (arg1 instanceof EvalToString) {
                node = new Function_isNAString();
            } else if (arg1 instanceof EvalToLogical) {
                node = new Function_isNALogical();
            } else {
                throw new EvalTreeException(this.m_parseNode, MinerApp.getText("ExpressionEvaluater_badArgumentType"));
            }
            node = node.setArgs(this.m_parseNode, this.m_args);
            return node;
        }
    }

    public class Function_isDOTna
    extends Function_isNA {
    }

    public class Function_NA
    extends EvalNode
    implements EvalToDouble,
    EvalToString,
    EvalToDateTime,
    EvalToLogical {
        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(0);
            return this;
        }

        public double evalToDouble() {
            return CNKObj.getDoubleNA();
        }

        public String evalToString() {
            return CNKObj.getStringNA();
        }

        public long evalToDateTime() {
            return CNKObj.getTimeDateNA();
        }

        public LogicalValue evalToLogical() {
            return ExpressionEvaluator.getLogicalNA();
        }

        public int estimateMaxStringWidth() {
            return 3;
        }
    }

    public class Op_LE
    extends Op_Compare {
        public LogicalValue evalToLogical() {
            return this.evalCompareToLogical(true, true, false);
        }
    }

    public class Op_GE
    extends Op_Compare {
        public LogicalValue evalToLogical() {
            return this.evalCompareToLogical(false, true, true);
        }
    }

    public class Op_LT
    extends Op_Compare {
        public LogicalValue evalToLogical() {
            return this.evalCompareToLogical(true, false, false);
        }
    }

    public class Op_GT
    extends Op_Compare {
        public LogicalValue evalToLogical() {
            return this.evalCompareToLogical(false, false, true);
        }
    }

    public class Op_NE
    extends Op_Compare {
        public boolean compareLogicalsOk() {
            return true;
        }

        public LogicalValue evalToLogical() {
            return this.evalCompareToLogical(true, false, true);
        }
    }

    public class Op_EQ
    extends Op_Compare {
        public boolean compareLogicalsOk() {
            return true;
        }

        public LogicalValue evalToLogical() {
            return this.evalCompareToLogical(false, true, false);
        }
    }

    public class Op_CompareLogical
    extends EvalNode
    implements EvalToDouble {
        EvalToLogical m_arg1;
        EvalToLogical m_arg2;

        public EvalNode initArgs() throws EvalTreeException {
            this.m_arg1 = (EvalToLogical)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToLogical)((Object)this.m_args[1]);
            return this;
        }

        public double evalToDouble() {
            LogicalValue v1 = this.m_arg1.evalToLogical();
            if (ExpressionEvaluator.isLogicalNA(v1)) {
                return CNKObj.getDoubleNA();
            }
            LogicalValue v2 = this.m_arg2.evalToLogical();
            if (ExpressionEvaluator.isLogicalNA(v2)) {
                return CNKObj.getDoubleNA();
            }
            if (ExpressionEvaluator.isLogicalFalse(v1)) {
                return ExpressionEvaluator.isLogicalFalse(v2) ? 0.0 : 1.0;
            }
            return ExpressionEvaluator.isLogicalFalse(v2) ? 1.0 : 0.0;
        }
    }

    public class Op_CompareString
    extends EvalNode
    implements EvalToDouble {
        EvalToString m_arg1;
        EvalToString m_arg2;

        public EvalNode initArgs() throws EvalTreeException {
            this.m_arg1 = (EvalToString)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToString)((Object)this.m_args[1]);
            return this;
        }

        public double evalToDouble() {
            String v1 = this.m_arg1.evalToString();
            if (CNKObj.isStringNA(v1)) {
                return CNKObj.getDoubleNA();
            }
            String v2 = this.m_arg2.evalToString();
            if (CNKObj.isStringNA(v2)) {
                return CNKObj.getDoubleNA();
            }
            return v1.compareTo(v2);
        }
    }

    public class Op_CompareDateTime
    extends EvalNode
    implements EvalToDouble {
        EvalToDateTime m_arg1;
        EvalToDateTime m_arg2;

        public EvalNode initArgs() throws EvalTreeException {
            this.m_arg1 = (EvalToDateTime)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToDateTime)((Object)this.m_args[1]);
            return this;
        }

        public double evalToDouble() {
            long v1 = this.m_arg1.evalToDateTime();
            if (CNKObj.isTimeDateNA(v1)) {
                return CNKObj.getDoubleNA();
            }
            long v2 = this.m_arg2.evalToDateTime();
            if (CNKObj.isTimeDateNA(v2)) {
                return CNKObj.getDoubleNA();
            }
            if (v1 < v2) {
                return -1.0;
            }
            if (v1 > v2) {
                return 1.0;
            }
            return 0.0;
        }
    }

    public class Op_CompareDouble
    extends EvalNode
    implements EvalToDouble {
        EvalToDouble m_arg1;
        EvalToDouble m_arg2;

        public EvalNode initArgs() throws EvalTreeException {
            this.m_arg1 = (EvalToDouble)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToDouble)((Object)this.m_args[1]);
            return this;
        }

        public double evalToDouble() {
            double v1 = this.m_arg1.evalToDouble();
            if (CNKObj.isDoubleNA(v1)) {
                return CNKObj.getDoubleNA();
            }
            double v2 = this.m_arg2.evalToDouble();
            if (CNKObj.isDoubleNA(v2)) {
                return CNKObj.getDoubleNA();
            }
            if (v1 < v2) {
                return -1.0;
            }
            if (v1 > v2) {
                return 1.0;
            }
            return 0.0;
        }
    }

    public abstract class Op_Compare
    extends EvalNode
    implements EvalToLogical {
        EvalToDouble m_arg1;

        public EvalNode initArgs() throws EvalTreeException {
            EvalNode compareNode = null;
            EvalNode arg1 = this.m_args[0];
            EvalNode arg2 = this.m_args[1];
            if (arg1 instanceof EvalToDouble && arg2 instanceof EvalToDouble) {
                compareNode = new Op_CompareDouble();
            } else if (arg1 instanceof EvalToDateTime && arg2 instanceof EvalToDateTime) {
                compareNode = new Op_CompareDateTime();
            } else if (arg1 instanceof EvalToString && arg2 instanceof EvalToString) {
                compareNode = new Op_CompareString();
            } else if (arg1 instanceof EvalToLogical && arg2 instanceof EvalToLogical) {
                if (!this.compareLogicalsOk()) {
                    throw new EvalTreeException(this.m_parseNode, MinerApp.getText("ExpressionEvaluater_illegalComparisonofLogicals"));
                }
                compareNode = new Op_CompareLogical();
            } else {
                throw new EvalTreeException(this.m_parseNode, MinerApp.getText("ExpressionEvaluater_comparisonArgumentsofDiffTypes"));
            }
            compareNode = compareNode.setArgs(this.m_parseNode, this.m_args);
            this.m_arg1 = compareNode;
            this.m_args = new EvalNode[]{compareNode};
            return this;
        }

        public boolean compareLogicalsOk() {
            return false;
        }

        public abstract LogicalValue evalToLogical();

        protected LogicalValue evalCompareToLogical(boolean lt, boolean eq, boolean gt) {
            double v1 = this.m_arg1.evalToDouble();
            if (CNKObj.isDoubleNA(v1)) {
                return ExpressionEvaluator.getLogicalNA();
            }
            if (lt && v1 < 0.0) {
                return ExpressionEvaluator.getLogicalTrue();
            }
            if (eq && v1 == 0.0) {
                return ExpressionEvaluator.getLogicalTrue();
            }
            if (gt && v1 > 0.0) {
                return ExpressionEvaluator.getLogicalTrue();
            }
            return ExpressionEvaluator.getLogicalFalse();
        }
    }

    public class Op_Or
    extends TwoLogicalArgEvalToLogical {
        public LogicalValue evalToLogical() {
            LogicalValue v1 = this.m_arg1.evalToLogical();
            if (ExpressionEvaluator.isLogicalNA(v1)) {
                LogicalValue v2 = this.m_arg2.evalToLogical();
                if (ExpressionEvaluator.isLogicalTrue(v2)) {
                    return ExpressionEvaluator.getLogicalTrue();
                }
                return ExpressionEvaluator.getLogicalNA();
            }
            if (ExpressionEvaluator.isLogicalTrue(v1)) {
                return ExpressionEvaluator.getLogicalTrue();
            }
            LogicalValue v2 = this.m_arg2.evalToLogical();
            if (ExpressionEvaluator.isLogicalNA(v2)) {
                return ExpressionEvaluator.getLogicalNA();
            }
            if (ExpressionEvaluator.isLogicalFalse(v2)) {
                return ExpressionEvaluator.getLogicalFalse();
            }
            return ExpressionEvaluator.getLogicalTrue();
        }
    }

    public class Op_And
    extends TwoLogicalArgEvalToLogical {
        public LogicalValue evalToLogical() {
            LogicalValue v1 = this.m_arg1.evalToLogical();
            if (ExpressionEvaluator.isLogicalNA(v1)) {
                LogicalValue v2 = this.m_arg2.evalToLogical();
                if (ExpressionEvaluator.isLogicalFalse(v2)) {
                    return ExpressionEvaluator.getLogicalFalse();
                }
                return ExpressionEvaluator.getLogicalNA();
            }
            if (ExpressionEvaluator.isLogicalFalse(v1)) {
                return ExpressionEvaluator.getLogicalFalse();
            }
            LogicalValue v2 = this.m_arg2.evalToLogical();
            if (ExpressionEvaluator.isLogicalNA(v2)) {
                return ExpressionEvaluator.getLogicalNA();
            }
            if (ExpressionEvaluator.isLogicalFalse(v2)) {
                return ExpressionEvaluator.getLogicalFalse();
            }
            return ExpressionEvaluator.getLogicalTrue();
        }
    }

    public class Op_Remainder
    extends TwoDoubleArgEvalToDouble {
        public double evalToDouble() {
            try {
                double e1 = this.m_arg1.evalToDouble();
                double e2 = this.m_arg2.evalToDouble();
                return e2 == 0.0 ? e1 : e1 - Math.floor(e1 / e2) * e2;
            }
            catch (Exception ex) {
                return CNKObj.getDoubleNA();
            }
        }
    }

    public class Op_Divide
    extends TwoDoubleArgEvalToDouble {
        public double evalToDouble() {
            try {
                return this.m_arg1.evalToDouble() / this.m_arg2.evalToDouble();
            }
            catch (Exception ex) {
                return CNKObj.getDoubleNA();
            }
        }
    }

    public class Op_Times
    extends TwoDoubleArgEvalToDouble {
        public double evalToDouble() {
            return this.m_arg1.evalToDouble() * this.m_arg2.evalToDouble();
        }
    }

    public class Function_asStringFromLogical
    extends EvalNode
    implements EvalToString {
        EvalToLogical m_arg1;

        public EvalNode initArgs() throws EvalTreeException {
            this.m_arg1 = (EvalToLogical)((Object)this.m_args[0]);
            return this;
        }

        public String evalToString() {
            LogicalValue v1 = this.m_arg1.evalToLogical();
            if (ExpressionEvaluator.isLogicalNA(v1)) {
                return CNKObj.getStringNA();
            }
            String val = ExpressionEvaluator.isLogicalFalse(v1) ? "false" : "true";
            return val;
        }

        public int estimateMaxStringWidth() {
            return 5;
        }
    }

    public class Function_asStringFromDateTimeFormat
    extends EvalNode
    implements EvalToString {
        EvalToDateTime m_arg1;
        EvalToString m_arg2;
        CNKSplusDateFormat m_format;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToDateTime.class, EvalToString.class});
            this.m_arg1 = (EvalToDateTime)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToString)((Object)this.m_args[1]);
            this.m_format = new CNKSplusDateFormat();
            this.m_format.setFormat(ExpressionEvaluator.this.m_worksheetPropertiesManager.getDateFormatString());
            this.m_format.setCenturyCutoff(ExpressionEvaluator.this.m_worksheetPropertiesManager.getCenturyCutoff());
            return this;
        }

        public String evalToString() {
            long v1 = this.m_arg1.evalToDateTime();
            if (CNKObj.isTimeDateNA(v1)) {
                return CNKObj.getStringNA();
            }
            String v2 = this.m_arg2.evalToString();
            if (CNKObj.isStringNA(v2)) {
                return CNKObj.getStringNA();
            }
            this.m_format.setFormat(v2);
            String val = this.m_format.convertTimeDateToString(v1);
            return val;
        }

        public int estimateMaxStringWidth() {
            return Math.max(40, this.m_arg2.estimateMaxStringWidth() + 20);
        }
    }

    public class Function_asStringFromDateTime
    extends EvalNode
    implements EvalToString {
        EvalToDateTime m_arg1;
        CNKSplusDateFormat m_format;

        public EvalNode initArgs() throws EvalTreeException {
            this.m_arg1 = (EvalToDateTime)((Object)this.m_args[0]);
            this.m_format = ExpressionEvaluator.this.m_worksheetPropertiesManager.getDateFormatter();
            return this;
        }

        public String evalToString() {
            long dtVal = this.m_arg1.evalToDateTime();
            if (CNKObj.isTimeDateNA(dtVal)) {
                return CNKObj.getStringNA();
            }
            String val = this.m_format.convertTimeDateToString(dtVal);
            return val;
        }

        public int estimateMaxStringWidth() {
            return 40;
        }
    }

    public class Function_asStringFromDouble
    extends EvalNode
    implements EvalToString {
        EvalToDouble m_arg1;

        public EvalNode initArgs() throws EvalTreeException {
            this.m_arg1 = (EvalToDouble)((Object)this.m_args[0]);
            return this;
        }

        public String evalToString() {
            double dVal = this.m_arg1.evalToDouble();
            if (CNKObj.isDoubleNA(dVal)) {
                return CNKObj.getStringNA();
            }
            String val = ExpressionEvaluator.this.m_worksheetPropertiesManager.formatFreeDouble(dVal);
            return val;
        }

        public int estimateMaxStringWidth() {
            return 25;
        }
    }

    public class Function_asString
    extends EvalNode {
        public EvalNode initArgs() throws EvalTreeException {
            if (this.m_args.length == 2 && this.m_args[0] instanceof EvalToDateTime && this.m_args[1] instanceof EvalToString) {
                EvalNode node = new Function_asStringFromDateTimeFormat();
                node = node.setArgs(this.m_parseNode, this.m_args);
                return node;
            }
            this.checkArgs(1);
            EvalNode node = this.m_args[0];
            if (node instanceof EvalToString) {
                return node;
            }
            if (node instanceof EvalToDouble) {
                node = new Function_asStringFromDouble();
            } else if (node instanceof EvalToDateTime) {
                node = new Function_asStringFromDateTime();
            } else if (node instanceof EvalToLogical) {
                node = new Function_asStringFromLogical();
            } else {
                throw new EvalTreeException(this.m_parseNode, "bad argument type");
            }
            node = node.setArgs(this.m_parseNode, this.m_args);
            return node;
        }
    }

    public class UnaryOp_Not
    extends EvalNode
    implements EvalToLogical {
        EvalToLogical m_arg1;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToLogical.class});
            this.m_arg1 = (EvalToLogical)((Object)this.m_args[0]);
            return this;
        }

        public LogicalValue evalToLogical() {
            LogicalValue v1 = this.m_arg1.evalToLogical();
            if (ExpressionEvaluator.isLogicalNA(v1)) {
                return ExpressionEvaluator.getLogicalNA();
            }
            if (ExpressionEvaluator.isLogicalFalse(v1)) {
                return ExpressionEvaluator.getLogicalTrue();
            }
            return ExpressionEvaluator.getLogicalFalse();
        }
    }

    public class UnaryOp_Plus
    extends EvalNode
    implements EvalToDouble {
        EvalToDouble m_arg1;

        public EvalNode initArgs() throws EvalTreeException {
            if (!(this.m_args[0] instanceof EvalToDouble)) {
                throw new EvalTreeException(this.m_parseNode, "arg not double");
            }
            this.m_arg1 = (EvalToDouble)((Object)this.m_args[0]);
            return this;
        }

        public double evalToDouble() {
            double v1 = this.m_arg1.evalToDouble();
            return v1;
        }
    }

    public class UnaryOp_Minus
    extends EvalNode
    implements EvalToDouble {
        EvalToDouble m_arg1;

        public EvalNode initArgs() throws EvalTreeException {
            if (!(this.m_args[0] instanceof EvalToDouble)) {
                throw new EvalTreeException(this.m_parseNode, "arg not double");
            }
            this.m_arg1 = (EvalToDouble)((Object)this.m_args[0]);
            return this;
        }

        public double evalToDouble() {
            double v1 = this.m_arg1.evalToDouble();
            return -v1;
        }
    }

    public class Op_Minus
    extends EvalNode {
        public EvalNode initArgs() throws EvalTreeException {
            EvalNode node = null;
            EvalNode arg1 = this.m_args[0];
            EvalNode arg2 = this.m_args[1];
            if (arg1 instanceof EvalToDouble && arg2 instanceof EvalToDouble) {
                node = new Op_PlusDouble();
                arg2 = ExpressionEvaluator.this.createNegativeNode(arg2);
            } else if (arg1 instanceof EvalToDateTime && arg2 instanceof EvalToDouble) {
                node = new Op_PlusDateTimeDouble();
                arg2 = ExpressionEvaluator.this.createNegativeNode(arg2);
            } else if (arg1 instanceof EvalToDateTime && arg2 instanceof EvalToDateTime) {
                node = new Op_MinusDateTime();
            } else {
                throw new EvalTreeException(this.m_parseNode, "bad argument types for Minus");
            }
            node = node.setArgs(this.m_parseNode, new EvalNode[]{arg1, arg2});
            return node;
        }
    }

    public class Op_MinusDateTime
    extends EvalNode
    implements EvalToDouble {
        EvalToDateTime m_arg1;
        EvalToDateTime m_arg2;

        public EvalNode initArgs() throws EvalTreeException {
            this.m_arg1 = (EvalToDateTime)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToDateTime)((Object)this.m_args[1]);
            return this;
        }

        public double evalToDouble() {
            long v1 = this.m_arg1.evalToDateTime();
            long v2 = this.m_arg2.evalToDateTime();
            if (CNKObj.isTimeDateNA(v1) || CNKObj.isTimeDateNA(v2)) {
                return CNKObj.getDoubleNA();
            }
            return (double)(v1 - v2) / 8.64E7;
        }
    }

    public class Op_PlusDateTimeDouble
    extends EvalNode
    implements EvalToDateTime {
        EvalToDateTime m_arg1;
        EvalToDouble m_arg2;

        public EvalNode initArgs() throws EvalTreeException {
            this.m_arg1 = (EvalToDateTime)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToDouble)((Object)this.m_args[1]);
            return this;
        }

        public long evalToDateTime() {
            long v1 = this.m_arg1.evalToDateTime();
            double v2 = this.m_arg2.evalToDouble();
            if (CNKObj.isTimeDateNA(v1) || CNKObj.isDoubleNA(v2)) {
                return CNKObj.getTimeDateNA();
            }
            return v1 + (long)(v2 * 24.0 * 60.0 * 60.0 * 1000.0);
        }
    }

    public class Op_PlusString
    extends EvalNode
    implements EvalToString {
        EvalToString m_arg1;
        EvalToString m_arg2;

        public EvalNode initArgs() throws EvalTreeException {
            this.m_arg1 = (EvalToString)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToString)((Object)this.m_args[1]);
            return this;
        }

        public String evalToString() {
            String v1 = this.m_arg1.evalToString();
            String v2 = this.m_arg2.evalToString();
            if (CNKObj.isStringNA(v1) || CNKObj.isStringNA(v2)) {
                return CNKObj.getStringNA();
            }
            return v1 + v2;
        }

        public int estimateMaxStringWidth() {
            return this.m_arg1.estimateMaxStringWidth() + this.m_arg2.estimateMaxStringWidth();
        }
    }

    public class Op_PlusDouble
    extends TwoDoubleArgEvalToDouble {
        public double evalToDouble() {
            double val = this.m_arg1.evalToDouble() + this.m_arg2.evalToDouble();
            return val;
        }
    }

    public class Op_Plus
    extends EvalNode {
        public EvalNode initArgs() throws EvalTreeException {
            EvalNode node = null;
            EvalNode arg1 = this.m_args[0];
            EvalNode arg2 = this.m_args[1];
            if (arg1 instanceof EvalToDouble && arg2 instanceof EvalToDouble) {
                node = new Op_PlusDouble();
            } else if (arg1 instanceof EvalToString || arg2 instanceof EvalToString) {
                node = new Op_PlusString();
                arg1 = ExpressionEvaluator.this.createCoerceToStringNode(arg1);
                arg2 = ExpressionEvaluator.this.createCoerceToStringNode(arg2);
            } else if (arg1 instanceof EvalToDateTime && arg2 instanceof EvalToDouble) {
                node = new Op_PlusDateTimeDouble();
            } else if (arg1 instanceof EvalToDouble && arg2 instanceof EvalToDateTime) {
                node = new Op_PlusDateTimeDouble();
                EvalNode temp = arg1;
                arg1 = arg2;
                arg2 = temp;
            } else {
                throw new EvalTreeException(this.m_parseNode, MinerApp.getText("ExpressionEvaluater_badArgumentTypes"));
            }
            node = node.setArgs(this.m_parseNode, new EvalNode[]{arg1, arg2});
            return node;
        }
    }

    public class Function_diff
    extends DataAccessPrevDouble {
        private int m_lag;
        private int m_diff;
        private double[] m_tempVals;
        DataAccessPrevArrayDouble m_prevArray;

        public Function_diff() {
            this.m_lag = 1;
            this.m_diff = 1;
            this.m_tempVals = null;
            this.m_prevArray = null;
        }

        public EvalNode initArgs() throws EvalTreeException {
            EvalNode arg3;
            EvalNode arg2;
            String id;
            if (this.m_args.length < 1 && this.m_args.length > 3) {
                throw new EvalTreeException(this.m_parseNode, "wrong number of arguments");
            }
            EvalNode arg1 = this.m_args[0];
            if (arg1 instanceof DataAccess) {
                id = ((DataAccess)arg1).getColumnName();
            } else if (arg1 instanceof StringConstant) {
                id = ((StringConstant)arg1).evalToString();
            } else {
                throw new EvalTreeException(this.m_parseNode, "first argument must be an identifier or a string constant");
            }
            DataInfo dat = new DataInfo(id);
            if (!dat.ok()) {
                throw new EvalTreeException(this.m_parseNode, "unknown column: \"" + ExpressionEvaluator.addEscapeChars(id) + "\"");
            }
            XTMetaData md = ExpressionEvaluator.this.m_metaDataArray[dat.m_inputNum];
            if (!md.isContinuousColumn(dat.m_colNum)) {
                throw new EvalTreeException(this.m_parseNode, "first argument must specify a numeric column");
            }
            EvalNode evalNode = arg2 = this.m_args.length < 2 ? new DoubleConstant(1.0) : this.m_args[1];
            if (!ExpressionEvaluator.this.isDoubleConstant(arg2)) {
                throw new EvalTreeException(this.m_parseNode, "second argument must be a constant number");
            }
            EvalNode evalNode2 = arg3 = this.m_args.length < 3 ? new DoubleConstant(1.0) : this.m_args[2];
            if (!ExpressionEvaluator.this.isDoubleConstant(arg3)) {
                throw new EvalTreeException(this.m_parseNode, "third argument must be a constant number");
            }
            double dLag = ExpressionEvaluator.this.getDoubleConstantValue(arg2);
            double dDiff = ExpressionEvaluator.this.getDoubleConstantValue(arg3);
            if (CNKObj.isDoubleNA(dLag) || dLag < 1.0 || CNKObj.isDoubleNA(dDiff) || dDiff < 1.0) {
                throw new EvalTreeException(this.m_parseNode, "bad value for lag or difference");
            }
            this.m_lag = (int)dLag;
            this.m_diff = (int)dDiff;
            this.setPrevNum(this.m_lag * (this.m_diff + 1));
            this.m_tempVals = new double[this.m_lag * (this.m_diff + 1)];
            this.setColumnInfo(dat);
            return this;
        }

        private double getPrev(int prev) {
            if (!this.m_prevArray.isPrevDataValid(prev)) {
                return CNKObj.getDoubleNA();
            }
            return this.m_prevArray.getDouble(prev);
        }

        public double evalToDouble() {
            int i;
            if (this.m_prevArray == null) {
                this.m_prevArray = (DataAccessPrevArrayDouble)this.getDataAccessPrevArray();
            }
            int numDiffs = this.m_lag * this.m_diff;
            for (i = 0; i < numDiffs; ++i) {
                double dataNow = this.getPrev(i);
                double dataThen = this.getPrev(i + this.m_lag);
                this.m_tempVals[i] = dataNow - dataThen;
            }
            while (numDiffs > 1) {
                for (i = 0; i < numDiffs - this.m_lag; ++i) {
                    this.m_tempVals[i] = i + this.m_lag > numDiffs ? CNKObj.getDoubleNA() : this.m_tempVals[i] - this.m_tempVals[i + this.m_lag];
                }
                numDiffs -= this.m_lag;
            }
            return this.m_tempVals[0];
        }
    }

    public class Function_prev
    extends EvalNode {
        public EvalNode initArgs() throws EvalTreeException {
            EvalNode arg3;
            EvalNode arg2;
            String id;
            if (this.m_args.length < 1 && this.m_args.length > 3) {
                throw new EvalTreeException(this.m_parseNode, "wrong number of arguments");
            }
            EvalNode arg1 = this.m_args[0];
            if (arg1 instanceof DataAccess) {
                id = ((DataAccess)arg1).getColumnName();
            } else if (arg1 instanceof StringConstant) {
                id = ((StringConstant)arg1).evalToString();
            } else {
                throw new EvalTreeException(this.m_parseNode, "first argument must be an identifier or a string constant");
            }
            DataInfo dat = new DataInfo(id);
            if (!dat.ok()) {
                throw new EvalTreeException(this.m_parseNode, "unknown column: \"" + ExpressionEvaluator.addEscapeChars(id) + "\"");
            }
            XTMetaData md = ExpressionEvaluator.this.m_metaDataArray[dat.m_inputNum];
            Class dataClass = null;
            if (md.isCategoricalColumn(dat.m_colNum) || md.isStringColumn(dat.m_colNum)) {
                dataClass = EvalToString.class;
            } else if (md.isContinuousColumn(dat.m_colNum)) {
                dataClass = EvalToDouble.class;
            } else if (md.isDateTimeColumn(dat.m_colNum)) {
                dataClass = EvalToDateTime.class;
            } else {
                throw new EvalTreeException(this.m_parseNode, "unknown type for column: \"" + ExpressionEvaluator.addEscapeChars(id) + "\"");
            }
            EvalNode evalNode = arg2 = this.m_args.length < 2 ? new DoubleConstant(1.0) : this.m_args[1];
            if (!ExpressionEvaluator.this.isDoubleConstant(arg2)) {
                throw new EvalTreeException(this.m_parseNode, "second argument must be a constant number");
            }
            EvalNode evalNode2 = arg3 = this.m_args.length < 3 ? new Function_NA() : this.m_args[2];
            if (dataClass == null || !dataClass.isInstance(arg3)) {
                throw new EvalTreeException(this.m_parseNode, "first and third argument types don't match");
            }
            DataAccessPrev node = null;
            if (dataClass == EvalToString.class) {
                node = new DataAccessPrevString();
            } else if (dataClass == EvalToDouble.class) {
                node = new DataAccessPrevDouble();
            } else if (dataClass == EvalToDateTime.class) {
                node = new DataAccessPrevDateTime();
            }
            node.setColumnInfo(dat);
            EvalNode initNode = node.setArgs(this.m_parseNode, new EvalNode[]{arg1, arg2, arg3});
            return initNode;
        }
    }

    public class Function_get
    extends EvalNode {
        public EvalNode initArgs() throws EvalTreeException {
            String id;
            this.checkArgs(1);
            if (this.m_args[0] instanceof DataAccess) {
                id = ((DataAccess)this.m_args[0]).getColumnName();
            } else if (this.m_args[0] instanceof StringConstant) {
                id = ((StringConstant)this.m_args[0]).evalToString();
            } else {
                throw new EvalTreeException(this.m_parseNode, MinerApp.getText("ExpressionEvaluater_aStringConstant"));
            }
            return ExpressionEvaluator.this.createDataAccessNode(this.m_parseNode, id);
        }
    }

    public class DataAccessPrevDateTime
    extends DataAccessPrev
    implements EvalToDateTime {
        EvalToDateTime m_naVal;
        DataAccessPrevArrayDateTime m_prevArray;

        public DataAccessPrevDateTime() {
            this.m_prevArray = null;
        }

        public EvalNode initArgs() throws EvalTreeException {
            super.initArgs();
            this.m_naVal = (EvalToDateTime)((Object)this.m_args[2]);
            return this;
        }

        public long evalToDateTime() {
            int prev;
            if (this.m_prevArray == null) {
                this.m_prevArray = (DataAccessPrevArrayDateTime)this.getDataAccessPrevArray();
            }
            if (!this.m_prevArray.isPrevDataValid(prev = this.getPrevNum())) {
                return this.m_naVal.evalToDateTime();
            }
            return this.m_prevArray.getDateTime(prev);
        }

        public DataAccessPrevArray getThisDataAccessPrevArray() {
            return new DataAccessPrevArrayDateTime();
        }
    }

    public class DataAccessPrevString
    extends DataAccessPrev
    implements EvalToString {
        EvalToString m_naVal;
        DataAccessPrevArrayString m_prevArray;

        public DataAccessPrevString() {
            this.m_prevArray = null;
        }

        public EvalNode initArgs() throws EvalTreeException {
            super.initArgs();
            this.m_naVal = (EvalToString)((Object)this.m_args[2]);
            return this;
        }

        public String evalToString() {
            int prev;
            if (this.m_prevArray == null) {
                this.m_prevArray = (DataAccessPrevArrayString)this.getDataAccessPrevArray();
            }
            if (!this.m_prevArray.isPrevDataValid(prev = this.getPrevNum())) {
                return this.m_naVal.evalToString();
            }
            return this.m_prevArray.getString(prev);
        }

        public DataAccessPrevArray getThisDataAccessPrevArray() {
            return new DataAccessPrevArrayString();
        }

        public int estimateMaxStringWidth() {
            int val = ExpressionEvaluator.this.m_worksheetPropertiesManager.getDefaultStringSize() - 1;
            try {
                XTMetaData md = ExpressionEvaluator.this.m_metaDataArray[this.getDataInfo().m_inputNum];
                val = ExpressionEvaluator.getStringOrFactorWidth(md, this.getDataInfo().m_colNum);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return val;
        }
    }

    public class DataAccessPrevDouble
    extends DataAccessPrev
    implements EvalToDouble,
    EvalToLogical {
        EvalToDouble m_naVal;
        DataAccessPrevArrayDouble m_prevArray;

        public DataAccessPrevDouble() {
            this.m_prevArray = null;
        }

        public EvalNode initArgs() throws EvalTreeException {
            super.initArgs();
            this.m_naVal = (EvalToDouble)((Object)this.m_args[2]);
            return this;
        }

        public double evalToDouble() {
            int prev;
            if (this.m_prevArray == null) {
                this.m_prevArray = (DataAccessPrevArrayDouble)this.getDataAccessPrevArray();
            }
            if (!this.m_prevArray.isPrevDataValid(prev = this.getPrevNum())) {
                return this.m_naVal.evalToDouble();
            }
            return this.m_prevArray.getDouble(prev);
        }

        public DataAccessPrevArray getThisDataAccessPrevArray() {
            return new DataAccessPrevArrayDouble();
        }

        public LogicalValue evalToLogical() {
            double v1 = this.evalToDouble();
            if (CNKObj.isDoubleNA(v1)) {
                return ExpressionEvaluator.getLogicalNA();
            }
            if (v1 != 0.0) {
                return ExpressionEvaluator.getLogicalTrue();
            }
            return ExpressionEvaluator.getLogicalFalse();
        }
    }

    public abstract class DataAccessPrev
    extends DataAccess {
        int m_prevNum;

        public DataAccessPrev() {
            this.m_prevNum = 1;
        }

        public EvalNode initArgs() throws EvalTreeException {
            double v = ExpressionEvaluator.this.getDoubleConstantValue(this.m_args[1]);
            if (CNKObj.isDoubleNA(v)) {
                throw new EvalTreeException(this.m_parseNode, "second argument cannot be NA");
            }
            this.m_prevNum = (int)v;
            return this;
        }

        public int getPrevNum() {
            return this.m_prevNum;
        }

        public void setPrevNum(int val) {
            this.m_prevNum = val;
        }

        public DataAccessPrevArray getDataAccessPrevArray() {
            return ExpressionEvaluator.this.lookupDataAccessPrevArray(this.getInputNum(), this.getColumnNum());
        }

        public Vector getRequiredDataAccessPrevArrays() {
            DataAccessPrevArray la;
            Vector<DataAccessPrevArray> vec = super.getRequiredDataAccessPrevArrays();
            if (vec == null) {
                vec = new Vector<DataAccessPrevArray>();
            }
            if ((la = this.getThisDataAccessPrevArray()) != null) {
                la.setColumnInfo(this.getDataInfo());
                la.setPrevMinMax(Math.min(0, this.m_prevNum), Math.max(0, this.m_prevNum));
                vec.add(la);
            }
            return vec;
        }

        public abstract DataAccessPrevArray getThisDataAccessPrevArray();
    }

    public class DataAccessPrevArrayString
    extends DataAccessPrevArray {
        String[] m_prevData;
        DataAccessString m_access;

        public DataAccessPrevArrayString() {
            this.m_prevData = null;
            this.m_access = null;
        }

        public void initPrevData() {
            this.m_prevData = new String[this.getPrevDataLength()];
            for (int i = 0; i < this.m_prevData.length; ++i) {
                this.m_prevData[i] = CNKObj.getStringNA();
            }
            this.m_access = new DataAccessString();
            this.m_access.setColumnInfo(this.getDataInfo());
        }

        public void readData(int toArrayIndex, int rowNum) {
            this.m_prevData[toArrayIndex] = this.m_access.evalToString(rowNum);
        }

        public void copyData(int toArrayIndex, int fromArrayIndex) {
            this.m_prevData[toArrayIndex] = this.m_prevData[fromArrayIndex];
        }

        public void beginChunk() {
            this.m_access.beginChunk();
        }

        public String getString(int lag) {
            int idx = this.getPrevDataIndex(lag);
            return idx < 0 ? CNKObj.getStringNA() : this.m_prevData[idx];
        }
    }

    public class DataAccessPrevArrayDateTime
    extends DataAccessPrevArray {
        long[] m_prevData;
        DataAccessDateTime m_access;

        public DataAccessPrevArrayDateTime() {
            this.m_prevData = null;
            this.m_access = null;
        }

        public void initPrevData() {
            this.m_prevData = new long[this.getPrevDataLength()];
            for (int i = 0; i < this.m_prevData.length; ++i) {
                this.m_prevData[i] = CNKObj.getTimeDateNA();
            }
            this.m_access = new DataAccessDateTime();
            this.m_access.setColumnInfo(this.getDataInfo());
        }

        public void readData(int toArrayIndex, int rowNum) {
            this.m_prevData[toArrayIndex] = this.m_access.evalToDateTime(rowNum);
        }

        public void copyData(int toArrayIndex, int fromArrayIndex) {
            this.m_prevData[toArrayIndex] = this.m_prevData[fromArrayIndex];
        }

        public void beginChunk() {
            this.m_access.beginChunk();
        }

        public long getDateTime(int lag) {
            int idx = this.getPrevDataIndex(lag);
            return idx < 0 ? CNKObj.getTimeDateNA() : this.m_prevData[idx];
        }
    }

    public class DataAccessPrevArrayDouble
    extends DataAccessPrevArray {
        double[] m_prevData;
        DataAccessDouble m_access;

        public DataAccessPrevArrayDouble() {
            this.m_prevData = null;
            this.m_access = null;
        }

        public void initPrevData() {
            this.m_prevData = new double[this.getPrevDataLength()];
            for (int i = 0; i < this.m_prevData.length; ++i) {
                this.m_prevData[i] = CNKObj.getDoubleNA();
            }
            this.m_access = new DataAccessDouble();
            this.m_access.setColumnInfo(this.getDataInfo());
        }

        public void readData(int toArrayIndex, int rowNum) {
            this.m_prevData[toArrayIndex] = this.m_access.evalToDouble(rowNum);
        }

        public void copyData(int toArrayIndex, int fromArrayIndex) {
            this.m_prevData[toArrayIndex] = this.m_prevData[fromArrayIndex];
        }

        public void beginChunk() {
            this.m_access.beginChunk();
        }

        public double getDouble(int lag) {
            int idx = this.getPrevDataIndex(lag);
            return idx < 0 ? CNKObj.getDoubleNA() : this.m_prevData[idx];
        }
    }

    public abstract class DataAccessPrevArray
    extends DataAccess {
        int m_prevMin;
        int m_prevMax;
        long m_dataRow;
        int m_prevMinAvailable;
        int m_prevMaxAvailable;

        public void setPrevMinMax(int prevMin, int prevMax) {
            this.m_prevMin = prevMin;
            this.m_prevMax = prevMax;
        }

        public int getPrevMin() {
            return this.m_prevMin;
        }

        public int getPrevMax() {
            return this.m_prevMax;
        }

        public int getPrevDataLength() {
            return 1 + this.m_prevMax - this.m_prevMin;
        }

        public abstract void initPrevData();

        public abstract void readData(int var1, int var2);

        public abstract void copyData(int var1, int var2);

        public void initUpdatePrevData() {
            this.initPrevData();
            this.m_dataRow = -1L;
        }

        public void updatePrevData(long chunkPosition, int inputRows, int inputRowsAvailable, int row) {
            int diffRow = (int)(chunkPosition + (long)row - this.m_dataRow);
            for (int i = 0; i < this.m_prevMax - this.m_prevMin + 1; ++i) {
                int copyElt = i + diffRow;
                int copyRow = row + (i - this.m_prevMax);
                if (copyRow >= inputRowsAvailable) {
                    copyRow = -1;
                }
                if (this.m_dataRow < 0L) {
                    this.readData(i, copyRow);
                    continue;
                }
                if (copyElt < 0 || copyElt > this.m_prevMax - this.m_prevMin) {
                    this.readData(i, copyRow);
                    continue;
                }
                this.copyData(i, copyElt);
            }
            this.m_dataRow = chunkPosition + (long)row;
            this.m_prevMinAvailable = Math.max(-(inputRowsAvailable - (row + 1)), this.m_prevMin);
            this.m_prevMaxAvailable = chunkPosition >= (long)this.m_prevMax ? this.m_prevMax : Math.min(this.m_prevMax, row + (int)chunkPosition);
        }

        public boolean isPrevDataValid(int lag) {
            return this.getPrevDataIndex(lag) >= 0;
        }

        public int getPrevDataIndex(int lag) {
            if (lag < this.m_prevMinAvailable || lag > this.m_prevMaxAvailable) {
                return -1;
            }
            return this.m_prevMax - lag;
        }
    }

    public class DataAccessDateTime
    extends DataAccess
    implements EvalToDateTime {
        long[] m_data;

        public DataAccessDateTime() {
            this.m_data = null;
        }

        public long evalToDateTime() {
            return this.evalToDateTime(ExpressionEvaluator.this.m_dataSourceRow);
        }

        public long evalToDateTime(int rowNum) {
            if (this.m_data == null) {
                this.m_data = ExpressionEvaluator.this.m_dataSourceProc.getChunkInputColumnDateTimes(this.getInputNum(), this.getColumnNum());
            }
            return rowNum < 0 || rowNum >= this.m_data.length ? CNKObj.getTimeDateNA() : this.m_data[rowNum];
        }

        public void beginChunk() {
            this.m_data = null;
        }
    }

    public class DataAccessDouble
    extends DataAccess
    implements EvalToDouble,
    EvalToLogical {
        double[] m_data;

        public DataAccessDouble() {
            this.m_data = null;
        }

        public double evalToDouble() {
            return this.evalToDouble(ExpressionEvaluator.this.m_dataSourceRow);
        }

        public double evalToDouble(int rowNum) {
            if (this.m_data == null) {
                this.m_data = ExpressionEvaluator.this.m_dataSourceProc.getChunkInputColumnDoubles(this.getInputNum(), this.getColumnNum());
            }
            return rowNum < 0 || rowNum >= this.m_data.length ? CNKObj.getDoubleNA() : this.m_data[rowNum];
        }

        public LogicalValue evalToLogical() {
            double v1 = this.evalToDouble();
            if (CNKObj.isDoubleNA(v1)) {
                return ExpressionEvaluator.getLogicalNA();
            }
            if (v1 != 0.0) {
                return ExpressionEvaluator.getLogicalTrue();
            }
            return ExpressionEvaluator.getLogicalFalse();
        }

        public void beginChunk() {
            this.m_data = null;
        }
    }

    public class DataAccessString
    extends DataAccess
    implements EvalToString {
        String[] m_data;

        public DataAccessString() {
            this.m_data = null;
        }

        public String evalToString() {
            return this.evalToString(ExpressionEvaluator.this.m_dataSourceRow);
        }

        public String evalToString(int rowNum) {
            if (this.m_data == null) {
                this.m_data = ExpressionEvaluator.this.m_dataSourceProc.getChunkInputColumnStrings(this.getInputNum(), this.getColumnNum());
            }
            return rowNum < 0 || rowNum >= this.m_data.length ? CNKObj.getStringNA() : this.m_data[rowNum];
        }

        public void beginChunk() {
            this.m_data = null;
        }

        public int estimateMaxStringWidth() {
            int val = ExpressionEvaluator.this.m_worksheetPropertiesManager.getDefaultStringSize() - 1;
            try {
                XTMetaData md = ExpressionEvaluator.this.m_metaDataArray[this.getDataInfo().m_inputNum];
                val = ExpressionEvaluator.getStringOrFactorWidth(md, this.getDataInfo().m_colNum);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return val;
        }
    }

    public class DataAccess
    extends EvalNode {
        public DataInfo m_dat;

        public DataAccess() {
            this.m_dat = null;
        }

        public void setColumnInfo(DataInfo dat) {
            this.m_dat = dat;
        }

        public DataInfo getDataInfo() {
            return this.m_dat;
        }

        public String getColumnName() {
            return this.m_dat.m_colName;
        }

        public int getColumnNum() {
            return this.m_dat.m_colNum;
        }

        public int getInputNum() {
            return this.m_dat.m_inputNum;
        }

        public ExpressionEvaluator getNewExpr() {
            if (this.m_dat == null || this.m_dat.m_id == null || ExpressionEvaluator.this.m_newColumnHash == null) {
                return null;
            }
            Object obj = ExpressionEvaluator.this.m_newColumnHash.get(this.m_dat.m_id);
            if (obj == null || !(obj instanceof ExpressionEvaluator)) {
                return null;
            }
            return (ExpressionEvaluator)obj;
        }
    }

    public class StringConstant
    extends EvalNode
    implements EvalToString {
        String m_val;

        StringConstant(SimpleNode parseNode, String str) throws EvalTreeException {
            this.m_val = "";
            this.setArgs(parseNode);
            try {
                this.m_val = ExpressionEvaluator.removeEscapeChars(str.substring(1, str.length() - 1));
            }
            catch (Exception ex) {
                throw new EvalTreeException(parseNode, MinerApp.getText("ExpressionEvaluater_badStringConstant"));
            }
        }

        public String evalToString() {
            return this.m_val;
        }

        public int estimateMaxStringWidth() {
            return ExpressionEvaluator.getStringUTF8Length(this.m_val);
        }
    }

    public class DoubleConstant
    extends EvalNode
    implements EvalToDouble {
        double m_val;

        DoubleConstant(double val) {
            this.m_val = 0.0;
            this.m_val = val;
        }

        DoubleConstant(SimpleNode parseNode, String str) throws EvalTreeException {
            this.m_val = 0.0;
            this.setArgs(parseNode);
            try {
                this.m_val = Double.parseDouble(str);
            }
            catch (Exception ex) {
                throw new EvalTreeException(parseNode, MinerApp.getText("ExpressionEvaluater_errorParsingDouble"));
            }
        }

        public double evalToDouble() {
            return this.m_val;
        }
    }

    public abstract class TwoLogicalArgEvalToLogical
    extends EvalNode
    implements EvalToLogical {
        EvalToLogical m_arg1;
        EvalToLogical m_arg2;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToLogical.class, EvalToLogical.class});
            this.m_arg1 = (EvalToLogical)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToLogical)((Object)this.m_args[1]);
            return this;
        }

        public abstract LogicalValue evalToLogical();
    }

    public abstract class TwoDoubleArgEvalToDouble
    extends EvalNode
    implements EvalToDouble {
        EvalToDouble m_arg1;
        EvalToDouble m_arg2;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToDouble.class, EvalToDouble.class});
            this.m_arg1 = (EvalToDouble)((Object)this.m_args[0]);
            this.m_arg2 = (EvalToDouble)((Object)this.m_args[1]);
            return this;
        }

        public abstract double evalToDouble();
    }

    public abstract class OneDoubleArgEvalToDouble
    extends EvalNode
    implements EvalToDouble {
        EvalToDouble m_arg1;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToDouble.class});
            this.m_arg1 = (EvalToDouble)((Object)this.m_args[0]);
            return this;
        }

        public abstract double evalToDouble();
    }

    public abstract class OneDateTimeArgEvalToDouble
    extends EvalNode
    implements EvalToDouble {
        EvalToDateTime m_arg1;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToDateTime.class});
            this.m_arg1 = (EvalToDateTime)((Object)this.m_args[0]);
            return this;
        }

        public abstract double evalToDouble();
    }

    public abstract class OneStringArgEvalToString
    extends EvalNode
    implements EvalToString {
        EvalToString m_arg1;

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(new Class[]{EvalToString.class});
            this.m_arg1 = (EvalToString)((Object)this.m_args[0]);
            return this;
        }

        public abstract String evalToString();
    }

    static interface EvalToLogical {
        public LogicalValue evalToLogical();
    }

    static interface EvalToDateTime {
        public long evalToDateTime();
    }

    static interface EvalToString {
        public String evalToString();

        public int estimateMaxStringWidth();
    }

    static interface EvalToDouble {
        public double evalToDouble();
    }

    public abstract class EvalNode {
        public SimpleNode m_parseNode = null;
        public EvalNode[] m_args;

        public final EvalNode setArgs(SimpleNode parseNode, EvalNode[] args) throws EvalTreeException {
            this.m_parseNode = parseNode;
            this.m_args = args;
            EvalNode newNode = this.initArgs();
            return newNode;
        }

        public final EvalNode setArgs(EvalNode[] args) throws EvalTreeException {
            SimpleNode parseNode = null;
            if (args.length > 0) {
                parseNode = args[0].m_parseNode;
            }
            return this.setArgs(parseNode, args);
        }

        public final EvalNode setArgs(SimpleNode parseNode) throws EvalTreeException {
            return this.setArgs(parseNode, new EvalNode[0]);
        }

        public EvalNode initArgs() throws EvalTreeException {
            this.checkArgs(0);
            return this;
        }

        public void checkArgs(int numArgs) throws EvalTreeException {
            this.checkArgs(new Class[numArgs]);
        }

        public void checkArgs(Class[] classes) throws EvalTreeException {
            if (this.m_args == null || classes == null) {
                throw new EvalTreeException(this.m_parseNode, MinerApp.getText("ExpressionEvaluater_badcalltoCheckArgs"));
            }
            if (this.m_args.length != classes.length) {
                throw new EvalTreeException(this.m_parseNode, MinerApp.getText("ExpressionEvaluater_given") + " " + this.m_args.length + " " + MinerApp.getText("ExpressionEvaluater_argumentsShouldhave") + " " + classes.length + " " + MinerApp.getText("ExpressionEvaluater_arguments"));
            }
            for (int i = 0; i < this.m_args.length; ++i) {
                EvalNode obj = this.m_args[i];
                Class objClass = classes[i];
                if (obj == null || objClass == null || objClass.isInstance(obj)) continue;
                String givenClassString = ExpressionEvaluator.this.evalClassToSimpleString(obj.getClass());
                String desiredClassString = ExpressionEvaluator.this.evalClassToSimpleString(objClass);
                throw new EvalTreeException(this.m_parseNode, MinerApp.getText("ExpressionEvaluater_argument") + " " + (i + 1) + " " + MinerApp.getText("ExpressionEvaluater_is") + " " + givenClassString + ", " + MinerApp.getText("ExpressionEvaluater_shouldbe") + " " + desiredClassString);
            }
        }

        public void checkArgClass(int argNum, Class[] classes) throws EvalTreeException {
            if (this.m_args == null || this.m_args.length <= argNum || this.m_args[argNum] == null || classes == null) {
                throw new EvalTreeException(this.m_parseNode, MinerApp.getText("ExpressionEvaluater_badCalltoCheckArgsClass"));
            }
            boolean ok = false;
            for (int i = 0; i < classes.length; ++i) {
                Class objClass = classes[i];
                if (objClass == null || !objClass.isInstance(this.m_args[argNum])) continue;
                ok = true;
                break;
            }
            if (!ok) {
                String givenClassString = ExpressionEvaluator.this.evalClassToSimpleString(this.m_args[argNum].getClass());
                String desiredClassString = null;
                for (int j = 0; j < classes.length; ++j) {
                    desiredClassString = desiredClassString == null ? "" : desiredClassString + ",";
                    desiredClassString = desiredClassString + ExpressionEvaluator.this.evalClassToSimpleString(classes[j]);
                }
                throw new EvalTreeException(this.m_parseNode, MinerApp.getText("ExpressionEvaluater_argument") + " " + (argNum + 1) + " " + MinerApp.getText("ExpressionEvaluater_is") + " " + givenClassString + ", " + MinerApp.getText("ExpressionEvaluater_shouldbeOneof") + " " + desiredClassString);
            }
        }

        public String toString() {
            String fullName = this.getClass().getName();
            int startOfName = fullName.lastIndexOf("$");
            if (startOfName < 0) {
                startOfName = fullName.lastIndexOf(".");
            }
            String className = fullName.substring(startOfName + 1);
            return className + " {" + this.m_parseNode + "}";
        }

        public String toString(String prefix) {
            return prefix + this.toString();
        }

        public void dump(String prefix) {
            System.out.println(this.toString(prefix));
            if (this.m_args != null) {
                for (int i = 0; i < this.m_args.length; ++i) {
                    EvalNode n = this.m_args[i];
                    if (n == null) continue;
                    n.dump(prefix + " ");
                }
            }
        }

        public void beginChunk() {
            if (this.m_args != null) {
                for (int i = 0; i < this.m_args.length; ++i) {
                    EvalNode n = this.m_args[i];
                    if (n == null) continue;
                    n.beginChunk();
                }
            }
        }

        public void endChunk() {
            if (this.m_args != null) {
                for (int i = 0; i < this.m_args.length; ++i) {
                    EvalNode n = this.m_args[i];
                    if (n == null) continue;
                    n.endChunk();
                }
            }
        }

        public void cleanup() {
            if (this.m_args != null) {
                for (int i = 0; i < this.m_args.length; ++i) {
                    EvalNode n = this.m_args[i];
                    if (n == null) continue;
                    n.cleanup();
                }
            }
        }

        public boolean needsDataSummary() {
            if (this.m_args != null) {
                for (int i = 0; i < this.m_args.length; ++i) {
                    EvalNode n = this.m_args[i];
                    if (n == null || !n.needsDataSummary()) continue;
                    return true;
                }
            }
            return false;
        }

        public Vector getRequiredDataAccessPrevArrays() {
            Vector vec = null;
            if (this.m_args != null) {
                for (int i = 0; i < this.m_args.length; ++i) {
                    Vector argVec;
                    EvalNode n = this.m_args[i];
                    if (n == null || (argVec = n.getRequiredDataAccessPrevArrays()) == null) continue;
                    if (vec == null) {
                        vec = argVec;
                        continue;
                    }
                    vec.addAll(argVec);
                }
            }
            return vec;
        }

        public Vector collectNodesInClass(Class[] cls) {
            int i;
            Vector vec = null;
            for (i = 0; i < cls.length; ++i) {
                if (!cls[i].isInstance(this)) continue;
                vec = new Vector();
                vec.add(this);
                break;
            }
            if (this.m_args != null) {
                for (i = 0; i < this.m_args.length; ++i) {
                    Vector argVec;
                    EvalNode n = this.m_args[i];
                    if (n == null || (argVec = n.collectNodesInClass(cls)) == null) continue;
                    if (vec == null) {
                        vec = argVec;
                        continue;
                    }
                    vec.addAll(argVec);
                }
            }
            return vec;
        }

        public void collectReferencedNames(Vector v) {
            if (this.m_args != null) {
                for (int i = 0; i < this.m_args.length; ++i) {
                    EvalNode n = this.m_args[i];
                    if (n == null) continue;
                    n.collectReferencedNames(v);
                }
            }
        }
    }

    public class EvalTreeException
    extends Exception {
        public int m_error_line = 0;
        public int m_error_column = 0;
        public String m_error_string = null;

        EvalTreeException(SimpleNode parseNode, String errorString) {
            this.m_error_string = errorString;
            if (parseNode != null && parseNode.getFirstToken() != null) {
                this.m_error_line = parseNode.getFirstToken().beginLine;
                this.m_error_column = parseNode.getFirstToken().beginColumn;
            }
        }

        EvalTreeException(EvalNode evalNode, String errorString) {
            this(evalNode.m_parseNode, errorString);
        }
    }

    public static class LogicalValue {
        private LogicalValue() {
        }
    }

    public class DataInfo {
        public int m_inputNum = -1;
        public int m_colNum = -1;
        public String m_id = null;
        public String m_colName = null;

        public DataInfo(String id) {
            this.m_id = id;
            if (ExpressionEvaluator.this.m_metaDataArray.length == 1) {
                this.m_inputNum = 0;
                this.m_colName = this.m_id;
            } else {
                int sepIndex;
                int dotIndex = id.indexOf(".");
                int dollarIndex = id.indexOf("$");
                int n = sepIndex = dollarIndex >= 0 && (dotIndex < 0 || dollarIndex < dotIndex) ? dollarIndex : dotIndex;
                if (id.startsWith("in") && sepIndex > 0) {
                    this.m_colName = this.m_id.substring(sepIndex + 1);
                    try {
                        this.m_inputNum = Integer.parseInt(id.substring(2, sepIndex)) - 1;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            if (this.m_inputNum >= 0 && this.m_inputNum < ExpressionEvaluator.this.m_metaDataArray.length) {
                XTMetaData md = ExpressionEvaluator.this.m_metaDataArray[this.m_inputNum];
                this.m_colNum = md.nameToOrdinal(this.m_colName);
            }
        }

        public boolean ok() {
            return this.m_colNum >= 0;
        }
    }
}

