/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.graphdlg.controls;

import com.insightful.miner.graphdlg.controls.MinerControlMethods;
import com.insightful.miner.graphdlg.controls.MinerLabelBox;
import java.awt.Dimension;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionListener;

public class MinerListBox
extends MinerLabelBox
implements MinerControlMethods {
    private JList list;
    JScrollPane scrollPane;
    private static final int listFontHeight = new JList().getFontMetrics(new JList().getFont()).getHeight();
    String[] prependString = null;
    String[] appendString = null;

    public MinerListBox() {
        this("", new String[]{""});
    }

    public MinerListBox(String text) {
        this(text, new String[]{""});
    }

    public MinerListBox(String text, char mnemonic) {
        this(text, new String[]{""});
        this.setMnemonic(mnemonic);
    }

    public MinerListBox(String text, int mnemonic) {
        this(text, new String[]{""});
        this.setMnemonic(mnemonic);
    }

    public MinerListBox(String text, char mnemonic, String[] listData) {
        this(text, listData);
        this.setMnemonic(mnemonic);
    }

    public MinerListBox(String text, int mnemonic, String[] listData) {
        this(text, listData);
        this.setMnemonic(mnemonic);
    }

    public MinerListBox(String text, String[] listData) {
        super(text);
        this.list = new JList<String>(listData);
        this.list.setFixedCellHeight(listFontHeight);
        Dimension listDimension = new Dimension(MinerListBox.labelDimension.width, MinerListBox.labelDimension.height * 4);
        this.scrollPane = new JScrollPane(this.list, 20, 31);
        this.scrollPane.setPreferredSize(listDimension);
        this.scrollPane.setMinimumSize(listDimension);
        this.setActionControl(this.scrollPane);
        this.setLabelFor(this.list);
    }

    public String getValue() {
        String[] stringArray = this.getValues();
        String returnValue = "";
        if (stringArray != null && stringArray.length > 0) {
            StringBuffer buffer = new StringBuffer(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                buffer.append("," + stringArray[i]);
            }
            returnValue = buffer.toString();
        }
        if (returnValue.endsWith("\\") && !returnValue.endsWith("\\\\")) {
            returnValue = returnValue.substring(0, returnValue.length() - 1);
        }
        return returnValue;
    }

    public String[] getValues() {
        int[] indices = this.list.getSelectedIndices();
        ListModel listModel = this.list.getModel();
        String[] stringArray = new String[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            stringArray[i] = (String)listModel.getElementAt(indices[i]);
        }
        return stringArray;
    }

    public void setValue(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        int numValues = tokenizer.countTokens();
        String[] stringArray = new String[numValues];
        for (int i = 0; i < numValues; ++i) {
            stringArray[i] = tokenizer.nextToken();
        }
        this.setValues(stringArray);
    }

    public void setValues(String[] values) {
        this.list.clearSelection();
        if (values.length == 0) {
            return;
        }
        int[] inds = new int[values.length];
        int numFound = 0;
        String[] optionList = this.getOptionList();
        String curValue = null;
        block0: for (int i = 0; i < values.length; ++i) {
            curValue = values[i];
            inds[i] = -1;
            for (int j = 0; j < optionList.length; ++j) {
                if (!curValue.equals(optionList[j])) continue;
                inds[i] = j;
                ++numFound;
                continue block0;
            }
        }
        int[] inds2 = new int[numFound];
        int curInd = 0;
        for (int i = 0; i < inds.length; ++i) {
            if (inds[i] == -1) continue;
            inds2[curInd++] = inds[i];
        }
        this.list.setSelectedIndices(inds2);
        if (inds2.length > 0) {
            this.list.ensureIndexIsVisible(inds2[0]);
        }
    }

    public String[] getOptionList() {
        ListModel listModel = this.list.getModel();
        int listSize = listModel.getSize();
        String[] stringArray = new String[listSize];
        for (int i = 0; i < listSize; ++i) {
            stringArray[i] = listModel.getElementAt(i).toString();
        }
        return stringArray;
    }

    public void setOptionList(String[] listData) {
        if (this.appendString == null && this.prependString == null) {
            this.list.setListData(listData);
        } else {
            int i;
            Vector<String> listVector = new Vector<String>();
            if (this.prependString != null) {
                for (i = 0; i < this.prependString.length; ++i) {
                    listVector.add(this.prependString[i]);
                }
            }
            if (listData != null) {
                for (i = 0; i < listData.length; ++i) {
                    listVector.add(listData[i]);
                }
            }
            if (this.appendString != null) {
                for (i = 0; i < this.appendString.length; ++i) {
                    listVector.add(this.appendString[i]);
                }
            }
            this.list.setListData(listVector.toArray());
        }
    }

    public boolean isEnabled() {
        return this.list.isEnabled();
    }

    public void setEnabled(boolean b) {
        this.list.setEnabled(b);
        this.scrollPane.setEnabled(b);
        this.setLabelEnabled(b);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.list.addListSelectionListener(listener);
    }

    public void clearSelection() {
        this.list.clearSelection();
    }

    public boolean isSelectionEmpty() {
        return this.list.isSelectionEmpty();
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public int[] getSelectedIndices() {
        return this.list.getSelectedIndices();
    }

    public void setSelectedIndex(int index) {
        this.list.setSelectedIndex(index);
    }

    public void setSelectedIndices(int[] indices) {
        this.list.setSelectedIndices(indices);
    }

    public int getSelectionMode() {
        return this.list.getSelectionMode();
    }

    public void setSelectionMode(int selectionMode) {
        this.list.setSelectionMode(selectionMode);
    }

    public void setPrepend(String[] str) {
        this.prependString = str;
        this.setOptionList(this.getOptionList());
    }

    public String[] getPrepend() {
        return this.prependString;
    }

    public void setAppend(String[] str) {
        this.appendString = str;
        this.setOptionList(this.getOptionList());
    }

    public String[] getAppend() {
        return this.appendString;
    }
}

