/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql;

import com.insightful.miner.AggregateEngineNode;
import com.insightful.miner.BDLList;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.sql.Column;
import com.insightful.miner.sql.CompiledStatement;
import com.insightful.miner.sql.Expression;
import com.insightful.miner.sql.HsqlException;
import com.insightful.miner.sql.HsqlNameManager;
import com.insightful.miner.sql.Parser;
import com.insightful.miner.sql.Result;
import com.insightful.miner.sql.Select;
import com.insightful.miner.sql.TableFilter;
import com.insightful.miner.sql.Token;
import com.insightful.miner.sql.Tokenizer;
import com.insightful.miner.sql.Trace;
import com.insightful.miner.sql.lib.HashSet;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class BigDataCommandInterpreter {
    public static BDLList noResult = new BDLList(0);
    Tokenizer tokenizer = new Tokenizer();
    Hashtable metaDataMap = new Hashtable(0);
    static final String oldLib = "org.hsql.Library.";
    static final int oldLibLen = "org.hsql.Library.".length();
    static final String newLib = "org.hsqldb.Library.";
    public static String ___sql = "SELECT fuel.Types, ed.Mileage FROM fuel left outer join ed on fuel.Types=ed.Types ORDER BY ed.Mileage";

    public BDLList execute(String sql, Hashtable mdMap) {
        this.metaDataMap = mdMap;
        BDLList result = noResult;
        int cmd = -1;
        try {
            String token;
            this.tokenizer.reset(sql);
            this.tokenizer.setConvertToUpperCase(false);
            Parser parser = new Parser(mdMap, this.tokenizer);
            do {
                this.tokenizer.setPartMarker();
            } while ((token = this.tokenizer.getString()).length() != 0 && ((cmd = Token.get(token)) == 320 || !(result = this.executePart(cmd, token, parser)).getName(0).equals("error")));
        }
        catch (Throwable t) {
            result = new BDLList(1);
            result.set(0, "error", t.getMessage());
        }
        return result;
    }

    private BDLList executePart(int cmd, String token, Parser parser) throws Throwable {
        BDLList result = noResult;
        switch (cmd) {
            case 193: {
                CompiledStatement cStatement = parser.compileSelectStatement(false);
                if (cStatement.parameters.length != 0) {
                    Trace.doAssert(false, Trace.getMessage(165));
                }
                result = this.processSelect(cStatement);
                break;
            }
            case 112: {
                CompiledStatement cStatement = parser.compileInsertStatement();
                if (cStatement.parameters.length != 0) {
                    Trace.doAssert(false, Trace.getMessage(165));
                }
                result = this.processInsert(cStatement);
                break;
            }
            case 222: {
                CompiledStatement cStatement = parser.compileUpdateStatement();
                if (cStatement.parameters.length != 0) {
                    Trace.doAssert(false, Trace.getMessage(165));
                }
                result = this.processUpdate(cStatement);
                break;
            }
            case 62: {
                CompiledStatement cStatement = parser.compileDeleteStatement();
                if (cStatement.parameters.length != 0) {
                    Trace.doAssert(false, Trace.getMessage(165));
                }
                result = this.processDelete(cStatement);
                break;
            }
            case 23: {
                CompiledStatement cStatement = parser.compileCallStatement();
                if (cStatement.parameters.length != 0) {
                    Trace.doAssert(false, Trace.getMessage(165));
                }
                result = this.processCall(cStatement);
                break;
            }
            case 196: {
                result = this.processSet();
                break;
            }
            case 35: {
                result = this.processCommit();
                break;
            }
            case 184: {
                result = this.processRollback();
                break;
            }
            case 188: {
                result = this.processSavepoint();
                break;
            }
            case 41: {
                result = this.processCreate();
                break;
            }
            case 4: {
                result = this.processAlter();
                break;
            }
            case 70: {
                result = this.processDrop();
                break;
            }
            case 96: {
                result = this.processGrantOrRevoke(true);
                break;
            }
            case 182: {
                result = this.processGrantOrRevoke(false);
                break;
            }
            case 37: {
                result = this.processConnect();
                break;
            }
            case 66: {
                result = this.processDisconnect();
                break;
            }
            case 318: {
                result = this.processScript();
                break;
            }
            case 322: {
                result = this.processShutdown();
                break;
            }
            case 303: {
                result = this.processCheckpoint();
                break;
            }
            case 304: {
                result = this.processExplainPlan();
                break;
            }
            case 176: {
                result = this.processReleaseSavepoint();
                break;
            }
            default: {
                throw Trace.error(11, token);
            }
        }
        return result;
    }

    private BDLList processScript() throws IOException, HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("SCRIPT not supported.");
        return new BDLList(0);
    }

    private BDLList processCreate() throws HsqlException {
        BDLList result = null;
        String token = this.tokenizer.getString();
        boolean isTemp = false;
        if (token.equals("TEMP")) {
            isTemp = true;
            token = this.tokenizer.getString();
            switch (Token.get(token)) {
                case 213: 
                case 309: 
                case 325: {
                    break;
                }
                default: {
                    throw Trace.error(11, token);
                }
            }
        }
        boolean unique = false;
        boolean tableType = false;
        switch (Token.get(token)) {
            case 213: {
                result = this.processCreateTable();
                break;
            }
            case 309: {
                this.tokenizer.getThis("TABLE");
                result = this.processCreateTable();
                break;
            }
            case 302: {
                this.tokenizer.getThis("TABLE");
                result = this.processCreateTable();
                break;
            }
            case 325: {
                this.tokenizer.getThis("TABLE");
                result = this.processCreateTable();
                break;
            }
            case 300: {
                result = this.processCreateAlias();
                break;
            }
            case 321: {
                result = this.processCreateSequence();
                break;
            }
            case 224: {
                result = this.processCreateTrigger();
                break;
            }
            case 223: {
                result = this.processCreateUser();
                break;
            }
            case 326: {
                result = this.processCreateView();
                break;
            }
            case 228: {
                unique = true;
                this.tokenizer.getThis("INDEX");
            }
            case 306: {
                result = this.processCreateIndex(unique);
                break;
            }
            default: {
                throw Trace.error(11, token);
            }
        }
        return result;
    }

    private int[] processColumnList(XTMetaData md) throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("COLUMN LIST not supported.");
        return new int[0];
    }

    private BDLList addIndexOn(XTMetaData md, String indexName, boolean indexNameQuoted, boolean unique) throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("INDEX not supported.");
        return new BDLList(0);
    }

    private BDLList processCreateTrigger() throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("TRIGGER not supported.");
        return new BDLList(0);
    }

    private Column processCreateColumn(XTMetaData md) throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("CREATE COLUMN not supported.");
        return null;
    }

    private Expression processCreateDefaultExpression(Hashtable mdMap, int type, int length) throws HsqlException {
        if (type == 1111) {
            throw Trace.error(46);
        }
        Parser parser = new Parser(mdMap, this.tokenizer);
        Expression expr = parser.readDefaultClause();
        expr.resolveTypes();
        if (expr.getType() == 1 || expr.getType() == 7 && expr.function.isSimple) {
            try {
                Object defValTemp = expr.getValue(type);
            }
            catch (HsqlException e) {
                throw Trace.error(46);
            }
            return expr;
        }
        throw Trace.error(46);
    }

    public static void checkBooleanDefault(String s, int type) throws HsqlException {
        if (type != 16 || s == null) {
            return;
        }
        if ((s = s.toUpperCase()).equals("TRUE") || s.equals("FALSE")) {
            return;
        }
        if (s.equals("0") || s.equals("1")) {
            return;
        }
        throw Trace.error(46, s);
    }

    private BDLList processCreateTable() throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("CREATE TABLE not supported.");
        return new BDLList(0);
    }

    private BDLList processCreateView() throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("CREATE VIEW not supported.");
        return new BDLList(0);
    }

    private BDLList processAlter() throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("ALTER not supported.");
        return new BDLList(0);
    }

    private BDLList processDrop() throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("DROP not supported.");
        return new BDLList(0);
    }

    private BDLList processGrantOrRevoke(boolean grant) throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("GRANT/REVOKE not supported.");
        return new BDLList(0);
    }

    private BDLList processConnect() throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("CONNECT not supported.");
        return new BDLList(0);
    }

    private BDLList processSet() throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("SET not supported.");
        return new BDLList(0);
    }

    private boolean processTrueOrFalse() throws HsqlException {
        String sToken = this.tokenizer.getString();
        if (sToken.equals("TRUE")) {
            return true;
        }
        if (sToken.equals("FALSE")) {
            return false;
        }
        throw Trace.error(11, sToken);
    }

    private BDLList processCommit() throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("COMMIT not supported.");
        return new BDLList(0);
    }

    private BDLList processRollback() throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("ROLLBACK not supported.");
        return new BDLList(0);
    }

    private BDLList processSavepoint() throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("SAVEPOINT not supported.");
        return new BDLList(0);
    }

    private BDLList processShutdown() throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("SHUTDOWN not supported.");
        return new BDLList(0);
    }

    private BDLList processCheckpoint() throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("CHECKPOINT not supported.");
        return new BDLList(0);
    }

    private BDLList checkIndexExists(String indexName, boolean yes) throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("INDEX not supported.");
        return new BDLList(0);
    }

    private BDLList checkTableExists(String tableName, boolean yes) throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("TABLE not supported.");
        return new BDLList(0);
    }

    private BDLList checkViewExists(String viewName, boolean yes) throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("VIEW not supported.");
        return new BDLList(0);
    }

    private BDLList checkTriggerExists(String triggerName, boolean yes) throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("TRIGGER not supported.");
        return new BDLList(0);
    }

    private BDLList processCreateAlias() throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("CREATE ALIAS not supported.");
        return new BDLList(0);
    }

    private BDLList processCreateIndex(boolean unique) throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("CREATE INDEX not supported.");
        return new BDLList(0);
    }

    private BDLList processCreateSequence() throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("CREATE SEQUENCE not supported.");
        return new BDLList(0);
    }

    private BDLList processCreateUser() throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("CREATE USER not supported.");
        return new BDLList(0);
    }

    private BDLList processDisconnect() throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("DISCONNECT not supported.");
        return new BDLList(0);
    }

    private BDLList processDropTable(boolean isView) throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("DROP TABLE not supported.");
        return new BDLList(0);
    }

    private BDLList processDropUser() throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("DROP USER not supported.");
        return new BDLList(0);
    }

    private BDLList processDropSequence() throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("DROP SEQUENCE not supported.");
        return new BDLList(0);
    }

    private BDLList processDropTrigger() throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("DROP TRIGGER not supported.");
        return new BDLList(0);
    }

    private BDLList processDropIndex() throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("DROP INDEX not supported.");
        return new BDLList(0);
    }

    private BDLList processExplainPlan() throws IOException, HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("EXPLAIN PLAN not supported.");
        return new BDLList(0);
    }

    private static String upgradeMethodFQN(String fqn) {
        return "";
    }

    private Class classForName(String fqn) throws ClassNotFoundException {
        return Object.class;
    }

    Result processSelectInto(Result result, HsqlNameManager.HsqlName intoHsqlName, int intoType) throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("SELECT INTO not supported.");
        return new Result(1);
    }

    private BDLList logTableDDL(XTMetaData md) throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("LOG not supported.");
        return new BDLList(0);
    }

    private BDLList processReleaseSavepoint() throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("SAVEPOINT not supported.");
        return new BDLList(0);
    }

    private String getJoinedColumnName(String cn, String src, TableFilter[] tfs) {
        XTMetaData srcMD = (XTMetaData)this.metaDataMap.get(src);
        Vector<String> conflictingSources = new Vector<String>();
        Enumeration keys = this.metaDataMap.keys();
        boolean anyNameConflicts = false;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            XTMetaData md = (XTMetaData)this.metaDataMap.get(key);
            if (md.nameToOrdinal(cn) == -1) continue;
            conflictingSources.add(key);
            anyNameConflicts = true;
        }
        if (!anyNameConflicts || tfs.length < 2) {
            return cn;
        }
        Hashtable<String, String> changedColumns = new Hashtable<String, String>();
        boolean isOne = src.equals(tfs[0].getName());
        boolean isTwo = src.equals(tfs[1].getName());
        int conflictNum = 0;
        int otherNum = 1;
        if (isOne) {
            conflictNum = 0;
            otherNum = 1;
        } else if (isTwo) {
            conflictNum = 1;
            otherNum = 0;
        }
        XTMetaData md1 = (XTMetaData)this.metaDataMap.get(tfs[0].getName());
        XTMetaData md2 = (XTMetaData)this.metaDataMap.get(tfs[1].getName());
        String cnT = cn;
        boolean cnFound = false;
        if (conflictNum != -1 && md1.nameToOrdinal(cn) != -1 && md2.nameToOrdinal(cn) != -1) {
            String keyCol = null;
            if (tfs[1].eAnd != null) {
                keyCol = conflictNum == 0 ? tfs[1].eAnd.getArg().getColumnName() : tfs[1].eAnd.getArg2().getColumnName();
            }
            if (!isOne && !isTwo) {
                cnT = cn + Integer.toString(conflictNum + 1);
                String cnOther = cn + Integer.toString(otherNum + 1);
                changedColumns.put(cnOther, cnOther);
            } else if (keyCol == null || !keyCol.equals(cn)) {
                return cn + Integer.toString(conflictNum + 1);
            }
            changedColumns.put(cnT, cnT);
        }
        if (md1.nameToOrdinal(cn) != -1 || md2.nameToOrdinal(cn) != -1) {
            changedColumns.put(cn, cn);
        }
        for (int i = 2; i < tfs.length; ++i) {
            XTMetaData mdn = (XTMetaData)this.metaDataMap.get(tfs[i].getName());
            if (mdn.nameToOrdinal(cn) == -1) continue;
            if (changedColumns.get(cn) != null && tfs[i].eAnd != null && !tfs[i].eAnd.getArg2().getColumnName().equals(cn)) {
                String sep = "";
                while (changedColumns.get(cn + sep + "1") != null) {
                    sep = sep + ".";
                }
                return cn + sep + "1";
            }
            changedColumns.put(cn, cn);
        }
        return cn;
    }

    private String strExpression(Expression expr, TableFilter[] tfs) throws HsqlException {
        Expression one = expr.getArg();
        Expression two = expr.getArg2();
        if (one == null && two == null) {
            block29: {
                String cn = expr.getColumnName();
                if (cn != null && cn.length() > 0) {
                    if (tfs == null || tfs.length == 1 || expr.getTableName() == null) {
                        return cn;
                    }
                    return this.getJoinedColumnName(cn, expr.getTableName(), tfs);
                }
                try {
                    String columnValue = expr.getValue().toString();
                    if (columnValue == null) break block29;
                    try {
                        Double.parseDouble(columnValue);
                    }
                    catch (Exception e) {
                        return "\"" + columnValue + "\"";
                    }
                    return columnValue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return "";
        }
        String exprStr = "";
        int exprType = expr.oldIType == -1 ? expr.exprType : expr.oldIType;
        switch (exprType) {
            case 21: {
                exprStr = " == ";
                break;
            }
            case 26: {
                exprStr = " != ";
                break;
            }
            case 24: {
                exprStr = " < ";
                break;
            }
            case 23: {
                exprStr = " > ";
                break;
            }
            case 25: {
                exprStr = " <= ";
                break;
            }
            case 22: {
                exprStr = " >= ";
                break;
            }
            case 28: {
                exprStr = " & ";
                break;
            }
            case 29: {
                exprStr = " | ";
                break;
            }
            case 11: 
            case 15: {
                exprStr = " + ";
                break;
            }
            case 12: {
                exprStr = " - ";
                break;
            }
            case 13: {
                exprStr = " * ";
                break;
            }
            case 14: {
                exprStr = " / ";
                break;
            }
            case 46: {
                exprStr = AggregateEngineNode.STD_DEV_METHOD_ATTRIBUTE_TAG;
                break;
            }
            case 45: {
                exprStr = AggregateEngineNode.VAR_METHOD_ATTRIBUTE_TAG;
                break;
            }
            case 40: {
                exprStr = AggregateEngineNode.COUNT_METHOD_ATTRIBUTE_TAG;
                break;
            }
            case 41: {
                exprStr = AggregateEngineNode.SUM_METHOD_ATTRIBUTE_TAG;
                break;
            }
            case 42: {
                exprStr = AggregateEngineNode.MIN_METHOD_ATTRIBUTE_TAG;
                break;
            }
            case 43: {
                exprStr = AggregateEngineNode.MAX_METHOD_ATTRIBUTE_TAG;
                break;
            }
            case 44: {
                exprStr = "avg";
                break;
            }
            default: {
                BigDataCommandInterpreter.unsupportedSQLFunction();
            }
        }
        if (one != null && two == null) {
            return this.strExpression(one, tfs) + "." + exprStr;
        }
        String firstExpr = this.strExpression(one, tfs);
        String secondExpr = this.strExpression(two, tfs);
        return "(" + firstExpr + exprStr + secondExpr + ")";
    }

    public String exprColumnName(Expression expr) throws HsqlException {
        Expression one = expr.getArg();
        Expression two = expr.getArg2();
        if (one == null && two == null) {
            String cn = expr.getColumnName();
            if (cn != null && cn.length() > 0) {
                return cn;
            }
            try {
                String columnValue = expr.getValue().toString();
                if (columnValue != null) {
                    return columnValue;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return "";
        }
        String exprStr = "";
        int exprType = expr.oldIType == -1 ? expr.exprType : expr.oldIType;
        switch (exprType) {
            case 21: {
                exprStr = ".EQUALS.";
                break;
            }
            case 26: {
                exprStr = ".NOT.EQUAL.";
                break;
            }
            case 24: {
                exprStr = ".LT.";
                break;
            }
            case 23: {
                exprStr = ".GT.";
                break;
            }
            case 25: {
                exprStr = ".LTE.";
                break;
            }
            case 22: {
                exprStr = ".GTE.";
                break;
            }
            case 28: {
                exprStr = ".AND.";
                break;
            }
            case 29: {
                exprStr = ".OR.";
                break;
            }
            case 11: 
            case 15: {
                exprStr = ".PLUS.";
                break;
            }
            case 12: {
                exprStr = ".MINUS.";
                break;
            }
            case 13: {
                exprStr = ".TIMES.";
                break;
            }
            case 14: {
                exprStr = ".DIV.";
                break;
            }
            default: {
                BigDataCommandInterpreter.unsupportedSQLFunction();
            }
        }
        String firstExpr = this.exprColumnName(one);
        String secondExpr = this.exprColumnName(two);
        return firstExpr + exprStr + secondExpr;
    }

    public String exprColumnType(Expression expr) throws HsqlException {
        Expression one = expr.getArg();
        Expression two = expr.getArg2();
        if (one == null && two == null) {
            String cn = expr.getColumnName();
            if (cn == null || cn.length() == 0) {
                try {
                    cn = expr.getValue().toString();
                    try {
                        Double.parseDouble(cn);
                        return XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG;
                    }
                    catch (NumberFormatException nfe) {
                        return XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            String type = "";
            Enumeration keys = this.metaDataMap.keys();
            while (keys.hasMoreElements()) {
                XTMetaData md = (XTMetaData)this.metaDataMap.get(keys.nextElement());
                String testType = md.getColumnType(cn);
                if (testType.length() <= 0) continue;
                type = testType;
                break;
            }
            return type;
        }
        String type1 = this.exprColumnType(one);
        String type2 = this.exprColumnType(two);
        if (type1.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG) || type2.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG)) {
            return XTMetaData.STRING_TYPE_ATTRIBUTE_TAG;
        }
        if (type1.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG) || type2.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
            return XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG;
        }
        return XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG;
    }

    private BDLList createEngineNodeList(String cmd, Object input, BDLList nodeProps, int numOutputs) {
        BDLList list = new BDLList(4);
        list.set(0, "cmd", cmd);
        list.set(1, "input", input);
        list.set(2, "node.props", nodeProps);
        list.set(3, "num.outputs", Integer.toString(numOutputs));
        return list;
    }

    private BDLList createEntryList(String name, Object entry) {
        BDLList list = new BDLList(1);
        list.set(0, name, entry);
        return list;
    }

    private BDLList createEntryList(String[] names, Object[] entries) {
        BDLList list = new BDLList(names.length);
        for (int i = 0; i < names.length; ++i) {
            list.set(0, names[i], entries[i]);
        }
        return list;
    }

    private BDLList createEntryList(Vector names, Vector entries) {
        BDLList list = new BDLList(names.size());
        for (int i = 0; i < names.size(); ++i) {
            list.set(0, (String)names.get(i), entries.get(i));
        }
        return list;
    }

    private BDLList processWhere(Expression where, TableFilter[] tfs, Object input) throws HsqlException {
        return this.processWhere(where, tfs, input, true);
    }

    private BDLList processWhere(Expression where, TableFilter[] tfs, Object input, boolean include) throws HsqlException {
        BDLList nodeProps = new BDLList(2);
        nodeProps.set(0, "testExpression", this.strExpression(where, tfs));
        nodeProps.set(1, "includeRows", include ? "true" : "false");
        return this.createEngineNodeList("com.insightful.miner.FilterRowsEngineNode", input, nodeProps, 1);
    }

    private BDLList processOrderBy(int[] sortOrder, int[] sortDirection, Expression[] exprList, TableFilter[] tfs, Object input) throws HsqlException {
        BDLList columnsToSort = new BDLList(sortOrder.length);
        BDLList sortDir = new BDLList(1);
        for (int i = 0; i < sortOrder.length; ++i) {
            sortDir.set(0, "ascending", sortDirection[i] == 1 ? "true" : "false");
            String cn = exprList[sortOrder[i]].getColumnName();
            String tn = exprList[sortOrder[i]].getTableName();
            String jName = this.getJoinedColumnName(cn, tn, tfs);
            columnsToSort.set(i, jName, sortDir);
        }
        return this.createEngineNodeList("com.insightful.miner.SortEngineNode", input, this.createEntryList("columnsToSort", columnsToSort), 1);
    }

    private BDLList processJoin(TableFilter[] inputs) throws HsqlException {
        return this.processJoin(inputs, null, 0);
    }

    private BDLList processJoin(TableFilter[] tfs, BDLList input, int rep) throws HsqlException {
        TableFilter one = tfs[rep];
        TableFilter two = tfs[rep + 1];
        BDLList iNames = new BDLList(2);
        Object oneInput = input;
        if (oneInput == null) {
            oneInput = one.getName();
        }
        iNames.set(0, "0", oneInput);
        iNames.set(1, "1", two.getName());
        BDLList unmatched = new BDLList(2);
        unmatched.set(0, "0", (two.isFullSpecified || two.isLeftSpecified) && two.isOuterJoin ? "true" : "false");
        unmatched.set(1, "1", two.isOuterJoin && (two.isFullSpecified || !two.isLeftSpecified) ? "true" : "false");
        BDLList keys = new BDLList(2);
        if (two.eAnd != null || two.eEnd != null) {
            Expression exp = two.eAnd != null ? two.eAnd : two.eEnd;
            String key1 = exp.getArg().getColumnName();
            String src1 = exp.getArg().getTableName();
            String key2 = exp.getArg2().getColumnName();
            String src2 = exp.getArg2().getTableName();
            if (!tfs[rep + 1].getName().equals(src2)) {
                String keyTemp = key2;
                String srcTemp = src2;
                key2 = key1;
                key1 = keyTemp;
                src2 = src1;
                src1 = srcTemp;
            }
            String jName1 = input == null ? key1 : this.getJoinedColumnName(key1, src1, tfs);
            String jName2 = input == null ? key2 : this.getJoinedColumnName(key2, src2, tfs);
            keys.set(0, "0", this.createEntryList("0", jName1));
            keys.set(1, "1", this.createEntryList("0", jName2));
        }
        BDLList nodeProps = new BDLList(5);
        nodeProps.set(0, "numInputs", "2");
        nodeProps.set(1, "keyColumn", two.eAnd != null ? "true" : "false");
        nodeProps.set(2, "includeUnmatched", unmatched);
        nodeProps.set(3, "inputKeys", keys);
        nodeProps.set(4, "sqlCrossJoin", two.isCrossJoin ? "true" : "false");
        BDLList joinList = this.createEngineNodeList("com.insightful.miner.JoinEngineNode", iNames, nodeProps, 1);
        if (rep + 2 == tfs.length) {
            return joinList;
        }
        return this.processJoin(tfs, joinList, rep + 1);
    }

    private String getAggregateMethod(int eType) {
        String aggStr = AggregateEngineNode.FIRST_METHOD_ATTRIBUTE_TAG;
        switch (eType) {
            case 44: {
                aggStr = AggregateEngineNode.MEAN_METHOD_ATTRIBUTE_TAG;
                break;
            }
            case 40: {
                aggStr = AggregateEngineNode.COUNT_METHOD_ATTRIBUTE_TAG;
                break;
            }
            case 43: {
                aggStr = AggregateEngineNode.MAX_METHOD_ATTRIBUTE_TAG;
                break;
            }
            case 42: {
                aggStr = AggregateEngineNode.MIN_METHOD_ATTRIBUTE_TAG;
                break;
            }
            case 41: {
                aggStr = AggregateEngineNode.SUM_METHOD_ATTRIBUTE_TAG;
                break;
            }
            case 46: {
                aggStr = AggregateEngineNode.STD_DEV_METHOD_ATTRIBUTE_TAG;
                break;
            }
            case 45: {
                aggStr = AggregateEngineNode.VAR_METHOD_ATTRIBUTE_TAG;
            }
        }
        return aggStr;
    }

    private boolean isGroupColumn(String cname, HashSet groups) {
        return cname != null && groups != null && groups.get(cname) != null;
    }

    private void getHavingConditions(Expression e, Vector hc) {
        Expression one = e.getArg();
        Expression two = e.getArg2();
        if (two == null) {
            if (one == null) {
                return;
            }
            hc.add(e);
        } else {
            this.getHavingConditions(one, hc);
            this.getHavingConditions(two, hc);
        }
    }

    private int createAggregateColumn(String cname, String tname, int eType, TableFilter[] tfs, BDLList addTo, int index) {
        String colName = this.getJoinedColumnName(cname, tname, tfs);
        String aggStr = this.getAggregateMethod(eType);
        BDLList aggregateInfo = new BDLList(2);
        aggregateInfo.set(0, AggregateEngineNode.SUMMARY_METHOD_ATTRIBUTE_TAG, aggStr);
        aggregateInfo.set(1, AggregateEngineNode.INPUT_NAME_ATTRIBUTE_TAG, colName);
        if (aggStr.equals(AggregateEngineNode.MEAN_METHOD_ATTRIBUTE_TAG)) {
            aggStr = "avg";
        }
        addTo.set(index, cname + "." + aggStr, aggregateInfo);
        return index + 1;
    }

    private Object processAggregate(Select sel, Object input) throws HsqlException {
        Expression[] e = sel.exprColumns;
        TableFilter[] tfs = sel.tFilter;
        int numAggs = 0;
        int numGroups = 0;
        boolean[] agg = new boolean[e.length];
        boolean[] gr = new boolean[e.length];
        boolean having = sel.havingCondition != null;
        Vector havingConditions = new Vector();
        for (int i = 0; i < e.length; ++i) {
            agg[i] = e[i].isAggregate();
            gr[i] = this.isGroupColumn(e[i].getColumnName(), sel.groupColumnNames);
            if (e[i] == sel.havingCondition) {
                havingConditions = new Vector();
                this.getHavingConditions(sel.havingCondition, havingConditions);
                numAggs += havingConditions.size();
                continue;
            }
            if (agg[i]) {
                ++numAggs;
                continue;
            }
            if (!gr[i]) continue;
            ++numGroups;
        }
        if (numAggs == 0) {
            return input;
        }
        BDLList outputColumns = new BDLList(numAggs);
        BDLList groupColumns = new BDLList(numGroups);
        int a = 0;
        int g = 0;
        for (int i = 0; i < e.length; ++i) {
            String tname;
            if (agg[i]) {
                if (e[i] == sel.havingCondition) {
                    for (int h = 0; h < havingConditions.size(); ++h) {
                        Expression expression = (Expression)havingConditions.get(h);
                        String cname = expression.getArg().getColumnName();
                        String tname2 = expression.getArg().getTableName();
                        a = this.createAggregateColumn(cname, tname2, expression.exprType, tfs, outputColumns, a);
                    }
                    continue;
                }
                String cname = e[i].getColumnName();
                tname = e[i].getTableName();
                a = this.createAggregateColumn(cname, tname, e[i].exprType, tfs, outputColumns, a);
                continue;
            }
            if (!gr[i]) continue;
            String cname = e[i].getColumnName();
            tname = e[i].getTableName();
            String colName = this.getJoinedColumnName(cname, tname, tfs);
            groupColumns.set(g++, colName, "");
        }
        BDLList nodeProps = new BDLList(2);
        nodeProps.set(0, AggregateEngineNode.SUMMARY_COLUMNS_ATTRIBUTE_TAG, outputColumns);
        nodeProps.set(1, AggregateEngineNode.AGGREGATE_COLUMNS_ATTRIBUTE_TAG, groupColumns);
        BDLList aggList = this.createEngineNodeList("com.insightful.miner.AggregateEngineNode", input, nodeProps, 1);
        if (!having) {
            return aggList;
        }
        return this.processWhere(sel.havingCondition, sel.tFilter, aggList);
    }

    private BDLList processSelect(CompiledStatement stat) throws HsqlException {
        Select sel = stat.select;
        int numSelCols = sel.exprColumns.length;
        boolean needFilterCols = numSelCols != 0;
        Object sqlInput = sel.tFilter[0].getName();
        if (sel.tFilter.length > 1) {
            sqlInput = this.processJoin(sel.tFilter);
        }
        sqlInput = this.processAggregate(sel, sqlInput);
        if (sel.sortOrder != null && sel.sortOrder.length != 0) {
            sqlInput = this.processOrderBy(sel.sortOrder, sel.sortDirection, sel.exprColumns, sel.tFilter, sqlInput);
        }
        if (sel.queryCondition != null && !sel.queryCondition.isInJoin) {
            sqlInput = this.processWhere(sel.queryCondition, sel.tFilter, sqlInput);
        }
        BDLList nodeProps = null;
        String cmd = null;
        if (needFilterCols) {
            int i;
            int numSortOrder = sel.sortOrder == null ? 0 : sel.sortOrder.length;
            int[] nonSortCols = new int[numSelCols - numSortOrder];
            int numCreateCols = 0;
            int selCol = 0;
            for (int i2 = 0; i2 < numSelCols; ++i2) {
                boolean isSortCol = false;
                for (int j = 0; !isSortCol && j < numSortOrder; ++j) {
                    if (i2 != sel.sortOrder[j]) continue;
                    isSortCol = true;
                }
                if (isSortCol) continue;
                nonSortCols[selCol++] = i2;
                String cname = sel.exprColumns[i2].getColumnName();
                if (sel.exprColumns[i2] == sel.havingCondition || sel.exprColumns[i2].isAggregate() || this.isGroupColumn(cname, sel.groupColumnNames) || sel.exprColumns[i2].getArg() == null || sel.exprColumns[i2].getArg2() == null) continue;
                ++numCreateCols;
            }
            if (numCreateCols != 0) {
                cmd = "com.insightful.miner.CreateColumnsEngineNode";
                BDLList colsToCreate = new BDLList(numCreateCols);
                int ccol = 0;
                for (i = 0; i < nonSortCols.length; ++i) {
                    int colNum = nonSortCols[i];
                    String cname = sel.exprColumns[colNum].getColumnName();
                    if (sel.exprColumns[colNum] == sel.havingCondition || this.isGroupColumn(cname, sel.groupColumnNames) || sel.exprColumns[colNum].isAggregate() || sel.exprColumns[colNum].getArg() == null || sel.exprColumns[colNum].getArg2() == null) continue;
                    String exprStr = this.strExpression(sel.exprColumns[colNum], sel.tFilter);
                    String colName = this.exprColumnName(sel.exprColumns[colNum]);
                    String exprType = this.exprColumnType(sel.exprColumns[colNum]);
                    BDLList createDetails = new BDLList(2);
                    createDetails.set(0, "expression", exprStr);
                    createDetails.set(1, "type", exprType);
                    colsToCreate.set(ccol++, colName, createDetails);
                }
                nodeProps = this.createEntryList("newColumns", colsToCreate);
                sqlInput = this.createEngineNodeList(cmd, sqlInput, nodeProps, 1);
            }
            cmd = "com.insightful.miner.FilterColumnsEngineNode";
            BDLList selCols = new BDLList(nonSortCols.length);
            for (i = 0; i < nonSortCols.length; ++i) {
                int colNum = nonSortCols[i];
                String cname = sel.exprColumns[colNum].getColumnName();
                String src = sel.exprColumns[colNum].getTableName();
                if (sel.exprColumns[colNum] == sel.havingCondition) continue;
                if (sel.exprColumns[colNum].isAggregate()) {
                    String aggType = this.getAggregateMethod(sel.exprColumns[colNum].exprType);
                    if (aggType.equals(AggregateEngineNode.MEAN_METHOD_ATTRIBUTE_TAG)) {
                        aggType = "avg";
                    }
                    cname = cname + "." + aggType;
                } else {
                    cname = sel.exprColumns[colNum].getArg() != null && sel.exprColumns[colNum].getArg2() != null ? this.exprColumnName(sel.exprColumns[colNum]) : this.getJoinedColumnName(cname, src, sel.tFilter);
                }
                selCols.set(i, cname, "true");
            }
            nodeProps = this.createEntryList("sqlIncludeColumns", selCols);
        } else {
            cmd = "com.insightful.miner.ModifyColumnsEngineNode";
            nodeProps = new BDLList(0);
        }
        BDLList filterColsList = this.createEngineNodeList(cmd, sqlInput, nodeProps, 1);
        return filterColsList;
    }

    private BDLList processInsert(CompiledStatement stat) throws HsqlException {
        String tname = stat.tableName;
        XTMetaData md = (XTMetaData)this.metaDataMap.get(tname);
        int numcolumns = stat.columnValues.length;
        String appendDF = "data.frame(";
        for (int i = 0; i < numcolumns; ++i) {
            if (i != 0) {
                appendDF = appendDF + ", ";
            }
            appendDF = appendDF + md.ordinalToName(stat.columnMap[i]) + "=c(";
            for (int j = 0; j < stat.columnValues[i].getNumValues(); ++j) {
                String value = stat.columnValues[i].getValueAt(j).toString();
                if (stat.columnValues[i].getValueClassName().equals("java.lang.String")) {
                    value = "'" + value + "'";
                }
                if (j != 0) {
                    appendDF = appendDF + ", ";
                }
                appendDF = appendDF + value;
            }
            appendDF = appendDF + ")";
        }
        appendDF = appendDF + ")";
        BDLList input = new BDLList(2);
        input.set(0, "0", tname);
        input.set(1, "1", appendDF);
        BDLList appendList = this.createEngineNodeList("com.insightful.miner.AppendEngineNode", input, this.createEntryList("joinType", "full"), 1);
        return appendList;
    }

    private BDLList processUpdate(CompiledStatement stat) throws HsqlException {
        BDLList whereExpr = stat.condition != null ? this.processWhere(stat.condition, new TableFilter[0], "") : null;
        String whereStr = whereExpr != null ? whereExpr.getValueBDLList(2).getValueString(0) : null;
        String tname = stat.tableName;
        BDLList colsToCreate = new BDLList(stat.columnValues.length);
        for (int i = 0; i < stat.columnValues.length; ++i) {
            Expression exp = stat.columnValues[i];
            String str = this.strExpression(exp, new TableFilter[0]);
            String exprType = this.exprColumnType(exp);
            XTMetaData md = (XTMetaData)this.metaDataMap.get(tname);
            String setColName = md.ordinalToName(stat.columnMap[i]);
            String createColStr = whereStr != null ? "ifelse(" + whereStr + "," + str + "," + setColName + ")" : str;
            BDLList createDetails = new BDLList(2);
            createDetails.set(0, "expression", createColStr);
            createDetails.set(1, "type", exprType);
            colsToCreate.set(i, setColName, createDetails);
        }
        String cmd = "com.insightful.miner.CreateColumnsEngineNode";
        BDLList nodeProps = this.createEntryList("newColumns", colsToCreate);
        return this.createEngineNodeList(cmd, tname, nodeProps, 1);
    }

    private BDLList processDelete(CompiledStatement stat) throws HsqlException {
        BDLList whereExpr = this.processWhere(stat.condition, new TableFilter[0], stat.tableName, false);
        return whereExpr;
    }

    private BDLList processCall(CompiledStatement stat) throws HsqlException {
        BigDataCommandInterpreter.unsupportedSQLFunction("CALL not supported.");
        return new BDLList(0);
    }

    private static void unsupportedSQLFunction() throws HsqlException {
        String fxn = new Exception("").getStackTrace()[1].getMethodName();
        String msg = fxn + " not supported.";
        BigDataCommandInterpreter.unsupportedSQLFunction(msg);
    }

    private static void unsupportedSQLFunction(String msg) throws HsqlException {
        throw new HsqlException(msg, msg, 40);
    }

    private class SQLMetaData
    extends XTMetaData {
        private HashMap names2sql;
        private HashMap sql2names;

        public SQLMetaData(XTMetaData md) throws Exception {
            super(md);
            this.names2sql = null;
            this.sql2names = null;
            Vector names = this.getColumnNames();
            int numCols = names.size();
            this.names2sql = new HashMap(numCols);
            this.sql2names = new HashMap(numCols);
            for (int i = 0; i < numCols; ++i) {
                String name = (String)names.get(i);
                String sql = name.toUpperCase();
                this.names2sql.put(name, sql);
                this.sql2names.put(sql, name);
            }
        }
    }
}

