#!/bin/sh
# script executed if nothing in S_WORK shell variable is acceptable
: ${S_WORK?}
trap  "exit 1" 2	# on interrupt
echo "None of the following directories exist with read/write/search permission:"
IFS=":"
set $S_WORK
for i
do
	echo $i
	ls -ld $i 2>/dev/null
done
echo ""
echo "To create one or fix its permissions, type its name;"
echo "Otherwise, type 'q' or a blank line to exit"
while :
do
	read ans
	case $ans in
	q)		exit 1;;	# quit
	[/a-zA-Z.0-9]*)	if test -d $ans
			then
				chmod 755 $ans && echo "permissions changed on $ans" && break
				echo "Couldn't change permissions on  directory $ans"
			else
				mkdir $ans && echo "created directory $ans" && break
				echo "Couldn't create directory $ans"
			fi
		;;
	?*)		echo "bad name; try again";;
	*)		exit 1;;	# blank line, quit
	esac
done
exit 0
