#ifndef S_R_DEFINES_H /* ( */
#define S_R_DEFINES_H

/* In R, Rdefines.h defines Splus macros in terms
 * of R constructs.  Also defines some related macros
 * like CREATE_STRING_VECTOR.
 */

#include <Rinternals.h>

#ifdef __cplusplus
extern "C" {
#endif

#define COPY_TO_USER_STRING(a) c_s_cpy(a, S_evaluator)
#define CREATE_FUNCTION_CALL(name, argList) alcf(name, argList, S_evaluator)
#define CREATE_STRING_VECTOR(a) STRING_VECTOR(a, S_evaluator)
#define NULL_USER_OBJECT R_NilValue
#define GET_SLOT(x, what) ((x)->value.tree[SLOT_POSITION(x, mkString(what))])
#define NEW_STRING(n) NEW_CHARACTER(n)

#ifdef SET_CLASS
#undef SET_CLASS
#endif
#define SET_CLASS(obj,classname)  set_attr((obj), "class", (classname), S_evaluator)

#ifdef GET_CLASS
#undef GET_CLASS
#endif
#define GET_CLASS(x) GET_ATTR((x), "class")

#define NEW_OBJECT(class_def) NEW(class_def)


#ifdef __cplusplus
}
#endif

#endif /* S_R_DEFINES_H) */
