/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile: S_memory.h,v $: $Revision: #10 $, $Date: 2006/06/26 $  */
#ifndef S_MEMORY_H
#define S_MEMORY_H 1
#include <stdio.h>
#include <sys/mman.h>

#ifndef STANDARD_MALLOC
#include "vmalloc.h"
#endif

#include "S_mmap.h"  /* contains public defines and functions */

#ifdef __cplusplus
extern "C" {
#endif

/* some versions of mman.h don't provide MAP_NORESERVE.  We define it */
/* to be zero, and then expect code that depends on it to check for a */
/* zero definition */
#ifndef MAP_NORESERVE
#define MAP_NORESERVE 0
#endif

/* some versions of mman.h don't provide MAP_AUTOGROW.  We define it */
/* to be zero, and then expect code that depends on it to check for a */
/* zero definition */
#ifndef MAP_AUTOGROW
#define MAP_AUTOGROW 0
#endif


typedef struct s_mmap_struct s_mmap;

/* the following definition would be nicer if it used information */
/* built into the map when it was created.  To do so requires */
/* information in each frame about the stability or not of the objects */
/* in that frame (e.g., provided by semantic analysis) */
/* Also, the following can fail to detect an unstable map when an */
/* assignment occurs inside an argument expression, with lazy */
/* evaluation. The desired cure is probably to detect such assignments */
/* and pre-evaluate arguments */

/* 
 * AIX 4.3.1 defines MAP_TYPE in mman.h with totaly different meaning
 * (for _ALL_SOURCE). Redefine here to be 0xf.  -sea.
 *
 * Same for OSF1 V4.
 */

#if defined(_AIX) || defined(__osf__) /*(*/
#undef MAP_TYPE
#define MAP_TYPE 0xF
#endif /*)*/

#define MAPPED_SHARED(map) ((map) && (map->flags & MAP_TYPE) == MAP_SHARED)
#define MAPPED_PRIVATE(map) ((map) && (map->flags & MAP_TYPE) == MAP_PRIVATE)

#define MAPPABLE_MODE(m) (m < MAX_ATOMIC && mappable_modes[m])
extern s_boolean mappable_modes[];

extern s_mmap *copy_mmap(s_mmap *map, char *from, char **to_p, size_t
			 length, unsigned size, s_evaluator *S_evaluator);
extern size_t mmap_threshold; extern int mmap_protection, mmap_flags, mmap_page;
extern s_mmap *alloc_mmap(size_t len, int prot, int flags, FILE *f, off_t
		      offset, char *path, s_evaluator *S_evaluator);
extern void move_mapped_data(s_object *from, s_evaluator *S_evaluator);
extern void mem_init(void);
extern int unstable_map(s_object *ent);
extern s_boolean set_length_mapped(s_object *obj, long len, s_evaluator *S_evaluator);
extern void incr_map_ref(s_object *obj, s_object *frame, s_evaluator *S_evaluator);
extern void no_longer_need_map(s_mmap *map, s_evaluator *S_evaluator);
extern s_boolean decr_map_ref(s_object *obj, s_boolean unmap, int how_much, s_evaluator *S_evaluator);
extern void free_local_maps(s_index_table *m_table, int frame, s_evaluator *S_evaluator);

extern void set_frame_map(long frame, s_index_table *value, s_evaluator *S_evaluator);
extern s_index_table *get_frame_map(long frame, s_evaluator *S_evaluator);

extern int mem_debug;
#ifdef __cplusplus
}
#endif
#endif
