#ifndef DISPLAY_LIST_H

#define DISPLAY_LIST_H

#include "S_engine.h"

#include "list_dev_defs.h"
#include "USRPrototypes.h"
#include "graphics.h"

#define curam(i)        current_am[(i)-1]

/*  Defines to turn off the alarm or */
/*  set the alarm for the next second */
#define ALARM_NO     alarm(0)
/* for Sys V machines, turn off alarms altogether until fix found
 * for problem of alarm interrupting system calls that cannot then
 * be restarted
 */
#define ALARM_YES    alarm(0)
#define DISPLAY_LIST    1

#define TEXT    1       /* display list item types */
#define MRKS    2
#define LINS    3
#define POLY    4
#define SEGS    5
#define AMOD    6
#define IMAG    7


extern float current_am[200];


/* Function prototypes */

void
addToDisplayList(device *dev, DisplayListItem *item, s_evaluator *S_evaluator);

void 
insertItem(device *dev, DisplayListItem *item);
void
redrawDisplayList(device *dev, s_evaluator *S_evaluator);
void
freeDisplayList(device *dev, s_evaluator *S_evaluator);
DisplayListItem *
imagItem(device *dev, float *where, char *filename, s_evaluator *S_evaluator);
DisplayListItem *
amodItem(device *dev, float *par, int n, s_evaluator *S_evaluator);
DisplayListItem *
polyItem(device *dev, float *x, float *y, long nxy, s_evaluator *S_evaluator);
DisplayListItem *
segsItem(device *dev, float *x0, float *y0, float *x1,float *y1, long nxy, s_evaluator *S_evaluator);
DisplayListItem *
linsItem(device *dev, float *x, float *y,long nxy, s_evaluator *S_evaluator);
DisplayListItem *
mrksItem(device *dev, float *x, float *y, long nxy, s_evaluator *S_evaluator);
DisplayListItem *
textItem(device *dev, double x, double y, char *str, long Strlen, double adj, s_evaluator *S_evaluator);


vector *
s_gr_text(device *dev, float *x, float *y, F_CHARTYPE str, long *l, float *adj, s_evaluator *S_evaluator);
vector *
s_gr_marks(device *dev, float *x, float *y, long *n, s_evaluator *S_evaluator);
vector *
s_gr_lines(device *dev, float *x, float *y, long *n, s_evaluator *S_evaluator);
vector *
s_gr_segments(device *dev,float *x0, float *y0, float *x1, float *y1, long *n, s_evaluator *S_evaluator);
vector *
s_gr_polygon(device *dev, float *x, float *y,long *n, s_evaluator *S_evaluator);


void 
drawItem(device *dev, DisplayListItem *item, s_evaluator *S_evaluator);

void 
doAmodUpdate(device *dev, AmodItem *item, s_evaluator *S_evaluator);
#ifdef check
#undef check
#endif
static void 
check(device *dev, s_evaluator *S_evaluator);


extern vector *
s_gr_flush(device *dev, s_evaluator *S_evaluator);

extern vector *
s_gr_clear(device *dev, s_evaluator *S_evaluator);

extern vector *
s_gr_wrap(device *dev, s_evaluator *S_evaluator);

extern vector *
s_gr_signalled(device *dev, s_evaluator *S_evaluator);


vector *
s_gr_input(device *dev,float x[], float y[], long *n, long *nmax, s_evaluator *S_evaluator);

vector *
s_gr_menu(device *dev, vector *ent, vector *arglist, s_evaluator *S_evaluator);

vector *
s_gr_hook(device *dev, s_evaluator *S_evaluator);

vector *
s_gr_length(device *dev, s_evaluator *S_evaluator);


extern unsigned int alarm();

void 
initDisplayList(device *dev);


vector *DNAME();


#ifndef NO_AUTO_DEF
static device d_DNAME = {
        -1L,
        NULL,
        NULL, NULL,
        FALSE                   /* active */
        ,0                      /* which (index into list of devices) */
        ,(float *) NULL         /* pointer to parameters */
        ,0                      /* nlocal */
        ,(char *) NULL          /* pointer to local parameters */
        ,1, 0,
        {  /* Device specific rendering functions, fully type checked.
              See USRPrototypes.h for basic flavour - names and arguments.
            */
         USRtext,
         USRmrks,
         USRlins,
         USRsegs,
         USRpoly,
         USRimage,
         USRamodes, 
         USRamReset,
         USRwrap, 
         USRclear,
         USRflush,
         NULL, /* USRinput, */
         USRmenu,
         USRhook, 
         NULL,  /* USRlength */
         USRsignalled,
         USRprocessEvents,
         USRgetFileDescriptor
        }
        ,{            /***** driver routines called from graphics.c *****/
                      /* Cause the action - plotting or tidying,     */
                      /* etc. - to be called. Often these are    
                      /* calls to functions which do something to the */
                      /* data before invoking the real rendering      */
                      /* routine (which are in the render struct      */
                      /* above)                                       */
                DNAME           /* initialization */
                ,s_gr_wrap           /* wrap up the job */
                ,s_gr_flush          /* bring output up to date */
                ,s_gr_signalled      /* fix up on interrupt */
                ,s_gr_marks          /* draw points */
                ,s_gr_lines          /* draw lines */
                ,s_gr_polygon        /* draw polygon */
                ,s_gr_text           /* draw text */
                ,s_gr_segments       /* draw segments */
                ,s_gr_clear          /* clear canvas */
                ,s_gr_input          /* graphic input */
                ,s_gr_menu           /* menu */
                ,s_gr_hook           /* hook */
                ,NULL           /* seek */
                ,NULL           /* point */
                ,NULL           /* line */
                ,s_gr_length         /* length */
                ,NULL           /* query */
                ,NULL           /* clear canvas */
                ,NULL
        }

};

#endif

#endif
