
#include "eval.h"


#ifdef S_DEBUG_API_HOOKS

/*********************************************************/
/*                                                       */
/*              EXTERN PROTOTYPES                        */
/*                                                       */
/*********************************************************/
extern long s_do_profiling_work;

/* function called for each eval loop...should handle functions */
void s_do_profiling_work_for_functions(s_object *eval);

/* function called for each allocation */
void s_do_profiling_work_for_allocations(long amount, long mode);

/* functions used to retrieve the last profiled function */
void s_set_last_profiled_function(char *fxn);
char* s_get_last_profiled_function();


/* define a function pointer type for the function profile handling function */
typedef void (*S_DO_PROFILE_FUNCTION)(long current_frame, char *fxn, s_object *eval);
/* define a function pointer type for the allocation profile handling functions */
typedef void (*S_DO_PROFILE_ALLOCATION)(long current_frame, long amount, long mode);


/*********************************************************/
/*                                                       */
/*           EXTERNAL INTERFACE FUNCTIONS                */
/*                                                       */
/*********************************************************/

int s_set_profile_function_handler_command_line();
int s_set_profile_allocation_handler_command_line();
int s_set_profile_function_handler_by_ptr(S_DO_PROFILE_FUNCTION *ptr);
int s_set_profile_allocation_handler_by_ptr(S_DO_PROFILE_ALLOCATION *ptr);


/* set and reset profile mode */
void s_set_profile_mode();
void s_reset_profile_mode();

/* set/reset profile output stream */
void s_set_profile_output(char **filename);
void s_reset_profile_output();

#endif /*S_DEBUG_API_HOOKS*/





