/* @(#)Copyright (c), 1987, 1998 StatSci, Inc.  All rights reserved. */
/* @(#)notif.h version 3.25 created 11/16/98 */

#ifndef S_NOTIF_H
#define S_NOTIF_H

#include "S_engine.h" 
#include <time.h> 
#include <sapi/types.h>

#define NOTIFY_SUMFILENAME      "__sum4.txt"
#define NOTIFY_INDEX_SUMFILENAME  "__sum4i.txt"

#define NOTIFY_SUMOLDNAME       "__sum.txt"
#if defined(IGNORE_V33_SUMMARY_FILES) /*(*/
#include "data.h"
#define SNotifyOpenSummaryFile DB_fopen
#else /*)(*/
extern FILE *SNotifyOpenSummaryFile(char *filename, char *mode);
#endif /*)*/

#if defined(S_API_EXCEPTION_NAMES)
char* exceptnames[]={"class",".Dim",".Dimnames",".Tsp","tspar",".guiColInfo",".guiObjInfo"};
int nexceptnames=sizeof(exceptnames)/sizeof(char*);
#else 
extern char* exceptnames[];
extern int nexceptnames;
#endif /*  S_API_EXCEPTION_NAMES */

#define S_GetExceptNames() (exceptnames)
#define  S_GetExceptNamesLength() (nexceptnames)

#define NOTIFY_SUMDELIM '\\'
/* Remove this line and the above line when ready to shift to new delimiter   */
#if 0
#define NOTIFY_SUMDELIM '023' /* =0x13 =DC3 */
#endif 

#define S_OID_TABLE_SAVED 0
#define S_NO_OID_TABLE 1
#define S_NO_OLD_METAINFO 2
#define S_CANNOT_OPEN_SUMMARY_INDEX_FILE 3


/* C notification function definitions */
/***************************************/

/* Type of notification events */
typedef enum {
        SAttach=0,
        SDetach=1,
        SRemove=2,
        SCreate=3,
        SRead=4
} SNotifyType;

typedef struct {
	SNotifyType type;
	char* db_name;
	char* db_path;
	long  db_position;
	char* object_name;
} SUpdateEvent;	
 
/* C type for an actual OID */
/* OID's are 1 based index. OID_ERROR==0 is an illegal OID */
/* VID's are starting at 1, 0 is an illegal value */
#define OID_ERROR       0
#define VID_ERROR       0
typedef unsigned long S_OID;
typedef unsigned long S_VID;
typedef int S_Specifier;

#define S_IS_FUNCTION       0x01
#define S_IS_DATA_FRAME     0x02
#define S_IS_NONE           0x00


typedef struct {
        S_OID oid;
        S_VID vid;
        time_t timestamp;
        short masked;
        short is_func_or_dframe;
        long position;
        S_apiObject* deep_summary;
 } SNotifyMetainfo;
 
 
/* return values for SNotifyReadSummaryLine */
typedef enum {
	SReadSumErrFormat=-2,
	SReadSumErrAlloc=-1,
	SReadSumSuccess=0,
	SReadSumClassData=0,
	SReadSumClassFunc=1
} SReadSumStatus;

/* Prototype of all C notification functions */
typedef void (*SCNotifyFunction) PARAMS((
        SNotifyType type,    /* type of notification */
        char* db_name,       /* name of DB */
        char* db_path,       /* path of DB or NULL */
        long  db_position,   /* position of DB */
        char* object_name,   /* name of object or NULL */
        SNotifyMetainfo* metainfo,  /* metainfo of object or NULL */
        /* vector of OIDs of objects above db_position with the 
        same object name, or a name of an object from  db_position (on SAttach or 
        SDetach). These are masking objects. Returns blt_in_NULL if none */ 
        S_apiObject* above, 
        /* vector of OIDs of objects below db_position with the 
        same object name, or a name of an object from  db_position (on SAttach or 
        SDetach). These are masked (or unmasked) objects.  Returns blt_in_NULL if 
        none */ 
        S_apiObject* below,
        /* Object itself, or NULL */
        S_apiObject* ent)); 
        
typedef struct {
    char* summary_file;   /* Summary file name for deep summaries and metainfo */
    char* summary_index_file; /* Index filename for the summary file to speed up startup */
} S_SummaryFileNames;


/* Function to register C notification functions with S */
extern void SRegisterCNotifyFunction PARAMS((SCNotifyFunction function));

/* Unregistration  */
/*******************/

/* Unregistration of C notification functions */
extern void SUnregisterCNotifyFunction PARAMS((SCNotifyFunction function));

/* Initializes notification */
extern void S_NotifyInit PARAMS((void));	 

/* Gets, and possibly sets, the state of "are notifications enabled for this */
/* top level eval?". */
extern int SNotifyState PARAMS((int set_state));
#define SGetNotifyState() SNotifyState(-1)

extern int  S_NotifyDBPositionFromSummaryFile PARAMS((char *filename,
	int *dbname_length));

extern void S_NotifyUpdateSummaryTable PARAMS((S_SummaryFileNames *filename));

extern void SNotifyFreeMetainfo PARAMS((SNotifyMetainfo *metainfo));

extern void SNotify PARAMS((SNotifyType type,
        char* db_name,
        char* db_path,
        long  db_position,
        char* object_name,
        S_apiObject* ent));

extern void SCallNotify PARAMS((SNotifyType type,
        char* db_name,
        char* db_path,
        long  db_position,
        char* object_name,
        SNotifyMetainfo* metainfo,
        S_apiObject* above, 
        S_apiObject* below,
        S_apiObject* ent));

extern void S_NotifyLoadSummaryTable PARAMS((S_SummaryFileNames* filename, long position));
extern S_apiStatus S_ObjDumpSummary PARAMS((S_apiObject **objs, long n, FILE* file));
extern S_apiObject* S_ObjRestoreSummary PARAMS((FILE* file));
extern SNotifyMetainfo*  S_NotifyComputeMetainfo PARAMS((S_apiObject* ent,
                                                        char* object_name,
                                                        long db_position, int bnew));
extern SNotifyMetainfo*  S_NotifyCloneMetainfo PARAMS((SNotifyMetainfo* metainfo));
extern int S_PartialDestroy PARAMS((S_apiObject *obj,int dup_data));
extern S_apiObject* S_NotifyCreateDBSummaryList PARAMS((long position,int anyDataClass,
                                                S_apiObject     *DataClass));
extern int S_NotifyInsertInSummaryByPosition PARAMS((long position, char* name, 
                                             SNotifyMetainfo* metainfo));
extern S_apiObject* S_make_meta_obj PARAMS((char* name, S_Specifier specifier,
                                           SNotifyMetainfo *metainfo));

extern S_apiObject* S_DB_make_names PARAMS((long db_position));
extern S_apiObject* S_make_range PARAMS((long min_db, long max_db));
extern S_OID S_exists_in_DB PARAMS((char* obj_name, long db_position));
extern S_apiObject* S_obj_exists  PARAMS((char* obj_name, long db_pos));
extern S_apiObject* S_exist_in_DB_range PARAMS((S_apiObject* names, 
                                               S_apiObject* range)); 
extern S_apiObject* S_above PARAMS((S_apiObject* names, long db_position));
extern S_apiObject* S_above1 PARAMS((char* name, long db_position));
extern S_apiObject* S_below PARAMS((S_apiObject* names, long db_position));
extern S_apiObject* S_below1 PARAMS((char* name, long db_position));
extern S_apiObject* S_make_names PARAMS((char* name));
extern int StringMatch(char *pszFindString, S_apiObject *pStringList, 
                        int iAllowInverts);
extern S_apiStatus S_create_in_sumfile(S_SummaryFileNames* sum_filename,char* object_name, 
                     time_t timestamp, S_apiObject* deep_summary, short is_func_or_dframe,
                                        long db_index,long fposition); 
extern long match_sumfile PARAMS((char* sumfilename)); 
extern S_apiObject*  S_OIDGetSummaries PARAMS((S_apiObject* oidsobj));
extern S_apiObject*  S_NotifyGetSummariesByOID PARAMS(( S_apiObject* ent, 
                                                        S_apiObject* arglist));
extern int S_NotifySaveSummary PARAMS((char* filename, long position));
extern int S_NotifySaveOIDTableByPosition PARAMS((long position));
extern void S_wipe_index_summary_file PARAMS((int db_index));
extern void S_wipe_summary_files PARAMS((int db_index));
	
#endif /* S_NOTIF_H  */    
