#ifndef S_OPTIONS_H
#define S_OPTIONS_H 1
#ifdef __cplusplus
extern "C" {
#endif

#define MAX_OPT_STRING 80

#if !defined(NOT_C_SOURCE) /*(*/
typedef struct s_options {
	int echo_on;
	char prompt[MAX_OPT_STRING];
	char c_prompt[MAX_OPT_STRING];
	long p_width;
	long p_length;
	long data_hash;
	long Max_block;
	long Max_memory;
	long Max_audit;
	int Check;
	int Err_code;
	long N_digits;
	int Gr_show;
	long S_Compact;
	long S_scrap;
        long S_scrap_length; /* scrap converted, nominally, to no. of doubles */
	long S_free_level;
	long S_warn_level;
	long S_expr_depth;
	long S_core_dump;
	int S_verify_level;
	int S_object_depth;
	int S_audit_level;
  	int S_conflicts_ok;
  	long S_complete_args;
  	s_object *S_Indentation;
        s_boolean S_Immediate;
		} Options;
#endif /*)*/

#define S_options S_evaluator->_S_options

#define scrap S_options->S_scrap
#define scrap_length S_options->S_scrap_length

#define S_echo_on S_options->echo_on
#define S_OPT_AUTOPAGESIZE_BIT		0x80000000
#define IS_S_OPT_AUTOPAGESIZE(x)	((x) & S_OPT_AUTOPAGESIZE_BIT)
#define SET_S_OPT_AUTOPAGESIZE(x)	((x) | S_OPT_AUTOPAGESIZE_BIT)
#define UNSET_S_OPT_AUTOPAGESIZE(x)	((x) & ~S_OPT_AUTOPAGESIZE_BIT)
#define S_OPT_AUTOPAGESIZE_STR		"auto"
#define S_opt_p_width S_options->p_width
#define S_opt_p_length S_options->p_length
#if defined(WIN32) /*(*/
#if defined(S_ENGINE_BUILD) /*(*/
#define S_p_width			S_stdout_p_width
#define S_p_length			S_stdout_p_length
#else /*)(*/
#define S_p_width			UNSET_S_OPT_AUTOPAGESIZE(S_opt_p_width)
#define S_p_length			UNSET_S_OPT_AUTOPAGESIZE(S_opt_p_length)
#endif /*)*/
#define S_set_p_width		S_opt_p_width
#define S_set_p_length		S_opt_p_length
#if defined(S_ENGINE_BUILD) /*(*/
#define S_stdout_p_width	SGUI_PageDim(S_FALSE, "stdout")
#define S_stdout_p_length	SGUI_PageDim(S_TRUE, "stdout")
#define S_stderr_p_width	SGUI_PageDim(S_FALSE, "stderr")
#define S_stderr_p_length	SGUI_PageDim(S_TRUE, "stderr")
#if !defined(NOT_C_SOURCE) /*(*/
LibExtern long S_STDCALL SGUI_PageDim(s_boolean get_length, char *page_name);
#endif /*)*/
#endif /*)*/
#else /*)(*/
#define S_p_width			UNSET_S_OPT_AUTOPAGESIZE(S_opt_p_width)
#define S_p_length			UNSET_S_OPT_AUTOPAGESIZE(S_opt_p_length)
#define S_set_p_width		S_opt_p_width
#define S_set_p_length		S_opt_p_length
#define S_stdout_p_width	S_p_width
#define S_stdout_p_length	S_p_length
#define S_stderr_p_width	S_p_width
#define S_stderr_p_length	S_p_length
#endif /*)*/
#define S_prompt S_options->prompt
#define S_cont_prompt S_options->c_prompt
#define S_error_code S_options->Err_code

#if defined(S_COMPATIBILITY) && S_COMPATIBILITY >= 10 /* PRIVATE DEFINES (*/
#define cont_prompt S_options->c_prompt
#define n_digits S_options->N_digits
#define Data_hash S_options->data_hash
#define max_block S_options->Max_block
#define max_memory S_options->Max_memory
#define max_audit S_options->Max_audit
#define S_check S_options->Check
#define gr_show S_options->Gr_show
#define Compact S_options->S_Compact
#define free_level S_options->S_free_level
#define warn_level S_options->S_warn_level
#define expr_depth S_options->S_expr_depth
#define core_dump S_options->S_core_dump
#define object_depth S_options->S_object_depth
#define verify_level S_options->S_verify_level
#define audit_level S_options->S_audit_level
#define conflicts_ok S_options->S_conflicts_ok
#define Indentation S_options->S_Indentation
#define complete_args S_options->S_complete_args
#define Immediate S_options->S_Immediate
#endif /* ) end of PRIVATE DEFINES */

#ifdef __cplusplus
}
#endif
#endif
