#include <guidefs.h>
POUND $RCSfile: x11.make,v $ version $Revision: 3.55 $ created $Date: 2001/03/02 01:59:23 $
POUND Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved.
POUND

POUND To load against debuggable MIT X11 libraries, create the Smakefile like this:
POUND     % rm smake
POUND     % env CPP_FLAGS=-DDebugX11Libs Splus MAKE smake
POUND     % ...
POUND This should cause the MIT X11 'libg' directory to get prepended to the
POUND library search path for the load. Because this is going to end up
POUND preferring the MIT libs, we also prepend the MIT X11 'include' directory
POUND to the include path. It also forces "static" loads instead of shared
POUND library loads, since we only have debuggable .a files.
POUND
POUND Also, the MIT X11R5 build process will create debuggable libraries like
POUND "libX11_d.a" and install them into the standard .../lib directory. In
POUND order for this stuff to work, those files need to be renamed...for
POUND example,
POUND     % mv lib/libX11_d.a libg/libX11.a
POUND

/* Setup the library referencing macro. */
#ifdef DebugX11Libs
OPTIMIZE_FLAG = -g
STRIP = -g

/* Hopefully, get the debuggable ones out of the MIT libg dir. */
#define XLIB_REF(x) -l/**/x
#define XLIB_REF_S(x) -l/**/x
#else
POUND
POUND For the time being, at least, dont strip out symbol tables.
STRIP =
#if defined(SUNOS_REV) && SUNOS_REV >= 500
/* #define OW_STATIC                                                         */
#ifdef OW_STATIC
#define XLIB_REF(x) $(OPENWINHOME)/lib/lib/**/x.a
#endif
#endif

#ifndef XLIB_REF
#define XLIB_REF(x) -l/**/x
#endif
#if defined(IRIX)
#define XLIB_REF_S(x) -l/**/x/**/_s
#else
#define XLIB_REF_S XLIB_REF
#endif
#endif

/* Start of machine-dependent settings... */

/* NOTES:
 *  -This will probably have problems until ported everywhere...see Scott if
 *   you have problems.
 *  -A '#define ForceX11Rel 5' can be done before including this file to try to
 *   force use of X11R5 libraries, for instance. (and it might even work :-)).
 */

/* Set OSX11Version equal to 4 for both S4 and S5 (even though S5 OSX11Version
 * is really 5) and define ForceX11Rel true for them to force use of the MIT
 * X11R5 libraries/includes instead of the native Openwindows ones to avoid
 * conflicts between our modified X code in $SL/utils and Openwindows code. */

#ifdef ForceX11Rel
#define UsedX11Version ForceX11Rel
#define SplusX11Version ForceX11Rel
#else
/* Platform-specific DefaultX11Rel defined in $INC/guidefs.h */
#define UsedX11Version DefaultX11Rel
#endif

#if SUNOS_REV >= 500
NO_PROTO=-U_NO_PROTO
#else
NO_PROTO=-D_NO_PROTO
#endif
#if defined(LINUX) /*(*/
#undef SUNOS
OPENWINHOME = /usr/openwin
OPENWIN2HOME = /usr/openwin
#define OSX11Version 6
#define MITXincdir /usr/X11R6/include
#define MotifXincdir  /usr/X11R6/include
#if defined(HAS_64BIT_LONG) /*(*/
#define MITXlibdir /usr/X11R6/lib64
#define MotifXlibdir  /usr/X11R6/lib64
#else /*)(*/
#define MITXlibdir /usr/X11R6/lib
#define MotifXlibdir  /usr/X11R6/lib
#endif /*)*/
#endif /*)*/
#if defined(SUNOS) /*(*/
#if SUNOS_REV < 530
#define OSX11Version 4
#define MotifXincdir  /sw/commercial/ICS/usr/include
#define MotifXlibdir  /sw/commercial/ICS/usr/lib
#else
#define OSX11Version 5
#define MotifXincdir /usr/dt/include
#define MotifXlibdir /usr/dt/lib
#endif

#if (defined(SUNOS4) && defined(SPARC)) /*(*/
OPENWINHOME = /usr/openwin
OPENWIN2HOME = /usr/openwin2
/*
#if UsedX11Version >= 5
#define XLdFlags $(LDFLAGS_DYN)
#endif
*/
#else /*)(*/
OPENWINHOME = /usr/openwin
#endif /*)*/

#define OSXincdir $(OPENWINHOME)/include
#define OSXlibdir $(OPENWINHOME)/lib

#if SUNOS_REV >= 500 /*(*/
#define ExtraOLXlibs -lolgx -lX11 
#define ExtraXlibs -Bdynamic -lsocket -lnsl -ldl -L/usr/ccs/lib -lgen -lw -lintl
/* Both SunOS5 compilers we have (Sun C & gcc) support prototypes. */
#define XCFlags $(NO_PROTO)

POUND
POUND Do the "stripping" of the executable with the strip(1) command instead
POUND of the ld '-s' switch. Running an executable produced with '-s' switch
POUND and using OpenWindows v3.1 shared libraries generates an Xt error:
POUND   Error: Unresolved inheritance operation
POUND Using the 'strip' command afterwards works fine.
STRIP =
#define StripCmd strip
STRIPCMD = strip

#else /*)(*/
/* Get the static F77 libs out of the 'f77...' load command. */
#define PostLibs -Bstatic

#define ExtraOLXlibs
/* SunOS 4.x */
#if UsedX11Version >= 5
/* Only need -ldl if we're using shared X11R5 libraries */
#define ExtraXlibs -Bdynamic -ldl 
#endif
#endif /*)*/
#endif /*)*/

#if defined(HPUX) /*(*/
#if HPUX_REV > 1000 /*(*/
#define OSX11Version 6
#define MITXincdir /usr/include/X11R6 -I/usr/contrib/X11R6/include
#define MITXlibdir /usr/lib/X11R6 -Wl,-L/usr/contrib/X11R6/lib
#define MotifXincdir  /usr/include/Motif1.2
#define MotifXlibdir  /usr/lib/Motif1.2_R6
#elif HPUX_REV < 900 /*)(*/
#define OSX11Version 4
#define OSXincdir /usr/include/X11R4
#define MotifXincdir /usr/include/Motif1.1
#define OSXlibdir /usr/lib/X11R4
#define MotifXlibdir /usr/lib/Motif1.1
#else /*)(*/
#define OSX11Version 5
#define OSXincdir /usr/include/X11R5
#define MotifXincdir /usr/include/Motif1.2
#define OSXlibdir /usr/lib/X11R5
#define MotifXlibdir /usr/lib/Motif1.2
#endif /*)*/
#define DashL -Wl,-L,

#define XCFlags -Wp,-H200000 $(NO_PROTO) -DSYSV

#if HPUX_REV >= 800 /*(*/
/* Will we have shared MIT X11R5 libraries on HPUX 8.x? If not, this will need
   some adjustment. */
#define XLdFlags $(LDFLAGS_DYN)
#endif /*)*/

#if OSX11Version == UsedX11Version    /* Use vendor's X11 libs */
#define XLibraries XLIB_REF(Xmu) XLIB_REF(Xt) XLIB_REF(Xhp11) XLIB_REF(Xext) XLIB_REF(X11)
#endif

#if HPUX_REV < 900 && UsedX11Version == 4
/* Use vendor's libXw for HPUX 8.x & X11R4 */
#define HPWidgetsLibrary XLIB_REF(Xw)
#else
#define HPWidgetsLibrary 
#endif

#endif /*)*/

#if defined(IRIS4D) /*(*/
#if IRIX_REV < 500
#define OSX11Version 4
#else
/* IRIX 5.x ships with X11R5, I think. */
#define OSX11Version 5
#if MIPS_BUILD_LEVEL == 3
#define MITXincdir /usr/include
#define MITXlibdir /usr/lib32
#define OSXincdir /usr/include
#define OSXlibdir /usr/lib32
#else 
#define MITXincdir /usr/include
#define MITXlibdir /usr/lib
#define OSXincdir /usr/include
#define OSXlibdir /usr/lib
#endif
#endif

#if OSX11Version == UsedX11Version   /* Using vendor's libs */
#define XLibraries XLIB_REF(Xmu) XLIB_REF_S(Xt) XLIB_REF_S(Xext) XLIB_REF(X11)
#define MotifLibrary XLIB_REF_S(Xm)
#endif

/* lib PW for regcmp, ref'd in libXm_s.a */
#define ExtraXlibs -lbsd -lPW
#endif /*)*/

#if defined(IBMRS6000) /*(*/
#if AIX_REV >= 324
#define OSX11Version 5
#if UsedX11Version == OSX11Version
#define XCFlags $(NO_PROTO) -DSYSV -DXM_1_1_BC
#define NO_MIT_X11
#define MotifLibrary  XLIB_REF(Xm)
#endif
#elif AIX_REV < 320
#define OSX11Version 3
#else
#define OSX11Version 4
#endif
#endif /*)*/

#if defined(NEXTM) /*(*/
#define OSX11Version 0    /* No X11 with OS. */
#endif /*)*/

#if defined(OSF1_DECALPHA) /*(*/
#define OSX11Version 5
X_F77LDFLAGS=-nofor_main
#endif /*)*/

#if defined(CONVEX) /*(*/
POUND I think CONVEX "currently" ships X11R5, but I dont know what
POUND incantations might be necessary to compile X11 progs there. So dont
POUND guess here.
#endif /*)*/

#ifndef OSX11Version
POUND !!!!! You will probably have problems.
POUND !!!!! The file $INC/x11.make does not have a machine dependent section
POUND !!!!! for this platform. Each machine dependent platform section should
POUND !!!!! do a '#define OSX11/**/Version' to something. Please go change
POUND !!!!! x11.make to explicitly configure the X11 availability for this
POUND !!!!! platform. Assuming no X11 shipped with OS and that we/you have
POUND !!!!! built the MIT X11 distribution into /usr/local/X11/R/**/UsedX11Version
#define OSX11Version 0
#endif

X11_DATA = $${SHOME}/splus/lib/X11

#ifndef SplusX11Version
#define SplusX11Version UsedX11Version
#endif
XVERSION = SplusX11Version
XVERSION_FLAG = -DSPLUS_XVERSION=$(XVERSION)

#ifndef DashL
#define DashL -L
#endif

#ifndef OSXincdir
#define OSXincdir /usr/include
#endif
#ifndef OSXlibdir
#define OSXlibdir /usr/lib
#endif
#ifndef MITXincdir
#define MITXincdir /sw/x11r$(XVERSION)/include
#endif
#ifndef MITXlibdir
#define MITXlibdir /sw/x11r$(XVERSION)/lib
#endif
#ifndef MotifXincdir
POUND Motif includes are in one of the other already searched directories.
MOTIFINC =
#else
MOTIFINC = -I/**/MotifXincdir
#endif
#ifndef MotifXlibdir
POUND Motif libs are in one of the other already searched directories.
MOTIFLIBDIR =
#else
MOTIFLIBDIR = DashL/**/MotifXlibdir
#endif

#ifndef UseOSX11
#if DebugX11Libs || (OSX11Version != SplusX11Version)
#define UseOSX11 0
#else
#define UseOSX11 1
#endif
#endif

OSXINCDIR  = OSXincdir
OSXLIBDIR  = OSXlibdir
MITXINCDIR = MITXincdir
MITXLIBDIR = MITXlibdir
#ifdef NO_MIT_X11  /*(*/
XINCLUDE = -I$(OSXINCDIR) $(MOTIFINC)
XLIBSDIR = DashL/**/$(OSXLIBDIR) $(MOTIFLIBDIR)
#else /*)(*/
#ifdef DebugX11Libs /*(*/
XINCLUDE = -I$(MITXINCDIR)g -I$(MITXINCDIR) $(MOTIFINC) -I$(OSXINCDIR)
XLIBSDIR = DashL/**/$(MITXLIBDIR)g DashL/**/$(MITXLIBDIR) \
           $(MOTIFLIBDIR) DashL/**/$(OSXLIBDIR)
#else /*)(*/
#if UseOSX11
XINCLUDE = -I$(OSXINCDIR) -I$(MITXINCDIR) $(MOTIFINC)
XLIBSDIR = DashL/**/$(OSXLIBDIR) DashL/**/$(MITXLIBDIR) $(MOTIFLIBDIR)
#else
XINCLUDE = -I$(MITXINCDIR) -I$(OSXINCDIR) $(MOTIFINC)
XLIBSDIR = DashL/**/$(MITXLIBDIR) DashL/**/$(OSXLIBDIR) $(MOTIFLIBDIR)
#endif
#endif /*)*/
#endif /* ) NO_MIT_X11 */

#ifdef DebugX11Libs
#undef XLdFlags
#define XLdFlags $(LDFLAGS)
#endif

#ifndef XLdFlags
/* Use regular system-dependent LDFLAGS by default. */
#define XLdFlags $(LDFLAGS)
#endif
XLDOPTS  = XLdFlags
XLDFLAGS = $(XLDOPTS) $(XLIBSDIR)

#ifdef HAVE_OPENLOOK2
OL2XINCLUDE = -I$(OPENWIN2HOME)/include
OL2XLIBSDIR = -L$(OPENWIN2HOME)/lib
OL2XLDFLAGS = $(LDFLAGS) $(OL2XLIBSDIR)
#endif

#ifdef HAVE_OPENLOOK
OLXINCLUDE = -I$(OPENWINHOME)/include
OLXLIBSDIR = -L$(OPENWINHOME)/lib
OLXLDFLAGS = $(LDFLAGS) $(OLXLIBSDIR)
#endif

#ifndef XCFlags
#if defined(Berkeley) || (defined(LINUX) && LINUX_REV > 220)
#define XCFlags $(NO_PROTO)
#else
#define XCFlags $(NO_PROTO) -DSYSV
#endif
#endif
X_CFLAGS = XCFlags $(XVERSION_FLAG)

#ifndef ExtraXlibs
#define ExtraXlibs
#endif

#if defined(USE_F2C)
#define ExtraSysLibs -lf2c -lm $(SYS_DEP_LIBS)
#else
#if defined(IRIS4D)
#define ExtraSysLibs -lm $(SYS_DEP_LIBS)
#endif
#if (defined(IBMRS6000) && (AIX_REV >= 324))
#define ExtraSysLibs  -lm $(SYS_DEP_LIBS) -lc
#endif
#endif

#ifndef ExtraSysLibs
#define ExtraSysLibs -lm $(SYS_DEP_LIBS) -lc
#endif

#ifndef PostLibs
#define PostLibs
#endif


/* Basic X11 libraries...no GUI-dependent toolkits. */
#ifndef XLibraries
#define XLibraries XLIB_REF(Xmu) XLIB_REF(Xt) XLIB_REF(Xext) XLIB_REF(X11)
#endif 
#if defined(LINUX)
POUND 
POUND Cannot depend on correct X11 libs on various flavors of linux,
POUND so statically link the X11 libs.
POUND
#if defined(HAS_64BIT_LONG) /*(*/
COMMONXLIBS = $(SHOME)/newfun/lib/sutils.a  /usr/X11/lib64/libXp.a /usr/X11/lib64/libXmu.a /usr/X11/lib64/libXt.a /usr/X11/lib64/libSM.a /usr/X11/lib64/libICE.a /usr/X11/lib64/libXext.a /usr/X11/lib64/libX11.a ExtraSysLibs PostLibs
#define MotifLibrary /usr/X11/lib64/libXm.a 
#else /*)(*/
COMMONXLIBS = $(SHOME)/newfun/lib/sutils.a  /usr/X11/lib/libXp.a /usr/X11/lib/libXmu.a /usr/X11/lib/libXt.a /usr/X11/lib/libSM.a /usr/X11/lib/libICE.a /usr/X11/lib/libXext.a /usr/X11/lib/libX11.a ExtraSysLibs PostLibs
#define MotifLibrary /usr/X11/lib/libXm.a 
#endif /*)*/
#else
COMMONXLIBS =	$(SHOME)/newfun/lib/needX11R5.z $(SHOME)/newfun/lib/libXS11.a $(SHOME)/newfun/lib/sutils.a \
       XLibraries ExtraXlibs ExtraSysLibs PostLibs
#endif
#ifdef HAVE_OPENLOOK2
POUND Need StringDefs.o from R5 libXt.a
OL2XLIBS = $L/needX11R4.z $L/libXS11.a $L/sutils.a \
        -Bstatic XLibraries -Bdynamic \
        /usr/local/X11/R5/lib/libXt.a ExtraSysLibs PostLibs
#endif
#ifdef HAVE_OPENLOOK
OLXVERSION = `awk < $(OPENWINHOME)/include/X11/Intrinsic.h ' \
$$1 ~ /^.define$$/ && $$2 == "XtSpecificationRelease" {print $$3} \
$$1 ~ /^\#/ && $$2 == "define" && $$3 == "XtSpecificationRelease" {print $$4} \
'`
OLXLIBS = $L/needX11R$(OLXVERSION).z $L/libXS11OW.a $L/sutils.a \
        XLibraries ExtraOLXlibs ExtraXlibs ExtraSysLibs PostLibs
#endif

/* More libraries... */

#ifndef MotifLibrary
#define MotifLibrary XLIB_REF(Xm)
#endif

MOTIFLIB = MotifLibrary 

#ifndef AthenaLibrary
#define AthenaLibrary XLIB_REF(Xaw)
#endif
ATHENALIB = AthenaLibrary 

#ifndef OpenLookLibrary
/* Don't bother shipping Xol shared library by default. */
#define OpenLookLibrary $(OPENWINHOME)/lib/libXol.a
#endif
OPENLOOKLIB = OpenLookLibrary

#ifndef OpenLook2Library
#define OpenLook2Library $(OPENWIN2HOME)/lib/libXol.a
#endif
OPENLOOK2LIB = OpenLook2Library

#ifndef HPWidgetsLibrary
#define HPWidgetsLibrary XLIB_REF(Xw)
#endif
HPWIDGETSLIB = HPWidgetsLibrary

#if defined(SUNOS)
PREFIX_ENV = LD_LIBRARY_PATH=
#endif

#ifndef StripCmd
POUND /bin/sh no-op command
STRIPCMD = -@:
#endif

POUND
POUND ===End of $RCSfile: x11.make,v $===
