<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" standalone="yes" indent="yes"/>
	<xsl:template match="PMML">
		<xsl:element name="S-PLUS">
			<xsl:element name="List">
				<xsl:attribute name="length"><xsl:value-of select="count(.//TreeModel)"/></xsl:attribute>
				<xsl:attribute name="named">F</xsl:attribute>
				<xsl:element name="Components">
					<xsl:apply-templates select=".//TreeModel"/>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="TreeModel">
		<xsl:param name="numSplits" select="count(.//Node[count(./True)=0])"/>
		<xsl:element name="Component">
			<xsl:element name="DataFrame">
				<xsl:attribute name="numRows"><xsl:value-of select="$numSplits"/></xsl:attribute>
				<xsl:attribute name="numCols">2</xsl:attribute>
				<xsl:element name="RowNames">
					<xsl:attribute name="length"><xsl:value-of select="$numSplits"/></xsl:attribute>
					<xsl:element name="Items">
						<xsl:for-each select=".//Node[count(./True)=0]">
							<xsl:element name="Item">
								<xsl:value-of select="position()"/>
							</xsl:element>
						</xsl:for-each>
					</xsl:element>
				</xsl:element>
				<xsl:element name="Columns">
					<xsl:element name="Column">
						<xsl:attribute name="length"><xsl:value-of select="$numSplits"/></xsl:attribute>
						<xsl:attribute name="type">character</xsl:attribute>
						<xsl:attribute name="name">Split.Column</xsl:attribute>
						<xsl:element name="Items">
						<xsl:for-each select=".//Node[count(./True)=0]">
								<xsl:element name="Item">
									<xsl:if test="count(SimplePredicate) &gt; 0">
										<xsl:value-of select="SimplePredicate[1]/@field"/>
									</xsl:if>
									<xsl:if test="count(CompoundPredicate) &gt; 0">
										<xsl:value-of select="CompoundPredicate/SimplePredicate[1]/@field"/>
									</xsl:if>
								</xsl:element>
							</xsl:for-each>
						</xsl:element>
					</xsl:element>
					<xsl:element name="Column">
						<xsl:attribute name="length"><xsl:value-of select="$numSplits"/></xsl:attribute>
						<xsl:attribute name="type">numeric</xsl:attribute>
						<xsl:attribute name="name">Change.in.Fit</xsl:attribute>
						<xsl:element name="Items">
							<xsl:for-each select=".//Node[count(./True)=0]">
								<xsl:element name="Item">
									<xsl:for-each select="Extension/X-IMML-XTProps/X-IMML-Property[@name='improvement']">
										<xsl:value-of select="@value"/>
									</xsl:for-each>
								</xsl:element>
							</xsl:for-each>
						</xsl:element>
					</xsl:element>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
