/********************************KMEANS CLUSTER ******************************************/
#if !defined(_IM_KMEANS_CLUSTER_H_)
#define _IM_KMEANS_CLUSTER_H_

#include "IMObjects.h"

#define IMinerKMeansClusterModel IMinerObject

/* macro to access a matrix element from IMinerMatrix object*/
#define IMINER_KMEANS_META_DATA_NUM			0
#define IMINER_KMEANS_CENTER_MEMBER			1
#define IMINER_KMEANS_SCALE_MEMBER			2
#define IMINER_KMEANS_SIZE_MEMBER			3

#define IMINER_KMEANS_META_DATA(pObj)		(pObj)->m_uData.m_ppList[IMINER_KMEANS_META_DATA_NUM]
#define IMINER_KMEANS_CENTER_PTR(pObj)		(pObj)->m_uData.m_ppList[IMINER_KMEANS_CENTER_MEMBER]
#define IMINER_KMEANS_SCALE_PTR(pObj)		(pObj)->m_uData.m_ppList[IMINER_KMEANS_SCALE_MEMBER]
#define IMINER_KMEANS_SIZE_PTR(pObj)		(pObj)->m_uData.m_ppList[IMINER_KMEANS_SIZE_MEMBER]

#ifdef __cplusplus
extern "C" {
#endif

/* alloc memory and set content for class KMeans Cluster */
IMCSRC_DLLAPI(long) IMinerKMeansClusterModel_create(
 IMinerObject* pModel,			/* out: data object */
 IMinerObject* md,			    /* in:  meta data object */
 long nClusters,				/* in:  number of rows */
 long nColumns,					/* in:  number of cols */ 
 const double* pdCenters,		/* in:  data as double of length (nClusters*nColumns) */
 const double* pdScale,			/* in:  scaling factors of length nColumns */
 const long*   pnSize			/* in:  cluster sizes of length nClusters */
);

/* validate the object */
IMCSRC_DLLAPI(long) IMinerKMeansClusterModel_isValid(const IMinerObject* pModel);

/* free memory */
IMCSRC_DLLAPI(long) IMinerKMeansClusterModel_destroy(IMinerObject* pModel );

/* write to stdout */
IMCSRC_DLLAPI(long) IMinerKMeansClusterModel_print(const IMinerObject* pModel);

/* predict cluster memberships */
IMCSRC_DLLAPI(long) IMinerKMeansClusterModel_predict(IMinerObject* pOutput,     /* out: output rectangular data */
 const IMinerObject* pInput, /* in: input rectangular data */													 
 IMinerObject* pDescr,		 /* in: input description (if NULL, description will be 
                                    created from input data) */
 const IMinerObject* pModel  /* in: the model */
);

#ifdef __cplusplus
}
#endif

#endif /*_IM_KMEANS_CLUSTER_H_ */

