<?xml version='1.0' encoding='utf-8' ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- XSL style sheet for classification and regression tree elements -->

	<xsl:template match="IMML">
		<html>
			<title><xsl:value-of select="DisplayOptions/@title"/></title>
			<style type="text/css">
				<xsl:value-of select="CSSText/text()"/>
			</style>
			<body>
				<h2 class="title"><xsl:value-of select="DisplayOptions/@title"/></h2>
				<xsl:apply-templates select="XTMetaData"/>
				<xsl:apply-templates select="TreeList"/>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="XTMetaData">
		<xsl:apply-templates select="ColumnDefinitions"/>
	</xsl:template>

	<xsl:template match="ColumnDefinitions">
		<table border="0" cellspacing="0" cellpadding="3" >
			<tr>
    				<td class="tableBG" height="2" >
    					<table cellspacing="1" cellpadding="5" border="0" class="content" bordercolor="#999999" bgcolor="#82C0FF">
	       					<tr>
	        					<td class="blueBG"><b>Columns:</b></td>
					 			<td class="blueBG"><b>Role:</b></td>
								<td class="blueBG"><b>Type:</b></td>
					 			<td class="blueBG"><b>Levels:</b></td>
             				</tr>
	       					<xsl:apply-templates select="ColumnInfo"/>
	       				</table>
	       			</td>
	       	</tr>
	    </table>
	    <br></br>
	</xsl:template>

	<xsl:template match="ColumnInfo">
		<tr>
			<xsl:choose>
				<xsl:when test="position() mod 2 = 0">
					<td class="whiteBG"><xsl:value-of select="@name"/></td>
					<td class="whiteBG"><xsl:value-of select="@role"/></td>
					<td class="whiteBG"><xsl:value-of select="@type"/></td>
					<td class="whiteBG"><xsl:apply-templates select="Level"/></td>
				</xsl:when>
				<xsl:otherwise>
					<td class="greyBG"><xsl:value-of select="@name"/></td>
					<td class="greyBG"><xsl:value-of select="@role"/></td>
					<td class="greyBG"><xsl:value-of select="@type"/></td>
					<td class="greyBG"><xsl:apply-templates select="Level"/></td>
				</xsl:otherwise>
			</xsl:choose>
    	</tr>
	</xsl:template>

	<xsl:template match="Level">
		<xsl:value-of select="@value"/><br></br>
	</xsl:template>


	<xsl:template match="TreeList">
		<table border="0" cellspacing="0" cellpadding="3">
			<tr>
				<td class="tableBG" >
					<h3 class="tableHead">
	       					<xsl:text>Predicting </xsl:text>
	       					<xsl:value-of select="TreeModel/@name"/>
	       					<xsl:text>: (</xsl:text>
		 				<xsl:if test="count(TreeModel)>0">
							<xsl:variable name="numTrees" select="count(TreeModel)"></xsl:variable>
							<xsl:value-of select="$numTrees"/>
						</xsl:if>
						<xsl:text> Trees)</xsl:text>
					</h3>
					<xsl:for-each select="TreeModel">
						<xsl:call-template name="TreeModel">
							<xsl:with-param name="element" select="."/>
							<xsl:with-param name="position" select="position()" />
						</xsl:call-template>
					</xsl:for-each>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="TreeModel">
		<xsl:param name="element" select="''"/>
		<xsl:param name="position" select="''" />

		<xsl:variable name="classification" select="$element/../@modelType" />

		<!-- PRINT TREE NUMBER -->
		<table cellspacing="1" cellpadding="5" border="0" class="content"><tbody>
				<tr><td class="whiteBG"><B>Tree #<xsl:value-of select="$position" /></B></td></tr>
		</tbody></table>

		<!-- PRINT STUCTURED TREE DESCRIPTION -->
		<table cellspacing="1" cellpadding="5" border="0" class="content" width="100%">
			<tbody>
				<tr><td class="greyBG"><B>Tree Structure:</B></td></tr>
				<tr><td class="greyBG">
					<DIV><B>[1]</B></DIV>
					<DIV style="margin-left:30px;">
					<xsl:for-each select="$element/Node/Node">
						<xsl:call-template name="StructuredProcessNode">
							<xsl:with-param name="element" select="."/>
							<xsl:with-param name="decimalPattern" select="../../../../DisplayOptions/@decimalPattern"/>
							<xsl:with-param name="scientificPattern" select="../../../../DisplayOptions/@scientificPattern"/>
							<xsl:with-param name="classification" select="$classification"/>
							<xsl:with-param name="listPosition" select="position()" />
						</xsl:call-template>
					</xsl:for-each>
					<!-- END INDENT -->
					</DIV>
				</td></tr>
			</tbody>
		</table>

		<!-- PRINT TABULAR TREE DESCRIPTION -->
		<table cellspacing="1" cellpadding="5" border="0" class="content" width="100%">
			<tbody>
				<tr>
					<td class="blueBG"><b>Node</b></td>
					<td class="blueBG"><b>Parent</b></td>
					<td class="blueBG"><b>Position</b></td>
					<td class="blueBG"><b>Left Split Definition</b></td>
					<td class="blueBG"><b>Score</b></td>
					<td class="blueBG"><b>Number Records</b></td>
					<td class="blueBG"><b>Entropy</b></td>
					<td class="blueBG"><b>Gini</b></td>
					<xsl:if test="$classification='classification'">
						<td class="blueBG"><b>Probabilities</b></td>
					</xsl:if>
				</tr>
				<xsl:call-template name="TabularProcessNode">
					<xsl:with-param name="list" select="$element/Node"/>
					<xsl:with-param name="decimalPattern" select="../../DisplayOptions/@decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="../../DisplayOptions/@scientificPattern"/>
					<xsl:with-param name="classification" select="$classification"/>
					<xsl:with-param name="root" select="1"/>
				</xsl:call-template>
			</tbody>
		</table>
		<br></br>
		<br></br>
	</xsl:template>

	<xsl:template name="StructuredProcessNode">
		<xsl:param name="element" select="''"/>
		<xsl:param name="decimalPattern" select="''"/>
		<xsl:param name="scientificPattern" select="''"/>
		<xsl:param name="classification" select="''"/>
		<xsl:param name="listPosition" select="''" />


		<!-- INDENT -->
		<B>[<xsl:value-of select="$element/@id"/>]<xsl:text> - </xsl:text></B>

		<!-- SPLIT DECISION -->
		<xsl:for-each select="$element/../CompoundPredicate">
			<xsl:call-template name="ProcessCompoundPredicate">
				<xsl:with-param name="element" select="."/>
				<xsl:with-param name="decimalPattern" select="$decimalPattern" />
				<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				<xsl:with-param name="listPosition" select="$listPosition" />
			</xsl:call-template>
		</xsl:for-each>
		<xsl:for-each select="$element/../SimplePredicate">
			<xsl:call-template name="ProcessSimplePredicate">
				<xsl:with-param name="element" select="."/>
				<xsl:with-param name="decimalPattern" select="$decimalPattern" />
				<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				<xsl:with-param name="listPosition" select="$listPosition" />
			</xsl:call-template>
		</xsl:for-each>
		<B><xsl:text> --> </xsl:text></B>

		<!-- SCORE -->
		<font color="red"><B>
		<xsl:choose>
			<xsl:when test="$classification!='classification'">
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="$element/@score" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
					<xsl:value-of select="$element/@score" />
			</xsl:otherwise>
		</xsl:choose>
		</B></font>

		<!-- RECORD COUNT -->
		<xsl:text> (</xsl:text>
		<xsl:value-of select="$element/@recordCount"/>
		<xsl:text>)</xsl:text>


		<!-- INDENT  -->
		<DIV style="margin-left:30px;">
		<!-- GET NEXT NODES -->
        <xsl:for-each select="$element/Node">
			<xsl:call-template name="StructuredProcessNode">
				<xsl:with-param name="element" select="."/>
				<xsl:with-param name="decimalPattern" select="$decimalPattern" />
				<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				<xsl:with-param name="classification" select="$classification"/>
				<xsl:with-param name="listPosition" select="position()" />
			</xsl:call-template>
        </xsl:for-each>
		<!-- END INDENT -->
        </DIV>

	</xsl:template>

	<xsl:template name="TabularProcessNode">
		<xsl:param name="list" select="''"/>
		<xsl:param name="decimalPattern" select="''"/>
		<xsl:param name="scientificPattern" select="''"/>
		<xsl:param name="classification" select="''"/>
		<xsl:param name="root" select="0"/>

		<xsl:variable name="children" select="$list/Node" />

		<!-- PRINT EACH LIST ITEM -->
		<xsl:for-each select="$list">
			<xsl:call-template name="OutputTableCell">
				<xsl:with-param name="element" select="."/>
				<xsl:with-param name="decimalPattern" select="$decimalPattern" />
				<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				<xsl:with-param name="classification" select="$classification"/>
				<xsl:with-param name="root" select="$root"/>
			</xsl:call-template>
		</xsl:for-each>

		<xsl:if test="$children">
			<!-- HAVE EACH CHILD PRINT ONLY THEMSELVES -->
			<xsl:call-template name="TabularProcessNode">
				<xsl:with-param name="list" select="$children"/>
				<xsl:with-param name="decimalPattern" select="$decimalPattern" />
				<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				<xsl:with-param name="classification" select="$classification"/>
			</xsl:call-template>
		</xsl:if>

	</xsl:template>

	<xsl:template name="OutputTableCell">
		<xsl:param name="element" select="''"/>
		<xsl:param name="decimalPattern" select="''"/>
		<xsl:param name="scientificPattern" select="''"/>
		<xsl:param name="classification" select="''"/>
		<xsl:param name="root" select="0"/>

		<xsl:element name="tr">
			<xsl:attribute name="class">
				<xsl:choose>
					<xsl:when test="$root = 1">whiteBG</xsl:when>
					<xsl:when test="position() mod 2 = 0">whiteBG</xsl:when>
					<xsl:otherwise>greyBG</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

			<td><xsl:value-of select="$element/@id"/></td>

			<td>
				<xsl:choose>
					<xsl:when test="$element/@id = 1">
						root
					</xsl:when>
					<xsl:when test="$element/@id mod 2 = 0">
						<xsl:value-of select="$element/@id div 2"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="($element/@id - 1) div 2"/>
					</xsl:otherwise>
				</xsl:choose>
	        </td>

			<td>
				<xsl:choose>
					<xsl:when test="$element/@group=0">root</xsl:when>
					<xsl:when test="$element/@group=1">left</xsl:when>
					<xsl:otherwise>right</xsl:otherwise>
				</xsl:choose>
            </td>

			<td>
				<xsl:for-each select="$element/CompoundPredicate">
					<xsl:call-template name="ProcessCompoundPredicate">
						<xsl:with-param name="element" select="."/>
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
					</xsl:call-template>
				</xsl:for-each>

				<xsl:for-each select="$element/SimplePredicate">
					<xsl:call-template name="ProcessSimplePredicate">
						<xsl:with-param name="element" select="."/>
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
					</xsl:call-template>
				</xsl:for-each>

				<xsl:if test="count($element/CompoundPredicate)=0">
					<xsl:if test="count($element/SimplePredicate)=0">(leaf)</xsl:if>
				</xsl:if>
            </td>

			<td>
				<xsl:choose>
					<xsl:when test="$classification!='classification'">
						<xsl:call-template name="roundNumber">
								<xsl:with-param name="string" select="$element/@score" />
								<xsl:with-param name="decimalPattern" select="$decimalPattern" />
								<xsl:with-param name="scientificPattern" select="$scientificPattern" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
							<xsl:value-of select="$element/@score" />
					</xsl:otherwise>
				</xsl:choose>
	        </td>

			<td><xsl:value-of select="$element/@recordCount"/></td>

			<td>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="$element/@entropy" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</td>
			<td>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="$element/@gini" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
            </td>

			<xsl:if test="$classification='classification'">
				<td>
					<xsl:call-template name="roundGroup">
							<xsl:with-param name="string" select="$element/@yprob" />
							<xsl:with-param name="pattern" select="' '" />
							<xsl:with-param name="decimalPattern" select="$decimalPattern" />
							<xsl:with-param name="scientificPattern" select="$scientificPattern" />
					</xsl:call-template>
				</td>
			</xsl:if>
        </xsl:element>
	</xsl:template>

	<xsl:template name="ProcessCompoundPredicate">
		<xsl:param name="element" select="''"/>
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />
		<xsl:param name="useParent" select="0" />

		<xsl:value-of select="$element/@operator"/>
		(

			<xsl:for-each select="$element/CompoundPredicate">
				<xsl:call-template name="ProcessCompoundPredicate">
					<xsl:with-param name="element" select="."/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern" />
					<xsl:with-param name="scientificPattern" select="$scientificPattern" />
					<xsl:with-param name="useParent" select="$useParent" />
				</xsl:call-template>
			</xsl:for-each>

			<xsl:for-each select="$element/SimplePredicate">
				<xsl:call-template name="ProcessSimplePredicate">
					<xsl:with-param name="element" select="."/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern" />
					<xsl:with-param name="scientificPattern" select="$scientificPattern" />
					<xsl:with-param name="useParent" select="$useParent" />
				</xsl:call-template>

				<xsl:if test="position() != last()">
					<xsl:text> </xsl:text>
					<xsl:value-of select="$element/@booleanOperator"/>
					<xsl:text> </xsl:text>
				</xsl:if>
			</xsl:for-each>

	       	)
	</xsl:template>

	<xsl:template name="ProcessSimplePredicate">
		<xsl:param name="element" select="''"/>
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />
		<xsl:param name="listPosition" select="1" />

		(
		<xsl:value-of select="$element/@field"/><xsl:text> </xsl:text>

		<xsl:choose>
			<xsl:when test="$element/@operator = 'equal'">
				<xsl:choose>
					<xsl:when test="$listPosition='1'">
						<xsl:text>= </xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>!= </xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$element/@operator = 'notEqual'">
				<xsl:choose>
					<xsl:when test="$listPosition='1'">
						<xsl:text>!= </xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>= </xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$element/@operator = 'lessThan'">
				<xsl:choose>
					<xsl:when test="$listPosition='1'">
						<xsl:text>&lt; </xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>&gt;= </xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$element/@operator = 'lessOrEqual'">
				<xsl:choose>
					<xsl:when test="$listPosition='1'">
						<xsl:text>&lt;= </xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>&gt; </xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$element/@operator = 'greaterThan'">
				<xsl:choose>
					<xsl:when test="$listPosition='1'">
						<xsl:text>&gt; </xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>&lt;= </xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$listPosition='1'">
						<xsl:text>&gt;= </xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>&lt; </xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>

		<xsl:call-template name="roundNumber">
				<xsl:with-param name="string" select="$element/@value" />
				<xsl:with-param name="decimalPattern" select="$decimalPattern" />
				<xsl:with-param name="scientificPattern" select="$scientificPattern" />
		</xsl:call-template>

		)
	</xsl:template>

	<xsl:template name="roundGroup">
		<xsl:param name="string" select="''" />
	   	<xsl:param name="pattern" select="' '" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />
		<xsl:choose>
	      <xsl:when test="contains($string, $pattern)">
			 <xsl:if test="not(starts-with($string, $pattern))">
			    <xsl:call-template name="roundGroup">
			        <xsl:with-param name="string" select="substring-before($string, $pattern)" />
			        <xsl:with-param name="pattern" select="$pattern" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
		     		<xsl:with-param name="scientificPattern" select="$scientificPattern" />
			    </xsl:call-template>
			 </xsl:if>
			 <xsl:call-template name="roundGroup">
			    	<xsl:with-param name="string" select="substring-after($string, $pattern)" />
				<xsl:with-param name="pattern" select="$pattern" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
		     		<xsl:with-param name="scientificPattern" select="$scientificPattern" />
			 </xsl:call-template>
	      </xsl:when>
	      <xsl:otherwise>
			 <xsl:call-template name="roundNumber">
				<xsl:with-param name="string" select="$string" />
				<xsl:with-param name="decimalPattern" select="$decimalPattern" />
				<xsl:with-param name="scientificPattern" select="$scientificPattern" />
 			 </xsl:call-template>
			 <xsl:text>  </xsl:text>
	      </xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="roundNumber">
		<xsl:param name="string" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />

	   	<xsl:variable name="lowerCasePattern" select="'e'" />
	   	<xsl:variable name="upperCasePattern" select="'E'" />
		<xsl:choose>
		      <xsl:when test="contains($string, $lowerCasePattern)">
			    <xsl:call-template name="outputRoundedScientific">
			        <xsl:with-param name="valueString" select="substring-before($string, $lowerCasePattern)" />
			        <xsl:with-param name="exponentString" select="substring-after($string, $lowerCasePattern)" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
		     		<xsl:with-param name="origString" select="$string" />
			    </xsl:call-template>
 			  </xsl:when>
		      <xsl:when test="contains($string, $upperCasePattern)">
			    <xsl:call-template name="outputRoundedScientific">
			        <xsl:with-param name="valueString" select="substring-before($string, $upperCasePattern)" />
			        <xsl:with-param name="exponentString" select="substring-after($string, $upperCasePattern)" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
		     		<xsl:with-param name="origString" select="$string" />
			    </xsl:call-template>
 			  </xsl:when>
		      <xsl:otherwise>
		      	 <xsl:choose>
					<xsl:when test="format-number($string, $decimalPattern) = format-number('A', $decimalPattern)">
						<xsl:value-of select="$string"/>
					</xsl:when>
					<xsl:when test="format-number($string, $decimalPattern) != format-number(0, $decimalPattern)">
						<xsl:value-of select="format-number($string, $decimalPattern)"/>
					</xsl:when>
					<xsl:when test="$string = 0">
						<xsl:value-of select="format-number($string, $decimalPattern)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="format-number($string, $scientificPattern)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text>  </xsl:text>
		      </xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="outputRoundedScientific">
		<xsl:param name="valueString" select="''" />
		<xsl:param name="exponentString" select="''" />
		<xsl:param name="decimalPattern" select="''" />
   		<xsl:param name="origString" select="''" />
		<xsl:choose>
			<xsl:when test="format-number($valueString, $decimalPattern) = format-number('A', $decimalPattern)">
				<xsl:value-of select="$origString"/>
			</xsl:when>
			<xsl:when test="format-number($exponentString, $decimalPattern) = format-number('A', $decimalPattern)">
				<xsl:value-of select="$origString"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="format-number($valueString, $decimalPattern)" />E<xsl:value-of select="format-number($exponentString, '#0')"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
