<?xml version='1.0' encoding='utf-8' ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format">

<!-- XSL style sheet for classification and regression tree elements -->
	<xsl:attribute-set name="title">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">20pt</xsl:attribute>
		<xsl:attribute name="line-height">24pt</xsl:attribute>
		<xsl:attribute name="space-after">10pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="bold-emph">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">16pt</xsl:attribute>
		<xsl:attribute name="line-height">20pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="small-cap">
		<xsl:attribute name="font-variant">small-caps</xsl:attribute>
		<xsl:attribute name="font-size">14pt</xsl:attribute>
		<xsl:attribute name="line-height">18pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="body">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="line-height">14pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="bold-body">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="line-height">14pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="header">
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-after-style">double</xsl:attribute>
		<xsl:attribute name="border-after-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="cell">
		<xsl:attribute name="text-align">right</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="row-header">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="left">
		<xsl:attribute name="border-start-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-start-style">double</xsl:attribute>
		<xsl:attribute name="border-start-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="right">
		<xsl:attribute name="border-end-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-end-style">double</xsl:attribute>
		<xsl:attribute name="border-start-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="top">
		<xsl:attribute name="border-before-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-before-style">double</xsl:attribute>
		<xsl:attribute name="border-before-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="bottom">
		<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-after-style">double</xsl:attribute>
		<xsl:attribute name="border-after-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="table-atts">
		<xsl:attribute name="border-before-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-before-style">double</xsl:attribute>
		<xsl:attribute name="border-before-width">6pt</xsl:attribute>
		<xsl:attribute name="border-start-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-start-style">double</xsl:attribute>
		<xsl:attribute name="border-start-width">3pt</xsl:attribute>
		<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-after-style">double</xsl:attribute>
		<xsl:attribute name="border-after-width">3pt</xsl:attribute>
		<xsl:attribute name="border-end-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-end-style">double</xsl:attribute>
		<xsl:attribute name="border-end-width">3pt</xsl:attribute>
	</xsl:attribute-set>
	

	<xsl:template match="/">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<fo:layout-master-set>
				<fo:simple-page-master master-name="page" page-width="11in" page-height="8.5in">
					<fo:region-body region-name="body" margin-top="0.5in" margin-bottom="0.5in" margin-left="0.5in" margin-right="0.5in" />
				</fo:simple-page-master>
			</fo:layout-master-set>
			
			<fo:page-sequence master-reference="page">
				<fo:flow flow-name="body">
					<fo:block>
						<xsl:apply-templates />
					</fo:block>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	
	<xsl:template match="IMML">
		<fo:block xsl:use-attribute-sets="title"><xsl:value-of select="DisplayOptions/@title"/></fo:block>

		<xsl:apply-templates select="XTMetaData"/>
		<xsl:apply-templates select="TreeList"/>
	</xsl:template>

	<xsl:template match="XTMetaData">
		<xsl:apply-templates select="ColumnDefinitions"/>
	</xsl:template>

	<xsl:template match="ColumnDefinitions">
		<fo:table xsl:use-attribute-sets="table-atts" table-layout="fixed" border-collapse="separate" >

			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-number">1</xsl:attribute>
				<xsl:attribute name="column-width">
					<xsl:call-template name="ColumnNameWidth">
						<xsl:with-param name="element" select="." />
						<xsl:with-param name="TotalNum" select="count(./ColumnInfo)" />
					</xsl:call-template>pt
				</xsl:attribute>
			</xsl:element>
			<fo:table-column column-number="2" column-width="80pt" />
			<fo:table-column column-number="3" column-width="80pt" />
			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-number">4</xsl:attribute>
				<xsl:attribute name="column-width">
					<xsl:call-template name="ColumnLevelNameWidth">
						<xsl:with-param name="element" select="./ColumnInfo/Level" />
						<xsl:with-param name="TotalNum" select="count(./ColumnInfo/Level)" />
					</xsl:call-template>pt
				</xsl:attribute>
			</xsl:element>

			<fo:table-header>
				<fo:table-row background-color="#CCE6FF">
					<fo:table-cell xsl:use-attribute-sets="header"><fo:block>Columns</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header"><fo:block>Role</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header"><fo:block>Type</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header"><fo:block>Levels</fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-header>

			<fo:table-body>
				<xsl:apply-templates select="ColumnInfo"/>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template name="ColumnNameWidth">
		<xsl:param name="element" select="''" />
		<xsl:param name="CurrentNum" select="0" />
		<xsl:param name="TotalNum" select="0" />
		<xsl:param name="minWidth" select="50" />
		<xsl:param name="maxWidth" select="0" />

		<xsl:variable name="this" select="$element/ColumnInfo[$CurrentNum]/@name" />
		<xsl:variable name="thisWidth" select="string-length($this) * 7" />

		<xsl:choose>
			<xsl:when test="$TotalNum = $CurrentNum">
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $thisWidth"><xsl:value-of select="$minWidth"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$thisWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $maxWidth"><xsl:value-of select="$minWidth"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$maxWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:call-template name="ColumnNameWidth">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$thisWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="ColumnNameWidth">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$maxWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="ColumnLevelNameWidth">
		<xsl:param name="element" select="''" />
		<xsl:param name="CurrentNum" select="0" />
		<xsl:param name="TotalNum" select="0" />
		<xsl:param name="minWidth" select="50" />
		<xsl:param name="maxWidth" select="0" />

		<xsl:variable name="this" select="$element[$CurrentNum]/@value" />
		<xsl:variable name="thisWidth" select="string-length($this) * 7" />

		<xsl:choose>
			<xsl:when test="$TotalNum = $CurrentNum">
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $thisWidth"><xsl:value-of select="$minWidth"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$thisWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $maxWidth"><xsl:value-of select="$minWidth"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$maxWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:call-template name="ColumnLevelNameWidth">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$thisWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="ColumnLevelNameWidth">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$maxWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="ColumnInfo">
		<xsl:element name="fo:table-row">
			<xsl:choose>
				<xsl:when test="position() mod 2 = 1">
					<xsl:attribute name="background-color">#EEEEEE</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="background-color">#FFFFFF</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>

			<fo:table-cell vertical-align="middle" xsl:use-attribute-sets="cell top bottom left right"><fo:block><xsl:value-of select="@name"/></fo:block></fo:table-cell >
			<fo:table-cell vertical-align="middle" xsl:use-attribute-sets="cell top bottom left right"><fo:block><xsl:value-of select="@role"/></fo:block></fo:table-cell >
			<fo:table-cell vertical-align="middle" xsl:use-attribute-sets="cell top bottom left right"><fo:block><xsl:value-of select="@type"/></fo:block></fo:table-cell >
			<fo:table-cell vertical-align="middle" xsl:use-attribute-sets="cell top bottom left right"><fo:block>
				<xsl:choose>
					<xsl:when test="count(Level)!=0"><fo:list-block><xsl:apply-templates select="Level"/></fo:list-block></xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</fo:block></fo:table-cell >
	    	</xsl:element>
	</xsl:template>

	<xsl:template match="Level">
		<fo:list-item>
			<fo:list-item-label><fo:block></fo:block></fo:list-item-label>
			<fo:list-item-body>
				<fo:block><xsl:value-of select="@value"/></fo:block>
			</fo:list-item-body>
		</fo:list-item>
	</xsl:template>

	<xsl:template match="TreeList">
		<xsl:for-each select="TreeModel">
			<fo:block space-after="5pt">
				<xsl:call-template name="TreeModel">
					<xsl:with-param name="element" select="."/>
					<xsl:with-param name="position" select="position()" />
				</xsl:call-template>
			</fo:block>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="TreeModel">
		<xsl:param name="element" select="''"/>
		<xsl:param name="position" select="''" />

		<xsl:variable name="classification" select="$element/../@modelType" />

		<!-- PRINT TREE NUMBER -->
		<fo:table xsl:use-attribute-sets="table-atts" table-omit-header-at-break="true" break-before="page" table-layout="fixed" border-collapse="separate" >
			<fo:table-column column-number="1" column-width="10in"/>
			<fo:table-header >
				<xsl:if test="$position = 1">
					<fo:table-row background-color="#82C0FF">
						<fo:table-cell xsl:use-attribute-sets="row-header left right bottom">
							<fo:block>
		       					<xsl:text>Predicting </xsl:text><xsl:value-of select="./@name"/>
		       					<xsl:text>: (</xsl:text>
									<xsl:variable name="numTrees" select="count(../TreeModel)"></xsl:variable>
									<xsl:value-of select="$numTrees"/>
								<xsl:text> Trees)</xsl:text>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</xsl:if>
				<fo:table-row background-color="#FFFFFF"  keep-with-previous.within-page="always">
					<fo:table-cell column-number="1" xsl:use-attribute-sets="row-header left right bottom"><fo:block>Tree #<xsl:value-of select="$position" /></fo:block></fo:table-cell>
				</fo:table-row>
				<fo:table-row background-color="#EEEEEE"  keep-with-previous.within-page="always">
					<fo:table-cell column-number="1" xsl:use-attribute-sets="row-header left right bottom"><fo:block>Tree Structure:</fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-header>
			<fo:table-body>
				<fo:table-row background-color="#EEEEEE"  keep-with-previous.within-page="always">
					<!-- PRINT STUCTURED TREE DESCRIPTION -->
					<fo:table-cell column-number="1" xsl:use-attribute-sets="row-header left right"><fo:block>
						<fo:block font-weight="bold">[1]</fo:block>
						<xsl:for-each select="$element/Node/Node">
							<xsl:call-template name="StructuredProcessNode">
								<xsl:with-param name="element" select="."/>
								<xsl:with-param name="decimalPattern" select="../../../../DisplayOptions/@decimalPattern"/>
								<xsl:with-param name="scientificPattern" select="../../../../DisplayOptions/@scientificPattern"/>
								<xsl:with-param name="classification" select="$classification"/>
								<xsl:with-param name="listPosition" select="position()" />
								<xsl:with-param name="indent" select="0.5" />
							</xsl:call-template>
						</xsl:for-each>
					</fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>

		<!-- PRINT TABULAR TREE DESCRIPTION -->
		<fo:table xsl:use-attribute-sets="table-atts"  keep-with-previous.within-page="always" table-layout="fixed" border-collapse="separate" >
			<fo:table-column column-number="1"  column-width="60pt"/>
			<fo:table-column column-number="2" column-width="60pt"/>
			<fo:table-column column-number="3" column-width="60pt"/>
			<xsl:choose>
				<xsl:when test="$classification='classification'">
					<fo:table-column column-number="4" column-width="220pt"/>
				</xsl:when>
				<xsl:otherwise>
					<fo:table-column column-number="4" column-width="320pt"/>
				</xsl:otherwise>
			</xsl:choose>
			<fo:table-column column-number="5" column-width="60pt"/>
			<fo:table-column column-number="6" column-width="60pt"/>
			<fo:table-column column-number="7" column-width="55pt"/>
			<fo:table-column column-number="8" column-width="45pt"/>
			<xsl:if test="$classification='classification'">
				<fo:table-column column-number="9" column-width="80pt"/>
			</xsl:if>

			<fo:table-header>
				<fo:table-row background-color="#CCE6FF">
					<fo:table-cell xsl:use-attribute-sets="header left right"><fo:block>Node</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right"><fo:block>Parent</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right"><fo:block>Position</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right"><fo:block>Left Split Decision</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right"><fo:block>Score</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right"><fo:block>Number Records</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right"><fo:block>Entropy</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right"><fo:block>Gini</fo:block></fo:table-cell>
					<xsl:if test="$classification='classification'">
						<fo:table-cell xsl:use-attribute-sets="header left right"><fo:block>Probabilities</fo:block></fo:table-cell>
					</xsl:if>
				</fo:table-row>
			</fo:table-header>

			<fo:table-body>
				<xsl:call-template name="TabularProcessNode">
					<xsl:with-param name="list" select="$element/Node"/>
					<xsl:with-param name="decimalPattern" select="../../DisplayOptions/@decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="../../DisplayOptions/@scientificPattern"/>
					<xsl:with-param name="classification" select="$classification"/>
					<xsl:with-param name="root" select="1"/>
				</xsl:call-template>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template name="StructuredProcessNode">
		<xsl:param name="scientificPattern" select="''"/>
		<xsl:param name="element" select="''"/>
		<xsl:param name="decimalPattern" select="''"/>
		<xsl:param name="classification" select="''"/>
		<xsl:param name="listPosition" select="''" />
		<xsl:param name="indent" select="0" />


		<xsl:element name="fo:block">
			<xsl:attribute name="start-indent"><xsl:value-of select="$indent" />in</xsl:attribute>
			<!-- INDENT -->
			<fo:inline font-weight="bold">[<xsl:value-of select="$element/@id"/>]</fo:inline ><xsl:text> - </xsl:text>
	
			<!-- SPLIT DECISION -->
			<fo:inline font-weight="normal">
				<xsl:for-each select="$element/../CompoundPredicate">
					<xsl:call-template name="ProcessCompoundPredicate">
						<xsl:with-param name="element" select="."/>
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
						<xsl:with-param name="listPosition" select="$listPosition" />
					</xsl:call-template>
				</xsl:for-each>
				<xsl:for-each select="$element/../SimplePredicate">
					<xsl:call-template name="ProcessSimplePredicate">
						<xsl:with-param name="element" select="."/>
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
						<xsl:with-param name="listPosition" select="$listPosition" />
					</xsl:call-template>
				</xsl:for-each>
			</fo:inline >
			<fo:inline font-weight="normal"><xsl:text> --> </xsl:text></fo:inline >
	
			<!-- SCORE -->
			<fo:inline font-weight="bold" color="red">
				<xsl:choose>
					<xsl:when test="$classification!='classification'">
						<xsl:call-template name="roundNumber">
								<xsl:with-param name="string" select="$element/@score" />
								<xsl:with-param name="decimalPattern" select="$decimalPattern" />
								<xsl:with-param name="scientificPattern" select="$scientificPattern" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
							<xsl:value-of select="$element/@score" />
					</xsl:otherwise>
				</xsl:choose>
			</fo:inline >
	
			<!-- RECORD COUNT -->
			<fo:inline font-weight="normal">
				<xsl:text> (</xsl:text>
				<xsl:value-of select="$element/@recordCount"/>
				<xsl:text>)</xsl:text>
			</fo:inline >
	
			<!-- INDENT  -->
			<xsl:element name="fo:block">
				<xsl:attribute name="start-indent"><xsl:value-of select="$indent+.5"/>in</xsl:attribute>
				<!-- GET NEXT NODES -->
				<xsl:for-each select="$element/Node">
					<xsl:call-template name="StructuredProcessNode">
						<xsl:with-param name="element" select="."/>
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
						<xsl:with-param name="classification" select="$classification"/>
						<xsl:with-param name="listPosition" select="position()" />
						<xsl:with-param name="indent" select="$indent + .5" />
					</xsl:call-template>
				</xsl:for-each>
			</xsl:element>
		</xsl:element>
		
	</xsl:template>

	<xsl:template name="TabularProcessNode">
		<xsl:param name="list" select="''"/>
		<xsl:param name="decimalPattern" select="''"/>
		<xsl:param name="scientificPattern" select="''"/>
		<xsl:param name="classification" select="''"/>
		<xsl:param name="root" select="0"/>

		<xsl:variable name="children" select="$list/Node" />

		<!-- PRINT EACH LIST ITEM -->
		<xsl:for-each select="$list">
			<xsl:call-template name="OutputTableCell">
				<xsl:with-param name="element" select="."/>
				<xsl:with-param name="decimalPattern" select="$decimalPattern" />
				<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				<xsl:with-param name="classification" select="$classification"/>
				<xsl:with-param name="root" select="$root"/>
			</xsl:call-template>
		</xsl:for-each>

		<xsl:if test="$children">
			<!-- HAVE EACH CHILD PRINT ONLY THEMSELVES -->
			<xsl:call-template name="TabularProcessNode">
				<xsl:with-param name="list" select="$children"/>
				<xsl:with-param name="decimalPattern" select="$decimalPattern" />
				<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				<xsl:with-param name="classification" select="$classification"/>
			</xsl:call-template>
		</xsl:if>

	</xsl:template>

	<xsl:template name="OutputTableCell">
		<xsl:param name="element" select="''"/>
		<xsl:param name="decimalPattern" select="''"/>
		<xsl:param name="scientificPattern" select="''"/>
		<xsl:param name="classification" select="''"/>
		<xsl:param name="root" select="0"/>

		<xsl:element name="fo:table-row">
			<xsl:attribute name="background-color">
				<xsl:choose>
					<xsl:when test="$root = 1">#FFFFFF</xsl:when>
					<xsl:when test="position() mod 2 = 0">#FFFFFF</xsl:when>
					<xsl:otherwise>#EEEEEE</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom">
				<fo:block><xsl:value-of select="$element/@id"/></fo:block>
			</fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:choose>
					<xsl:when test="$element/@id = 1">
						root
					</xsl:when>
					<xsl:when test="$element/@id mod 2 = 0">
						<xsl:value-of select="$element/@id div 2"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="($element/@id - 1) div 2"/>
					</xsl:otherwise>
				</xsl:choose>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:choose>
					<xsl:when test="$element/@group=0">root</xsl:when>
					<xsl:when test="$element/@group=1">left</xsl:when>
					<xsl:otherwise>right</xsl:otherwise>
				</xsl:choose>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:for-each select="$element/CompoundPredicate">
					<xsl:call-template name="ProcessCompoundPredicate">
						<xsl:with-param name="element" select="."/>
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
					</xsl:call-template>
				</xsl:for-each>

				<xsl:for-each select="$element/SimplePredicate">
					<xsl:call-template name="ProcessSimplePredicate">
						<xsl:with-param name="element" select="."/>
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
					</xsl:call-template>
				</xsl:for-each>

				<xsl:if test="count($element/CompoundPredicate)=0">
					<xsl:if test="count($element/SimplePredicate)=0">(leaf)</xsl:if>
				</xsl:if>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:choose>
					<xsl:when test="$classification!='classification'">
						<xsl:call-template name="roundNumber">
								<xsl:with-param name="string" select="$element/@score" />
								<xsl:with-param name="decimalPattern" select="$decimalPattern" />
								<xsl:with-param name="scientificPattern" select="$scientificPattern" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
							<xsl:value-of select="$element/@score" />
					</xsl:otherwise>
				</xsl:choose>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom">
				<fo:block><xsl:value-of select="$element/@recordCount"/></fo:block>
			</fo:table-cell>


			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="$element/@entropy" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
            		</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="$element/@gini" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
            		</fo:block></fo:table-cell>

			<xsl:if test="$classification='classification'">
				<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
					<xsl:call-template name="roundGroup">
							<xsl:with-param name="string" select="$element/@yprob" />
							<xsl:with-param name="pattern" select="' '" />
							<xsl:with-param name="decimalPattern" select="$decimalPattern" />
							<xsl:with-param name="scientificPattern" select="$scientificPattern" />
					</xsl:call-template>
				</fo:block></fo:table-cell>
			</xsl:if>
	        </xsl:element>
	</xsl:template>

	<xsl:template name="ProcessCompoundPredicate">
		<xsl:param name="element" select="''"/>
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />
		<xsl:param name="useParent" select="0" />

		<xsl:value-of select="$element/@operator"/>
		(

			<xsl:for-each select="$element/CompoundPredicate">
				<xsl:call-template name="ProcessCompoundPredicate">
					<xsl:with-param name="element" select="."/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern" />
					<xsl:with-param name="scientificPattern" select="$scientificPattern" />
					<xsl:with-param name="useParent" select="$useParent" />
				</xsl:call-template>
			</xsl:for-each>

			<xsl:for-each select="$element/SimplePredicate">
				<xsl:call-template name="ProcessSimplePredicate">
					<xsl:with-param name="element" select="."/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern" />
					<xsl:with-param name="scientificPattern" select="$scientificPattern" />
					<xsl:with-param name="useParent" select="$useParent" />
				</xsl:call-template>

				<xsl:if test="position() != last()">
					<xsl:text> </xsl:text>
					<xsl:value-of select="$element/@booleanOperator"/>
					<xsl:text> </xsl:text>
				</xsl:if>
			</xsl:for-each>

	       	)
	</xsl:template>

	<xsl:template name="ProcessSimplePredicate">
		<xsl:param name="element" select="''"/>
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />
		<xsl:param name="listPosition" select="1" />

		(
		<xsl:value-of select="$element/@field"/><xsl:text> </xsl:text>

		<xsl:choose>
			<xsl:when test="$element/@operator = 'equal'">
				<xsl:choose>
					<xsl:when test="$listPosition='1'">
						<xsl:text>= </xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>!= </xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$element/@operator = 'notEqual'">
				<xsl:choose>
					<xsl:when test="$listPosition='1'">
						<xsl:text>!= </xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>= </xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$element/@operator = 'lessThan'">
				<xsl:choose>
					<xsl:when test="$listPosition='1'">
						<xsl:text>&lt; </xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>&gt;= </xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$element/@operator = 'lessOrEqual'">
				<xsl:choose>
					<xsl:when test="$listPosition='1'">
						<xsl:text>&lt;= </xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>&gt; </xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$element/@operator = 'greaterThan'">
				<xsl:choose>
					<xsl:when test="$listPosition='1'">
						<xsl:text>&gt; </xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>&lt;= </xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$listPosition='1'">
						<xsl:text>&gt;= </xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>&lt; </xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>

		<xsl:call-template name="roundNumber">
				<xsl:with-param name="string" select="$element/@value" />
				<xsl:with-param name="decimalPattern" select="$decimalPattern" />
				<xsl:with-param name="scientificPattern" select="$scientificPattern" />
		</xsl:call-template>

		)
	</xsl:template>

	<xsl:template name="roundGroup">
		<xsl:param name="string" select="''" />
	   	<xsl:param name="pattern" select="' '" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />
		<xsl:choose>
	      <xsl:when test="contains($string, $pattern)">
			 <xsl:if test="not(starts-with($string, $pattern))">
			    <xsl:call-template name="roundGroup">
			        <xsl:with-param name="string" select="substring-before($string, $pattern)" />
			        <xsl:with-param name="pattern" select="$pattern" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
		     		<xsl:with-param name="scientificPattern" select="$scientificPattern" />
			    </xsl:call-template>
			 </xsl:if>
			 <xsl:call-template name="roundGroup">
			    	<xsl:with-param name="string" select="substring-after($string, $pattern)" />
				<xsl:with-param name="pattern" select="$pattern" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
		     		<xsl:with-param name="scientificPattern" select="$scientificPattern" />
			 </xsl:call-template>
	      </xsl:when>
	      <xsl:otherwise>
			 <xsl:call-template name="roundNumber">
				<xsl:with-param name="string" select="$string" />
				<xsl:with-param name="decimalPattern" select="$decimalPattern" />
				<xsl:with-param name="scientificPattern" select="$scientificPattern" />
 			 </xsl:call-template>
			 <xsl:text>  </xsl:text>
	      </xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="roundNumber">
		<xsl:param name="string" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />

	   	<xsl:variable name="lowerCasePattern" select="'e'" />
	   	<xsl:variable name="upperCasePattern" select="'E'" />
		<xsl:choose>
		      <xsl:when test="contains($string, $lowerCasePattern)">
			    <xsl:call-template name="outputRoundedScientific">
			        <xsl:with-param name="valueString" select="substring-before($string, $lowerCasePattern)" />
			        <xsl:with-param name="exponentString" select="substring-after($string, $lowerCasePattern)" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
		     		<xsl:with-param name="origString" select="$string" />
			    </xsl:call-template>
 			  </xsl:when>
		      <xsl:when test="contains($string, $upperCasePattern)">
			    <xsl:call-template name="outputRoundedScientific">
			        <xsl:with-param name="valueString" select="substring-before($string, $upperCasePattern)" />
			        <xsl:with-param name="exponentString" select="substring-after($string, $upperCasePattern)" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
		     		<xsl:with-param name="origString" select="$string" />
			    </xsl:call-template>
 			  </xsl:when>
		      <xsl:otherwise>
		      	 <xsl:choose>
					<xsl:when test="not(boolean($decimalPattern))">
						<xsl:value-of select="$string"/>
					</xsl:when>
					<xsl:when test="format-number($string, $decimalPattern) = format-number('A', $decimalPattern)">
						<xsl:value-of select="$string"/>
					</xsl:when>
					<xsl:when test="format-number($string, $decimalPattern) != format-number(0, $decimalPattern)">
						<xsl:value-of select="format-number($string, $decimalPattern)"/>
					</xsl:when>
					<xsl:when test="$string = 0">
						<xsl:value-of select="format-number($string, $decimalPattern)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="format-number($string, $scientificPattern)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text>  </xsl:text>
		      </xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="outputRoundedScientific">
		<xsl:param name="valueString" select="''" />
		<xsl:param name="exponentString" select="''" />
		<xsl:param name="decimalPattern" select="''" />
   		<xsl:param name="origString" select="''" />
		<xsl:choose>
			<xsl:when test="not(boolean($decimalPattern))">
				<xsl:value-of select="$origString"/>
			</xsl:when>
			<xsl:when test="format-number($valueString, $decimalPattern) = format-number('A', $decimalPattern)">
				<xsl:value-of select="$origString"/>
			</xsl:when>
			<xsl:when test="format-number($exponentString, $decimalPattern) = format-number('A', $decimalPattern)">
				<xsl:value-of select="$origString"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="format-number($valueString, $decimalPattern)" />E<xsl:value-of select="format-number($exponentString, '#0')"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
