<?xml version='1.0' encoding='utf-8' ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format">
	

<xsl:attribute-set name="title">
	<xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="font-size">20pt</xsl:attribute>
	<xsl:attribute name="line-height">24pt</xsl:attribute>
	<xsl:attribute name="space-after">10pt</xsl:attribute>
</xsl:attribute-set>
<xsl:attribute-set name="bold-emph">
	<xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="font-size">16pt</xsl:attribute>
	<xsl:attribute name="line-height">20pt</xsl:attribute>
	<xsl:attribute name="space-after">2pt</xsl:attribute>
</xsl:attribute-set>
<xsl:attribute-set name="small-cap">
	<xsl:attribute name="font-variant">small-caps</xsl:attribute>
	<xsl:attribute name="font-size">14pt</xsl:attribute>
	<xsl:attribute name="line-height">18pt</xsl:attribute>
	<xsl:attribute name="space-after">2pt</xsl:attribute>
</xsl:attribute-set>
<xsl:attribute-set name="body">
	<xsl:attribute name="font-size">10pt</xsl:attribute>
	<xsl:attribute name="line-height">14pt</xsl:attribute>
	<xsl:attribute name="space-after">2pt</xsl:attribute>
</xsl:attribute-set>
<xsl:attribute-set name="bold-body">
	<xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="font-size">10pt</xsl:attribute>
	<xsl:attribute name="line-height">14pt</xsl:attribute>
	<xsl:attribute name="space-after">2pt</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="header">
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
	<xsl:attribute name="border-after-style">double</xsl:attribute>
	<xsl:attribute name="border-after-width">2pt</xsl:attribute>
</xsl:attribute-set>
<xsl:attribute-set name="cell">
	<xsl:attribute name="text-align">right</xsl:attribute>
</xsl:attribute-set>
<xsl:attribute-set name="row-header">
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="font-weight">bold</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="left">
	<xsl:attribute name="border-start-color">#82C0FF</xsl:attribute>
	<xsl:attribute name="border-start-style">double</xsl:attribute>
	<xsl:attribute name="border-start-width">2pt</xsl:attribute>
</xsl:attribute-set>
<xsl:attribute-set name="right">
	<xsl:attribute name="border-end-color">#82C0FF</xsl:attribute>
	<xsl:attribute name="border-end-style">double</xsl:attribute>
	<xsl:attribute name="border-start-width">2pt</xsl:attribute>
</xsl:attribute-set>
<xsl:attribute-set name="top">
	<xsl:attribute name="border-before-color">#82C0FF</xsl:attribute>
	<xsl:attribute name="border-before-style">double</xsl:attribute>
	<xsl:attribute name="border-before-width">2pt</xsl:attribute>
</xsl:attribute-set>
<xsl:attribute-set name="bottom">
	<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
	<xsl:attribute name="border-after-style">double</xsl:attribute>
	<xsl:attribute name="border-after-width">2pt</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="table-atts">
	<xsl:attribute name="border-before-color">#82C0FF</xsl:attribute>
	<xsl:attribute name="border-before-style">double</xsl:attribute>
	<xsl:attribute name="border-before-width">6pt</xsl:attribute>
	<xsl:attribute name="border-start-color">#82C0FF</xsl:attribute>
	<xsl:attribute name="border-start-style">double</xsl:attribute>
	<xsl:attribute name="border-start-width">3pt</xsl:attribute>
	<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
	<xsl:attribute name="border-after-style">double</xsl:attribute>
	<xsl:attribute name="border-after-width">3pt</xsl:attribute>
	<xsl:attribute name="border-end-color">#82C0FF</xsl:attribute>
	<xsl:attribute name="border-end-style">double</xsl:attribute>
	<xsl:attribute name="border-end-width">3pt</xsl:attribute>
</xsl:attribute-set>

<xsl:template match="/">
	<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="page">
				<fo:region-body region-name="body" margin-top="0.5in" margin-bottom="0.5in" margin-left="0.5in" margin-right="0.5in" />
			</fo:simple-page-master>
		</fo:layout-master-set>
		
		<fo:page-sequence master-reference="page">
			<fo:flow flow-name="body">
				<fo:block>
					<xsl:apply-templates />
				</fo:block>
			</fo:flow>
		</fo:page-sequence>
	</fo:root>
</xsl:template>

<!-- XSL style sheet for ColumnStats element -->
	<xsl:template match="IMML">
		<xsl:choose>
			<xsl:when test="DisplayOptions[@title] = 0">
				<fo:block xsl:use-attribute-sets="title">
					Column Information: <xsl:value-of select="DisplayOptions/@title"/>
				</fo:block>
				<xsl:apply-templates select="XTMetaData"/>
			</xsl:when>
			<xsl:otherwise>
				<fo:block xsl:use-attribute-sets="title">
					Column Information: <xsl:value-of select="DisplayOptions/@title"/>
				</fo:block>
				<xsl:apply-templates select="XTMetaData"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="XTMetaData">
		<xsl:apply-templates select="ColumnStats"/>
	</xsl:template>

	<xsl:template match="ColumnStats">
		<xsl:choose>
			<xsl:when test="TableStats/@rowCount = 0">
				<fo:block xsl:use-attribute-sets="body">
					<fo:wrapper xsl:use-attribute-sets="bold-emph">Number of Rows: </fo:wrapper> 
					<xsl:text>  0</xsl:text>
				</fo:block>
				<fo:block xsl:use-attribute-sets="body">
					<fo:wrapper xsl:use-attribute-sets="bold-emph">Number of Columns: </fo:wrapper> 
					<xsl:text>  0</xsl:text>
				</fo:block>
			</xsl:when>
			<xsl:when test="count(UnivariateStats) = 0">
				<fo:block xsl:use-attribute-sets="body">
					<fo:wrapper xsl:use-attribute-sets="bold-emph">Number of Rows: </fo:wrapper> 
					<xsl:text>  0</xsl:text>
				</fo:block>
				<fo:block xsl:use-attribute-sets="body">
					<fo:wrapper xsl:use-attribute-sets="bold-emph">Number of Columns: </fo:wrapper> 
					<xsl:text>  0</xsl:text>
				</fo:block>
			</xsl:when>
			<xsl:otherwise>
				<fo:block xsl:use-attribute-sets="body">
					<fo:wrapper xsl:use-attribute-sets="bold-emph">Number of Rows: </fo:wrapper> 
					<xsl:text>  </xsl:text>
					<xsl:value-of select="TableStats/@rowCount"/>
				</fo:block>
				<fo:block xsl:use-attribute-sets="body">
					<fo:wrapper xsl:use-attribute-sets="bold-emph">Number of Columns: </fo:wrapper> 
					<xsl:text>  </xsl:text>
					<xsl:value-of select="count(UnivariateStats)"/>
				</fo:block>

				<xsl:if test="TableStats/@rowCount != 0">
					<xsl:if test="count(../ColumnDefinitions/ColumnInfo[@type = 'continuous']) != 0">
						<fo:block xsl:use-attribute-sets="small-cap">Continuous Columns</fo:block>

						<fo:table xsl:use-attribute-sets="table-atts" table-layout="fixed">
							<xsl:element name="fo:table-column">
								<xsl:attribute name="column-number">1</xsl:attribute>
								<xsl:attribute name="column-width">
									<xsl:call-template name="ColumnInfoName">
										<xsl:with-param name="element" select="../ColumnDefinitions" />
										<xsl:with-param name="TotalNum" select="count(../ColumnDefinitions/ColumnInfo)" />
									</xsl:call-template>pt
								</xsl:attribute>
							</xsl:element>
							<fo:table-column column-number="2" column-width="60pt" />
							<fo:table-column column-number="3" column-width="60pt" />
							<fo:table-column column-number="4" column-width="60pt" />
							<fo:table-column column-number="5" column-width="60pt" />
							<fo:table-column column-number="6" column-width="60pt" />

							<fo:table-header>
								<fo:table-row background-color="#CCE6FF">
									<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block></fo:block></fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Mean</fo:block></fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Min</fo:block></fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Max</fo:block></fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>StdDev</fo:block></fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Missing</fo:block></fo:table-cell>
								</fo:table-row>
							</fo:table-header>

							<fo:table-body>
								<xsl:for-each select="../ColumnDefinitions/ColumnInfo">
									<xsl:variable name="name" select="@name"/>
									<xsl:if test="@type = 'continuous'">
										<xsl:element name="fo:table-row">
											<xsl:call-template name="NumericInfo">
												<xsl:with-param name="element" select="../../ColumnStats/UnivariateStats[@field = $name]/NumericInfo" />
												<xsl:with-param name="name" select="$name" />
												<xsl:with-param name="position" select="position() mod 2" />
											</xsl:call-template>
										</xsl:element>
									</xsl:if>
								</xsl:for-each>
								
							</fo:table-body>
						</fo:table>
					</xsl:if>

					<xsl:if test="count(../ColumnDefinitions/ColumnInfo[@type = 'categorical']) != 0">
						<fo:block xsl:use-attribute-sets="small-cap">Categorical Columns</fo:block>
						<fo:block xsl:use-attribute-sets="body">
							<xsl:apply-templates select="UnivariateStats"/>
						</fo:block>
					</xsl:if>

					<xsl:if test="count(../ColumnDefinitions/ColumnInfo[@type = 'string']) != 0">
						<fo:block xsl:use-attribute-sets="small-cap">String Columns</fo:block>

						<fo:table xsl:use-attribute-sets="table-atts" table-layout="fixed">
							<xsl:element name="fo:table-column">
								<xsl:attribute name="column-number">1</xsl:attribute>
								<xsl:attribute name="column-width">
									<xsl:call-template name="ColumnInfoName">
										<xsl:with-param name="element" select="../ColumnDefinitions" />
										<xsl:with-param name="TotalNum" select="count(../ColumnDefinitions/ColumnInfo)" />
									</xsl:call-template>pt
								</xsl:attribute>
							</xsl:element>
							<fo:table-column column-number="2" column-width="60pt" />

							<fo:table-header>
								<fo:table-row background-color="#82C0FF">
									<fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="row-header left right bottom"><fo:block><xsl:value-of select="../@field" /></fo:block></fo:table-cell>
								</fo:table-row>
								<fo:table-row background-color="#CCE6FF">
									<fo:table-cell column-number="1" xsl:use-attribute-sets="row-header left right"><fo:block></fo:block></fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="header left right"><fo:block>Width</fo:block></fo:table-cell>
								</fo:table-row>
							</fo:table-header>
					
							<fo:table-body>
								<xsl:for-each select="../ColumnDefinitions/ColumnInfo[@type = 'string']">
									<xsl:variable name="name" select="@name"/>

									<fo:table-row>
										<fo:table-cell xsl:use-attribute-sets="row-header left right bottom top" font-weight="bold">
											<xsl:element name="fo:block">
												<xsl:attribute name="background-color">
													<xsl:choose>
														<xsl:when test="position() mod 2 = 1">#EEEEEE</xsl:when>
														<xsl:otherwise>#FFFFFF</xsl:otherwise>
													</xsl:choose>
												</xsl:attribute>
												<xsl:value-of select="@name"/>
											</xsl:element>
										</fo:table-cell>
										<fo:table-cell xsl:use-attribute-sets="cell left right bottom top">
											<xsl:element name="fo:block">
												<xsl:attribute name="background-color">
													<xsl:choose>
														<xsl:when test="position() mod 2 = 1">#EEEEEE</xsl:when>
														<xsl:otherwise>#FFFFFF</xsl:otherwise>
													</xsl:choose>
												</xsl:attribute>
								
												<xsl:value-of select="@width"/>
											</xsl:element>
										</fo:table-cell>
									</fo:table-row>
								</xsl:for-each>
							</fo:table-body>
						</fo:table>
					</xsl:if>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="UnivariateStats">
		<xsl:for-each select=".">
			<xsl:variable name="field" select="@field"/>
			<xsl:variable name="missingFreq" select="Counts/@missingFreq"/>


			<xsl:choose>
				<xsl:when test="count(Counts[Category])!=0">
					<fo:block space-after="5pt">
						<xsl:apply-templates select="Counts[Category]"/>
					</fo:block>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="../../ColumnDefinitions/ColumnInfo[@name = $field]/@type = 'categorical'">
						<xsl:if test="$missingFreq > 0">
							<fo:table xsl:use-attribute-sets="table-atts" table-layout="fixed">
								<xsl:element name="fo:table-column">
									<xsl:attribute name="column-number">1</xsl:attribute>
									<xsl:attribute name="column-width">
										<xsl:value-of select="string-length('Missing') * 8"/>pt
									</xsl:attribute>
								</xsl:element>
								<fo:table-column column-number="2" column-width="60pt" />

								<fo:table-header>
									<fo:table-row background-color="#82C0FF">
										<fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="row-header left right bottom"><fo:block><xsl:value-of select="../@field" /></fo:block></fo:table-cell>
									</fo:table-row>
									<fo:table-row background-color="#CCE6FF">
										<fo:table-cell column-number="1" xsl:use-attribute-sets="row-header left right"><fo:block>Level Name</fo:block></fo:table-cell>
										<fo:table-cell column-number="2" xsl:use-attribute-sets="header left right"><fo:block>Counts</fo:block></fo:table-cell>
									</fo:table-row>
								</fo:table-header>
						
								<fo:table-body>
									<xsl:if test="$missingFreq != 0">
										<fo:table-row>
											<fo:table-cell xsl:use-attribute-sets="row-header left right bottom top" font-weight="bold">
												<xsl:element name="fo:block">
													<xsl:attribute name="background-color">
														<xsl:choose>
															<xsl:when test="position() mod 2 = 1">#EEEEEE</xsl:when>
															<xsl:otherwise>#FFFFFF</xsl:otherwise>
														</xsl:choose>
													</xsl:attribute>
													Missing
												</xsl:element>
											</fo:table-cell>
											<fo:table-cell xsl:use-attribute-sets="cell left right bottom top">
												<xsl:element name="fo:block">
													<xsl:attribute name="background-color">
														<xsl:choose>
															<xsl:when test="position() mod 2 = 1">#EEEEEE</xsl:when>
															<xsl:otherwise>#FFFFFF</xsl:otherwise>
														</xsl:choose>
													</xsl:attribute>
									
													<xsl:value-of select="@missingFreq"/>
												</xsl:element>
											</fo:table-cell>
										</fo:table-row>
									</xsl:if>
								</fo:table-body>
							</fo:table>
						</xsl:if>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="Counts[Category]">
		<fo:table xsl:use-attribute-sets="table-atts" table-layout="fixed">
			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-number">1</xsl:attribute>
				<xsl:attribute name="column-width">
					<xsl:call-template name="CategoryWidth">
						<xsl:with-param name="element" select="." />
						<xsl:with-param name="TotalNum" select="count(./Category)" />
						<xsl:with-param name="minWidth" select="60" />
					</xsl:call-template>pt
				</xsl:attribute>
			</xsl:element>
			<fo:table-column column-number="2" column-width="60pt" />	
			<fo:table-header>
				<fo:table-row background-color="#82C0FF">
					<fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="row-header left right bottom"><fo:block><xsl:value-of select="../@field" /></fo:block></fo:table-cell>
				</fo:table-row>
				<fo:table-row background-color="#CCE6FF">
					<fo:table-cell column-number="1" xsl:use-attribute-sets="row-header left right"><fo:block>Level Name</fo:block></fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="header left right"><fo:block>Counts</fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-header>
	
			<fo:table-body>
				<xsl:apply-templates select="Category"/>
				<xsl:if test="position()=last()">
					<xsl:if test="@missingFreq != 0">
						<fo:table-row>
							<fo:table-cell xsl:use-attribute-sets="row-header left right bottom top" font-weight="bold">
								<xsl:element name="fo:block">
									<xsl:attribute name="background-color">
										<xsl:choose>
											<xsl:when test="position() mod 2 = 1">#EEEEEE</xsl:when>
											<xsl:otherwise>#FFFFFF</xsl:otherwise>
										</xsl:choose>
									</xsl:attribute>
									Missing
								</xsl:element>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell left right bottom top">
								<xsl:element name="fo:block">
									<xsl:attribute name="background-color">
										<xsl:choose>
											<xsl:when test="position() mod 2 = 1">#EEEEEE</xsl:when>
											<xsl:otherwise>#FFFFFF</xsl:otherwise>
										</xsl:choose>
									</xsl:attribute>
					
									<xsl:value-of select="@missingFreq"/>
								</xsl:element>
							</fo:table-cell>
						</fo:table-row>
					</xsl:if>
				</xsl:if>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template match="Category">
		<fo:table-row>
			<fo:table-cell xsl:use-attribute-sets="row-header left right bottom top" font-weight="bold">
				<xsl:element name="fo:block">
					<xsl:attribute name="background-color">
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">#EEEEEE</xsl:when>
							<xsl:otherwise>#FFFFFF</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
	
					<xsl:value-of select="@value"/>
				</xsl:element>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="cell left right bottom top">
				<xsl:element name="fo:block">
					<xsl:attribute name="background-color">
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">#EEEEEE</xsl:when>
							<xsl:otherwise>#FFFFFF</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
	
					<xsl:value-of select="@freq"/>
				</xsl:element>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>

	<xsl:template name="NumericInfo">
		<xsl:param name="element" select="''" />
		<xsl:param name="name" select="''" />
		<xsl:param name="position" select="1" />
		
		<xsl:variable name="decimalPattern" select="$element/../../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="$element/../../../../DisplayOptions/@scientificPattern"/>
		<xsl:variable name="decimalZero" select="format-number(0, $decimalPattern)"/>

		<fo:table-cell xsl:use-attribute-sets="row-header left right bottom top" font-weight="bold">
			<xsl:element name="fo:block">
				<xsl:attribute name="background-color">
					<xsl:choose>
						<xsl:when test="$position=1">#EEEEEE</xsl:when>
						<xsl:otherwise>#FFFFFF</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>

				<xsl:value-of select="$name"/>
			</xsl:element>
		</fo:table-cell>

		<fo:table-cell xsl:use-attribute-sets="cell left right bottom top">
			<xsl:element name="fo:block">
				<xsl:attribute name="background-color">
					<xsl:choose>
						<xsl:when test="$position=1">#EEEEEE</xsl:when>
						<xsl:otherwise>#FFFFFF</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>

				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="$element/@mean" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</xsl:element>
		</fo:table-cell>	
		<fo:table-cell xsl:use-attribute-sets="cell left right bottom top">
						<xsl:element name="fo:block">
				<xsl:attribute name="background-color">
					<xsl:choose>
						<xsl:when test="$position=1">#EEEEEE</xsl:when>
						<xsl:otherwise>#FFFFFF</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>

				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="$element/@minimum" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</xsl:element>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="cell left right bottom top">
			<xsl:element name="fo:block">
				<xsl:attribute name="background-color">
					<xsl:choose>
						<xsl:when test="$position=1">#EEEEEE</xsl:when>
						<xsl:otherwise>#FFFFFF</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>

				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="$element/@maximum" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</xsl:element>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="cell left right bottom top">
			<xsl:element name="fo:block">
				<xsl:attribute name="background-color">
					<xsl:choose>
						<xsl:when test="$position=1">#EEEEEE</xsl:when>
						<xsl:otherwise>#FFFFFF</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>

				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="$element/@standardDeviation" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</xsl:element>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="cell left right bottom top">
			<xsl:element name="fo:block">
				<xsl:attribute name="background-color">
					<xsl:choose>
						<xsl:when test="$position=1">#EEEEEE</xsl:when>
						<xsl:otherwise>#FFFFFF</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>

				<xsl:value-of select="$element/../Counts/@missingFreq"/> 
			</xsl:element>
		</fo:table-cell>
	</xsl:template>

	<xsl:template name="ColumnInfoName">
		<xsl:param name="element" select="''" />
		<xsl:param name="CurrentNum" select="0" />
		<xsl:param name="TotalNum" select="0" />
		<xsl:param name="minWidth" select="50" />
		<xsl:param name="maxWidth" select="0" />

		<xsl:variable name="this" select="$element/ColumnInfo[$CurrentNum]/@name" />
		<xsl:variable name="thisWidth" select="string-length($this) * 6" />

		<xsl:choose>
			<xsl:when test="$TotalNum = $CurrentNum">
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $thisWidth"><xsl:value-of select="$minWidth"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$thisWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $maxWidth"><xsl:value-of select="$minWidth"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$maxWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:call-template name="ColumnInfoName">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$thisWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="ColumnInfoName">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$maxWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="CategoryWidth">
		<xsl:param name="element" select="''" />
		<xsl:param name="CurrentNum" select="0" />
		<xsl:param name="TotalNum" select="0" />
		<xsl:param name="minWidth" select="50" />
		<xsl:param name="maxWidth" select="0" />

		<xsl:variable name="this" select="$element/Category[$CurrentNum]/@value" />
		<xsl:variable name="thisWidth" select="string-length($this) * 6" />

		<xsl:choose>
			<xsl:when test="$TotalNum = $CurrentNum">
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $thisWidth"><xsl:value-of select="$minWidth"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$thisWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $maxWidth"><xsl:value-of select="$minWidth"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$maxWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:call-template name="CategoryWidth">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$thisWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="CategoryWidth">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$maxWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="roundNumber">
		<xsl:param name="string" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />

	   	<xsl:variable name="lowerCasePattern" select="'e'" />
	   	<xsl:variable name="upperCasePattern" select="'E'" />

		<xsl:choose>
		      <xsl:when test="contains($string, $lowerCasePattern)">
			    <xsl:call-template name="outputRoundedScientific">
			        <xsl:with-param name="valueString" select="substring-before($string, $lowerCasePattern)" />
			        <xsl:with-param name="exponentString" select="substring-after($string, $lowerCasePattern)" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
			    </xsl:call-template>
 			  </xsl:when>
		      <xsl:when test="contains($string, $upperCasePattern)">
			    <xsl:call-template name="outputRoundedScientific">
			        <xsl:with-param name="valueString" select="substring-before($string, $upperCasePattern)" />
			        <xsl:with-param name="exponentString" select="substring-after($string, $upperCasePattern)" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
			    </xsl:call-template>
 			  </xsl:when>
		      <xsl:otherwise>
		      	 <xsl:choose>
				<xsl:when test="format-number($string, $decimalPattern) != format-number(0, $decimalPattern)">
					<xsl:value-of select="format-number($string, $decimalPattern)"/>
				</xsl:when>
				<xsl:when test="$string = 0">
					<xsl:value-of select="format-number($string, $decimalPattern)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="format-number($string, $scientificPattern)"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>  </xsl:text>
		      </xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="outputRoundedScientific">
		<xsl:param name="valueString" select="''" />
		<xsl:param name="exponentString" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:value-of select="format-number($valueString, $decimalPattern)" />E<xsl:value-of select="format-number($exponentString, '#0')"/>
	</xsl:template>

</xsl:stylesheet>
