#!/bin/sh

# Copyright (c) 2002, 2006 Insightful, Inc.  All rights reserved.

#
#  Build script for sample S-PLUS EJB client.  This might be better 
#  accomplished using makefiles or ant scripts, but for simplicity and
#  clarity, a single shell script is presented here.
#

if [ -z "$JAVA_HOME" ]
then
	echo "The JAVA_HOME environmental variable must be set"
	exit 1
fi

if [ -z "$JBOSS_HOME" ]
then
	echo "The JBOSS_HOME environmental variable must be set"
	exit 1
fi

if [ "x$SHOME" = "x" ]
then
	echo "The SHOME environmental variable must be set"
	exit 1
fi

CLASSPATH=.:"$SHOME"/java/Splus.jar:"$JBOSS_HOME"/lib/ext/jboss-j2ee.jar:../SplusEngine.jar
export CLASSPATH

echo "Building QueryTester.java"
"$JAVA_HOME"/bin/javac QueryTester.java

echo "Building QueryTesterProxy.java"
"$JAVA_HOME"/bin/javac QueryTesterProxy.java
"$JAVA_HOME"/bin/rmic QueryTesterProxy

echo "Creating QueryTester.jar"
mkdir ejbsplus
cp ../ejbsplus/SplusEngineClient.class ejbsplus
"$JAVA_HOME"/bin/jar cvf QueryTester.jar *.class ejbsplus/SplusEngineClient.class

echo "Deploying QueryTester.jar to $JBOSS_HOME/lib/ext"
cp QueryTester.jar $JBOSS_HOME/lib/ext
