## This function provides a simple demonstration
##   of GraphServlet.
## It generates a simple plot of a specified number
##   of randomly generated points, and includes
##   a region the user can click to generate a
##   new plot with a different random number of
##   points.
##
## Author:  Gary Nelson, gnelson@insightful.com
## Version: 19 January 2001

DemoPlot <- function(nNumPts)
{
	## Draw the plot.
	plot(runif(nNumPts), runif(nNumPts), type = 'l',
		xlim = c(0, 1), ylim = c(0, 1))

	## Pick a random number of points for the next graph.
	nNewNumPts <- round(runif(1) * 40 + 10)

	## Specify a "hot" region the user can click to
	##   generate the next graph.
  	title(xlab = paste(" [Redraw with", nNewNumPts, "Points]"), adj=0.0)
	java.identify(
		x1 = -0.05, x2 = 0.3, y1 = -0.15, y2 = -0.22,
		labels = paste("New Graph\nwith", nNewNumPts, "Points"),
		actions = MakeAction(DemoPlot, nNumPts = nNewNumPts))

	## Return text for the title bar on the user's browser.
	return(paste("Random Graph with", nNumPts, "Points"))
}
