hist.cities <- function(state="Texas",city="Dallas",vartoplot="Pop1990"){


###########################################################################
###
### hist.cities: Produces a histogram graphlet of city data for the selected state.
###              
###             
### Arguments:
###
### state:     The selected State.
###
### city:      The selected City.
###
### vartoplot: Column name from the cities dataframe. This is the variable
###            that will be plotted in the histogram.
###
###########################################################################

  ## Strip out unwanted "%20" characters
  state <- token(source=state)
  city <- token(city)
  
  ## Subset cities dataframe down to the selected state
  idx <- as.character(cities$State.name) == state
  c.in.s <- cities[idx,]
  
  ## Locate the selected city
  cityref.idx <- as.character(c.in.s$City.name) == city

  ## Set the color device to trellis colors
  java.set.colorscheme(java.colorscheme.trellis)

  ## build a title string for the plot
  xtitle <- paste(vartoplot, " for ", city, "(" ,
		  round(c.in.s[,vartoplot][cityref.idx],digits=3),") marked with a vertical line") 
  
  ## Plot the histogram
  hist(c.in.s[,vartoplot],nclass=min(c(15,dim(c.in.s)[1])),include.lowest=F, xlab=xtitle)
  
  ## Add a title to the plot
  title(main=paste(vartoplot, " for cities in ",state,sep="")) 
  

  ## Add a vertical line identifying the location of the data element
  ## of the selected city.
  abline(v=c.in.s[,vartoplot][cityref.idx])

  ##  Set up the active regions
  x1 <- x2 <- c.in.s[,vartoplot]
  y1 <- rep(0,dim(c.in.s)[1])
  y2 <- rep(par()$usr[4],dim(c.in.s)[1])

  ## Set up the options for new data to plot as histograms
  pos.names <- c("Pop1990", "Pct.Male", "Pct.0.5", "Pct.65.up", "Households", "Median.val" )
  change.names.idx <- !is.element(pos.names,vartoplot)
  menu.options <- pos.names[change.names.idx]
  

  menu <- list()

  ## Build up the required action commands
  for (name in menu.options){
    menu[[name]]<- paste('<menuitem label="', 
			 name,'">', MakeAction(hist.cities,state=state,
					       city=as.character(c.in.s$City.name),
					       vartoplot=name), '</menuitem>')}

  menupaste <- apply(data.frame(menu),1,paste, collapse="")
  menupaste <- paste("<menu>",menupaste,"</menu>")

  ## Create the active regions with required action commands.
  java.identify(x1=x1,x2=x2,y1=y1,y2=y2,
		labels=paste(c.in.s$City.name, ": ",
		  round(c.in.s[,vartoplot],digits=3),sep=""), actions = menupaste)
	
}

