// Import the necessary swing and S-PLUS classes
import com.insightful.splus.*;
import com.insightful.controls.*;
import javax.swing.*;

public class SummaryDialogExample extends SplusDialog {

  public SummaryDialogExample(){
    // Specify the title in the SplusDialog constructor
    super("Summary Dialog");
      
    // Specify the function to call on OK or Apply
    SplusFunctionInfo funcInfo = new
      SplusFunctionInfo("summary");
    setFunctionInfo(funcInfo);
  
    // Create a panel to contain the dialog controls
    JPanel dataPage = new JPanel();

    // Create a combo box control
    SplusDataSetComboBox dataSet = new
      SplusDataSetComboBox();
      
    // Add the combo box to the dialog panel
    dataPage.add(dataSet);

    // Add the combo box to the list of function arguments
    funcInfo.add(dataSet, "object");
      
    // Add the panel to the dialog and perform dialog sizing
    setCenterPanel(dataPage);
  }
}
