
// The S-Plus expression to add a menu item launching the dialog is:
//
//   .JavaMethod("SummaryDialogWithMenu", "addMenuItem", "()V")
//

import com.insightful.splus.*;
import com.insightful.controls.*;
import javax.swing.*;

public class SummaryDialogWithMenu extends SplusDialog {

  // Constructor for dialog

  public SummaryDialogWithMenu(){
    super("Summary Dialog");
      
    SplusFunctionInfo funcInfo = new
      SplusFunctionInfo("summary");
    setFunctionInfo(funcInfo);
  
    JPanel dataPage = new JPanel();
    SplusDataSetComboBox dataSet = new
      SplusDataSetComboBox();
      
    dataPage.add(dataSet);
    funcInfo.add(dataSet, "object");
      
    setCenterPanel(dataPage);
  }

  // Method to modify menu

  // Have a flag indicating whether menu already added.
  // Another approach is to check the menu item text.

  static boolean menuHasBeenAdded = false;
 
  public static void addMenuItem() {

    if (!menuHasBeenAdded){
      menuHasBeenAdded = true;

      JMenu myMenu = new JMenu("Other");
      myMenu.setMnemonic('O');

      JMenuItem menuItem = new 
        JMenuItem("Simple Summary...");
      menuItem.setMnemonic('S');

      // The menu action listener launches a dialog if it
      // gets an action command starting with "D:".

      menuItem.setActionCommand("D:SummaryDialogWithMenu");
      menuItem.addActionListener(getMainActionListener());
      myMenu.add(menuItem);

      // Add myMenu after the Statistics menu.

      JMenuBar menuBar = getMainMenuBar();

      int numItems = menuBar.getMenuCount();

      // Find Statistics menu item

      int index = -1;

      for (int i = 0; index < 0 && i < numItems; i++){
        JMenuItem item = (JMenuItem) 
          menuBar.getComponent(i);
        if (item.getText().equals("Statistics"))
          index = i + 1;
      }

      menuBar.add(myMenu, index);

      // revalidate to get menu to redisplay
      menuBar.revalidate();
    }
  }
}
