### $Id: Demand.q,v 3.1 1999/09/07 17:04:02 silvia Exp silvia $
### Analysis of the per capita demand deposits data given as data
### set 3.6 in "SAS System for Mixed Models"
names( Demand )
formula( Demand )
# the "grp" factor is a dummy factor with only one level.
Demand$grp <- rep(1,length(Demand$y))
unique( Demand$grp )
# Crossed random-effects factors have to be created by pdIdent applied to
# the indicator variables and joined together by pdBlocked.
fm1Demand <- lme( log(d) ~ log(y) + log(rd) + log(rt) + log(rs), data = Demand,
  random = list(grp = pdBlocked(list(pdIdent(~ State - 1), pdIdent(~ Year - 1)))),
  method = "REML" )
summary( fm1Demand )        # compare to output 3.13, p. 132
