/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001
*/

// spconnec.cxx: implementation of the CSPconnection class.
//
//////////////////////////////////////////////////////////////////////
#ifdef __hppa
#include <stdlib.h>
#endif

#include "sconnect.h"
#include "S_io.h"
#include "string.h"
#include "sys_codes.h"

extern "C" s_object* S_STDCALL S_pipe(s_object* call, s_object* arglist, s_evaluator* S_evaluator);
extern "C" s_object* S_STDCALL s_data_put(s_object* data, s_object* con_obj);
extern "C" s_object* S_STDCALL s_data_get(s_object* con_obj, s_object* optional, s_object* deflt);

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSPconnection::CSPconnection()
:CSPobject()
{

}

CSPconnection::~CSPconnection()
{
	if( IsValid() )
		Close();
}

void CSPconnection::Close(Which which)
{
	if( IsValid() )
	{
		s_connection s_con;
		::as_s_connection(&s_con, GetPtr(), S_evaluator);
		switch(which)
		{
			case connection:
			{
				::close_connection(&s_con, S_evaluator);
			}
			break;
			case read:
			case write:
			{
				try
				{
					CSPevaluator sEvaluator;
					S_evaluator->_sys_index = 3;
					s_object *ps_arglist = NEW_LIST(2);
					LIST_POINTER(ps_arglist)[0] = GetPtr();
					s_object* ps_Type = NULL;
					LIST_POINTER(ps_arglist)[1] = ps_Type = NEW_CHARACTER(1);
					CHARACTER_POINTER(ps_Type)[0] = c_s_cpy((which==read?"r":"w"), S_evaluator);
					S_pipe(blt_in_NULL, ps_arglist, S_evaluator);
				}
				catch(...)
				{
				}
			}
			break;
		}
		Detach();
	}
}

BOOL CSPconnection::Open()
{
	BOOL bSuccess = FALSE;
	try
	{
		if( !IsValid() )
			SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);

		CSPevaluator sEvaluator;

		CSPcall spOpen("open");
		s_object* ps_object = spOpen.Eval(GetPtr());
		if ( !SPL_NotThere(ps_object) )
		{
			ps_object = sEvaluator.CloneIfNeeded(ps_object);

			ReAttachAndAssign(ps_object);
			bSuccess = TRUE;
		}
	}
	catch (CSPexception& except)
	{
		except.Print();
	}
	catch(...)
	{
	}
	return bSuccess;
}

S_newio_FILE* CSPconnection::GetReadFile()
{
	if ( !IsValid() )
		return NULL;

	CSPevaluator s;

	s_connection s_con;
	::as_s_connection(&s_con, GetPtr(), S_evaluator);
	return s_con.rfile;
}

S_newio_FILE* CSPconnection::GetWriteFile()
{
	if ( !IsValid() )
		return NULL;

	CSPevaluator s;

	s_connection s_con;
	::as_s_connection(&s_con, GetPtr(), S_evaluator);
	return s_con.wfile;
}

const char*  CSPconnection::GetDescription()
{
	if ( !IsValid() )
		return NULL;

	CSPevaluator s;

	s_connection s_con;
	::as_s_connection(&s_con, GetPtr(), S_evaluator);
	return s_con.description;
}

long  CSPconnection::GetReadfd()
{
	if ( !IsValid() )
		return 0;

	CSPevaluator s;

	s_connection s_con;
	::as_s_connection(&s_con, GetPtr(), S_evaluator);
	return s_con.rfd;
}

long  CSPconnection::GetWritefd()
{
	if ( !IsValid() )
		return 0;

	CSPevaluator s;

	s_connection s_con;
	::as_s_connection(&s_con, GetPtr(), S_evaluator);
	return s_con.wfd;
}

size_t CSPconnection::GetReadPos()
{
	if ( !IsValid() )
		return 0;

	s_connection s_con;
	::as_s_connection(&s_con, GetPtr(), S_evaluator);
	//::ok_getpos(s_con.rfile, &s_con.rpos, S_evaluator);
	//return s_con.rpos;
	return ftell(s_con.rfile);
}

size_t  CSPconnection::GetWritePos()
{
	if ( !IsValid() )
		return 0;

	CSPevaluator s;

	s_connection s_con;
	::as_s_connection(&s_con, GetPtr(), S_evaluator);
	//::ok_getpos(s_con.wfile, &s_con.wpos, S_evaluator);
	//return s_con.wpos;
	return ftell(s_con.wfile);
}

size_t CSPconnection::GetSize()
{
	if ( !IsValid() )
		return 0;

	s_connection s_con;
	::as_s_connection(&s_con, GetPtr(), S_evaluator);
	if ( !s_con.sbuf )
		return 0;

	return ((struct stat*)s_con.sbuf)->st_size;
}

void CSPconnection::SeekWrite(long pos, From from)
{
	if ( !IsValid() )
		return;

	CSPevaluator s;

	s_connection s_con;
	::as_s_connection(&s_con, GetPtr(), S_evaluator);
	::con_seek(&s_con, pos, (int)from, WRITE_MODE, S_evaluator);
}

void CSPconnection::SeekRead(long pos, From from)
{
	if ( !IsValid() )
		return;

	if( !S_evaluator->_eval_open )
		SCONNECT_ThrowException(SCONNECT_EVALUATOR_CLOSED);

	s_connection s_con;
	::as_s_connection(&s_con, GetPtr(), S_evaluator);
	::con_seek(&s_con, pos, (int)from, READ_MODE, S_evaluator);
}

size_t CSPconnection::DataPut(s_object* ps_object)
{
	if ( !IsValid() )
		return 0;

	if ( SPL_NotThere(ps_object) )
		SCONNECT_ThrowException("Invalid S-PLUS object for symbolic dump");

	size_t nBytes = 0;
	try
	{
		CSPevaluator s;

		nBytes = GetWritePos();
		s_data_put(ps_object, *this);
		nBytes = GetWritePos()-nBytes;
	}
	catch(CSPexception& except)
	{
		except.Print();
	}
	catch(...)
	{
	}

	return nBytes;
}

s_object* CSPconnection::DataGet()
{
	if ( !IsValid() )
		return NULL;

	s_object* ps_object = NULL;
	try
	{
		CSPevaluator sEvaluator;
		ps_object = s_data_get(*this, blt_in_FALSE, blt_in_NULL);
		ps_object = sEvaluator.CloneIfNeeded(ps_object);
	}
	catch(CSPexception& except)
	{
		except.Print();
	}
	catch(...)
	{
	}

	return ps_object;
}


//////////////////////// CSPtextConnection ////////////////////////

//Default constructor
CSPtextConnection::CSPtextConnection()
: CSPconnection()
{
}

//Construct from a valid S-expression
CSPtextConnection::CSPtextConnection(const char* pszExpression)
: CSPconnection()
{
	Create(pszExpression);
}

//Copy constructor 
CSPtextConnection::CSPtextConnection(s_object* ps_object)
: CSPconnection()
{
	if(!CoerceAttach(ps_object))
		SCONNECT_ThrowException("Failed to coerce object to class textConnection"); 
}

//Copy constructor 
CSPtextConnection::CSPtextConnection(const CSPtextConnection& sobject)
: CSPconnection()
{
	if(!CoerceAttach(sobject.GetPtr()))
		SCONNECT_ThrowException("Failed to coerce object to class textConnection");  
}

//Assigment operator
CSPtextConnection& CSPtextConnection::operator = (s_object* ps_object)
{
	if(!CoerceAttach(ps_object))
		SCONNECT_ThrowException("Failed to coerce object to class textConnection");  
	return *this;
}

//Assigment operator
CSPtextConnection& CSPtextConnection::operator = (const CSPtextConnection& sobject)
{
	if(!CoerceAttach(sobject.GetPtr()))
		SCONNECT_ThrowException("Failed to coerce object to class textConnection");  
	return *this;
}

//Create a persistent object when pszName != NULL
BOOL CSPtextConnection::Create(
	const char* pszExpression, //==NULL, uses the default constructor, else use the expression to instantiate it.
	const char* pszName,       //object name
	long lDataBase )				//database
{
	BOOL bSuccess = TRUE;	
	try
	{
		bSuccess = CSPconnection::BaseCreate("textConnection", pszExpression, pszName, lDataBase );
		if(bSuccess)
			Coerce();
	}
	catch(...)
	{
		bSuccess = FALSE;
	}

	return bSuccess;
}

//The destructor
CSPtextConnection::~CSPtextConnection()
{
}

//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////

//Return TRUE if the object is a valid 'textConnection' class
BOOL CSPtextConnection::IsValid(void) const
{
	if(CSPobject::IsValid())
		return IS(GetPtr(), MAKE_CLASS("textConnection"));

	return FALSE;
}

//Coerce to textConnection-connection class
BOOL CSPtextConnection::Coerce(void)
{
	return CoerceAttach(GetPtr());
}

//CoerceAttach() coerces to "textConnection" class and attatch
BOOL CSPtextConnection::CoerceAttach(s_object* ps_object)
{
	if(ps_object == NULL)
		return FALSE;
	
	s_object* ps_textConnection=NULL;
	try
	{
		if(!IS(ps_object, MAKE_CLASS("textConnection")))
		{
			CSPcharacter scharText(ps_object);
			if(scharText.IsValid())
			{
				ps_textConnection = create_textConnection(ps_object, S_evaluator);
				ReAttachAndAssign(ps_textConnection);
			}	
		}
	}
	catch(...)
	{
		SCONNECT_ThrowException("Failed to coerce object to class textConnect");
	}

	return TRUE;
}

// open a text connection
BOOL CSPtextConnection::TextConnection(const char* pszText)
{
	if ( !pszText || !*pszText )
		SCONNECT_ThrowException("Invalid text for textConnection");

	try
	{
		CSPevaluator sEvaluator;

		CSPcall spFCall("textConnection");
		spFCall.SetArg(pszText,1);
		s_object* ps_object = spFCall.Eval();
		ps_object = sEvaluator.CloneIfNeeded(ps_object);
		Attach(ps_object);
	}
	catch(CSPexception& except)
	{
		except.Print();
	}
	catch(...)
	{
	}
	return IsValid();
}

//ParseTest() parses to test the expression(text) in this textConnnection object 
//(only the first line, i.e. up to the first '\n').
//It returns status result.
//The arg. pnCharParsed is length of char. sucessfully parsed.

#define PARSE_EXP_SLOT 0
#define PARSE_TEXT_SLOT 1
#define PARSE_MESSAGE_SLOT 2
#define PARSE_CHARSPARSED_SLOT 4
#define PARSE_RESULTS_SLOT 5

int CSPtextConnection::ParseTest(long* plCharParsed)
{
	int nParseResult = PARSE_COMPLETE; //Start as complete
	try
	{
		CSPevaluator sEvaluator;

		*plCharParsed = 0;
		s_object* ps_nlines = NEW_INTEGER(1);
		INTEGER_POINTER(ps_nlines)[0] = -1; //-1 means parsing the entire text. Hopefully no change in engine
		s_object* ps_extended_parse = NEW_LOGICAL(1);
		LOGICAL_POINTER(ps_extended_parse)[0] = TRUE;
		s_object* ps_parse = ::do_parse_lines(GetPtr(), NULL, ps_nlines, NULL, ps_extended_parse);
		char *pszParseResult;

		//Fail if the return object from do_parse_lines() is not 'parseTest' class.
		if(!IS_OBJ(ps_parse, parseTest))
		{
			nParseResult = PARSE_FAIL;
		}
		else if(LENGTH(ps_parse->value.tree[PARSE_RESULTS_SLOT]) != 1)
		{
			SCONNECT_ThrowException("Invalid parse object: missing results slot");  
		}
#ifdef WIN32
		else if (stricmp(pszParseResult=CHARACTER_POINTER(ps_parse->value.tree[PARSE_RESULTS_SLOT])[0], "complete") == 0)
#else
		else if (strcasecmp(pszParseResult=CHARACTER_POINTER(ps_parse->value.tree[PARSE_RESULTS_SLOT])[0], "complete") == 0)
#endif
		{
			nParseResult = PARSE_COMPLETE;
		}
#ifdef WIN32
		else if (stricmp(pszParseResult, "incomplete") == 0)
#else
		else if (strcasecmp(pszParseResult, "incomplete") == 0)
#endif
		{
			nParseResult = PARSE_INCOMPLETE;
		}
#ifdef WIN32
		else if (stricmp(pszParseResult, "continue string") == 0)
#else
		else if (strcasecmp(pszParseResult, "continue string") == 0)
#endif
		{
			nParseResult = PARSE_CONTINSTR;
		}
#ifdef WIN32
		else if (stricmp(pszParseResult, "error") == 0)
#else
		else if (strcasecmp(pszParseResult, "error") == 0)
#endif
		{
			CSPcharacter scharError(ps_parse->value.tree[PARSE_MESSAGE_SLOT]);
			set_doing_error_message();
			MESSAGE "Problem: %s", (char*) scharError[0] PRINT_IT;
			MESSAGE "Problem: %s", (char*) scharError[0] END_MESSAGE;
			S_write_log_line((char*)"Error", GET_MESSAGE);
			(void)S_incr_n_session_errors();
			unset_doing_error_message();
			nParseResult = PARSE_ERROR;
		}

		//If complete, determine length of char. successfully parsed
		if(nParseResult == PARSE_COMPLETE || nParseResult == PARSE_ERROR)
		{
			(*plCharParsed) = INTEGER_POINTER(ps_parse->value.tree[PARSE_CHARSPARSED_SLOT])[0];
			//Does it really complete with number of char parsed?
			if(*plCharParsed <= 0)
				nParseResult = PARSE_NOTHING;	
		}

		try_to_free(ps_parse, FALSE, Nframe, S_evaluator);
		try_to_free(ps_nlines, FALSE, Nframe, S_evaluator);
		try_to_free(ps_extended_parse, FALSE, Nframe, S_evaluator);
	}
	catch(...)
	{
		nParseResult = PARSE_FAIL;
	}
	return nParseResult;
}

s_object* CSPtextConnection::Parse()
{
	if ( !IsValid() )
		return NULL;

	CSPevaluator sEvaluator;

	s_object* ps_object = NULL;
	try
	{
		s_object* ps_arglist = NEW_LIST(5);
		LIST_POINTER(ps_arglist)[0] = *this;
		LIST_POINTER(ps_arglist)[1] = blt_in_NULL;
		LIST_POINTER(ps_arglist)[2] = blt_in_NULL;
		LIST_POINTER(ps_arglist)[3] = blt_in_FALSE;
		LIST_POINTER(ps_arglist)[4] = blt_in_FALSE;
		ps_object = S_parse(blt_in_NULL, ps_arglist, S_evaluator);
		sEvaluator.CloneIfNeeded(ps_object);
	}
	catch(...)
	{
	}
	return ps_object;
}

s_object* CSPtextConnection::ParseEval(void) 
{
	if ( !IsValid() )
		return NULL;

	CSPevaluator sEvaluator;

	s_object* ps_arglist = NEW_LIST(2);
	LIST_POINTER(ps_arglist)[0] = Parse();
	LIST_POINTER(ps_arglist)[1] = blt_in_TRUE;
	S_evaluator->_sys_index = S_EVAL;
	s_object* ps_object = S_dummy(blt_in_NULL, ps_arglist, S_evaluator);

	return sEvaluator.CloneIfNeeded(ps_object);
}

//////////////////////// CSPfile ////////////////////////

//Default constructor
CSPfile::CSPfile()
: CSPconnection()
{
}

//Construct from a valid S-expression
CSPfile::CSPfile(const char* pszExpression)
: CSPconnection()
{
	Create(pszExpression);
}

//Copy constructor 
CSPfile::CSPfile(s_object* ps_object)
: CSPconnection()
{
	if(!CoerceAttach(ps_object))
		SCONNECT_ThrowException("Failed to coerce object to class file"); 
}

//Copy constructor 
CSPfile::CSPfile(const CSPfile& sobject)
: CSPconnection()
{
	if(!CoerceAttach(sobject.GetPtr()))
		SCONNECT_ThrowException("Failed to coerce object to class file");  
}

//Assigment operator
CSPfile& CSPfile::operator = (s_object* ps_object)
{
	if(!CoerceAttach(ps_object))
		SCONNECT_ThrowException("Failed to coerce object to class file");  
	return *this;
}

//Assigment operator
CSPfile& CSPfile::operator = (const CSPfile& sobject)
{
	if(!CoerceAttach(sobject.GetPtr()))
		SCONNECT_ThrowException("Failed to coerce object to class file");  
	return *this;
}

//Create a persistent object when pszName != NULL
BOOL CSPfile::Create(
	const char* pszExpression, //==NULL, uses the default constructor, else use the expression to instantiate it.
	const char* pszName,       //object name
	long lDataBase )				//database
{
	BOOL bSuccess = TRUE;	
	try
	{
		bSuccess = CSPconnection::BaseCreate("file", pszExpression, pszName, lDataBase );
		if(bSuccess)
			Coerce();
	}
	catch(...)
	{
		bSuccess = FALSE;
	}

	return bSuccess;
}

//The destructor
CSPfile::~CSPfile()
{
}

//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////

//Return TRUE if the object is a valid 'fileConnection' class
BOOL CSPfile::IsValid(void) const
{
	if(CSPobject::IsValid())
		return IS(GetPtr(), MAKE_CLASS("file"));

	return FALSE;
}

//Coerce to textConnection-connection class
BOOL CSPfile::Coerce(void)
{
	return CoerceAttach(GetPtr());
}

//CoerceAttach() coerces to "file" class and attatch
BOOL CSPfile::CoerceAttach(s_object* ps_object)
{
	if(ps_object == NULL)
		return FALSE;
	
	s_class* pcl = MAKE_CLASS("file");
	if ( !IS(ps_object, pcl) )
		ps_object = AS(ps_object, pcl);

	if ( SPL_NotThere(ps_object) )
		return FALSE;

	ReAttachAndAssign(ps_object);
	return TRUE;
}

//////////////////////////////////////////////////////
// Operations
//////////////////////////////////////////////////////
	//Open a file connection

BOOL CSPfile::File(const char* pszPath, const char* pszOpen)
{

	char* pszTemp = NULL;
	try
	{
		CSPevaluator sEvaluator;
		if ( !pszPath )
		{
#ifdef WIN32
			pszTemp = _tempnam(".", "sp");
#else
			pszTemp = tempnam(".", "sp");
#endif
			if ( !pszPath )
				SCONNECT_ThrowException("Failed to generate unique temporary file name");
			pszPath = (const char*)pszTemp;
		}

		CSPcall spFCall("file");
		spFCall.SetArg(pszPath,1);
		if ( pszOpen && *pszOpen )
			spFCall.SetArg(pszOpen, 2, "open");

		s_object* ps_object = spFCall.Eval();
		ps_object = sEvaluator.CloneIfNeeded(ps_object);
		Attach(ps_object);
	}
	catch(CSPexception& except)
	{
		except.Print();
	}
	catch(...)
	{
	}
	if ( pszTemp )
		free(pszTemp);

	return IsValid();
}


//////////////////////// CSPpipe ////////////////////////

//Default constructor
CSPpipe::CSPpipe()
: CSPconnection()
{
}

//Construct from a valid S-expression
CSPpipe::CSPpipe(const char* pszExpression)
: CSPconnection()
{
	Create(pszExpression);
}

//Copy constructor 
CSPpipe::CSPpipe(s_object* ps_object)
: CSPconnection()
{
	if(!CoerceAttach(ps_object))
		SCONNECT_ThrowException("Failed to coerce object to class pipe"); 
}

//Copy constructor 
CSPpipe::CSPpipe(const CSPpipe& sobject)
: CSPconnection()
{
	if(!CoerceAttach(sobject.GetPtr()))
		SCONNECT_ThrowException("Failed to coerce object to class pipe");  
}

//Assigment operator
CSPpipe& CSPpipe::operator = (s_object* ps_object)
{
	if(!CoerceAttach(ps_object))
		SCONNECT_ThrowException("Failed to coerce object to class pipe");  
	return *this;
}

//Assigment operator
CSPpipe& CSPpipe::operator = (const CSPpipe& sobject)
{
	if(!CoerceAttach(sobject.GetPtr()))
		SCONNECT_ThrowException("Failed to coerce object to class pipe");  
	return *this;
}

//Create a persistent object when pszName != NULL
BOOL CSPpipe::Create(
	const char* pszExpression, //==NULL, uses the default constructor, else use the expression to instantiate it.
	const char* pszName,       //object name
	long lDataBase )				//database
{
	BOOL bSuccess = TRUE;	
	try
	{
		bSuccess = CSPconnection::BaseCreate("pipe", pszExpression, pszName, lDataBase );
		if(bSuccess)
			Coerce();
	}
	catch(...)
	{
		bSuccess = FALSE;
	}

	return bSuccess;
}

//The destructor
CSPpipe::~CSPpipe()
{
}

//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////

//Return TRUE if the object is a valid 'pipe' class
BOOL CSPpipe::IsValid(void) const
{
	if(CSPobject::IsValid())
		return IS(GetPtr(), MAKE_CLASS("pipe"));

	return FALSE;
}

//Coerce to textConnection-connection class
BOOL CSPpipe::Coerce(void)
{
	return CoerceAttach(GetPtr());
}

//CoerceAttach() coerces to "pipe" class and attatch
BOOL CSPpipe::CoerceAttach(s_object* ps_object)
{
	if(ps_object == NULL)
		return FALSE;
	
	s_class* pcl = MAKE_CLASS("pipe");
	if ( !IS(ps_object, pcl) )
		ps_object = AS(ps_object, pcl);

	if ( SPL_NotThere(ps_object) )
		return FALSE;

	ReAttachAndAssign(ps_object);
	return TRUE;
}

//////////////////////////////////////////////////////
// Operations
//////////////////////////////////////////////////////
	//Open a pipe connection

BOOL CSPpipe::Pipe(const char* pszCommand, const char* pszOpen)
{
	try
	{
		CSPevaluator sEvaluator;
		// If command is empty open a pipe for communication
		if ( !pszCommand )
			pszCommand = (const char*)"";

		CSPcall spFCall("pipe");
		spFCall.SetArg(pszCommand,1);
		if ( pszOpen && *pszOpen )
			spFCall.SetArg(pszOpen, 2, "open");
		s_object* ps_object = spFCall.Eval();
		ps_object = sEvaluator.CloneIfNeeded(ps_object);
		Attach(ps_object);

	}
	catch(CSPexception& except)
	{
		except.Print();
	}
	catch(...)
	{
	}

	return IsValid();
}


const char* CSPpipe::GetText()
{
	if ( !IsValid() )
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);

	char* pszBuf = NULL;
	try
	{
		CSPevaluator sEvaluator;

		s_boolean bOpened;
		s_connection* ps_con = con_setup_input(GetPtr(), &bOpened, S_evaluator);
		if ( !ps_con->rfile )
			SCONNECT_ThrowException("Read file descriptor of the pipe is closed");
		// Close the writing side of the pipe to pevent a deadlock.
		Close(write);

		con_get_all(ps_con, -1, S_evaluator);
		if ( ps_con->put_back )
			pszBuf = ps_con->put_back;
	}
	catch(CSPexception& except)
	{
		except.Print();
	}
	catch(...)
	{
	}
	return pszBuf;
}
